#include "usbd_cdc_if.h"
#include "zmodem.h"
#include "mcurses.h"

#define APP_RX_DATA_SIZE  64
#define APP_TX_DATA_SIZE  64

uint8_t UserRxBufferFS[APP_RX_DATA_SIZE];
uint8_t UserTxBufferFS[APP_TX_DATA_SIZE];

extern USBD_HandleTypeDef hUsbDeviceFS;

static int8_t CDC_Init_FS(void);
static int8_t CDC_DeInit_FS(void);
static int8_t CDC_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length);
static int8_t CDC_Receive_FS(uint8_t* pbuf, uint32_t *Len);


USBD_CDC_ItfTypeDef USBD_Interface_fops_FS =
{
  CDC_Init_FS,
  CDC_DeInit_FS,
  CDC_Control_FS,
  CDC_Receive_FS
};

/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Initializes the CDC media low layer over the FS USB IP
  * @retval USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_Init_FS(void)
{
  /* USER CODE BEGIN 3 */
  /* Set Application Buffers */
  USBD_CDC_SetTxBuffer(&hUsbDeviceFS, UserTxBufferFS, 0);
  USBD_CDC_SetRxBuffer(&hUsbDeviceFS, UserRxBufferFS);
  return (USBD_OK);
  /* USER CODE END 3 */
}

/**
  * @brief  DeInitializes the CDC media low layer
  * @retval USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_DeInit_FS(void)
{
  /* USER CODE BEGIN 4 */
  return (USBD_OK);
  /* USER CODE END 4 */
}

/**
  * @brief  Manage the CDC class requests
  * @param  cmd: Command code
  * @param  pbuf: Buffer containing command data (request parameters)
  * @param  length: Number of data to be sent (in bytes)
  * @retval Result of the operation: USBD_OK if all operations are OK else USBD_FAIL
  */
static int8_t CDC_Control_FS(uint8_t cmd, uint8_t* pbuf, uint16_t length)
{
  /* USER CODE BEGIN 5 */
  switch(cmd)
  {
    case CDC_SEND_ENCAPSULATED_COMMAND:

    break;

    case CDC_GET_ENCAPSULATED_RESPONSE:

    break;

    case CDC_SET_COMM_FEATURE:

    break;

    case CDC_GET_COMM_FEATURE:

    break;

    case CDC_CLEAR_COMM_FEATURE:

    break;

  /*******************************************************************************/
  /* Line Coding Structure                                                       */
  /*-----------------------------------------------------------------------------*/
  /* Offset | Field       | Size | Value  | Description                          */
  /* 0      | dwDTERate   |   4  | Number |Data terminal rate, in bits per second*/
  /* 4      | bCharFormat |   1  | Number | Stop bits                            */
  /*                                        0 - 1 Stop bit                       */
  /*                                        1 - 1.5 Stop bits                    */
  /*                                        2 - 2 Stop bits                      */
  /* 5      | bParityType |  1   | Number | Parity                               */
  /*                                        0 - None                             */
  /*                                        1 - Odd                              */
  /*                                        2 - Even                             */
  /*                                        3 - Mark                             */
  /*                                        4 - Space                            */
  /* 6      | bDataBits  |   1   | Number Data bits (5, 6, 7, 8 or 16).          */
  /*******************************************************************************/
    case CDC_SET_LINE_CODING:

    break;

    case CDC_GET_LINE_CODING:

    break;

    case CDC_SET_CONTROL_LINE_STATE:

    break;

    case CDC_SEND_BREAK:

    break;

  default:
    break;
  }

  return (USBD_OK);
  /* USER CODE END 5 */
}



static int8_t CDC_Receive_FS(uint8_t* Buf, uint32_t *Len)
{
  /* USER CODE BEGIN 6 */
    USBD_CDC_SetRxBuffer(&hUsbDeviceFS, &Buf[0]);
    USBD_CDC_ReceivePacket(&hUsbDeviceFS);

    for(uint32_t i = 0; i < *Len; i++){
	push(&Stack_Zm,UserRxBufferFS[i]); // 襬   ⥪
    }

    if(STARTM == MENU_START){
    	inputMenuCh(UserRxBufferFS, *Len);
    }

    if(UserRxBufferFS[0] == 0x1b && UserRxBufferFS[1] == 0x5b && UserRxBufferFS[2] == 0x32 && UserRxBufferFS[3] == 0x34 && UserRxBufferFS[4] == 0x7e)
    {
    	outFileSistem = 1;
    }

    switch(ZMODEM_SELECT)
    {
    case ZMODEMSTARTRECEIVESEND :
    	ZMODEM_SELECTFUNC();
    	break;

    case ZMODEMRECEIVE :
    	ZMODEM_SELECTFUNC();
    	break;

    case SEND_ZRPOS :
    	ZMODEM_SELECTFUNC();
    	break;

    case SEND_ZRINIT:
    	ZMODEM_SELECTFUNC();
    	break;

    case SEND_ZFIN :
    	ZMODEM_SELECTFUNC();
    	break;

    default :
    	break;
    };


    /*  ᤥ ॠ  모   ⮪ ZModem ?
     * 蠣 ᭥ ࠡ ⮪ zmodem.   .  .
     * ਥ 䠩 --->
     * 1.  --->   RZ+CR  ᫮   .hex ଠ 72 7A 0D
     * 2.  --->   " 뢠 ZRQINIT"  .hex ଠ 2A 2A 18 42 30 30 30 30 30 30 30 30 30 30 30 30 30 30 8D 8A 11 ᪫뢠  HEX HEADER "* * ZDLE B TYPE F3/P0 F2/P1 F1/P2 F0/P3 CRC-1 CRC-2 CR LF XON" 祬 8D 8A  xor 樨
     * 3.  <---   ⢥   "ZRQINIT" ⢥  HEX ଠ (  ᭮ HEX ଠ) "2A 2A 18 42 30 31 30 30 30 30 30 30 32 33 62 65 30 0D 8A" 祬 ᠬ ᭮  ਩      ਩  㦭 ࠡ뢠  ᮡ
     * 4.  --->   "ZFILE"    䠩 ᭠砫  "2A 18 41 04 00 00 00 01 99 27" ᫥ ࠧ 室 "68 65 6C 6C 6F 77 6F 72 6C 64 2E 74 78 74 00 31 37 20 31 33 37 33 36 37 33 36 32 35 34 20 31 30 30 36 34 34 00 18 6B 18 51 4A"  ZDLE 㦭 뢠  ஫쭮 㬬
     * 5.  <--- ᫥ ࠧ ⢥ ZRPOS ࠢ 뫪 "2A 2A 18 42 30 39 30 30 30 30 30 30 30 30 61 38 37 63 0D 8A"
     * 6.  --->  ᭠砫 ZDATA
     * 7.  --->   䠩  .bin ଠ "68 65 6C 6C 6F 20 77 6F 72 6C 64 21 21 21 21 21 21 18 68 B3 94"   ஫쭠 㬬 Crc16
     * 8.  --->  ᨫ ⪮ 䠩   䠩 "ZEOF" "2A 2A 18 42 30 62 31 31 30 30 30 30 30 30 38 31 65 63 8D 8A 11"
     * 9.  <--- ⢥  ZRQINIT .hex ଠ "2A 2A 18 42 30 31 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 10. ---> ਭ  ZFIN "2A 2A 18 42 30 38 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 11. <--- ⢥ ZFIN "2A 2A 18 42 30 38 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 12. --->   ᨬ "OO"
     *
     * । 䠩  zmodem
     * 1.  <--- ।  RZ+CR  .hex ଠ 72 7A 0D
     * 2.  <--- ।  "ZRQINIT"  .hex ଠ 2A 2A 18 42 30 30 30 30 30 30 30 30 30 30 30 30 30 30 8D 8A 11 祬 8D 8A  xor 樨
     * 3.  --->  ⢥ "ZRINIT" ⢥  HEX ଠ (  ᭮ HEX ଠ) "2A 2A 18 42 30 31 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 4.  <--- ।  "ZFILE"    䠩 ᭠砫 "2A 18 41 04 00 00 00 01 99 27" ᫥ ࠧ ࠢ  "68 65 6C 6C 6F 77 6F 72 6C 64 2E 74 78 74 00 31 37 20 31 33 37 33 36 37 33 36 32 35 34 20 31 30 30 36 34 34 00 18 6B 18 51 4A"  ZDLE 㦭 뢠  ஫쭮 㬬
     * 5.  --->  ⢥ ZRPOS
     * 6.  --->  ᭠砫 ZDATA
     * 7.  --->   䠩  .bin ଠ "68 65 6C 6C 6F 20 77 6F 72 6C 64 21 21 21 21 21 21 18 68 B3 94"   ஫쭠 㬬 Crc16
     * 8.  --->  ᨫ ⪮ 䠩   䠩 "ZEOF" "2A 2A 18 42 30 62 31 31 30 30 30 30 30 30 38 31 65 63 8D 8A 11"
     * 9.  <--- ⢥  ZRQINIT .hex ଠ "2A 2A 18 42 30 31 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 10. ---> ਭ  ZFIN "2A 2A 18 42 30 38 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 11. <--- ⢥ ZFIN "2A 2A 18 42 30 38 30 30 30 30 30 30 32 33 62 65 30 0D 8A"
     * 12. <--- ।  ᨬ "OO"
     * */

    return(USBD_OK);
  /* USER CODE END 6 */
}



uint8_t CDC_Transmit_FS(uint8_t* Buf, uint16_t Len)
{
  uint8_t result = USBD_OK;
  /* USER CODE BEGIN 7 */
  USBD_CDC_HandleTypeDef *hcdc = (USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData;
  if (hcdc->TxState != 0){
    return USBD_BUSY;
  }
  USBD_CDC_SetTxBuffer(&hUsbDeviceFS, Buf, Len);
  result = USBD_CDC_TransmitPacket(&hUsbDeviceFS);
  /* USER CODE END 7 */
  return result;
}

