#include "main.h"
#include "stm32h7xx_it.h"
#include "SysVar.h"

extern PCD_HandleTypeDef hpcd_USB_OTG_FS;
extern UART_HandleTypeDef huart2;
extern UART_HandleTypeDef huart3;
extern RTC_HandleTypeDef hrtc;


struct
{
  uint32_t r0;
  uint32_t r1;
  uint32_t r2;
  uint32_t r3;
  uint32_t r12;
  uint32_t lr;
  uint32_t pc;
  uint32_t psr;
}*stack_ptr; //⥫  ⥪饥 祭 ⥪(SP)

void NMI_Handler(void)
{

}


void HardFault_Handler(void)
{

	  asm(
	      "TST lr, #4 \n" //㥬 3  㪠⥫ ⥪(⮢ )
	      "ITE EQ \n"   //祭 㪠⥫ ⥪   3?
	      "MRSEQ %[ptr], MSP  \n"  //, ࠭塞 ᭮ 㪠⥫ ⥪
	      "MRSNE %[ptr], PSP  \n"  //, ࠭塞 㪠⥫ ⥪ 
	      : [ptr] "=r" (stack_ptr)
	      );

	SET_BIT(GPIOD->BSRR, GPIO_BSRR_BS14);

	while(1);
}


void MemManage_Handler(void)
{
  while (1)
  {

  }
}


void BusFault_Handler(void)
{

  while (1)
  {

  }
}


void UsageFault_Handler(void)
{

  while (1)
  {

  }
}


void SVC_Handler(void)
{

}


void DebugMon_Handler(void)
{

}


void PendSV_Handler(void)
{

}


void SysTick_Handler(void)
{
  static uint16_t counter = 0;
  counter ++;
  if(counter >= 10){
  counter = 0;
  SysMem.DIO_MIN[0].DIO_00.SysTimer ++;

  if(SysMem.DIO_MIN[0].DIO_00.SysTimer >= 86399.99)
  {
	  SysMem.DIO_MIN[0].DIO_00.SysTimer = 0.0;
  }
  }


  HAL_IncTick();
}


void OTG_FS_IRQHandler(void)
{
  HAL_PCD_IRQHandler(&hpcd_USB_OTG_FS);
}
