#include "menu.h"

const menuItem m_s1i1;
const menuItem m_s1i2;

TERM MenuDISP[30][95] __attribute__((section(".dma_buffer"))); // ࠧ 5700
TERM MirrorMenuDISP[30][95] __attribute__((section(".dma_buffer"))); // ࠧ 5700
TERM PopUpDisp[sizeWindowAxisY][sizeWindowAxisX]  __attribute__((section(".dma_buffer"))); // ࠧ 1200

_retMenu retMenu __attribute__((section(".dma_buffer"))); // ࠧ 4 
_Menu Menu __attribute__((section(".D2"))); // ࠧ 24584

_MenuUpdate MenuUpdate __attribute__((section(".dma_buffer"))); //
_inputKeyBoard inputKeyBoard __attribute__((section(".dma_buffer"))); //

uint16_t blockingWorkMenu = 0;

int32_t cursorInputX = 0, cursorInputY = 0;
uint8_t textPopUp[32] __attribute__((section(".dma_buffer"))) = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		                 	 	 	 	 	 	 	 	 	 	 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
int16_t counterTextPopUp = 0;
int16_t offsetFile = 0;
int16_t shiftButtonPopUp = 0;
int16_t popButtonPopUp = 0;
int16_t choiceSettings = 0;



menuItem Null_Menu = {(void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0, (void*)0,
					  0, 0, NULL_FUNC, NULL_FUNC, NULL_FUNC, {0x00}, {0x00}};

uint32_t MenuX = 0, MenuY = 0;
uint32_t MenuColorF = 7, MenuColorB = 0;


const uint8_t functionkeys[15][6] = {{0x1b, 0x5b, 0x31, 0x31, 0x7e, 0x00}, // F1
		                             {0x1b, 0x5b, 0x31, 0x32, 0x7e, 0x00}, // F2
								     {0x1b, 0x5b, 0x31, 0x33, 0x7e, 0x00}, // F3
									 {0x1b, 0x5b, 0x31, 0x34, 0x7e, 0x00}, // F4
									 {0x1b, 0x5b, 0x31, 0x35, 0x7e, 0x00}, // F5
									 {0x1b, 0x5b, 0x31, 0x37, 0x7e, 0x00}, // F6
									 {0x1b, 0x5b, 0x31, 0x38, 0x7e, 0x00}, // F7
									 {0x1b, 0x5b, 0x31, 0x39, 0x7e, 0x00}, // F8
									 {0x1b, 0x5b, 0x32, 0x30, 0x7e, 0x00}, // F9
									 {0x1b, 0x5b, 0x32, 0x31, 0x7e, 0x00}, // F10
									 {0x1b, 0x5b, 0x32, 0x31, 0x7e, 0x00}, // F11
									 {0x1b, 0x5b, 0x41, 0x00, 0x00, 0x00}, // UP
									 {0x1b, 0x5b, 0x42, 0x00, 0x00, 0x00}, // DOWN
									 {0x1b, 0x5b, 0x43 ,0x00, 0x00, 0x00}, // Right
									 {0x1b, 0x5b, 0x44, 0x00, 0x00, 0x00}, // Left
};


                                           /*         y    x   梥      梥    ⥪ */
const _TypeButonPressed ReadBut          = { "1",  "",  29,  0,  White,  Black,  Black,  Cyan};
const _TypeButonPressed DelBut           = { "2",  "",  29,  8,  White,  Black,  Black,  Cyan};
const _TypeButonPressed ChangeNameBut    = { "3",  "",  29,  16, White,  Black,  Black,  Cyan};
const _TypeButonPressed CopyBut          = { "4",  "",  29,  24, White,  Black,  Black,  Cyan};
const _TypeButonPressed DefragmentingBut = { "5",  " ",  29,  32, White,  Black,  Black,  Cyan};
const _TypeButonPressed startB00         = { "6",  "ै",  29,  40, White,  Black,  Black,  Cyan};
const _TypeButonPressed DataTimeBut      = { "7",  "ࠣ",  29,  48, White,  Black,  Black,  Cyan};
const _TypeButonPressed CopyFile         = { "8",  "  ",  29,  56, White,  Black,  Black,  Cyan};
const _TypeButonPressed createBut        = { "9",  " ",  29,  64, White,  Black,  Black,  Cyan};
const _TypeButonPressed ReserveBut       = { "10", "",  29,  72, White,  Black,  Black,  Cyan};


                        /*y    x            梥 front   back                     ⥪  */
const _popUp popUpName = {10,  20,  9 ,48,	     Black,  White,
		                  11,  36,  	         Black,  White,                   " २ ",
						  12,  24,  	         Black,  White,                   " २ ",
						  13,  24,  	         Black,  Cyan,    Black,  White,  "                                       ",
                          15,  24,  	         Black,  Cyan,    Black,  White,  "{ २ }",
						  15,  35,  	         Black,  Cyan,    Black,  White,  "[  ]",
						  15,  50,  	         Black,  Cyan,    Black,  White,  "[ ⬥ ]",
						 {
							"                                               ",
							"  ͻ  ",
							"                                             ",
							"                                             ",
							"  Ķ  ",
							"                                             ",
							"  ͼ  ",
							"                                               ",
							 "",
						 }
};


							/*y     x          梥  front   back                     ⥪  */
const _popUp popUpNewFile = { 10,   20,  9 ,42,	 Black,  White,
							  11,   35,  	         Black,  White,                   "  䠩 ",
							  12,   24,  	         Black,  White,                   " 䠩:",
							  13,   24,  	         Black,  Cyan,   Black,  White,   "                                 ",
							  15,   26,  	         Black,  Cyan,   Black,  White,   "{ Ok }",
							  15,   35,  	         Black,  Cyan,   Black,  White,   "[  ]",
							  15,   45,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
							  {
								"                                         ",
								"  ͻ  ",
								"                                       ",
								"                                       ",
								"  Ķ  ",
								"                                       ",
								"  ͼ  ",
								"                                         ",
								 "",
							  }
};


const _popUp popUpDellFile = { 10,   22,  9 ,39,	 Black,  White,
							   11,   35,  	         Black,  White,                   "  ",
							   12,   26,  	         Black,  White,                   "      㤠 䠩:    ",
							   13 ,  26,  	         Black,  Cyan,   Black,  White,   "                               ",
							   15,   27,  	         Black,  Cyan,   Black,  White,   "{  }",
							   15,   37,  	         Black,  Cyan,   Black,  White,   "[  ]",
							   15,   43,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
							   {
							    "                                      ",
							    "  ͻ  ",
							    "                                    ",
							    "                                    ",
							    "  Ķ  ",
							    "                                    ",
							    "  ͼ  ",
								"                                      ",
							     "",
							   }
};


const _popUp popUpCopy =        { 10,  20,  9 ,48,	     Black,  White,
		  	  	  	  	  	  	  11,  37,  	         Black,  White,                   " ஢ ",
								  12,  24,  	         Black,  White,                   " ஢ 䠩 ",
								  13 , 24,  	         Black,  Cyan,   Black,  White,   "                                       ",
								  15,  25,  	         Black,  Cyan,   Black,  White,   "{ ஢ }",
								  15,  35,  	         Black,  Cyan,   Black,  White,   "[  ]",
								  15,  50,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
								  {
									"                                               ",
									"  ͻ  ",
									"                                             ",
									"                                             ",
									"  Ķ  ",
									"                                             ",
									"  ͼ  ",
									"                                               ",
									 "",
								  }
}; // 㢥   ࠧ ᤥ 


                          /*y    x            梥 front   back                     ⥪  */
const _popUp popUpCompil = {10,  15,  9 ,52,	 Black,  White,
						    11,  33,  	         Black,  White,                   " ஢ ",
						    12,  19,  	         Black,  White,                   "                                            ",
						    13,  19,  	         Black,  Cyan,    Black,  White,  "                                            ",
						    15,  21,  	         Black,  Cyan,    Black,  White,  "{ ஢ }",
						    15,  30,  	         Black,  Cyan,    Black,  White,  "[  ]",
						    15,  50,  	         Black,  Cyan,    Black,  White,  "[ ⬥ ]",
						    {
						    "                                                   ",
						    "  ͻ  ",
						    "                                                 ",
						    "                                                 ",
						    "  Ķ  ",
						    "                                                 ",
						    "  ͼ  ",
						    "                                                   ",
						     "",
						    }
};

                          /*y    x            梥 front   back                     ⥪  */
const _popUp popUpDefrag = {10,  20,  9 ,42,	 Black,  White,
							11,  31,  	         Black,  White,                   " ࠣ஢ ",
							12,  24,  	         Black,  White,                   "   믮 ",
							13 , 24,  	         Black,  Cyan,    Black,  White,  " ࠣ஢? ",
							15,  24,  	         Black,  Cyan,    Black,  White,  "{ ࠣ஢ }",
							15,  35,  	         Black,  Cyan,    Black,  White,  "[  ]",
							15,  47,  	         Black,  Cyan,    Black,  White,  "[ ⬥ ]",
							{
							"                                         ",
							"  ͻ  ",
							"                                       ",
							"                                       ",
							"  Ķ  ",
							"                                       ",
							"  ͼ  ",
							"                                         ",
							 "",
							}
};



                                /*y    x            梥 front   back                     ⥪  */
const _popUp popUpWarning =     { 10,  20,  9 ,48,	     Black,  White,
		  	  	  	  	  	  	  11,  36,  	         Black,  White,                   " ।० ",
								  12,  25,  	         Black,  White,                   "                  ",
								  13,  25,  	         Black,  Cyan,   Black,  White,   "               ",
								  15,  41,  	         Black,  Cyan,   Black,  White,   "[  ]",
								  15,  35,  	         Black,  Cyan,   Black,  White,   "[  ]",
								  15,  48,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
								  {"                                               ",
								   "  ͻ  ",
								   "                                             ",
								   "                                             ",
								   "  Ķ  ",
								   "                                             ",
								   "  ͼ  ",
								   "                                               ",
								    "",
								  }
};

                                 /*y    x            梥 front   back                     ⥪  */
const _popUp popUpSaveAS =      { 10,  20,  9 ,42,	     Black,  White,
								  11,  33,  	         Black,  White,                   " १ ",
								  12,  25,  	         Black,  White,                   "                  ",
								  13,  25,  	         Black,  Cyan,   Black,  White,   "               ",
								  15,  38,  	         Black,  Cyan,   Black,  White,   "{  }",
								  15,  35,  	         Black,  Cyan,   Black,  White,   "[  ]",
								  15,  45,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
								  {
										"                                         ",
										"  ͻ  ",
										"                                       ",
										"                                       ",
										"  Ķ  ",
										"                                       ",
										"  ͼ  ",
										"                                         ",
										 "",
								  }
};


								 /*y    x            梥 front   back                     ⥪  */
const _popUp popUpBoot =      {   10,  20,  9 ,42,	     Black,  White,
								  11,  31,  	         Black,  White,                   " 室  稪 ",
								  12,  23,  	         Black,  White,                   "  稪? ",
								  13,  25,  	         Black,  Cyan,   Black,  White,   "               ",
								  15,  24,  	         Black,  Cyan,   Black,  White,   "{  }",
								  15,  35,  	         Black,  Cyan,   Black,  White,   "[  ]",
								  15,  45,  	         Black,  Cyan,   Black,  White,   "[ ⬥ ]",
								  {
										  "                                         ",
										  "  ͻ  ",
										  "                                       ",
										  "                                       ",
										  "  Ķ  ",
										  "                                       ",
										  "  ͼ  ",
										  "                                         ",
										   "",
								  }
};


                                           /*y     x           梥 front    back            ⥪  */
const _popUpProgressbar popUpProgressbar = { 10,    20, 8,  42,     Black,   White,
		                                     11,    32,  	 		Black,   White,  " ࠣ... ",
											 12,    28,       		Black,   White,  "                ",
											 13,    28,      		Green,   White,  "                         ",
											 {
											   "                                         ",
											   "  ͻ  ",
											   "                                       ",
											   "                                       ",
											   "                                       ",
											   "  ͼ  ",
											   "                                         ",
											    "",
											 },
};

								  /*y     x    梥 front    back            ⥪  */
const _settings settings       = { 9,     20, 10,  42,    Black,   White,
		                           10,    35,  	 		  Black,   White,  " ன ",
								   11,    24,       	  Black,   Cyan,   Black,  White, " [x]ன ᮢ ",  " [ ]ன ᮢ ",
								   12,    24,             Black,   Cyan,   Black,  White, " [x] 稪 "," [ ] 稪 ",
								   13,    24,       	  Black,   Cyan,   Black,  White, "                 ", "                 ",
								   12,    24,       	  Black,   Cyan,   Black,  White, "                 ", "                 ",
								   12,    24,       	  Black,   Cyan,   Black,  White, "                 ", "                 ",
								   12,    28,       	  Black,   Cyan,                  "                 ",
								   15,    25,  	          Black,   Cyan,   Black,  White,   "[ ந ]",
								   15,    29,  	          Black,   Cyan,   Black,  White,   "{  }",
								   15,    46,  	          Black,   Cyan,   Black,  White,   "[ ⬥ ]",
								   {
									"                                         ",
									"  ͻ  ",
									"                                       ",
									"                                       ",
									"                                       ",
									"  Ķ  ",
									"                                       ",
									"  ͼ  ",
									"                                         ",
									 "",
									},
};



                                            /*y     x           梥   front    back                       ⥪  */
const _watch watch =                       {{ 7,    20, 15 , 40,       Black,   White,
				                              8,    31,                Black,   White,                      " ன ᮢ ",
											  9,    22,        		   Black,   Yellow,                     "      ",
											  13,   22,        		   Black,   Yellow,                     " ६    ",
											  10 ,  22,                Black,   White,                      " :    ",
											  11,   22,                Black,   White,                      " :   ",
											  12,   22,                Black,   White,                      " :     ",
											  14,   22,                Black,   White,                      " :    ",
											  15,   22,                Black,   White,                      " :  ",
											  16,   22,                Black,   White,                      " ᥪ㭤: ",
											  10,   32,                Black,   Cyan,    Black,  White,     "01",
											  10,   34,                Black,   White,                      ".",
											  11,   32,                Black,   Cyan,    Black,  White,     "01",
											  11,   34,                Black,   White,                      ".",
											  12,   32,                Black,   Cyan,    Black,  White,     "2021",
											  {0,0,0,0,0},
											  14,   32,                Black,   Cyan,    Black,  White,     "16",
											  14,   37,                Black,   White,                      ":",
											  15,   32,                Black,   Cyan,    Black, White,      "57",
											  15,   40,                Black,   White,                      ":",
											  16,   32,                Black,   Cyan,    Black,  White,     "00",
											  {0,0,0,0,0},
											  18,   24,                Black,   Cyan ,   Black,  White,     "{ ࠭ }",
											  {0,0,0,0,0},
											  18,   44,                Black,   Cyan ,   Black,  White,     "[ ⬥ ]",
}};

const char *frameClock[] = {
							"                                       ",
							" ͻ ",
							"                                     ",
							"                                     ",
							"                                     ",
							"                                     ",
							"                                     ",
							"                                     ",
							"                                     ",
							"                                     ",
							" Ķ ",
							"                                     ",
							" ͼ ",
							"                                       ",
							 "",
};


const char *frame[] ={
		"ͻ14:46",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"                                                                           ",
		"ͼͼ",
		"                                                                                "
		"                                                                                "
};



int16_t watchCell = 0;
int16_t counterWatch[6] =  {0,0,0,0,0,0};
_bufWatch bufWatch = {{
						{0,0,0,0,0,0,0,0,0,0,0,0},
						{0,0,0,0,0,0,0,0,0,0,0,0},
						{0,0,0,0,0,0,0,0,0,0,0,0},
						{0,0,0,0,0,0,0,0,0,0,0,0},
						{0,0,0,0,0,0,0,0,0,0,0,0},
						{0,0,0,0,0,0,0,0,0,0,0,0},
}};


void menuChange(const menuItem* NewMenu)
{
		if ((void*)NewMenu == (void*)&NULL_ENTRY){
		  return;
		}
			selectedMenuItem = (menuItem *)NewMenu;
				if(NewMenu->SelectFunc != (FuncPtr)NULL_FUNC){
					SELECTFUNCM();
				}
}


void menuEnterFunc(const menuItem* NewMenu)
{
	if(NewMenu->EnterFunc != (FuncPtr)NULL_FUNC){
		ENTERFUNCM();
	}
}


void    initStackMenu(void)
{
       memset(&Menu, 0, sizeof(Menu));
}

void    pushMenu(_Menu *stack, uint8_t value, uint8_t y, uint8_t x)
{
	stack->data[stack->head] = value;
	stack->Y[stack->head] = y;
	stack->X[stack->head] = x;
	stack->head ++;
	stack->head &= TxDispDataMask;
}

_retMenu popMenu(_Menu *stack)
{
	_retMenu Men;
    Men.ch = stack->data[stack->tail];
    Men.y  = stack->Y[stack->tail];
    Men.x  = stack->X[stack->tail];
    stack->tail ++;
    stack->tail  &= TxDispDataMask;
    return(Men);
}

_retMenu peekMenu(_Menu *stack)
{
	_retMenu Men;
    Men.ch = stack->data[stack->tail];
    Men.y  = stack->Y[stack->tail];
    Men.x  = stack->X[stack->tail];
    stack->tail  &= TxDispDataMask;
    return(Men);
}

int sizeStackMenu(_Menu *stack)
{
	return((stack->head - stack->tail)&TxDispDataMask);
}


void    initStackMenuUpdate(_MenuUpdate *stack)
{
	   for(uint32_t i = 0; i < sizeTxDispData; i++)
	   {
	   stack->data[i] = 0;
	   }
       stack->head = 0;
       stack->tail = 0;
}


void    pushMenuUpdate(_MenuUpdate *stack, uint8_t value)
{
	stack->data[stack->head] = value;
	stack->head ++;
	stack->head &= TxDispDataMask;
}


uint8_t popMenuUpdate(_MenuUpdate *stack)
{
    uint8_t var = 0;
    var = stack->data[stack->tail];
	stack->tail ++;
	stack->tail  &= TxDispDataMask;
	return(var);
}


int sizeStackMenuUpdate(_MenuUpdate *stack)
{
	return((stack->head - stack->tail)&TxDispDataMask);
}


uint32_t fullUpdateMenuWindows(void) //  
{
    static uint32_t x, y, colFold, colBold, setCursor;

    if(sizeStackMenuUpdate(&MenuUpdate) == 0){

    uint32_t colB = 0, colF = 0, dim = 0;

     if(x == 0 && y == 0 && setCursor == 0){

     	for(uint32_t i = 0; i < sizeWindowAxisY; i++){
     		 for(uint32_t j = 0; j < sizeWindowAxisX; j++){
     			 MirrorMenuDISP[i][j].F_C = MenuDISP[i][j].F_C;
     			 MirrorMenuDISP[i][j].B_C = MenuDISP[i][j].B_C;
     			 MirrorMenuDISP[i][j].ch  = MenuDISP[i][j].ch;
     		}
     	}

     	searchESCM();

    	colF = MirrorMenuDISP[y][x].F_C;
    	colB = MirrorMenuDISP[y][x].B_C;

    	dim = colF & 0x8;

    	colF = colF & 0x7;

    	colB = colB & 0x7;

    	colF = colF << 8;

    	colB = colB << 12;

    	colF = colF & F_COLOR;

    	colB= colB & B_COLOR;

    	attrsetMenuUpdate(A_NORMAL);

    	moveMenuUpdate(0,0);

    	curs_setMenuUpdate(0); // ⪫祭 

    	if(dim == 0){
    	attrsetMenuUpdate(colF|colB);
    	}
    	else{
    	attrsetMenuUpdate(colF|colB|A_BOLD);
    	}

    	colFold = MirrorMenuDISP[y][x].F_C;
        colBold = MirrorMenuDISP[y][x].B_C;
    }

    if(y < sizeWindowAxisY){
    for(uint32_t i = 0; i < sizeWindowAxisX; i++){

    if(colBold != MirrorMenuDISP[y][i].B_C || colFold != MirrorMenuDISP[y][i].F_C){

    	colF = MirrorMenuDISP[y][i].F_C;
    	colB = MirrorMenuDISP[y][i].B_C;

    	dim = colF & 0x8;

    	colF = colF & 0x7;

    	colB = colB & 0x7;

    	colF = colF << 8;

    	colB = colB << 12;

    	colF = colF & F_COLOR;

    	colB= colB & B_COLOR;

    	if(dim == 0){
    	attrsetMenuUpdate(colF|(colB));
    	}
    	else{
    	attrsetMenuUpdate(colF|(colB)|A_BOLD);
    	}
    }

    addchMenuUpdate(MirrorMenuDISP[y][i].ch);
    colFold = MirrorMenuDISP[y][i].F_C;
    colBold = MirrorMenuDISP[y][i].B_C;
    }
    }
    	x = 0;
    	y ++;
        if(y > sizeWindowAxisY){
        		if(setCursor == 0){
        			if(onOffCursor == 0){
        			retMenu = peekMenu(&Menu);
        				moveMenuUpdate(retMenu.y, retMenu.x);
        			}
        			else{
        				moveMenuUpdate(MenuY, MenuX);
        			}
        			setCursor = 1;
        	    	if(onOffCursor == 1){
        	    	curs_setMenuUpdate(1); // ⪫祭 
        	    	}
        		}
        		else
        			{
        			x = 0;
        			y = 0;
        			colFold = 0;
        			colBold = 0;
        			setCursor = 0;
        			return(1);
        			}
        }
        else{
        	moveMenuUpdate(y,x);
        }

        extraditionMenuDisp();
    }
    else{
    	extraditionMenuDisp();
    }

    return(0);
}




void initMenuDisp(void)
{
    for(uint32_t i = 0; i < sizeWindowAxisY; i++)
    {
    	for(uint32_t j = 0; j < sizeWindowAxisX; j++)
    	{
    		MenuDISP[i][j].F_C = 7;
    		MenuDISP[i][j].B_C = 0;
    		MenuDISP[i][j].ch  = ' ';
    	}
    }
}


void extraditionMenuDisp(void)
{
	sizeTXUSB = sizeStackMenuUpdate(&MenuUpdate);

	if(sizeTXUSB >= 63){
	sizeTXUSB = 63;
	}

	if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED && (sizeTXUSB != 0) && (((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState == 0))
	{
		if(sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff)
		{
			for(int i = 0; i < sizeTXUSB; i++){
			bufTxUSB[i] = popMenuUpdate(&MenuUpdate);
			}
			transmitDataTerminal(bufTxUSB,sizeTXUSB);
			CDC_Transmit_FS(bufTxUSB, sizeTXUSB);
		}
		else
			{
			transmitDataTerminal(bufTxUSB,0);
			}
    }
	else{
		if(hUsbDeviceFS.dev_state != USBD_STATE_CONFIGURED && (sizeTXUSB != 0) && (sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff))
		{

			for(int i = 0; i < sizeTXUSB; i++){
				bufTxUSB[i] = popMenuUpdate(&MenuUpdate);
			}
			transmitDataTerminal(bufTxUSB,sizeTXUSB);

		}
	}
}


void inputMenuCh(uint8_t *buf, uint32_t len)
{
    for(int i = 0; i < len; i++){
    	if(sizeInputKeyBoard(&inputKeyBoard) < 250){
    	pushInputKeyBoard(&inputKeyBoard, buf[i]);
    	}
    }
}


int8_t codeComande(void)
{
	int8_t i = 0, j = 0;
	char str1[8], str2[8];
	memset(str1, 0, 8);
	memset(str2, 0, 8);

	while(j < 6){

			if(i == 0)
			{
			str1[j++] = popInputKeyBoard(&inputKeyBoard);
				if(j == 1)
				{
					if(peekInputKeyBoard(&inputKeyBoard) != 0x5b)
					{
						return(0x1b);
					}
				}
			}

			strcpy(str2, (void*)&functionkeys[i++][0]);

				if(strcmp(str1, str2) == 0 )
				{
					return(i);
				}

				if(i >= 15)
				{
					i = 0;
				}
		}

		return(-1);
}


void parserCommandKeyBoard(int16_t size)
{
	if(peekInputKeyBoard(&inputKeyBoard) != 0x1b)
	{
	outputMessagesPopUp(popInputKeyBoard(&inputKeyBoard));
	}
	else{
		switch(codeComande())
		{
		case 1: //F1
			break;

		case 2: //F2
			if(SELECTM == MENU_W1)
			{
			menuChange(COMPILM);
			}
			break;

		case 3: //F3
			if(SELECTM == MENU_W1)
			{
	    	menuChange(NEWFILE);
			}
			break;

		case 4: //F4
			if(SELECTM == MENU_W1)
			{
			menuChange(EDITORM);
			}
			break;

		case 5: //F5
			if(SELECTM == MENU_W1)
			{
			menuChange(COPYM);
			}
			break;

		case 6: //F6
			if(SELECTM == MENU_W1)
			{
			menuChange(NEXTM);
			}
			break;

		case 7:  //F7
			if(SELECTM == MENU_W1)
			{
	        menuChange(DEFRAG);
			}
			break;

		case 8: //F8
			if(SELECTM == MENU_W1)
			{
			menuChange(DELLM);
			}
			break;

		case 9: //F9
			if(SELECTM == MENU_W1)
			{
    		menuChange(PARENTM);
			}
			break;

		case 10: //F10
			if(SELECTM == MENU_W1)
			{
			menuChange(STARTB);
			}
			break;

		case 12: //UP
			switch(SELECTM)
			{
			case MENU_POP_UP: shiftButtonPopUp != 0 ? shiftButtonPopUp--  :shiftButtonPopUp; ENTERFUNCM();
				break;

			case MENU_CREATURE: shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
				break;

			case MENU_COPY: shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
				break;

			case MENU_W1:
				fileChoiceUp(Y_NameFileColumn_1, X_NameFileColumn_1);
				break;

			case MENU_SETTINGS:
				shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
				break;

			case MENU_ACK_BOOT:
				shiftButtonPopUp != 0 ? shiftButtonPopUp-- : shiftButtonPopUp; ENTERFUNCM();
				break;

			case MENU_CLOCK:
				setUpDataTime(&watch);
				break;


			}

			break;

		case 13: //DOWN
			switch(SELECTM)
			{
			case MENU_POP_UP: shiftButtonPopUp >= 2 ? shiftButtonPopUp : shiftButtonPopUp ++;  ENTERFUNCM();
				break;

			case MENU_CREATURE: shiftButtonPopUp >= 2 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
				break;

			case MENU_COPY: shiftButtonPopUp >= 2 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
				break;

			case MENU_W1:
				fileChoiceDown(Y_NameFileColumn_1, X_NameFileColumn_1);
				break;

			case MENU_SETTINGS:
				shiftButtonPopUp >= 3 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
				break;

			case MENU_ACK_BOOT:
				shiftButtonPopUp >= 1 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
				break;

			case MENU_CLOCK: setDownDataTime(&watch);
				break;
			}

			break;

		case 14: //Right

					switch(SELECTM){

					case MENU_POP_UP:
					case MENU_COPY:
					case MENU_CREATURE: if(shiftButtonPopUp != 0)
										{
										shiftButtonPopUp >= 2 ? shiftButtonPopUp :shiftButtonPopUp ++;
										}
										else
											{
												counterTextPopUp++;
												if(counterTextPopUp >= strlen((char*)textPopUp))
												{
												counterTextPopUp = strlen((char*)textPopUp);
												}
											}
											ENTERFUNCM();
						break;


					case MENU_DELL: shiftButtonPopUp >= 1 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
						break;

					case MENU_COMPIL: shiftButtonPopUp >= 1 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
						break;

					case MENU_DEFRAG:
									if(defSpace > 0)
									{
										shiftButtonPopUp >= 1 ? shiftButtonPopUp : shiftButtonPopUp ++;
									}
									else
									{
										shiftButtonPopUp = 1;
									}
									ENTERFUNCM();
						break;

					case MENU_SETTINGS:
						shiftButtonPopUp >= 3 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
						break;

					case MENU_ACK_BOOT:
						shiftButtonPopUp >= 1 ? shiftButtonPopUp : shiftButtonPopUp ++; ENTERFUNCM();
						break;

					case MENU_CLOCK: setRightDataTime(&watch);
						break;
					}

			break;

		case 15: //Left

					switch(SELECTM){

					case MENU_POP_UP:
					case MENU_COPY:
					case MENU_CREATURE: if(shiftButtonPopUp != 0)
										{
										shiftButtonPopUp != 0 ? shiftButtonPopUp-- : shiftButtonPopUp;
										}
										else
											{
												counterTextPopUp--;
												if(counterTextPopUp <= 0)
												{
												counterTextPopUp = 0;
												}
											}
											ENTERFUNCM();
						break;

					case MENU_DELL: shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
						break;


					case MENU_COMPIL: shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
						break;

					case MENU_DEFRAG:
								if(defSpace > 0)
								{
									shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;
								}
								else
								{
									shiftButtonPopUp = 1;
								}
								ENTERFUNCM();
						break;

					case MENU_SETTINGS:
						shiftButtonPopUp != 0 ? shiftButtonPopUp -- : shiftButtonPopUp;  ENTERFUNCM();
						break;

					case MENU_ACK_BOOT:
						shiftButtonPopUp != 0 ? shiftButtonPopUp-- : shiftButtonPopUp; ENTERFUNCM();
						break;

					case MENU_CLOCK: setLeftDataTime(&watch);
					break;
					}

			break;

		case 0x1b:  // ESC
			EscKey();
			break;
		}

	}

}


void moveM(uint32_t y, uint32_t x)
{
	MenuX = x;
	MenuY = y;
	moveMenu(y,x);
}


void colorM(uint32_t colF, uint32_t colB)
{
	while(sizeStackMenu(&Menu) > 5000){
		asm("nop");
	};

	uint32_t dim = 0;

	MenuColorF = colF & 0x7;

	MenuColorB = colB & 0x7;

	dim = colF & 0x8;

	dim = colB & 0x8;

	if(dim == 0){
	attrsetMenu(((MenuColorF & 0x7) << 8) | ((MenuColorB & 0x7) << 12));
	}
	else{
	attrsetMenu(((MenuColorF & 0x7) << 8) | ((MenuColorB & 0x7) << 12) | A_BOLD);
	}
}


void chM(uint8_t ch)
{
	while(sizeStackMenu(&Menu) > 5000){
		asm("nop");
	};

	if(sizeWindowAxisX >= MenuX)
	{
		addchMenu(ch);
		writeWindow(MenuY, MenuX, MenuColorF, MenuColorB, (char*)&ch, 1);
	}
}


void strM(uint8_t *str)
{
	while(sizeStackMenu(&Menu) > 5000){
		asm("nop");
	};

	int32_t len = strlen((char*)str);

	if((MenuX + len) >= sizeWindowAxisX){
		str[sizeWindowAxisX - MenuX] = 0;

		len = sizeWindowAxisX - len;
	}
	addstrMenu((char*)str);

	writeWindow(MenuY, MenuX, MenuColorF, MenuColorB, (char*)str, len);
}


void writeWindow(uint32_t y, uint32_t x, uint32_t colF, uint32_t colB, char *str, uint32_t len)
{
	int32_t i;

	if((MenuX + len) <= sizeWindowAxisX){

	for(i = 0; i < len; i++){
		MenuDISP[y][x + i].ch = *str++;
			MenuDISP[y][x + i].F_C = colF;
				MenuDISP[y][x + i].B_C = colB;
	}
		MenuX = MenuX + len;

	}
	else{

		for(i = 0; i < (sizeWindowAxisX - len); i++){
			MenuDISP[y][x + i].ch = *str++;
				MenuDISP[y][x + i].F_C = colF;
					MenuDISP[y][x + i].B_C = colB;
		}
			MenuX = sizeWindowAxisX;
	}

}


void DraWClock(uint32_t y, uint32_t x, uint8_t hours, uint8_t minutes, uint8_t seconds, uint16_t year, uint8_t month, uint8_t day)
{
	if(onOffCursor == 0)
	{
	char text[32];
	memset(text, 0, sizeof(text));
	sprintf(text,"%02d:%02d", hours, minutes);
	moveM(y,x);
	colorM(Black, Cyan);
	strM((uint8_t*)text);
	}
}


void drawTypeFile(uint32_t y, uint32_t x)
{
	uint32_t i = 0, Y = y, X = x;
	char linkedText[32], generalText[32];
	memset(linkedText, 0, sizeof(linkedText));
	memset(generalText, 0, sizeof(generalText));

	for(i = offsetFile; i < 50 + offsetFile; i++)
	{
	if(i == Num_File && numberFilesInSystem > 0)
	{
		drawContentFile(Y_ContentFile, X_ContentFile, ListFileItem[Num_File]);
		colorM(Black, Yellow);
	}
	else
		{
		colorM(White, Blue);
		}


	if(i <= 24 + offsetFile){
	moveM(Y++, X);
	if(i < numberFilesInSystem)
	{
		sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
		sprintf(generalText,"%-24s",linkedText);
	}
	else
		{
		sprintf(generalText,"%-24s","                       ");
		}
		strM((uint8_t*)generalText);
	}
	else{
		if(i == 25 + offsetFile){
			 Y = y;
			 X = X + 25;
		}
		moveM(Y++, X);
		if(i < numberFilesInSystem)
		{
			sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
			sprintf(generalText,"%-24s",linkedText);
		}
		else
			{
			sprintf(generalText,"%-24s","                       ");
			}
			strM((uint8_t*)generalText);
		}
			memset(linkedText, 0, sizeof(linkedText));
			memset(generalText, 0, sizeof(generalText));
	}

}


void drawContentFile(uint32_t y, uint32_t x, uint32_t num)
{
	uint32_t Y = y, X = x;

	char text[64];
	memset(text, 0, sizeof(text));

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-16s",": ");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%02d%c%02d%c%04d", HeaderFileList[num]->date.day, '.', HeaderFileList[num]->date.mounts, '.', HeaderFileList[num]->date.year + 2000);
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-18s","६:");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%02d%c%02d%c%02d", HeaderFileList[num]->time.hour, ':', HeaderFileList[num]->time.min, ':', HeaderFileList[num]->time.sec);
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-16s","ࠧ: ");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)HeaderFileList[num]->size);
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-16s"," ᥪ: ");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)HeaderFileList[num]->numberSector);
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-16s"," 䠩 ");
	strM((uint8_t*)text);
	moveM(++Y, X);
	sprintf(text,"%-16s","ᥪ: ");
	strM((uint8_t*)text);

	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)quantityBusySector(HeaderFileList[num]->size));
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-16s","CRC: ");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%6s%04x","0x", (int)HeaderFileList[num]->crc);
	strM((uint8_t*)text);
}


void infoFileSystem(void)
{
	uint32_t Y = 16, X = X_ContentFile;
	char text[64];
	memset(text, 0, sizeof(text));

	colorM(Cyan, Blue);
	moveM(Y, X);
	sprintf(text,"%-21s","ᨬ쭮 ");
	strM((uint8_t*)text);
	moveM(++Y, X);
	sprintf(text,"%-16s","ࠧ 䠩:");
	strM((uint8_t*)text);

	colorM(Yellow, Blue);
	sprintf(text,"%8d", (int)((numbeSectors - quantityBusySectorSystem() - defSpace)* SIZE_CLASTER > 0xFA00 ? 0xFA00 : (numbeSectors - quantityBusySectorSystem() - defSpace)* SIZE_CLASTER)/1000);
	strM((uint8_t*)text);


	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-20s","⢮ ᢮");
	strM((uint8_t*)text);
	moveM(++Y, X);
	sprintf(text,"%-16s","ᥪ஢:");
	strM((uint8_t*)text);

	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)(numbeSectors - quantityBusySectorSystem() - defSpace));
	strM((uint8_t*)text);


	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-20s","⢮ ");
	strM((uint8_t*)text);
	moveM(++Y, X);
	sprintf(text,"%-16s","ᥪ஢:");
	strM((uint8_t*)text);

	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)(numbeSectors - (numbeSectors - quantityBusySectorSystem() - defSpace)));
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-20s","⢮ 䠩: ");
	strM((uint8_t*)text);
	colorM(Yellow, Blue);
	sprintf(text,"%6d", (int)numberFilesInSystem);
	strM((uint8_t*)text);

	colorM(Cyan, Blue);
	moveM(++Y, X);
	sprintf(text,"%-20s","ࠣ஢");
	strM((uint8_t*)text);
	moveM(++Y, X);
	sprintf(text,"%-16s","ᥪ஢:");
	strM((uint8_t*)text);

	colorM(Yellow, Blue);
	sprintf(text,"%10d", (int)defSpace);
	strM((uint8_t*)text);
}


void drawErrors(uint32_t y, uint32_t x)
{
	char text[80];
	memset(text,0,sizeof(text));
	colorM(White, Black);
	moveM(y, x);
	SysMem.ERRORS[79] = 0;
	snprintf(text, sizeof(text),"%-79s", SysMem.ERRORS);
	strM((uint8_t*)text);
}


void openPopUpRename(_popUp *popUp)
{
	int32_t i, j;

	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->inputFieldY, popUp->inputFieldX);
	colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
	strM((uint8_t*)popUp->inputFieldStr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpNewFile(_popUp *popUp)
{
	int32_t i, j;
	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->srt1Y, popUp->srt1X);
	colorM(popUp->str1ColF, popUp->str1ColB);
	strM((uint8_t*)popUp->str1);

	moveM(popUp->inputFieldY, popUp->inputFieldX);
	colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
	strM((uint8_t*)popUp->inputFieldStr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpDellFile(_popUp *popUp)
{
	int32_t i, j;

	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->srt1Y, popUp->srt1X);
	colorM(popUp->str1ColF, popUp->str1ColB);
	strM((uint8_t*)popUp->str1);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpCopyFile(_popUp *popUp)
{
	int32_t i, j;

	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}

		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->srt1Y, popUp->srt1X);
	colorM(popUp->str1ColF, popUp->str1ColB);
	strM((uint8_t*)popUp->str1);

	moveM(popUp->inputFieldY, popUp->inputFieldX);
	colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
	strM((uint8_t*)popUp->inputFieldStr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpCompilFile(_popUp *popUp)
{
	int32_t i, j;

	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
			{
				moveM(popUp->Y + i, popUp->X);
			}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpDefrag(_popUp *popUp)
{
	int32_t i, j;

	memset(&PopUpDisp, 0, sizeof(PopUpDisp));

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
			{
			moveM(popUp->Y + i, popUp->X);
			}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	if(defSpace == 0)
	{
	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
	strM((uint8_t*)popUp->ButCancelStr);

	shiftButtonPopUp = 1;
	}
	else
	{
	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
	}
}


void openPopUpWarning(_popUp *popUp)
{
	int32_t i, j;

	for(i = 0; i < popUp->sizeY; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}
		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
			{
			moveM(popUp->Y + i, popUp->X);
			}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);
}


void openPopUpSaveAs(_popUp *popUp)
{
	int32_t i, j;

	for(i = 0; i < popUp->sizeY; i++){
		for(j = 0; j < popUp->sizeX; j++){
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
				PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
					PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}
		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);
}


void openPopUpSettings (_settings *popUp)
{
	int32_t i, j;
		for(i = 0; i < popUp->sizeY; i++)
		{
			for(j = 0; j < popUp->sizeX; j++)
			{
				PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
				PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
				PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
			}
				if(i == popUp->sizeY - 1)
				{
					moveM(popUp->Y + i, popUp->X + 1);
				}
				else
					{
					moveM(popUp->Y + i, popUp->X);
					}
					colorM(popUp->frameColF, popUp->frameColB);
					strM((uint8_t*)&popUp->frame[i][0]);
		}

		moveM(popUp->srtHeadY, popUp->srtHeadX);
		colorM(popUp->HeadColF, popUp->HeadColB);
		strM((uint8_t*)popUp->Headstr);

		moveM(popUp->srt1Y, popUp->srt1X);   // 뢮 ᮢ
		colorM(popUp->str1OnF, popUp->str1OnB);
		strM((uint8_t*)popUp->str1Off);

		moveM(popUp->srt2Y, popUp->srt2X);  // 뢮 祭 ⫮
		colorM(popUp->str2OffF, popUp->str2OffB);
		strM((uint8_t*)popUp->str2Off);

		moveM(popUp->ButEnterY, popUp->ButEnterX);
		colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
		strM((uint8_t*)popUp->ButEnterStr);

		moveM(popUp->ButCancelY, popUp->ButCancelX);
		colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
		strM((uint8_t*)popUp->ButCancelStr);
}


void openPopUpBoot(_popUp *popUp)
{
	int32_t i, j;

	for(i = 0; i < popUp->sizeY; i++){
		for(j = 0; j < popUp->sizeX; j++){
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
				PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
					PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}
		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}


	moveM(popUp->srtHeadY, popUp->srtHeadX);
	colorM(popUp->HeadColF, popUp->HeadColB);
	strM((uint8_t*)popUp->Headstr);

	moveM(popUp->srt1Y, popUp->srt1X);
	colorM(popUp->str1ColF, popUp->str1ColB);
	strM((uint8_t*)popUp->str1);

	moveM(popUp->ButEnterY, popUp->ButEnterX);
	colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	strM((uint8_t*)popUp->ButEnterStr);

	moveM(popUp->ButCancelY, popUp->ButCancelX);
	colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	strM((uint8_t*)popUp->ButCancelStr);
}


void closePopUp(_popUp *popUp)
{
	int32_t i = 0, j = 0;
	uint32_t oldColF = 0, oldColB = 0;

	for(i = 0; i < popUp->sizeY ; i++){

		moveM(popUp->Y + i, popUp->X);

		for(j = 0; j < popUp->sizeX; j++){

			if(oldColF != PopUpDisp[i][j].F_C || oldColB != PopUpDisp[i][j].B_C){
						colorM(PopUpDisp[i][j].F_C, PopUpDisp[i][j].B_C);
			}
				chM(PopUpDisp[i][j].ch);
					oldColF = PopUpDisp[i][j].F_C;
						oldColB = PopUpDisp[i][j].B_C;
		}

	}
}


void closePopUpSettings(_settings *popUp)
{
	int32_t i = 0, j = 0;
	uint32_t oldColF = 0, oldColB = 0;

	for(i = 0; i < popUp->sizeY ; i++){

		moveM(popUp->Y + i, popUp->X);

		for(j = 0; j < popUp->sizeX; j++){

			if(oldColF != PopUpDisp[i][j].F_C || oldColB != PopUpDisp[i][j].B_C){
						colorM(PopUpDisp[i][j].F_C, PopUpDisp[i][j].B_C);
			}
				chM(PopUpDisp[i][j].ch);
				oldColF = PopUpDisp[i][j].F_C;
				oldColB = PopUpDisp[i][j].B_C;
		}

	}
}


void outputMessagesPopUp(uint8_t buf)
{
	    if(SELECTM == MENU_POP_UP || SELECTM == MENU_CREATURE || SELECTM == MENU_COPY || SELECTM == MENU_DELL
	    	|| SELECTM == MENU_WARNING || SELECTM == MENU_COMPIL || SELECTM == MENU_DEFRAG || SELECTM == MENU_SETTINGS || SELECTM == MENU_CLOCK
			|| SELECTM == MENU_ACK_BOOT
		  )
	    {
	    	switch(buf){

	    	case 0x8: // 㤠 ᨬ BackSpace
	    		backSpace();
	    		break;

	    	case 0x7f:
	    		delete();
	    		break;

	    	case '\t': // ᫨  tab
	    		tab();
	    		break;

	    	case 0xd: // ᫨  ENTER
	    		EnterKey();
	    		break;

	    	case ',' :
	    	case '.' :
	    			switch(SELECTM)
	    			{
	    				case MENU_POP_UP:
	    					checkInputPoint(&popUpName);
	    					break;

	    				case MENU_CREATURE:
	    					checkInputPoint(&popUpNewFile);
	    					break;

	    				case MENU_COPY:
	    					checkInputPoint(&popUpCopy);
    			    	break;
	    			}
	    		break;

	    		case '0':
	    		case '1':
	    		case '2':
	    		case '3':
	    		case '4':
	    		case '5':
	    		case '6':
	    		case '7':
	    		case '8':
	    		case '9':

	    		case 'a':
	    		case 'b':
	    		case 'c':
	    		case 'd':
	    		case 'e':
	    		case 'f':
	    		case 'g':
	    		case 'h':
	    		case 'i':
	    		case 'j':
	    		case 'k':
	    		case 'l':
	    		case 'm':
	    		case 'n':
	    		case 'o':
	    		case 'p':
	    		case 'q':
	    		case 'r':
	    		case 's':
	    		case 't':
	    		case 'u':
	    		case 'v':
	    		case 'w':
	    		case 'x':
	    		case 'y':
	    		case 'z':

	    		case 'A':
	    		case 'B':
	    		case 'C':
	    		case 'D':
	    		case 'E':
	    		case 'F':
	    		case 'G':
	    		case 'H':
	    		case 'I':
	    		case 'J':
	    		case 'K':
	    		case 'L':
	    		case 'M':
	    		case 'N':
	    		case 'O':
	    		case 'P':
	    		case 'Q':
	    		case 'R':
	    		case 'S':
	    		case 'T':
	    		case 'U':
	    		case 'V':
	    		case 'W':
	    		case 'X':
	    		case 'Y':
	    		case 'Z':

	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':

	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':
	    		case '':

	    		switch(SELECTM)
	    		{
				case MENU_POP_UP:
					checkInputChar(&popUpName, buf);
					break;

				case MENU_CREATURE:
					checkInputChar(&popUpNewFile, buf);
					break;

				case MENU_COPY:
					checkInputChar(&popUpCopy, buf);
		    	break;

	    		    case MENU_CLOCK:
	    			if(watchCell != 2)
	    			{
	    				if(counterChar < 2 && strlen((char*)bufWatch.buf[watchCell]) < 2)
	    				{
	    					if(!(counterChar == 0 && buf == '0'))
	    					{
	    						addCharStr(textPopUp, buf, (int16_t*)&counterChar);
	    						inputStrDataTime(&watch, textPopUp);
	    					}
	    				}
	    			}
	    			else
	    				{
	    					if(counterChar < 4 && strlen((char*)bufWatch.buf[watchCell]) < 4)
	    					{
		    					if(!(counterChar == 0 && buf == '0'))
		    					{
		    						addCharStr(textPopUp, buf, (int16_t*)&counterChar);
		    						inputStrDataTime(&watch, textPopUp);
		    					}
	    					}
	    				}
	    		    break;
	    		}

	    		break;
	    	}
	    }
}


void openPopUpProgressbar(_popUpProgressbar *popUp)
{
	int32_t i = 0, j = 0;

	for(i = 0; i < popUp->sizeY ; i++)
	{
		for(j = 0; j < popUp->sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + popUp->Y][j + popUp->X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ popUp->Y][j + popUp->X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + popUp->Y][j + popUp->X].B_C;
		}

		if(i == popUp->sizeY - 1)
		{
			moveM(popUp->Y + i, popUp->X + 1);
		}
		else
		{
			moveM(popUp->Y + i, popUp->X);
		}
		colorM(popUp->frameColF, popUp->frameColB);
		strM((uint8_t*)&popUp->frame[i][0]);
	}

	moveM(popUp->srtY1, popUp->srtX1);
	colorM(popUp->strColF1, popUp->strColB1);
	strM((uint8_t*)popUp->Str1);

	moveM(popUp->srtY2, popUp->srtX2);
	colorM(popUp->strColF2, popUp->strColB2);
	strM((uint8_t*)popUp->Str2);

	moveM(popUp->ProgBarY, popUp->ProgBarX);
	colorM(popUp->ProgBarColF, popUp->ProgBarColB);
	strM((uint8_t*)popUp->ProgBarStr);
}


void outputScaleProgressbar(_popUpProgressbar *popUp, int16_t percent)
{
	uint16_t i =0;
	moveM(popUp->ProgBarY, popUp->ProgBarX);
	colorM(popUp->ProgBarColF, popUp->ProgBarColB);

	if(percent == 0)
	{
	strM((uint8_t*)popUp->ProgBarStr);
	}
	else
		{
			if(percent <= 100)
			{
				for(i = 0; i < percent; i++)
				{
					if((i % 4) == 0)
					{
						chM('');
					}
				}
			}
		}

	while(sizeStackMenu(&Menu)){
		asm("nop");
	};
}


void closePopUpProgressbar(_popUpProgressbar *popUp)
{
		int32_t i = 0, j = 0;
		uint32_t oldColF = 0, oldColB = 0;

		for(i = 0; i < popUp->sizeY ; i++){

			moveM(popUp->Y + i, popUp->X);

			for(j = 0; j < popUp->sizeX; j++){

				if(oldColF != PopUpDisp[i][j].F_C || oldColB != PopUpDisp[i][j].B_C){
							colorM(PopUpDisp[i][j].F_C, PopUpDisp[i][j].B_C);
				}
					chM(PopUpDisp[i][j].ch);
					oldColF = PopUpDisp[i][j].F_C;
					oldColB = PopUpDisp[i][j].B_C;
			}

		}
}


void openClock(_watch *clock)
{
	int32_t i, j;

	for(i = 0; i < clock->field.sizeY; i++)
	{
		for(j = 0; j < clock->field.sizeX; j++)
		{
			PopUpDisp[i][j].ch = MenuDISP[i + clock->field.Y][j + clock->field.X].ch;
			PopUpDisp[i][j].F_C = MenuDISP[i+ clock->field.Y][j + clock->field.X].F_C;
			PopUpDisp[i][j].B_C = MenuDISP[i + clock->field.Y][j + clock->field.X].B_C;
		}

		if(i == clock->field.sizeY - 1)
		{
			moveM(clock->field.Y + i, clock->field.X + 1);
		}
		else
		{
			moveM(clock->field.Y + i, clock->field.X);
		}
		colorM(clock->field.frameColF, clock->field.frameColB);
		strM((uint8_t*)&frameClock[i][0]);
	}

	snprintf((char*)bufWatch.field.hour, sizeof(bufWatch.field.hour) - 1, "%d", Rtctime.hours);
	snprintf((char*)bufWatch.field.min,  sizeof(bufWatch.field.min) - 1,  "%d", Rtctime.minutes);
	snprintf((char*)bufWatch.field.sec,  sizeof(bufWatch.field.sec) - 1,  "%d", Rtctime.seconds);

	snprintf((char*)bufWatch.field.year, sizeof(bufWatch.field.year) - 1, "%d", Rtcdata.year + 2000);
	snprintf((char*)bufWatch.field.mon,  sizeof(bufWatch.field.mon) - 1,  "%d", Rtcdata.month);
	snprintf((char*)bufWatch.field.day,  sizeof(bufWatch.field.day) - 1,  "%d", Rtcdata.day);

	moveM(clock->field.srtY0, clock->field.srtX0);
	colorM(clock->field.strColF0, clock->field.strColB0);
	strM((uint8_t*)clock->field.Str0);

	moveM(clock->field.srtY1, clock->field.srtX1);
	colorM(clock->field.strColF1, clock->field.strColB1);
	strM((uint8_t*)clock->field.Str1);

	moveM(clock->field.srtY2, clock->field.srtX2);
	colorM(clock->field.strColF2, clock->field.strColB2);
	strM((uint8_t*)clock->field.Str2);

	moveM(clock->field.srtY3, clock->field.srtX3);
	colorM(clock->field.strColF3, clock->field.strColB3);
	strM((uint8_t*)clock->field.Str3);

	moveM(clock->field.srtY4, clock->field.srtX4);
	colorM(clock->field.strColF4, clock->field.strColB4);
	strM((uint8_t*)clock->field.Str4);

	moveM(clock->field.srtY5, clock->field.srtX5);
	colorM(clock->field.strColF5, clock->field.strColB5);
	strM((uint8_t*)clock->field.Str5);

	moveM(clock->field.srtY6, clock->field.srtX6);
	colorM(clock->field.strColF6, clock->field.strColB6);
	strM((uint8_t*)clock->field.Str6);


	moveM(clock->field.srtY7, clock->field.srtX7);
	colorM(clock->field.strColF7, clock->field.strColB7);
	strM((uint8_t*)clock->field.Str7);


	moveM(clock->field.srtY8, clock->field.srtX8);
	colorM(clock->field.strColF8, clock->field.strColB8);
	strM((uint8_t*)clock->field.Str8);

	moveM(clock->field.dayY, clock->field.dayX);
	colorM(clock->field.dayColOnF, clock->field.dayColOnB);
	strM(addSpaceInStr(bufWatch.field.day, 6));

	moveM(clock->field.monY, clock->field.monX);
	colorM(clock->field.monColOffF, clock->field.monColOffB);
	strM((uint8_t*)bufWatch.field.mon);

	moveM(clock->field.yearY, clock->field.yearX);
	colorM(clock->field.yearColOffF, clock->field.yearColOffB);
	strM((uint8_t*)bufWatch.field.year);

	moveM(clock->field.hourY, clock->field.hourX);
	colorM(clock->field.hourColOffF, clock->field.hourColOffB);
	strM((uint8_t*)bufWatch.field.hour);

	moveM(clock->field.minY, clock->field.minX);
	colorM(clock->field.minColOffF, clock->field.minColOffB);
	strM((uint8_t*)bufWatch.field.min);

	moveM(clock->field.secY, clock->field.secX);
	colorM(clock->field.secColOffF, clock->field.secColOffB);
	strM((uint8_t*)bufWatch.field.sec);

	moveM(clock->field.butEnterY, clock->field.butEnterX);
	colorM(clock->field.butEnterOffF, clock->field.butEnterOffB);
	strM((uint8_t*)clock->field.butEnterStr);

	moveM(clock->field.butCancelY, clock->field.butCancelX);
	colorM(clock->field.butCancelOffF, clock->field.butCancelOffB);
	strM((uint8_t*)clock->field.butCancelStr);

	memcpy(textPopUp,bufWatch.buf[watchCell], strlen((char*)bufWatch.buf[watchCell]));

	curs_setMenu(1);
	cursorInputY = clock->field.dayY, cursorInputX = clock->field.dayX + strlen((char*)bufWatch.field.day);
	moveM(cursorInputY, cursorInputX);
	counterChar = strlen((char*)bufWatch.field.day);
}


void closeClock(_watch *clock)
{
	int32_t i, j;
	uint32_t oldColF = 0, oldColB = 0;

	for(i = 0; i < clock->field.sizeY; i++)
	{
		moveM(clock->field.Y + i, clock->field.X);

		for(j = 0; j < clock->field.sizeX; j++)
		{
			if(oldColF != PopUpDisp[i][j].F_C || oldColB != PopUpDisp[i][j].B_C)
			{
				colorM(PopUpDisp[i][j].F_C, PopUpDisp[i][j].B_C);
			}
				chM(PopUpDisp[i][j].ch);
				oldColF = PopUpDisp[i][j].F_C;
				oldColB = PopUpDisp[i][j].B_C;
		}
	}
	memset(&bufWatch, 0, sizeof(bufWatch));
	curs_setMenu(0);
	watchCell = 0;
	counterChar = 0;
}


void setLeftDataTime(_watch *clock)
{
	uint32_t Y, X, colF, colB;

	if(watchCell <= 5)
	{
		curs_setMenu(1);
		Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
		X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
		colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 2];
		colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 3];
		moveM(Y, X);
		colorM(colF, colB);
		strM(addSpaceInStr(bufWatch.buf[watchCell], 6));

		counterChar--;
		if(counterChar <= 0)
		{
		counterChar = 0;
		}
		moveM(Y, X + counterChar);
	}
	else
		{
		curs_setMenu(0);
		Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
		X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
		colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 4];
		colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 5];
		moveM(Y, X);
		colorM(colF, colB);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);

		watchCell --;
		if(watchCell < 0)
		{
		watchCell = 7;
		}

		Y = clock->buf[numberCellWatch + watchCell*stepWatch];
		X = clock->buf[numberCellWatch + watchCell*stepWatch + 1];
		colF = clock->buf[numberCellWatch + watchCell*stepWatch + 2];
		colB = clock->buf[numberCellWatch + watchCell*stepWatch + 3];
		moveM(Y, X);
		colorM(colF, colB);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);

		}
}


void setRightDataTime(_watch *clock)
{
	uint32_t Y, X, colF, colB;

		if(watchCell <= 5)
		{
		curs_setMenu(1);
		Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
		X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
		colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 2];
		colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 3];
		moveM(Y, X);
		colorM(colF, colB);
		strM(addSpaceInStr(bufWatch.buf[watchCell], 6));

		uint16_t len = strlen((char*)bufWatch.buf[watchCell]);

		counterChar++;
		if(watchCell != 2)
		{
			if(len >= 2)
			{
				len = 2;
				bufWatch.buf[watchCell][2] = 0;
			}

			if(counterChar >= len)
			{
				counterChar = len;
			}
		}
		else
			{
				if(len >= 4)
				{
					len = 4;
				bufWatch.buf[watchCell][4] = 0;
				}

				if(counterChar >= len)
				{
				counterChar = len;
				}
			}
			moveM(Y, X + counterChar);
		}
		else
			{
			curs_setMenu(0);
			Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
			X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
			colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 4];
			colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 5];
			moveM(Y, X);
			colorM(colF, colB);
			strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);

			watchCell ++;
			if(watchCell >= 8)
			{
			watchCell = 0;
			}

			Y = clock->buf[numberCellWatch + watchCell*stepWatch];
			X = clock->buf[numberCellWatch + watchCell*stepWatch + 1];
			colF = clock->buf[numberCellWatch + watchCell*stepWatch + 2];
			colB = clock->buf[numberCellWatch + watchCell*stepWatch + 3];
			moveM(Y, X);
			colorM(colF, colB);
			strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);
			}
}


void setUpDataTime(_watch *clock)
{
	uint32_t Y, X, colF, colB;

    Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
    X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
    colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 4];
    colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 5];
	moveM(Y, X);
	colorM(colF, colB);

	if(watchCell <= 5)
	{
		curs_setMenu(1);
		if(strlen((char*)bufWatch.buf[watchCell]) == 0)
		{
			strM(addSpaceInStr((uint8_t*)"0", 6));
		}
		else
			{
			strM(addSpaceInStr(bufWatch.buf[watchCell], 6));
			}
	}
	else{
		curs_setMenu(0);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);
		}

	watchCell --;
	if(watchCell < 0)
	{
		watchCell = 7;
	}

    Y = clock->buf[numberCellWatch + watchCell*stepWatch];
    X = clock->buf[numberCellWatch + watchCell*stepWatch + 1];
    colF = clock->buf[numberCellWatch + watchCell*stepWatch + 2];
    colB = clock->buf[numberCellWatch + watchCell*stepWatch + 3];
	moveM(Y, X);
	colorM(colF, colB);

	if(watchCell <= 5)
	{
	curs_setMenu(1);
	strM(addSpaceInStr(bufWatch.buf[watchCell], 6));
	memset(textPopUp, 0, sizeof(textPopUp));
	strcpy((char*)textPopUp, (char*)bufWatch.buf[watchCell]);
	counterChar = strlen((char*)bufWatch.buf[watchCell]);
	moveM(Y, X + counterChar);
	}
	else
		{
		curs_setMenu(0);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);
		}
}


void setDownDataTime(_watch *clock)
{
	uint32_t Y, X, colF, colB;

    Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
    X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
    colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 4];
    colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 5];
	moveM(Y, X);
	colorM(colF, colB);

	if(watchCell <= 5)
	{
		curs_setMenu(1);
		if(strlen((char*)bufWatch.buf[watchCell]) == 0)
		{
			strM(addSpaceInStr((uint8_t*)"0", 6));
		}
		else
			{
			strM(addSpaceInStr(bufWatch.buf[watchCell], 6));
			}
	}
	else{
		curs_setMenu(0);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);
		}

	watchCell ++;
	if(watchCell >= 8)
	{
		watchCell = 0;
	}

    Y = clock->buf[numberCellWatch + watchCell*stepWatch];
    X = clock->buf[numberCellWatch + watchCell*stepWatch + 1];
    colF = clock->buf[numberCellWatch + watchCell*stepWatch + 2];
    colB = clock->buf[numberCellWatch + watchCell*stepWatch + 3];
	moveM(Y, X);
	colorM(colF, colB);

	if(watchCell <= 5)
	{
	curs_setMenu(1);
	strM(addSpaceInStr(bufWatch.buf[watchCell], 6));
	counterChar = strlen((char*)bufWatch.buf[watchCell]);
	memset(textPopUp, 0, sizeof(textPopUp));
	strcpy((char*)textPopUp, (char*)bufWatch.buf[watchCell]);
	moveM(Y, X + counterChar);
	}
	else
		{
		curs_setMenu(0);
		strM((uint8_t*)&clock->buf[numberCellWatch + (watchCell)*stepWatch + 6]);
		}
}


void inputStrDataTime(_watch *clock, uint8_t *str)
{
	uint32_t Y, X, colF, colB;
	uint8_t text[16];
	memset(text, 0, sizeof(text));
	int32_t var;

    if(watchCell <= 5)
    {
        Y = clock->buf[numberCellWatch + (watchCell)*stepWatch];
        X = clock->buf[numberCellWatch + (watchCell)*stepWatch + 1];
        colF = clock->buf[numberCellWatch + (watchCell)*stepWatch + 2];
        colB = clock->buf[numberCellWatch + (watchCell)*stepWatch + 3];
    	moveM(Y, X);
    	colorM(colF, colB);
    	snprintf((char*)text,sizeof(text) - 1,"%s","     ");
    	strM(text);
    	moveM(Y, X);

        memset(bufWatch.buf[watchCell], 0, sizeof(bufWatch.buf[watchCell]));
    	memcpy(bufWatch.buf[watchCell], str, strlen((char*)str));
    	var =  atoi((char*)bufWatch.buf[watchCell]);

    	if(var != 0)
    	{
		if(watchCell == 2)
		{
			snprintf((char*)text,sizeof(text) - 1,"%d", (int)var);
		}
		else
			{
			snprintf((char*)text,sizeof(text) - 1,"%d", (int)var);
			}

		strM(text);
        }
    	else
    		{
    		memset(text, 0, sizeof(text));
    		strM(text);
    		}
    }
}


void saveDataTime(void)
{
	_RtcData data;
	_RtcTime time;

	data.day =    atoi((char*)bufWatch.field.day) > 31 ? 0 : atoi((char*)bufWatch.field.day);
	data.month =  atoi((char*)bufWatch.field.mon) > 12 ? 0 : atoi((char*)bufWatch.field.mon);
	data.year =   (atoi((char*)bufWatch.field.year) - 2000) > 100 ? 0 : (atoi((char*)bufWatch.field.year) - 2000);

	time.hours =   atoi((char*)bufWatch.field.hour) > 24 ? 0 : atoi((char*)bufWatch.field.hour);
	time.minutes = atoi((char*)bufWatch.field.min) > 60 ? 0 : atoi((char*)bufWatch.field.min);
	time.seconds = atoi((char*)bufWatch.field.sec) > 60 ? 0 : atoi((char*)bufWatch.field.sec);

	setTime(&time);
	setData(&data);
}


void fileChoiceUp(uint32_t y, uint32_t x)
{
	uint32_t i = 0, Y = y, X = x;
	char linkedText[32], generalText[32];
	memset(linkedText, 0, sizeof(linkedText));
	memset(generalText, 0, sizeof(generalText));

	if(Num_File != 0){
	PREVIOUS_File;

	for(i = offsetFile; i < (50 + offsetFile); i++)
	{
		if(i == Num_File && numberFilesInSystem > 0)
		{
			drawContentFile(Y_ContentFile, X_ContentFile, ListFileItem[Num_File]);
			colorM(Black, Yellow);
		}
		else
			{
			colorM(White, Blue);
			}

		if(i <= 24 + offsetFile)
		{
			moveM(Y++, X);
			if(i < numberFilesInSystem)
			{
				sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
				sprintf(generalText,"%-24s",linkedText);
			}
			else
				{
				sprintf(generalText,"%-24s","                       ");
				}
				strM((uint8_t*)generalText);
		}
		else{
			if(i == 25 + offsetFile)
			{
			 	 Y = y;
			 	 X = X + 25;
			}
			moveM(Y++, X);
			if(i < numberFilesInSystem)
			{
				sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
				sprintf(generalText,"%-24s",linkedText);
			}
			else
				{
				sprintf(generalText,"%-24s","                       ");
				}
				strM((uint8_t*)generalText);
		}
		memset(linkedText, 0, sizeof(linkedText));
		memset(generalText, 0, sizeof(generalText));

		}

		if(Num_File  <= offsetFile)
		{
			offsetFile --;
			if(offsetFile <= 0){offsetFile = 0;}
		}

	}

}


void fileChoiceDown(uint32_t y, uint32_t x)
{
	uint32_t i = 0, Y = y, X = x;
	char linkedText[32], generalText[32];
	memset(linkedText, 0, sizeof(linkedText));
	memset(generalText, 0, sizeof(generalText));

	if(Num_File < (numberFilesInSystem - 1))
	{
	Next_File;

	if(Num_File >= 50)
	{
		offsetFile ++;
		if(offsetFile >= (256 - 50)){offsetFile = 206;}
	}

	for(i = offsetFile; i < (50 + offsetFile); i++)
	{
		if(i == Num_File && numberFilesInSystem > 0)
		{
			drawContentFile(Y_ContentFile, X_ContentFile, ListFileItem[Num_File]);
			colorM(Black, Yellow);
		}
		else
			{
			colorM(White, Blue);
			}

		if(i <= 24 + offsetFile)
		{
		moveM(Y++, X);
		if(i < numberFilesInSystem)
		{
			sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
			sprintf(generalText,"%-24s",linkedText);
		}
		else
			{
			sprintf(generalText,"%-24s","                       ");
			}

			strM((uint8_t*)generalText);
		}
		else{
			if(i == 25 + offsetFile){
				 Y = y;
				 X = X + 25;
			}
			moveM(Y++, X);
			if(i < numberFilesInSystem)
			{
				sprintf(linkedText,"%s%c%s",HeaderFileList[ListFileItem[i]]->name,'.',HeaderFileList[ListFileItem[i]]->textExtension);
				sprintf(generalText,"%-24s",linkedText);
			}
			else
				{
				sprintf(generalText,"%-24s","                       ");
				}
				strM((uint8_t*)generalText);
		}
		memset(linkedText, 0, sizeof(linkedText));
		memset(generalText, 0, sizeof(generalText));
	}

	}

}


void DrawFrame(void) //  ࠬ
{
    for(uint32_t i = 0; i < (sizeWindowAxisY - 2); i++)
    {
    	for(uint32_t j = 0; j < sizeWindowAxisX; j++)
    	{
         MenuDISP[i][j].ch = frame[i][j];
         MenuDISP[i][j].F_C = Cyan;
         MenuDISP[i][j].B_C = Blue;
    	}
    }

    colorM(Yellow, Blue);
	moveM(Y_NameColumn_1, X_NameColumn_1);
	strM((uint8_t*)"");

	moveM(Y_NameColumn_2, X_NameColumn_2);
	strM((uint8_t*)"");

    colorM(Black, Cyan);
    moveM(0, 60);
	strM((uint8_t*)" ଠ ");

    Button(&ReadBut);
    Button(&DelBut);
    Button(&ChangeNameBut);
    Button(&CopyBut);
    Button(&DefragmentingBut);
    Button(&startB00);
    Button(&DataTimeBut);
    Button(&CopyFile);
    Button(&createBut);
    Button(&ReserveBut);

    numberFilesInSystem = quantityFileInSystem();
    defSpace = defragmentedSpace();
    infoFileSystem();
    drawTypeFile(Y_NameFileColumn_1, X_NameFileColumn_1);
}



void Button(_TypeButonPressed *but)
{
	moveM(but->y, but->x);
	colorM(but->numColF, but->numColB);
	strM((uint8_t*)but->numStr);

	colorM(but->strColF, but->strColB);
	strM((uint8_t*)but->str);
}



/*㭪樨   堭*/
void initInputKeyBoard(void)
{
	memset(&inputKeyBoard,0,sizeof(inputKeyBoard));
}

void pushInputKeyBoard(_inputKeyBoard *stack, uint8_t value)
{
	stack->data[stack->head ++] = value;
	stack->head &= (sizeBufInputKeyBoard - 1);
}

uint8_t popInputKeyBoard(_inputKeyBoard *stack)
{
	uint8_t var = 0;
    var = stack->data[stack->tail];
    if(stack->tail != stack->head)
    {
    	stack->tail ++;
    }
    stack->tail &= (sizeBufInputKeyBoard - 1);
    return(var);
}

uint8_t peekInputKeyBoard(_inputKeyBoard *stack)
{
	uint8_t var = 0;
	var = stack->data[stack->tail];
	return(var);
}

int sizeInputKeyBoard(_inputKeyBoard *stack)
{
	return((stack->head - stack->tail)&(sizeBufInputKeyBoard - 1));
}


void outSymbolEditor(char ch)
{
	addchMenu(ch);
}


void outStrEditor(char *str)
{
    addstrMenu(str);
}


void startByteCode(void)
{
	if(searchFile(&Manager, "b00"))
	{
		searchExecFile(&Manager);
		clearStack(&Stack_Zm);
		ZMODEMChange(&z_s1i1);
		menuChange(&m_s1i1);
		managerInitTaskBoo();
		TIM15->CR1 |= TIM_CR1_CEN;
		WORK_PROGRAM;
		initStackMenu();
		counterUpdateDisp = 0xFFFFFFF;
	}
	else{
		initStackMenu();
		menuChange(PREVIOUSM);
	}
}


void clickingRenamefile(void)
{
	int16_t len;
	char text[32];
	memset(text,0, sizeof(text));
	memset(textPopUp, 0, sizeof(textPopUp));
	counterTextPopUp = 0;
	openPopUpRename(&popUpName);
	len = strnlen(HeaderFileList[ListFileItem[Num_File]]->name, (sizeName - 1));

	memcpy(textPopUp, HeaderFileList[ListFileItem[Num_File]]->name, len);
	memcpy((textPopUp + len), (void*)".", 1);

	memcpy((textPopUp + len + 1), HeaderFileList[ListFileItem[Num_File]]->textExtension,
	strnlen(HeaderFileList[ListFileItem[Num_File]]->textExtension, (sizeTextExtension - 1)));

	moveM(popUpName.srt1Y, popUpName.srt1X);
	colorM(popUpName.str1ColF, popUpName.str1ColB);
	sprintf(text,"२ %s ",textPopUp);
	strM((uint8_t*)text);

	colorM(popUpName.inputFieldOnF, popUpName.inputFieldOnB);
	moveM(popUpName.inputFieldY, popUpName.inputFieldX);
	strM((uint8_t*)textPopUp);

	counterTextPopUp = strlen((char*)textPopUp);
	curs_setMenu(1);
	cursorInputX = popUpName.inputFieldX, cursorInputY = popUpName.inputFieldY;
}


void shiftButRenameFile(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpName;

    switch(shiftButtonPopUp)
    {
    	 case 0:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(1);
    		 break;

    	 case 1:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(0);
    		 break;

    	 case 2:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(0);
    		 break;
    }

    if(onOffCursor == 1)
    {
   	moveM(cursorInputY, cursorInputX + counterTextPopUp);
    }
}


void clikingNewFile(void)
{
	memset(textPopUp, 0, sizeof(textPopUp));
	counterTextPopUp = 0;
	openPopUpNewFile(&popUpNewFile);
	colorM(popUpNewFile.inputFieldOnF, popUpNewFile.inputFieldOnB);
	moveM(popUpNewFile.inputFieldY, popUpNewFile.inputFieldX);
	strM((uint8_t*)textPopUp);
	curs_setMenu(1);
	cursorInputX = popUpNewFile.inputFieldX, cursorInputY = popUpNewFile.inputFieldY;
}


void shiftclikingNewFile(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpNewFile;

     switch(shiftButtonPopUp)
     {
     	 case 0:
     		 moveM(popUp->inputFieldY, popUp->inputFieldX);
     		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
     		 strM((uint8_t*)textPopUp);

     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 curs_setMenu(1);
     		 break;

     	 case 1:
     		 moveM(popUp->inputFieldY, popUp->inputFieldX);
     		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
     		 strM((uint8_t*)textPopUp);

     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 curs_setMenu(0);
     		 break;

     	 case 2:
     		 moveM(popUp->inputFieldY, popUp->inputFieldX);
     		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
     		 strM((uint8_t*)textPopUp);

     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 curs_setMenu(0);
     		 break;
     }

     if(onOffCursor == 1)
     {
    	moveM(cursorInputY, cursorInputX + counterTextPopUp);
     }
}


void clickingDeleteBut(void)
{
	uint8_t linkedText[32], generalText[64];
	memset(linkedText, 0, sizeof(linkedText));
	memset(generalText, 0, sizeof(generalText));

	openPopUpDellFile(&popUpDellFile);
	moveM(popUpDellFile.inputFieldY,  popUpDellFile.inputFieldX);
	colorM(popUpDellFile.inputFieldOffF, popUpDellFile.inputFieldOffB);

	if(numberFilesInSystem > 0)  // ᫨  䠩
	{
	sprintf((char*)linkedText,"%s%c%s",HeaderFileList[ListFileItem[Num_File]]->name,'.',HeaderFileList[ListFileItem[Num_File]]->textExtension);
	centerText((char*)linkedText, (char*)generalText, strlen(popUpDellFile.inputFieldStr));
	}
	else
		{
		sprintf((char*)generalText,"%-24s"," ⥬ !");
		}
		strM((uint8_t*)generalText);
}


void shiftClickingDeleteBut(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpDellFile;

     switch(shiftButtonPopUp)
     {
     	 case 0:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;

     	 case 1:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;
     }

     if(onOffCursor == 1)
     {
    	moveM(cursorInputY, cursorInputX + counterTextPopUp);
     }
}


void clickingCopyBut(void)
{
		int16_t len;
		char text[32];
		memset(text,0, sizeof(text));
		memset(textPopUp, 0, sizeof(textPopUp));
		counterTextPopUp = 0;
		openPopUpCopyFile(&popUpCopy);
		len = strnlen(HeaderFileList[ListFileItem[Num_File]]->name, (sizeName - 1));

		memcpy(textPopUp, HeaderFileList[ListFileItem[Num_File]]->name, len);
		memcpy((textPopUp + len), (void*)".", 1);
		memcpy((textPopUp + len + 1), HeaderFileList[ListFileItem[Num_File]]->textExtension, strnlen(HeaderFileList[ListFileItem[Num_File]]->textExtension, (sizeTextExtension - 1)) );

		moveM(popUpCopy.srt1Y, popUpCopy.srt1X);
		colorM(popUpCopy.str1ColF, popUpCopy.str1ColB);
		sprintf(text,"஢ %s :",textPopUp);
		strM((uint8_t*)text);

		colorM(popUpCopy.inputFieldOnF, popUpCopy.inputFieldOnB);
		moveM(popUpCopy.inputFieldY, popUpCopy.inputFieldX);
		strM((uint8_t*)textPopUp);

		counterTextPopUp = strlen((char*)textPopUp);
		curs_setMenu(1);
		cursorInputX = popUpCopy.inputFieldX, cursorInputY = popUpCopy.inputFieldY;
}


void shiftClickingCopyBut(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpCopy;

    switch(shiftButtonPopUp)
    {
    	 case 0:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(1);
    		 break;

    	 case 1:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(0);
    		 break;

    	 case 2:
    		 moveM(popUp->inputFieldY, popUp->inputFieldX);
    		 colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    		 strM((uint8_t*)textPopUp);

    		 moveM(popUp->ButEnterY, popUp->ButEnterX);
    		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
    		 strM((uint8_t*)popUp->ButEnterStr);

    		 moveM(popUp->ButCancelY, popUp->ButCancelX);
    		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
    		 strM((uint8_t*)popUp->ButCancelStr);
    		 curs_setMenu(0);
    		 break;
    }

    if(onOffCursor == 1)
    {
   	moveM(cursorInputY, cursorInputX + counterTextPopUp);
    }
}


void clickingCompilBut(void)
{
	int16_t len;
	char text[32], alignmentCentStr[64];
	memset(text,0, sizeof(text));
	memset(alignmentCentStr, 0, sizeof(alignmentCentStr));
	memset(textPopUp, 0, sizeof(textPopUp));
	openPopUpCompilFile(&popUpCompil);
	moveM(popUpCompil.srt1Y, popUpCompil.srt1X);
	colorM(popUpCompil.str1ColF, popUpCompil.str1ColB);

	if(numberFilesInSystem != 0)
	{
		len = strlen(HeaderFileList[ListFileItem[Num_File]]->name) > (sizeName - 1) ? (sizeName - 1) : strlen(HeaderFileList[ListFileItem[Num_File]]->name);
		memcpy(textPopUp, HeaderFileList[ListFileItem[Num_File]]->name, len);
		memcpy((textPopUp + len), (void*)".", 1);
		memcpy((textPopUp + len + 1), HeaderFileList[ListFileItem[Num_File]]->textExtension,
										strlen(HeaderFileList[ListFileItem[Num_File]]->textExtension) > (sizeTextExtension - 1)
											? (sizeTextExtension - 1)
												: strlen(HeaderFileList[ListFileItem[Num_File]]->textExtension));
		sprintf(text,"஢ %s",textPopUp);

	}
	else
		{
		sprintf(text,"  ⥬");
		}
		centerText(text, alignmentCentStr, strlen(popUpCompil.str1));
		strM((uint8_t*)alignmentCentStr);

		colorM(popUpCompil.inputFieldOffF, popUpCompil.inputFieldOffB);
		moveM(popUpCompil.inputFieldY, popUpCompil.inputFieldX);
		if(numberFilesInSystem != 0)
		{
		sprintf(text," ᯮ塞  ?");
		}
		else
		{
		sprintf(text," ");
		}
		centerText(text, alignmentCentStr, strlen(popUpCompil.str1));
		strM((uint8_t*)alignmentCentStr);

		memset(textPopUp, 0, sizeof(textPopUp));
		counterTextPopUp = 0;
}


void shiftClickingCompilBut(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpCompil;

     switch(shiftButtonPopUp)
     {
     	 case 0:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;

     	 case 1:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;
     }
}


void clickingDefragBut(void)
{
	char text[32];
	memset(text,0, sizeof(text));
	openPopUpDefrag(&popUpDefrag);

	if(defSpace == 0){
		moveM(popUpDefrag.srt1Y, popUpDefrag.srt1X);
		colorM(popUpDefrag.str1ColF, popUpDefrag.str1ColB);

		sprintf(text,"  ࠣ஢ %d", (int)defSpace);
		strM((uint8_t*)text);

		moveM(popUpDefrag.inputFieldY, popUpDefrag.inputFieldX);
		colorM(popUpDefrag.inputFieldOffF, popUpDefrag.inputFieldOffB);

		sprintf(text," ࠣ  㦭");
		strM((uint8_t*)text);
	}
	else
	{
		moveM(popUpDefrag.srt1Y, popUpDefrag.srt1X);
		colorM(popUpDefrag.str1ColF, popUpDefrag.str1ColB);

		sprintf(text,"  ࠣ஢ %d", (int)defSpace);
		strM((uint8_t*)text);

		moveM(popUpDefrag.inputFieldY, popUpDefrag.inputFieldX);
		colorM(popUpDefrag.inputFieldOffF, popUpDefrag.inputFieldOffB);

		sprintf(text," ࠣ 㦭");
		strM((uint8_t*)text);
	}
}


void shiftClickingDefragBut(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpDefrag;

     switch(shiftButtonPopUp)
     {
     	 case 0:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;

     	 case 1:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;
     }
}


void processingDefrag(void)
{
	closePopUp(&popUpDefrag);
	openPopUpProgressbar(&popUpProgressbar);

	while(sizeStackMenu(&Menu)){
		asm("nop");
	}
}


void clickingEditorBut(void)
{
	workRedactor = 1;
}


void clickingSettingsBut(void)
{
	openPopUpSettings(&settings);
}


void shiftSettingsBut(void)
{
	    _settings *popUp;
		popUp = (_settings*)&settings;

	     switch(shiftButtonPopUp)
	     {
	     	 case 0:
	     		 moveM(popUp->srt1Y, popUp->srt1X);
	     		 colorM(popUp->str1OnF, popUp->str1OnB);
	     		 if(choiceSettings == SETTINGS_CLOCK)
	     		 {
	     		 strM((uint8_t*)popUp->str1On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str1Off);
	     		 }

	     		 moveM(popUp->srt2Y, popUp->srt2X);
	     		 colorM(popUp->str2OffF, popUp->str2OffB);
	     		 if(choiceSettings == SETTINGS_BOOT)
	     		 {
	     		 strM((uint8_t*)popUp->str2On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str2Off);
	     		 }

	     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
	     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	     		 strM((uint8_t*)popUp->ButEnterStr);

	     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
	     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	     		 strM((uint8_t*)popUp->ButCancelStr);
	     		 break;

	     	 case 1:
	     		 moveM(popUp->srt1Y, popUp->srt1X);
	     		 colorM(popUp->str1OffF, popUp->str1OffB);

	     		 if(choiceSettings == SETTINGS_CLOCK)
	     		 {
	     		 strM((uint8_t*)popUp->str1On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str1Off);
	     		 }

	     		 moveM(popUp->srt2Y, popUp->srt2X);
	     		 colorM(popUp->str2OnF, popUp->str2OnB);
	     		 if(choiceSettings == SETTINGS_BOOT)
	     		 {
	     		 strM((uint8_t*)popUp->str2On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str2Off);
	     		 }

	     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
	     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	     		 strM((uint8_t*)popUp->ButEnterStr);

	     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
	     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	     		 strM((uint8_t*)popUp->ButCancelStr);
	     		 break;

	     	 case 2:
	     		 moveM(popUp->srt1Y, popUp->srt1X);
	     		 colorM(popUp->str1OffF, popUp->str1OffB);
	     		 if(choiceSettings == SETTINGS_CLOCK)
	     		 {
	     		 strM((uint8_t*)popUp->str1On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str1Off);
	     		 }

	     		 moveM(popUp->srt2Y, popUp->srt2X);
	     		 colorM(popUp->str2OffF, popUp->str2OffB);
	     		 if(choiceSettings == SETTINGS_BOOT)
	     		 {
	     		 strM((uint8_t*)popUp->str2On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str2Off);
	     		 }

	     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
	     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
	     		 strM((uint8_t*)popUp->ButEnterStr);

	     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
	     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
	     		 strM((uint8_t*)popUp->ButCancelStr);
	     		 break;

	     	 case 3:
	     		 moveM(popUp->srt1Y, popUp->srt1X);
	     		 colorM(popUp->str1OffF, popUp->str1OffB);
	     		 if(choiceSettings == SETTINGS_CLOCK)
	     		 {
	     		 strM((uint8_t*)popUp->str1On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str1Off);
	     		 }

	     		 moveM(popUp->srt2Y, popUp->srt2X);
	     		 colorM(popUp->str2OffF, popUp->str2OffB);
	     		 if(choiceSettings == SETTINGS_BOOT)
	     		 {
	     		 strM((uint8_t*)popUp->str2On);
	     		 }
	     		 else
	     		 {
	     		  strM((uint8_t*)popUp->str2Off);
	     		 }

	     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
	     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	     		 strM((uint8_t*)popUp->ButEnterStr);

	     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
	     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
	     		 strM((uint8_t*)popUp->ButCancelStr);
	     		 break;
	     }
}


void popSettingsBut(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&settings;

	switch(shiftButtonPopUp)
	{
		case 0:
			 moveM(popUp->ButEnterY, popUp->ButEnterX);
			 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
			 strM((uint8_t*)popUp->ButEnterStr);

			 moveM(popUp->ButCancelY, popUp->ButCancelX);
			 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
			 strM((uint8_t*)popUp->ButCancelStr);
			 break;

	     case 1:
	     	 moveM(popUp->ButEnterY, popUp->ButEnterX);
	     	 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
	     	 strM((uint8_t*)popUp->ButEnterStr);

	     	 moveM(popUp->ButCancelY, popUp->ButCancelX);
	     	 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
	     	 strM((uint8_t*)popUp->ButCancelStr);
	     	 break;
	}
}


void clickingClockBut(void)
{
	openClock(&watch);
}


void clickingWarningBut(void)
{
		char text[64];
		memset(text,0, sizeof(text));
		openPopUpWarning(&popUpWarning);

		moveM(popUpWarning.srt1Y, popUpWarning.srt1X);
		colorM(popUpWarning.str1ColF, popUpWarning.str1ColB);
		sprintf(text," %s ",textPopUp);
		strM((uint8_t*)text);

		colorM(popUpWarning.inputFieldOffF, popUpWarning.inputFieldOffB);
		moveM(popUpWarning.inputFieldY, popUpWarning.inputFieldX);
		sprintf(text,"%s", " 㣮 ");
		strM((uint8_t*)text);
		memset(textPopUp, 0, sizeof(textPopUp));
		counterTextPopUp = 0;
}


void clickingSaveAsBut(void)
{

}


void clickingBoot(void)
{
	openPopUpBoot(&popUpBoot);
}


void shiftClickingBoot(void)
{
	_popUp *popUp;
	popUp = (_popUp*)&popUpBoot;

     switch(shiftButtonPopUp)
     {
     	 case 0:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOnF, popUp->ButEnterOnB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOffF, popUp->ButCancelOffB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;

     	 case 1:
     		 moveM(popUp->ButEnterY, popUp->ButEnterX);
     		 colorM(popUp->ButEnterOffF, popUp->ButEnterOffB);
     		 strM((uint8_t*)popUp->ButEnterStr);

     		 moveM(popUp->ButCancelY, popUp->ButCancelX);
     		 colorM(popUp->ButCancelOnF, popUp->ButCancelOnB);
     		 strM((uint8_t*)popUp->ButCancelStr);
     		 break;
     }
}


void EscKey(void)
{
	switch(SELECTM){
	case MENU_POP_UP:
		closePopUp(&popUpName);
		counterTextPopUp = 0;
		curs_setMenu(0);
		memset(textPopUp, 0, sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		break;

	case MENU_CREATURE:
		closePopUp(&popUpNewFile);
		counterTextPopUp = 0;
		curs_setMenu(0);
		memset(textPopUp,0,sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		break;

	case MENU_DELL:
		closePopUp(&popUpDellFile);
		counterTextPopUp = 0;
		curs_setMenu(0);
		memset(textPopUp,0,sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		break;

	case MENU_COPY:
		closePopUp(&popUpCopy);
		counterTextPopUp = 0;
		curs_setMenu(0);
		memset(textPopUp,0,sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		break;

    case MENU_WARNING:
    	closePopUp(&popUpWarning);
		counterTextPopUp = 0;
		memset(textPopUp,0,sizeof(textPopUp));
		shiftButtonPopUp = 0;
		menuChange(PREVIOUSM);
    	break;

    case MENU_COMPIL:
    	closePopUp(&popUpCompil);
		counterTextPopUp = 0;
		memset(textPopUp, 0, sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
    	break;

    case MENU_DEFRAG:
    	closePopUp(&popUpDefrag);
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
    	break;

    case MENU_SETTINGS:
    	closePopUpSettings(&settings);
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		popButtonPopUp = 0;
		choiceSettings = 0;
    	break;


    case MENU_CLOCK:
    	closeClock(&watch);
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
		popButtonPopUp = 0;
    	break;

    case MENU_ACK_BOOT:
    	closePopUp(&popUpBoot);
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
    	break;

	}
}


void EnterKey(void)
{
	int32_t numFile = 0;

	if(peekInputKeyBoard(&inputKeyBoard) == 0xa)
	{
	popInputKeyBoard(&inputKeyBoard);
	}

	switch(SELECTM){

	case  MENU_POP_UP:
		closePopUp(&popUpName);
		curs_setMenu(0);

		if(shiftButtonPopUp == 1 || shiftButtonPopUp == 0)
		{
			numFile = FileSearch((char*)textPopUp);
			if(numFile == -1)
			{
				renameFile(ListFileItem[Num_File], textPopUp);
				counterTextPopUp = 0;
				memset(textPopUp, 0, sizeof(textPopUp));
				shiftButtonPopUp = 0;
				menuChange(PREVIOUSM);
			}
			else
			{
			menuChange(PARENTM);
			}
		}
		else
			{
			counterTextPopUp = 0;
			memset(textPopUp, 0, sizeof(textPopUp));
			shiftButtonPopUp = 0;
			menuChange(PREVIOUSM);
			}
		break;

	case MENU_CREATURE:
		closePopUp(&popUpNewFile);
		curs_setMenu(0);

		if(shiftButtonPopUp == 1 || shiftButtonPopUp == 0)
		{
			numFile = FileSearch((char*)textPopUp);
			if(numFile == -1)
			{
			createFile(textPopUp, 0);
			counterTextPopUp = 0;
			memset(textPopUp, 0, sizeof(textPopUp));
			shiftButtonPopUp = 0;
			menuChange(PREVIOUSM);
			}
			else
				{
				menuChange(PARENTM);
				}
		}
		else
			{
			counterTextPopUp = 0;
			memset(textPopUp, 0, sizeof(textPopUp));
			shiftButtonPopUp = 0;
			menuChange(PREVIOUSM);
			}
	 	break;

	case MENU_COPY:
		closePopUp(&popUpCopy);
		curs_setMenu(0);

			if(shiftButtonPopUp == 1 || shiftButtonPopUp == 0)
			{
				numFile = FileSearch((char*)textPopUp);

				if(numFile == -1)
				{
				copyFile(textPopUp, ListFileItem[Num_File]);
				counterTextPopUp = 0;
				memset(textPopUp,0,sizeof(textPopUp));
				shiftButtonPopUp = 0;
				menuChange(PREVIOUSM);
				}
				else
					{
					menuChange(PARENTM);
					}
			}
			else
				{
				counterTextPopUp = 0;
				memset(textPopUp,0,sizeof(textPopUp));
				shiftButtonPopUp = 0;
				menuChange(PREVIOUSM);
				}
		break;


    case MENU_DELL:
    	closePopUp(&popUpDellFile);
		curs_setMenu(0);

			if(shiftButtonPopUp == 0)
			{
    		    if(numberFilesInSystem > 0){
    			delFile(ListFileItem[Num_File]);
    				if(Num_File > 0){
    				PREVIOUS_File;
    				}
    			}
			}
			counterTextPopUp = 0;
			memset(textPopUp, 0, sizeof(textPopUp));
			menuChange(PREVIOUSM);
			shiftButtonPopUp = 0;
    break;

    case MENU_WARNING:
    	closePopUp(&popUpWarning);
		counterTextPopUp = 0;
		memset(textPopUp,0,sizeof(textPopUp));
		shiftButtonPopUp = 0;
		menuChange(PREVIOUSM);
    	break;

    case MENU_COMPIL:
    	closePopUp(&popUpCompil);
		if(shiftButtonPopUp == 0 && numberFilesInSystem != 0)
		{
		compileFile(ListFileItem[Num_File]);
		initStackSysMem();
		}
		counterTextPopUp = 0;
		memset(textPopUp, 0, sizeof(textPopUp));
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
    	break;

    case MENU_DEFRAG:
    	closePopUp(&popUpDefrag);

		if(shiftButtonPopUp == 0)
		{
			menuChange(CHILDM);
			copyHead();
			qsort(sortHead, numberFilesInSystem, sizeof(_sortHead), cmpSector);
			overwritingFile();
		}
		menuChange(PREVIOUSM);
		shiftButtonPopUp = 0;
    	break;

    case MENU_SETTINGS:

    	switch(shiftButtonPopUp)
    	{
    	case 0:	// 
    		if(choiceSettings == SETTINGS_CLOCK)
    		{
    		moveM(settings.srt1Y, settings.srt1X);
    		colorM(settings.str1OnF, settings.str1OnB);
    		strM((uint8_t*)settings.str1Off);

    		moveM(settings.srt2Y, settings.srt2X);
    		colorM(settings.str1OffF, settings.str1OffB);
    		strM((uint8_t*)settings.str2Off);
    		choiceSettings = 0;
    		}
    		else
    			{
    			choiceSettings = SETTINGS_CLOCK;
    			moveM(settings.srt1Y, settings.srt1X);
    			colorM(settings.str1OnF, settings.str1OnB);
    			strM((uint8_t*)settings.str1On);

        		moveM(settings.srt2Y, settings.srt2X);
        		colorM(settings.str1OffF, settings.str1OffB);
        		strM((uint8_t*)settings.str2Off);
    			}
    	break;

    	case 1:	// ⫮
    		if(choiceSettings == SETTINGS_BOOT)
    		{
        	moveM(settings.srt1Y, settings.srt1X);
        	colorM(settings.str1OffF, settings.str1OffB);
        	strM((uint8_t*)settings.str1Off);

    		moveM(settings.srt2Y, settings.srt2X);
    		colorM(settings.str2OnF, settings.str2OnB);
    		strM((uint8_t*)settings.str2Off);
    		choiceSettings = 0;
    		}
    		else
    			{
    			choiceSettings = SETTINGS_BOOT;
    			moveM(settings.srt2Y, settings.srt2X);
    			colorM(settings.str2OnF, settings.str2OnB);
    			strM((uint8_t*)settings.str2On);

            	moveM(settings.srt1Y, settings.srt1X);
            	colorM(settings.str1OffF, settings.str1OffB);
            	strM((uint8_t*)settings.str1Off);
    			}
    	break;

    	case 2: // ENTER
    		switch(choiceSettings)
    		{
    			case SETTINGS_CLOCK: // 뢠  ன ᮢ
    				closePopUpSettings(&settings);
    				menuChange(CHILDM);
    				shiftButtonPopUp = 0;
    				choiceSettings = 0;
    			break;

    			case SETTINGS_BOOT: // 뢠  稪  ⢥ত
    				closePopUpSettings(&settings);
    				menuChange(PARENTM);
    				shiftButtonPopUp = 0;
    				choiceSettings = 0;
    			break;
    		}
    		break;

    	case 3: // CLOSE
    		closePopUpSettings(&settings);
    		menuChange(PREVIOUSM);
    		shiftButtonPopUp = 0;
    		choiceSettings = 0;
    	break;
    	}

    	break;

    	case MENU_CLOCK:
    		saveDataTime();
    		menuChange(PREVIOUSM);
    		closeClock(&watch);
    		counterTextPopUp = 0;
    		memset(textPopUp, 0, sizeof(textPopUp));
    		break;

    	case MENU_ACK_BOOT:
        	closePopUp(&popUpBoot);
    		counterTextPopUp = 0;
    		memset(textPopUp,0,sizeof(textPopUp));
    	    if(shiftButtonPopUp == 0)
    		{
    	    *(__IO uint32_t*)(0x38800000+0) = 0xAAAAAAAA;  //  ⫮ 㧪

    	    NVIC_SystemReset();
    		}
    		menuChange(PREVIOUSM);
    		shiftButtonPopUp = 0;
    		break;
	}
}


void backSpace(void)
{
	switch(SELECTM){
	    case  MENU_POP_UP:
	    	checkBackSpace(&popUpName);
	    break;

	    case MENU_CREATURE:
	    	 checkBackSpace(&popUpNewFile);
       	break;

	    case MENU_COPY:
	    		checkBackSpace(&popUpCopy);
	    break;

	    case MENU_CLOCK:
	    	    if(counterChar > 0)
	    	    {
	    		dellCharStr(textPopUp, (int16_t*)&counterChar);
	    	    }
				inputStrDataTime(&watch, textPopUp);
	    	break;
	  }
}


void delete(void)
{
	uint8_t clearDisp[32];
	memset(clearDisp, 0, sizeof(clearDisp));

		switch(SELECTM){

		    case  MENU_POP_UP:
		    case MENU_COPY:
		    case MENU_CREATURE:
		    	moveM(popUpNewFile.inputFieldY, popUpNewFile.inputFieldX);
		    	colorM(popUpNewFile.inputFieldOnF, popUpNewFile.inputFieldOnB);
		    	memset(clearDisp,' ', strnlen((char*)textPopUp,24) + 1);
		    	strM(clearDisp);
			    moveM(popUpNewFile.inputFieldY, popUpNewFile.inputFieldX);
			    colorM(popUpNewFile.inputFieldOnF, popUpNewFile.inputFieldOnB);
			    if(strlen((char*)textPopUp) != 0)
			    {
			    counterTextPopUp ++;
			    }
			    dellCharStr(textPopUp, (int16_t*)&counterTextPopUp);
		    	strM(textPopUp);
		    	moveM(popUpNewFile.inputFieldY, popUpNewFile.inputFieldX + counterTextPopUp);
	       	break;

		    case MENU_CLOCK:
		    	    if(counterChar > 0)
		    	    {
		    		dellCharStr(textPopUp, (int16_t*)&counterChar);
		    	    }
					inputStrDataTime(&watch, textPopUp);
		    	break;
		  }
}


void tab(void)
{
	switch(SELECTM)
	{
	    case MENU_CLOCK:
	    setDownDataTime(&watch);
	    break;

		case MENU_POP_UP:
		case MENU_CREATURE:
		case MENU_COPY:
			shiftButtonPopUp >= 2 ? shiftButtonPopUp = 0 : shiftButtonPopUp ++; ENTERFUNCM();
			break;

		case MENU_SETTINGS:
			shiftButtonPopUp >= 3 ? shiftButtonPopUp = 0 : shiftButtonPopUp ++; ENTERFUNCM();
			break;

		case MENU_ACK_BOOT:
			shiftButtonPopUp >= 1 ? shiftButtonPopUp = 0 : shiftButtonPopUp ++; ENTERFUNCM();
			break;
	}
}


void checkInputChar(_popUp *popUp, uint8_t buf)
{
    colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    moveM(popUp->inputFieldY, popUp->inputFieldX);

    if(charInStr(textPopUp, '.', strlen((char*)textPopUp)) == -1)
    {
    	if(counterTextPopUp < 19)
    	{
    		addCharStr(textPopUp, buf, (int16_t*)&counterTextPopUp);
    	}
    }
    else
    	{
    		if((charInStr(textPopUp, '.', strlen((char*)textPopUp)) - counterTextPopUp) < 0)
    		{
    			if(strlen((char*)textPopUp) - charInStr(textPopUp, '.', strlen((char*)textPopUp)) <= 3)
    			{
    				addCharStr(textPopUp, buf, (int16_t*)&counterTextPopUp);
    			}
    		}
    		else
    			{
    				if(charInStr(textPopUp, '.', strlen((char*)textPopUp)) < 19)
    				{
    					addCharStr(textPopUp, buf, (int16_t*)&counterTextPopUp);
    				}
    			}
    	}
		strM(textPopUp);
		moveM(popUp->inputFieldY, popUp->inputFieldX + counterTextPopUp);
}


void checkInputPoint(_popUp *popUp)
{
	colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
    moveM(popUp->inputFieldY, popUp->inputFieldX);
    if(charInStr(textPopUp, '.', strlen((char*)textPopUp)) == -1)
    {
    	if(counterTextPopUp < 24)
    	{
    		addCharStr(textPopUp, '.', (int16_t*)&counterTextPopUp);
    	}
    }
    strM(textPopUp);
    moveM(popUp->inputFieldY, popUp->inputFieldX + counterTextPopUp);
}


void checkBackSpace(_popUp *popUp)
{
	uint8_t clearDisp[32];
	memset(clearDisp, 0, sizeof(clearDisp));

	moveM(popUp->inputFieldY, popUp->inputFieldX);
	colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);
	memset(clearDisp,' ', strnlen((char*)textPopUp,24) + 1);
	strM(clearDisp);
    moveM(popUp->inputFieldY, popUp->inputFieldX);
    colorM(popUp->inputFieldOnF, popUp->inputFieldOnB);

    dellCharStr(textPopUp, (int16_t*)&counterTextPopUp);
	strM(textPopUp);
	moveM(popUp->inputFieldY, popUp->inputFieldX + counterTextPopUp);
}

