#include "main.h"
#include "usb_device.h"
#include "zmodem.h"
#include "SysVar.h"
#include "Flash.h"
#include "mcurses.h"
#include "menu.h"
#include <math.h>
#include <string.h>
#include "Glob.h"

extern USBD_HandleTypeDef hUsbDeviceFS;
extern void initialise_monitor_handles(void);

RTC_HandleTypeDef hrtc;

void SystemClock_Config(void);
static void MX_RTC_Init(void);

void initADC(void);               // 樠 
void initTimerTaskManager(void);  // 樠   ⠩   ਮ 1 .
void initUsartExtBloks(void);     // 樠   ࠡ  譥 
void initUSARTASU(void);          // 樠 ASU  砫쭮 ᪮ 115200
void initSPIEeprom(void);         // 樠 SPI4  EEPROM
void initLed(void);               // 樠 ⮢ ᢥ⮤
void initDisplay(void);           // 樠  ࠡ  ᯫ

void * compile(char * filename);

void DMA1_Stream0_IRQHandler(void)
{
	if(READ_BIT(DMA1->LISR, DMA_LISR_TCIF0))
	{
		SysMem.DIO_MIN[0].DIO_00.ADC.det_5V = filter5V((uint16_t)(((float)ADC[4] * 2.5/65536)*2500));
		SysMem.DIO_MIN[0].DIO_00.ADC.det_24V = filter24V((uint16_t)(((float)ADC[2] * 2.5/65536)*12110));
		SysMem.DIO_MIN[0].DIO_00.ADC.detReserve = filterReserve24V((uint16_t)(((float)ADC[1] * 2.5/65536)*12110));
		SysMem.DIO_MIN[0].DIO_00.ADC.detCurrent_24V = filterCurrent24((uint16_t)(((float)ADC[3] * 2.5/65536)*454));
		SysMem.DIO_MIN[0].DIO_00.ADC.detCurrent_5V  = filterCurrent5V((uint16_t)(((float)ADC[0] * 2.5/65536)*200));
	}

	DMA1->LIFCR;
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF0); //  䫠 뢠
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF0);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF0);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF0);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF0);
}


void DMA1_Stream1_IRQHandler(void) // 뢠  ਥ   譨 
{
	if(READ_BIT(DMA1->LISR, DMA_LISR_TCIF1))
	{
	    TIM16->CNT = 0;
	    TIM16->CR1 &= ~TIM_CR1_CEN;
		RXData();
		errorsExchangeDio --;
		if(errorsExchangeDio <= 0)
		{
			CLEAR_DIO_ERRORS;
			errorsExchangeDio = 0;
		}

		DMA1->LIFCR;
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF1); //  䫠 뢠
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF1);
	}
	else
		{
		DMA1->LIFCR;
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF1);
		SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF1);
		}
}


void DMA1_Stream2_IRQHandler(void){ //  䫠  । 
	DMA1->LIFCR;
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF2); //  䫠 뢠
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF2);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF2);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF2);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF2);
}


void DMA1_Stream3_IRQHandler(void){ // 뢠  ਥ   USART1
	DMA1->LIFCR;
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF3); //  䫠 뢠
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF3);
}


void DMA1_Stream4_IRQHandler(void)  // 뢠  ।   USART1
{
	if(READ_BIT(DMA1->HISR, DMA_HISR_TCIF4))
	{
		int i, len;
			len = sizeUpdateMonitor(&UpdateMonitor);
			if(len >= 256)
			{
				len = 256;
			}
			for(i = 0; i < len; i++)
			{
				USART1_TX[i] = popUpdateMonitor(&UpdateMonitor);
			}

			DMA1_Stream4->CR &= ~DMA_SxCR_EN;
			while (DMA1_Stream4->CR & DMA_SxCR_EN);

			DMA1->HIFCR;
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTCIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CHTIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTEIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CDMEIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CFEIF4);

			DMA1_Stream4->CR = DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE;
			DMA1_Stream4->NDTR = len;
			DMA1_Stream4->PAR = (uint32_t)&USART1->TDR;
			DMA1_Stream4->M0AR = (uint32_t)&USART1_TX;
			DMA1_Stream4->CR |= DMA_SxCR_EN;
	}
	else
		{
			DMA1->HIFCR;
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTCIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CHTIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTEIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CDMEIF4);
			SET_BIT(DMA1->HIFCR,DMA_HIFCR_CFEIF4);
		}
}


/*  ࠡ稪 뢠  ASU  */
void DMA2_Stream0_IRQHandler(void){
	DMA2->LIFCR;
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTCIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CHTIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTEIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CDMEIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CFEIF0);
}


void DMA2_Stream1_IRQHandler(void){
	DMA2->LIFCR;
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTCIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CHTIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTEIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CDMEIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CFEIF1);
}


void TIM17_IRQHandler(void)  //  뢠  ࠭
{
	if(TIM17->SR & TIM_DIER_UIE)
	{
		if(blockingWorkMenu == 0)
		{
			if(usbConect >= 2048)
			{
				callTxDispData();
			}
			else
				{
				usbConect ++;
				}
		}
	}
	TIM17->SR;
	TIM17->SR = 0;
}


void TIM15_IRQHandler(void) // 믮  
{
    if(TIM15->SR & TIM_DIER_UIE)
    {
	execByteCode(&Manager);
    }
	TIM15->SR;
	TIM15->SR = 0;
}

void RTC_WKUP_IRQHandler(void)
{
  static int32_t time = 0;

  EXTI_D1->PR1 = EXTI_IMR1_IM19;
  RTC->ISR = (~((RTC_ISR_WUTF) | RTC_ISR_INIT)|(RTC->ISR & RTC_ISR_INIT));

  getTime(&Rtctime);
  getData(&Rtcdata);

  SysMem.DIO_MIN[0].DIO_00.RTC_Hour = Rtctime.hours;
  SysMem.DIO_MIN[0].DIO_00.RTC_Min  = Rtctime.minutes;
  SysMem.DIO_MIN[0].DIO_00.RTC_Sec  = Rtctime.seconds;
  SysMem.DIO_MIN[0].DIO_00.RTC_Year = Rtcdata.year + 2000;
  SysMem.DIO_MIN[0].DIO_00.RTC_Mon  = Rtcdata.month;
  SysMem.DIO_MIN[0].DIO_00.RTC_Day  = Rtcdata.day;
  SysMem.DIO_MIN[0].DIO_00.RTC_Week = Rtcdata.weekDay;

  time++;
  if(time >= 360)
  {
	SysMem.DIO_MIN[0].DIO_00.WRK_Hour ++;
	EepromWriteF(30000, SysMem.DIO_MIN[0].DIO_00.WRK_Hour);
	time = 0;
  }

  readyClock = 1;

}


void TIM16_IRQHandler(void){ // 뢠   諨  ࠢ塞  ࠧ
    if(TIM16->SR & TIM_DIER_UIE)
    {
    TimeOutRxData();
    }
    TIM16->SR;
    TIM16->SR = 0;
}


void USART2_IRQHandler(void) // 뢠  ਥ   ASU
{
	if(USART2->ISR & USART_ISR_RTOF)
	{
		if(AsuCRC16(AsuRX, (256 - DMA2_Stream0->NDTR)) == 0 && (256 - DMA2_Stream0->NDTR) < 256)  // ஢ઠ ஫쭮 㬬
		{
			if(AsuRX[0] == SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr) // ஢ઠ 
			{
				modbasRTU();
			}
		}
		else
			{
			DMA2_Stream0->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
			while (DMA2_Stream0->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA

			DMA2->LIFCR;
			SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTCIF0);
			SET_BIT(DMA2->LIFCR,DMA_LIFCR_CHTIF0);
			SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTEIF0);
			SET_BIT(DMA2->LIFCR,DMA_LIFCR_CDMEIF0);
			SET_BIT(DMA2->LIFCR,DMA_LIFCR_CFEIF0);

			DMA2_Stream0->NDTR = 256; // ⢮   ।  USART2   
			DMA2_Stream0->CR |= DMA_SxCR_EN; // ਥ
			}

		WRITE_REG(USART2->ICR, USART_ICR_RTOCF);
	}

	USART2->ICR = 1* USART_ICR_PECF    |
				  1* USART_ICR_FECF    |
				  1* USART_ICR_NECF    |
				  1* USART_ICR_ORECF   |
				  1* USART_ICR_IDLECF  |
				  1* USART_ICR_TXFECF  |
				  1* USART_ICR_TCCF    |
				  1* USART_ICR_TCBGTCF |
				  1* USART_ICR_LBDCF   |
				  1* USART_ICR_CTSCF   |
				  1* USART_ICR_EOBCF   |
				  1* USART_ICR_UDRCF   |
				  1* USART_ICR_CMCF    |
				  1* USART_ICR_WUCF;
}


/*				 ࠡ					*/
//                  RENAME,         PREVIOUS        PARENT,         CHILD           DELL            COPY            START         EDITOR        COMPIL          HELP       		DEFRAG          NEWFILE
MAKE_MENU(m_s1i1,	m_s1i2,         NULL_ENTRY,		NULL_ENTRY,		NULL_ENTRY,		NULL_ENTRY,   	NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY,		NULL_ENTRY,     MENU_CANCEL,    MENU_CANCEL,        NULL_FUNC,				NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i2,	m_s1i3,         NULL_ENTRY,     m_s1i5    ,     m_s1i4    ,     m_s1i7    ,  	m_s1i8,         m_s1i9    ,   m_s1i10   ,	m_s1i12   ,		NULL_ENTRY, 	m_s1i14,		m_s1i6,	    	MENU_START,     MENU_W1,            DrawFrame,      		NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i3,	NULL_ENTRY,     m_s1i2,         m_s1i11   ,     NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,     MENU_POP_UP,        clickingRenamefile,    	shiftButRenameFile,     NULL_FUNC,		"", "");
MAKE_MENU(m_s1i4,	NULL_ENTRY,     m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,	  NULL_ENTRY,   NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY,		NULL_ENTRY,		MENU_START,     MENU_CANCEL,	    NULL_FUNC,     			NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i5,	NULL_ENTRY,     m_s1i2,         m_s1i19   ,     m_s1i16   ,     NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY,		NULL_ENTRY,		MENU_START,     MENU_SETTINGS,      clickingSettingsBut,    shiftSettingsBut,       NULL_FUNC,	    "", "");
MAKE_MENU(m_s1i6,	NULL_ENTRY,		m_s1i2,         m_s1i11   ,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY,	 	NULL_ENTRY,		MENU_START,		MENU_CREATURE,      clikingNewFile,      	shiftclikingNewFile,    NULL_FUNC,		"", "");
MAKE_MENU(m_s1i7,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_DELL,          clickingDeleteBut,      shiftClickingDeleteBut, NULL_FUNC,		"", "");
MAKE_MENU(m_s1i8,	NULL_ENTRY,		m_s1i2,         m_s1i11   ,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_COPY,          clickingCopyBut  ,      shiftClickingCopyBut,   NULL_FUNC,		"", "");
MAKE_MENU(m_s1i9,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_STARTB,        startByteCode    ,      NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i10,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_EDIT,          clickingEditorBut,      NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i11,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_WARNING,       clickingWarningBut,     NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i12,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_COMPIL,        clickingCompilBut,      shiftClickingCompilBut, NULL_FUNC,		"", "");
MAKE_MENU(m_s1i13,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_HELP,          NULL_FUNC,              NULL_FUNC,              NULL_FUNC,		"", "");
MAKE_MENU(m_s1i14,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     m_s1i15   ,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_DEFRAG,        clickingDefragBut,      shiftClickingDefragBut, NULL_FUNC,		"", "");
MAKE_MENU(m_s1i15,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_PROGRESSBAR,   processingDefrag ,      NULL_FUNC             , NULL_FUNC,		"", "");
MAKE_MENU(m_s1i16,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_CLOCK      ,   clickingClockBut ,      NULL_FUNC             , NULL_FUNC,		"", "");
MAKE_MENU(m_s1i17,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_SAVE_AS    ,   NULL_FUNC        ,      NULL_FUNC             , NULL_FUNC,		"", "");
MAKE_MENU(m_s1i18,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_FS_BUSY    ,   NULL_FUNC        ,      NULL_FUNC             , NULL_FUNC,		"", "");
MAKE_MENU(m_s1i19,	NULL_ENTRY,		m_s1i2,         NULL_ENTRY,     NULL_ENTRY,     NULL_ENTRY,		NULL_ENTRY,     NULL_ENTRY,   NULL_ENTRY,	NULL_ENTRY,		NULL_ENTRY, 	NULL_ENTRY, 	NULL_ENTRY,		MENU_START,		MENU_ACK_BOOT   ,   clickingBoot     ,      shiftClickingBoot     , NULL_FUNC,		"", "");

/*   ᯮ짮   뢮  㭪樨  
     * PA3 ADC1-15 ⥫ 24 
     * PA4 ADC1-18  24
     * PA5 ADC1-19 ⥫ 5
     * PA6 ADC1-3  5
     * PB0 ADC1-9 殮  १ࢭ ⠭  100 .
     *
     * PE4 NSS
     * PE6 MOSI
     * PE5 MISO
     * PE3 WR
     * PE2 SCK
     * PE0 HOLD
     *  40
     *
     *  ⠩ tim16, tim17.
     *    ⠩ tim15
*/


int main(void)
{
    //SCB_EnableICache();
	//SCB_EnableDCache();

	NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
	SystemClock_Config();

	MX_USB_DEVICE_Init();
	MX_RTC_Init();
	initLed();
	initDisplay();
	initUSARTASU();
	initADC();

	initialise_monitor_handles();

	/*ன  */
	VREFBUF->CSR = 0 << VREFBUF_CSR_VRS_Pos | VREFBUF_CSR_ENVR; //   2,5 祭  室 Vrev+ ୮ 殮 
	while (!(VREFBUF->CSR & VREFBUF_CSR_VRR)); //   ⠡  

	/*樠  ࠡ*/
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE7, 0x0 << GPIO_MODER_MODE7_Pos);
	MODIFY_REG(GPIOB->OSPEEDR, GPIO_OSPEEDR_OSPEED7,0x0 << GPIO_OSPEEDR_OSPEED7_Pos);
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD7, 0x00 << GPIO_PUPDR_PUPD7_Pos);

	if(READ_BIT(GPIOB->IDR,GPIO_IDR_ID7))
	{
		READY_WORK;
	}
	else
		{
		PROHIBITED_WORK;
		}

	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE3, 0x2 << GPIO_MODER_MODE3_Pos);
	MODIFY_REG(GPIOB->OSPEEDR,GPIO_OSPEEDR_OSPEED3,0x2 << GPIO_OSPEEDR_OSPEED3_Pos);
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD3, 0x00 << GPIO_PUPDR_PUPD3_Pos);
	MODIFY_REG(GPIOB->AFR[0], GPIO_AFRL_AFSEL3, 0x0 << GPIO_AFRL_AFSEL3_Pos);

	/*祭 ࠧ襭  ࠡ  譥 */
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE3, 0x1 << GPIO_MODER_MODE3_Pos);
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED3, 0x0 << GPIO_OSPEEDR_OSPEED3_Pos);
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD3, 0x00 << GPIO_PUPDR_PUPD3_Pos);
	SET_BIT(GPIOD->BSRR, GPIO_BSRR_BR3);


	/*ன   ५ 宩 ⠪*/
	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE10, 0x1 << GPIO_MODER_MODE10_Pos); // ॢ   室 ५
	MODIFY_REG(GPIOA->OSPEEDR,GPIO_OSPEEDR_OSPEED10,0x0 << GPIO_OSPEEDR_OSPEED10_Pos); // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD10, 0x00 << GPIO_PUPDR_PUPD10_Pos); // ⪫祭 寧
	SET_BIT(GPIOA->BSRR, GPIO_BSRR_BR10); //⠭ ᪮    ५


	/*ᨣ ⮢  ࠡ 娥 ⠪*/
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE1, 0x1 << GPIO_MODER_MODE1_Pos); // ॢ   室 ५
	MODIFY_REG(GPIOD->OSPEEDR,GPIO_OSPEEDR_OSPEED1,0x0 << GPIO_OSPEEDR_OSPEED1_Pos); // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD1, 0x00 << GPIO_PUPDR_PUPD1_Pos); // ⪫祭 寧
	SET_BIT(GPIOD->BSRR, GPIO_BSRR_BS1);

	/*			  ⪫祭 		*/
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE9, 0x00 << GPIO_MODER_MODE9_Pos); // ॢ   室
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD9, 0x00 << GPIO_PUPDR_PUPD9_Pos); // ⪫祭 寧


	/*ன   */
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE1, 0x00 << GPIO_MODER_MODE1_Pos); // ॢ   室
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD1, 0x00 << GPIO_PUPDR_PUPD1_Pos); // ⪫祭 寧

	/*ன ⠩  ࠡ⪨ */
    TIM17->DIER = TIM_DIER_UIE;
    TIM17->PSC = 11520 - 1;
    TIM17->ARR = 40-1;
    TIM17->CNT = 0;
    TIM17->CCR1 = 0;
    TIM17->RCR = 1 - 1;
    TIM17->EGR = TIM_EGR_UG;
    TIM17->SR;
    TIM17->SR = 0;
	NVIC_SetPriority(TIM17_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ⠩ TIM17
    NVIC_EnableIRQ(TIM17_IRQn);
	TIM17->CR1 |= TIM_CR1_CEN;


    /*⠩  譥 */
    TIM16->CR1 = TIM_CR1_OPM | TIM_CR1_URS;
    TIM16->DIER = TIM_DIER_UIE;
    TIM16->PSC = 16799 - 1;
    TIM16->ARR = 20;
    TIM16->CNT = 0;
    TIM16->CCR1 = 0;
    TIM16->RCR = 1 - 1;
    TIM16->EGR = TIM_EGR_UG;
    TIM16->SR;
    TIM16->SR = 0;

	NVIC_SetPriority(TIM16_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ⠩ TIM16
	NVIC_ClearPendingIRQ(TIM16_IRQn); // ࠭஢  䫣 뢠
    NVIC_EnableIRQ(TIM16_IRQn);

    initUsartExtBloks(); // 樠 USART  譨 

    initTimerTaskManager(); // 樠   ⠩  ࠡ    ਮ 1 .

    initSPIEeprom();

    /*樠  砩 ᥫ*/
    RNG->CR = RNG_CR_RNGEN;

	/*樠 */
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE1, 0x0 << GPIO_MODER_MODE1_Pos);
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED1,0x0 << GPIO_OSPEEDR_OSPEED1_Pos); // ன ᪮ ஭ USART ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD1, 0x00 << GPIO_PUPDR_PUPD1_Pos); // ⪫祭 寧

	/*樠 ⥪ ਥ*/
	initStack(&Stack_Zm); // 樠 ⥪ ⮡    

	initStacktxDispData(&txDispData);

	initStackDispDataUpdate(&DispDataUpdate);

	initStackSysMem();
	initMenuDisp();
	initInputDataKeyboard();
	managerTaskInit();
	initStackMcalc(&MCALC);
	initStrCalc();
	initForNext();
	initSubprog();
	initStackMenu();
	initStackMenuUpdate(&MenuUpdate);
	initInputKeyBoard();
	initUpdateMonitor();
	initStackCommandExternalDevice(); // 樠 ⥪ ਥ ।  
	initMirrorDISP();
	memset(&StackCommandExternalDevice, 0, sizeof(StackCommandExternalDevice)); // 樠 ⥪   譥 
	memset(&txDispData, 0, sizeof(txDispData));
	memset(&DispDataUpdate, 0, sizeof( DispDataUpdate));
	memset(&UpdateMonitor, 0, sizeof(UpdateMonitor));
	memset(ExternalsBlocks_TX, 0, sizeof(ExternalsBlocks_TX));
	memset(ExternalsBlocks_RX, 0, sizeof(ExternalsBlocks_RX));

	clpbrd_len = 0;

	initRNG();

	for(uint32_t j = 0; j < sizeFileSystem; j++){
	HeaderFileList[j] = (headerFileList*)(ADDR_FLASH_SECTOR_7_BANK1 + j*64);
	}

	numberFilesInSystem = quantityFileInSystem();

	clearStack(&Stack_Zm);
	ZMODEMChange(&z_s1i1);
	menuChange(&m_s1i1);

	SysMem.DIO_MIN[0].DIO_00.WRK_Hour = EepromReadF(30000);

	HAL_Delay(2000);

	if(searchFile(&Manager, "b00") && READ_BIT(GPIOE->IDR, GPIO_IDR_ID1))
	{
		searchExecFile(&Manager);
		managerInitTaskBoo();
		TIM15->CR1 |= TIM_CR1_CEN; //  ⠩  
		WORK_PROGRAM;
	}
	else{
		menuChange(NEXTM);
		WORK_EDIT;
	}

	while(1)
	{

		execTask();

		if(ZMODEM_SELECT == SEND_HEADER_FILE || ZMODEM_SELECT == SEND_ZDATA || ZMODEM_SELECT == SEND_DATA || ZMODEM_SELECT == SEND_OO)
		{
			CALLSELECTFUNC;
		}

		if(outFileSistem == 1){
			  outFileSistem = 0;
			  startFileSystem();
		}

		if(STARTM == MENU_START)
		{
			if(SELECTM != MENU_EDIT)
			{
			int16_t size = sizeInputKeyBoard(&inputKeyBoard);
				if( size > 0)
				{
				parserCommandKeyBoard(size);
				}
				  if(readyClock == 1)
				  {
					  DraWClock(0, 75, Rtctime.hours, Rtctime.minutes, 0, Rtcdata.year + 2000, Rtcdata.month, Rtcdata.day);
					  readyClock = 0;
				  }
				  if(updateDispZmodem == 1)
				  {
			          DrawFrame();
					  updateDispZmodem = 0;
					  counterUpdateDisp = 0x3FFFFFFF;
				  }
			}
			else
			{
				initStackMenu();
				startEditor(ListFileItem[Num_File]);
				workRedactor = 0;
				initStackSysMem();
				menuChange(PREVIOUSM);
				counterUpdateDisp = 0x3FFFFFFF;
			}
		}

	}
}


void SystemClock_Config(void) {
	/* ⠭ PWR*/
	PWR->CR3 = PWR_CR3_LDOEN; // ⪫祭 USB ८ࠧ⥫ 5 ---> 3.3,  ३ ⪫祭,  ⪫祭, LDO  祭.
	PWR->D3CR = PWR_D3CR_VOS_1 | PWR_D3CR_VOS_0;
	while (!(PWR->D3CR & PWR_D3CR_VOSRDY)); //   ⠡ LDO ⠡  
	SET_BIT(SYSCFG->PWRCR, SYSCFG_PWRCR_ODEN); // ॢ   ᨬ쭮 殮 1,35,  ஢     "CAP"
	PWR->CR1 = PWR_CR1_ALS_LEV3 | PWR_CR1_AVDEN | PWR_CR1_SVOS_1 | PWR_CR1_DBP | PWR_CR1_PLS_LEV6 | PWR_CR1_PVDEN; // 砥 ஢ ⥪஢  殮 (2,5),
	while(!(PWR->CR1 & PWR_CR1_DBP)); //  ⮡ ࠭஢ 稫  3
	PWR->CPUCR = PWR_CPUCR_RUN_D3; //  D3 ᥣ ࠡ⠥

	/* ⠪⮢  RCC*/
	RCC->CR |= RCC_CR_HSEON; // 砥 譥   16 
	while (!(RCC->CR & RCC_CR_HSERDY)); //     16  ⠡
	RCC->BDCR |= RCC_BDCR_LSEDRV_0 | RCC_BDCR_LSEDRV_1; // 砥  ᨬ쭮 ᨫ ᮢ 
	RCC->BDCR |= RCC_BDCR_LSEON; // 砥 ᮢ . ᫨ ᮢ  㦥 ࠡ⠥  ३  ந室  ⠢ 
	while (!(RCC->BDCR & RCC_BDCR_LSERDY)); //   ⠡ ᮢ 

	RCC->PLLCKSELR |= 0x2 << RCC_PLLCKSELR_PLLSRC_Pos; // 砥 ⠪஢  Pll  譥 

	// PLL1 ன
	RCC->CR &= ~RCC_CR_PLL1ON; // ࠭஢ ⪫祭  pll1
	while (RCC->CR & RCC_CR_PLL1RDY); // ஢塞  ⪫稫, ࠭஢   ⪫祭  PLL1
	RCC->PLLCKSELR |= RCC_PLLCKSELR_DIVM1_0; // ᨣ "DIVM1" ன ।⥫  "pll1_p_ck" ⠪஢ ६  譥  "HSE"  16    '1' 砥 室   PLL2 16 . 砥  PLL1 ⠪ 16 .
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL1VCOSEL; // 砥 ப pll1
	RCC->PLLCFGR |= RCC_PLLCFGR_PLL1RGE_3; //  室  8 - 16 .
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL1FRACEN; // 몫祭 ࠪ⠫
	RCC->PLL1FRACR = 0; // ன ࠪ⠫  pll1. ࠪ⠫  ⥯ 㭪 ᤥ  ࠢ "0"  祭 "1".
	RCC->PLLCFGR |= RCC_PLLCFGR_DIVP1EN | RCC_PLLCFGR_DIVQ1EN | RCC_PLLCFGR_DIVR1EN; // 뤠 ᨣ   "pll1_p_ck"   "P"
	RCC->PLL1DIVR = ((2 - 1) << RCC_PLL1DIVR_P1_Pos)
			| ((60 - 1) << RCC_PLL1DIVR_N1_Pos)
			| ((20 - 1) << RCC_PLL1DIVR_Q1_Pos)
			| ((10 - 1) << RCC_PLL1DIVR_R1_Pos); // 㬭 室   "60",    "P"  10.   ࠧ  10
	RCC->CR |= RCC_CR_PLL1ON; // 砥 PLL1
	while (!(RCC->CR & RCC_CR_PLL1RDY)); //   ⠡
	//  室 MCO_1  'pll1_Q'  3,1  c ⥫ "/15".   3,2 .  PLL1_Q  USB      48 .    16  ஢ ⠦  MCO_1.

	// PLL2 ன
	RCC->CR &= ~RCC_CR_PLL2ON; // ࠭஢ ⪫祭  pll2
	while (RCC->CR & RCC_CR_PLL2RDY); // ஢塞  ⪫稫, ࠭஢   ⪫祭  PLL2
	RCC->PLLCKSELR |= RCC_PLLCKSELR_DIVM2_0; // ᨣ "DIVM2" ன ।⥫  "pll2_p_ck" ⠪஢ ६  譥  "HSE"  16    '1' 砥 室   PLL2 16 . 砥  PLL2 ⠪ 16 .
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL2VCOSEL; // 砥 ப pll
	RCC->PLLCFGR |= RCC_PLLCFGR_PLL2RGE_3; //  室  8 - 16 .
	RCC->PLL2FRACR = 0x00; // ன ࠪ⠫  pll2. ࠪ⠫  ⥯ 㭪 ᤥ  ࠢ "0"  祭 "1".
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL2FRACEN; // 몫祭 ࠪ⠫
	RCC->PLL2DIVR = ((10 - 1) << RCC_PLL2DIVR_Q2_Pos) | ((10 - 1) << RCC_PLL2DIVR_P2_Pos) | ((50 - 1) << RCC_PLL2DIVR_N2_Pos); // 㬭 室   "50",    "P"  10.   ࠧ  10
	RCC->PLLCFGR |= RCC_PLLCFGR_DIVP2EN; // 뤠 ᨣ   "pll2_p_ck"   "P"
	RCC->PLLCFGR |= RCC_PLLCFGR_DIVQ2EN; // 뤠 ᨣ   "pll2_p_ck"   "Q"
	RCC->CR |= RCC_CR_PLL2ON; // 砥 PLL2 뤠 ᨣ pll2_p
	while(!(RCC->CR & RCC_CR_PLL2RDY)); //   ⠡

	// PLL3 ன
	RCC->CR &= ~RCC_CR_PLL3ON; // ࠭஢ ⪫祭  pll3
	while (RCC->CR & RCC_CR_PLL3RDY); // ஢塞  ⪫稫, ࠭஢   ⪫祭  PLL3
	RCC->PLLCKSELR |= RCC_PLLCKSELR_DIVM3_0; // ᨣ "DIVM2" ன ।⥫  "pll3_p_ck" ⠪஢ ६  譥  "HSE"  16    '1' 砥 室   PLL2 16 . 砥  PLL2 ⠪ 16 .
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL3VCOSEL; // 砥 ப pll
	RCC->PLLCFGR |= RCC_PLLCFGR_PLL3RGE_3; //  室  8 - 16 .
	RCC->PLL3FRACR = 0x00; // ன ࠪ⠫  pll3. ࠪ⠫  ⥯ 㭪 ᤥ  ࠢ "0"  祭 "1".
	RCC->PLLCFGR &= ~RCC_PLLCFGR_PLL3FRACEN; // 몫祭 ࠪ⠫
	RCC->PLL3DIVR = ((10 - 1) << RCC_PLL3DIVR_P3_Pos) | ((50 - 1) << RCC_PLL3DIVR_N3_Pos); // 㬭 室   "50",    "P"  10.   ࠧ  10
	RCC->PLLCFGR |= RCC_PLLCFGR_DIVP3EN; // 뤠 ᨣ   "pll2_p_ck"   "P"  ⠫   ⪫祭
	RCC->CR |= RCC_CR_PLL3ON; // 砥 PLL3 뤠 ᨣ pll3_p
	while (!(RCC->CR & RCC_CR_PLL3RDY)); //   ⠡


	MODIFY_REG(FLASH->ACR, FLASH_ACR_LATENCY,FLASH_ACR_LATENCY_4WS); // ⠭ প  5 ⠪⮢
	MODIFY_REG(FLASH->ACR, FLASH_ACR_WRHIGHFREQ,FLASH_ACR_WRHIGHFREQ_1);
	MODIFY_REG(RCC->D1CFGR, RCC_D1CFGR_D1PPRE,RCC_D1CFGR_D1PPRE_2);
	MODIFY_REG(RCC->D2CFGR, RCC_D2CFGR_D2PPRE1,RCC_D2CFGR_D2PPRE1_2);
	MODIFY_REG(RCC->D2CFGR, RCC_D2CFGR_D2PPRE2,RCC_D2CFGR_D2PPRE2_2);
	MODIFY_REG(RCC->D3CFGR, RCC_D3CFGR_D3PPRE,RCC_D3CFGR_D3PPRE_2);
	MODIFY_REG(RCC->D1CFGR, RCC_D1CFGR_HPRE,RCC_D1CFGR_HPRE_3);
	MODIFY_REG(RCC->D1CFGR, RCC_D1CFGR_D1CPRE,0x0 << RCC_D1CFGR_D1CPRE_Pos);
	MODIFY_REG(RCC->CFGR, RCC_CFGR_SW,0x3 << RCC_CFGR_SW_Pos); // clock kernel pll1

	MODIFY_REG(RCC->BDCR, RCC_BDCR_RTCSEL_Msk, RCC_BDCR_RTCSEL_0); // clk lse ---> rtc
    MODIFY_REG(RCC->BDCR, RCC_BDCR_RTCEN_Msk, RCC_BDCR_RTCEN); // on RTC enable
    MODIFY_REG(RCC->D2CCIP2R, RCC_D2CCIP2R_USART28SEL_Msk, 0x00 << RCC_D2CCIP2R_USART28SEL_Pos); // usart2345678 ---> pclk
    MODIFY_REG(RCC->D2CCIP2R, RCC_D2CCIP2R_USBSEL_Msk, RCC_D2CCIP2R_USBSEL_0); // usb ---> pll1q*/

	MODIFY_REG(RCC->D3CCIPR, RCC_D3CCIPR_ADCSEL, 0 << RCC_D3CCIPR_ADCSEL_Pos); // 砥 ⠪஢    "pll2_p_ck"   80 
	MODIFY_REG(RCC->D2CCIP2R, RCC_D2CCIP2R_USART16SEL, 0 << RCC_D2CCIP2R_USART16SEL_Pos); // 砥 ⠪஢ USART1   "rcc_pclk2"
	MODIFY_REG(RCC->D2CCIP1R, RCC_D2CCIP1R_SPI45SEL, 0x1 << RCC_D2CCIP1R_SPI45SEL_Pos); //  spi4  120 

	RCC->AHB2ENR |= RCC_AHB2ENR_SRAM1EN;
	RCC->AHB2ENR |= RCC_AHB2ENR_SRAM2EN;
	RCC->AHB2ENR |= RCC_AHB2ENR_SRAM3EN;

	RCC->AHB1ENR |= RCC_AHB1LPENR_DMA1LPEN; // 砥 DMA1  設 AHB1
	while (!(RCC->AHB1ENR & RCC_AHB1LPENR_DMA1LPEN)); //  ࠭஢ 祭

	RCC->AHB1ENR |= RCC_AHB1LPENR_DMA2LPEN; // 砥 DMA2  設 AHB1
	while (!(RCC->AHB1ENR & RCC_AHB1LPENR_DMA2LPEN)); //  ࠭஢ 祭

	RCC->APB4ENR |= RCC_APB4ENR_VREFEN; // 祭 ⠪஢  
	RCC->AHB1ENR |= RCC_AHB1ENR_ADC12EN; // 砥 1_2  32-ࠧ來 設 AHB1   묨

	RCC->AHB4ENR |= RCC_AHB4ENR_CRCEN;     // 祭  CRC  設 AHB4
	RCC->AHB4ENR |= RCC_AHB4ENR_BKPRAMEN;  // 祭  BKPSRAM4  設 AHB4

	SET_BIT(RCC->BDCR, RCC_BDCR_RTCEN);
	while(!READ_BIT(RCC->BDCR, RCC_BDCR_RTCEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOAEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOAEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOBEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOBEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOCEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOCEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIODEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIODEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOEEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOEEN));

    SET_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOHEN);
    while(!READ_BIT(RCC->AHB4ENR, RCC_AHB4ENR_GPIOHEN));

    SET_BIT(RCC->AHB1ENR, RCC_AHB1ENR_USB2OTGHSEN); // 祭 ⠪஢  USB
    while(!READ_BIT(RCC->AHB1ENR, RCC_AHB1ENR_USB2OTGHSEN));

	MODIFY_REG(RCC->D2CCIP2R, RCC_D2CCIP2R_RNGSEL, RCC_D2CCIP2R_RNGSEL_0); //  ⠪⮢   RNG 
	RCC->AHB2ENR |= RCC_AHB2ENR_RNGEN; // 祭 RNG   設

	RCC->APB2ENR |= RCC_APB2ENR_USART1EN; // 砥 USART 1  設 ABP2
	while (!(RCC->APB2ENR & RCC_APB2ENR_USART1EN)); //  ⮡ ࠭஢ 稫

	RCC->APB1LENR |= RCC_APB1LENR_USART2EN; // 砥 USART 2  設 ABP2
	while (!(RCC->APB1LENR & RCC_APB1LENR_USART2EN)); //  ⮡ ࠭஢ 稫

	RCC->APB1LENR |= RCC_APB1LENR_USART3EN; // 砥 USART 3  設 ABP1
	while (!(RCC->APB1LENR & RCC_APB1LENR_USART3EN)); //  ⮡ ࠭஢ 稫

	RCC->APB2ENR |= RCC_APB2ENR_SPI4EN;
	while(!(RCC->APB2ENR & RCC_APB2ENR_SPI4EN));

    MODIFY_REG(RCC->APB2ENR, RCC_APB2ENR_TIM16EN, 0x1 << RCC_APB2ENR_TIM16EN_Pos); // 祭 ⠪஢ ⠩ TIM16
    while(!(RCC->APB2ENR & RCC_APB2ENR_TIM16EN)); //   

    RCC->APB2ENR |= RCC_APB2ENR_TIM15EN; // 祭 ⠪஢ ⠩ TIM15
    while(!(RCC->APB2ENR & RCC_APB2ENR_TIM15EN)); //   

    RCC->APB2ENR |= RCC_APB2ENR_TIM17EN; // 祭 ⠪஢ ⠩ TIM17
    while(!(RCC->APB2ENR & RCC_APB2ENR_TIM17EN)); //   

    CoreDebug->DEMCR |= 0x01000000;
    ITM->LAR = 0xC5ACCE55;
    DWT->CYCCNT = 0;
    DWT->CTRL |= DWT_CTRL_CYCCNTENA_Msk;

    SysTick_Config(480000);
	NVIC_SetPriority(SysTick_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0));
    NVIC_EnableIRQ(SysTick_IRQn);

  	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE11, 0x2 << GPIO_MODER_MODE11_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USB
  	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE12, 0x2 << GPIO_MODER_MODE12_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USB
  	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED11, 0x0 << GPIO_OSPEEDR_OSPEED11_Pos); // ன ᪮ ஭
  	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED12, 0x0 << GPIO_OSPEEDR_OSPEED12_Pos); // ன ᪮ ஭
  	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD11, 0x00 << GPIO_PUPDR_PUPD11_Pos); // ⪫祭 寧
  	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD12, 0x00 << GPIO_PUPDR_PUPD12_Pos); // ⪫祭 寧
  	MODIFY_REG(GPIOD->AFR[1], GPIO_AFRH_AFSEL11, 0x10 << GPIO_AFRH_AFSEL11_Pos); // ४祭  ୠ⨢ ० ࠡ  AF10
  	MODIFY_REG(GPIOD->AFR[1], GPIO_AFRH_AFSEL12, 0x10 << GPIO_AFRH_AFSEL12_Pos); // ४祭  ୠ⨢ ० ࠡ  AF10

  	NVIC_SetPriority(OTG_FS_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 0, 0)); // 뢠 USB
    NVIC_EnableIRQ(OTG_FS_IRQn);

    SET_BIT(PWR->CR3, PWR_CR3_USB33DEN);

    SET_BIT(RCC->APB4ENR, RCC_APB4ENR_SYSCFGEN);
    while(!READ_BIT(RCC->APB4ENR, RCC_APB4ENR_SYSCFGEN));

    /* ஢ ᮢ 뢮 */


	MODIFY_REG(RCC->CFGR,RCC_CFGR_MCO2, 0x1 << RCC_CFGR_MCO2_Pos); // ன 室 MCO2  䠯 PLL2
	MODIFY_REG(RCC->CFGR,RCC_CFGR_MCO2PRE, 0xf << RCC_CFGR_MCO2PRE_Pos); // ன 室 MCO2  䠯 PLL2
}


static void MX_RTC_Init(void){

	hrtc.Instance = RTC;
	hrtc.Init.HourFormat = RTC_HOURFORMAT_24;
	hrtc.Init.AsynchPrediv = 127;
	hrtc.Init.SynchPrediv = 255;
	hrtc.Init.OutPut = RTC_OUTPUT_DISABLE;
	hrtc.Init.OutPutPolarity = RTC_OUTPUT_POLARITY_HIGH;
	hrtc.Init.OutPutType = RTC_OUTPUT_TYPE_OPENDRAIN;
	hrtc.Init.OutPutRemap = RTC_OUTPUT_REMAP_NONE;

	if(HAL_RTC_Init(&hrtc) != HAL_OK)
	{
	Error_Handler();
	}

	WRITE_REG(RTC->WPR, 0xca);
	WRITE_REG(RTC->WPR, 0x53);

	RTC->CR &= ~(RTC_CR_WUTE);
	RTC->ISR = ~(RTC_ISR_WUTF | RTC_ISR_INIT)|(RTC->ISR & RTC_ISR_INIT);

	while(!READ_BIT(RTC->ISR, RTC_ISR_WUTWF));
	MODIFY_REG(RTC->WUTR, RTC_WUTR_WUT, 0x0 << RTC_WUTR_WUT_Pos);
	MODIFY_REG(RTC->CR, RTC_CR_WUCKSEL, RTC_CR_WUCKSEL_2);

	MODIFY_REG(RTC->CR, RTC_CR_WUTIE, 0x1 << RTC_CR_WUTIE_Pos);
	MODIFY_REG(RTC->CR, RTC_CR_WUTE, 0x1 << RTC_CR_WUTE_Pos);
	EXTI_D1->IMR1 |= EXTI_IMR1_IM19;
	EXTI->RTSR1 |= EXTI_IMR1_IM19;
	WRITE_REG(RTC->WPR, 0xff);

	if(HAL_RTCEx_SetCalibrationOutPut(&hrtc, RTC_CALIBOUTPUT_512HZ) != HAL_OK)
	{
	Error_Handler();
	}

	NVIC_SetPriority(RTC_WKUP_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0));
	NVIC_EnableIRQ(RTC_WKUP_IRQn);
}


void initADC(void)
{
	DMAMUX1_Channel0->CCR = (9 << DMAMUX_CxCR_DMAREQ_ID_Pos); // 祭 १ MUXDMA DMA1_ਬ_0  ADC1

	DMA1_Stream0->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while(DMA1_Stream0->CR & DMA_SxCR_EN); //  ࠭஢ 몫祭 DMA  直 砩
	DMA1_Stream0->CR = DMA_SxCR_MSIZE_0 | DMA_SxCR_PSIZE_0 | DMA_SxCR_MINC | DMA_SxCR_CIRC | DMA_SxCR_TCIE; // ன   
	DMA1_Stream0->NDTR = 5; // ⢮   ।     
	DMA1_Stream0->PAR = (uint32_t)&ADC1->DR; //   㤠   ()
	DMA1_Stream0->M0AR = (uint32_t)&ADC; // 㪠뢠  ᨢ 㤠 

	NVIC_SetPriority(DMA1_Stream0_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(DMA1_Stream0_IRQn);

	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE3, 0x3 << GPIO_MODER_MODE3_Pos); // ॢ    ० 㭪 ADC1-15
	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE4, 0x3 << GPIO_MODER_MODE4_Pos); // ॢ    ० 㭪 ADC1-18
	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE5, 0x3 << GPIO_MODER_MODE5_Pos); // ॢ    ० 㭪 ADC1-19
	MODIFY_REG(GPIOA->MODER, GPIO_MODER_MODE6, 0x3 << GPIO_MODER_MODE6_Pos); // ॢ    ० 㭪 ADC1-3
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE0, 0x3 << GPIO_MODER_MODE0_Pos); // ॢ    ० 㭪 ADC1-9

	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED3,0x0 << GPIO_OSPEEDR_OSPEED3_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED4,0x0 << GPIO_OSPEEDR_OSPEED4_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED5,0x0 << GPIO_OSPEEDR_OSPEED5_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOA->OSPEEDR, GPIO_OSPEEDR_OSPEED6,0x0 << GPIO_OSPEEDR_OSPEED6_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOB->OSPEEDR, GPIO_OSPEEDR_OSPEED0,0x0 << GPIO_OSPEEDR_OSPEED0_Pos); // ன ᪮ ஭

	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD3, 0x00 << GPIO_PUPDR_PUPD3_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD4, 0x00 << GPIO_PUPDR_PUPD4_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD5, 0x00 << GPIO_PUPDR_PUPD5_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOA->PUPDR, GPIO_PUPDR_PUPD6, 0x00 << GPIO_PUPDR_PUPD6_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD0, 0x00 << GPIO_PUPDR_PUPD0_Pos); // ⪫祭 寧

	MODIFY_REG(GPIOA->AFR[0], GPIO_AFRL_AFSEL3, 0x0 << GPIO_AFRL_AFSEL3_Pos); // ४祭  ୠ⨢ ० AF0
	MODIFY_REG(GPIOA->AFR[0], GPIO_AFRL_AFSEL4, 0x0 << GPIO_AFRL_AFSEL4_Pos); // ४祭  ୠ⨢ ० AF0
	MODIFY_REG(GPIOA->AFR[0], GPIO_AFRL_AFSEL5, 0x0 << GPIO_AFRL_AFSEL5_Pos); // ४祭  ୠ⨢ ० AF0
	MODIFY_REG(GPIOA->AFR[0], GPIO_AFRL_AFSEL6, 0x0 << GPIO_AFRL_AFSEL6_Pos); // ४祭  ୠ⨢ ० AF0
	MODIFY_REG(GPIOB->AFR[0], GPIO_AFRL_AFSEL0, 0x0 << GPIO_AFRL_AFSEL0_Pos); // ४祭  ୠ⨢ ० AF0

	ADC12_COMMON->CCR = ADC_CCR_VBATEN
				       | ADC_CCR_TSEN
				       | ADC_CCR_PRESC_0 | ADC_CCR_PRESC_1 | ADC_CCR_PRESC_3; // ⥫  1_2  256 祭 ⠭ 稪 ⥬, 祭  殮, ⥫ ckmode/1.


    if(READ_BIT(ADC1->CR, ADC_CR_DEEPPWD)){ // ஢ઠ ᫨ 祭 ࣮ᡥ०
	MODIFY_REG(ADC1->CR, ADC_CR_DEEPPWD, 0 << ADC_CR_DEEPPWD_Pos); // ⪫祭  யॡ 
	while(ADC1->CR & ADC_CR_DEEPPWD); //  ⮡ ࠭஢  襫  ० ࣮ᡥ०
	}
	
	if(!READ_BIT(ADC1->CR, ADC_CR_ADVREGEN)){
	MODIFY_REG(ADC1->CR, ADC_CR_ADVREGEN, 1 << ADC_CR_ADVREGEN_Pos); // 砥 LDO
	while(!(ADC1->ISR & (1<<12))); //  ᨣ ⮢ LDORDY
	}

    if(READ_BIT(ADC1->CR, ADC_CR_ADEN)){
    MODIFY_REG(ADC1->CR, ADC_CR_ADEN, 0 << ADC_CR_ADEN_Pos); //몫砥 
	}

    /*						஢							*/
    MODIFY_REG(ADC1->CR, ADC_CR_ADCALDIF, 0 << ADC_CR_ADCALDIF_Pos);  // 몫砥 ஢ ७樠쭮 室
    MODIFY_REG(ADC1->CR, ADC_CR_ADCALLIN, 1 << ADC_CR_ADCALLIN_Pos);  // 砥 ஢ 
    MODIFY_REG(ADC1->CR, ADC_CR_ADCAL, 1 << ADC_CR_ADCAL_Pos); // ஢ 
    while(ADC1->CR & ADC_CR_ADCAL); //    ஢


	WRITE_REG(ADC1->DIFSEL,0);

	ADC1->CFGR = ADC_CFGR_JQDIS | ADC_CFGR_CONT | ADC_CFGR_DMNGT_1 | ADC_CFGR_DMNGT_0; // 横᪠ । १ DMA
	WRITE_REG(ADC1->CFGR2,0);

	ADC1->SMPR1 = ADC_SMPR1_SMP9_2 | ADC_SMPR1_SMP3_2; // প 樮   32,5 ⠪ ⠪஥ 
	ADC1->SMPR2 = ADC_SMPR2_SMP19_2 | ADC_SMPR2_SMP18_2 | ADC_SMPR2_SMP15_2; // প 樮   32,5 ⠪ ⠪஥ 

	ADC1->PCSEL = ADC_PCSEL_PCSEL_19 | ADC_PCSEL_PCSEL_18 | ADC_PCSEL_PCSEL_15 | ADC_PCSEL_PCSEL_9 | ADC_PCSEL_PCSEL_3; // 19,18,15,9,3

	ADC1->LTR1 = 0x00; // ⠭  ஢  
	ADC1->LTR2 = 0x00; // ⠭  ஢  
	ADC1->LTR3 = 0x00; // ⠭  ஢  
	ADC1->HTR1 = 0x3FFFFFF; // ⠭ 孥 ஢  
	ADC1->HTR2 = 0x3FFFFFF; // ⠭ 孥 ஢  
	ADC1->HTR3 = 0x3FFFFFF; // ⠭ 孥 ஢  

	ADC1->SQR1 = (ADC_SQR1_SQ1_1 | ADC_SQR1_SQ1_0)
				 | (ADC_SQR1_SQ2_3 |  ADC_SQR1_SQ2_0)
				 | (ADC_SQR1_SQ3_3 | ADC_SQR1_SQ3_2 | ADC_SQR1_SQ3_1 | ADC_SQR1_SQ3_0)
				 | (ADC_SQR1_SQ4_4 | ADC_SQR1_SQ4_1)
				 | (ADC_SQR1_L_2); // 蠣    3 --> 9 ---> 15 ---> 18 ---> 19

	ADC1->SQR2 = (ADC_SQR2_SQ5_4 | ADC_SQR2_SQ5_1 | ADC_SQR2_SQ5_0); // 19  
	ADC1->SQR3 = 0; // ⠫    
	ADC1->SQR4 = 0; // ⠫    

	MODIFY_REG(ADC1->CR, ADC_CR_ADEN, 1 << ADC_CR_ADEN_Pos); // 砥 
	while(!(ADC1->ISR & ADC_ISR_ADRDY)); //    ⠭ ⮢  ࠡ

	MODIFY_REG(DMA1_Stream0->CR, DMA_SxCR_EN, 1 << DMA_SxCR_EN_Pos); // 砥 DMA  
	while(!(DMA1_Stream0->CR & DMA_SxCR_EN)); //    dma

	MODIFY_REG(ADC1->CR,ADC_CR_ADSTART,1 << ADC_CR_ADSTART_Pos); //  ਮࠧ
}


void initTimerTaskManager(void)
{
    TIM15->DIER = TIM_DIER_UIE;
    TIM15->PSC = 240 - 1;
    TIM15->ARR = 1000 - 1;
	NVIC_SetPriority(TIM15_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ⠩
    NVIC_EnableIRQ(TIM15_IRQn);
}


void initUSARTASU(void)
{
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE6, 0x2 << GPIO_MODER_MODE6_Pos); // ॢ   ୠ⨢ 㭪 RX
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE5, 0x2 << GPIO_MODER_MODE5_Pos); // ॢ   ୠ⨢ 㭪 TX
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE4, 0x2 << GPIO_MODER_MODE4_Pos); // ॢ   ୠ⨢ 㭪 DE

	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED6, 0x0 << GPIO_OSPEEDR_OSPEED6_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED5, 0x0 << GPIO_OSPEEDR_OSPEED5_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED4, 0x0 << GPIO_OSPEEDR_OSPEED4_Pos); // ன ᪮ ஭

	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD6, 0x00 << GPIO_PUPDR_PUPD6_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD5, 0x00 << GPIO_PUPDR_PUPD5_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD4, 0x00 << GPIO_PUPDR_PUPD4_Pos); // ⪫祭 寧

	MODIFY_REG(GPIOD->AFR[0], GPIO_AFRL_AFSEL6, 0x7 << GPIO_AFRL_AFSEL6_Pos);
	MODIFY_REG(GPIOD->AFR[0], GPIO_AFRL_AFSEL5, 0x7 << GPIO_AFRL_AFSEL5_Pos);
	MODIFY_REG(GPIOD->AFR[0], GPIO_AFRL_AFSEL4, 0x7 << GPIO_AFRL_AFSEL4_Pos);

	DMAMUX1_Channel8->CCR = (43 << DMAMUX_CxCR_DMAREQ_ID_Pos); // rx
	DMAMUX1_Channel9->CCR = (44 << DMAMUX_CxCR_DMAREQ_ID_Pos); // tx

	DMA2_Stream0->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA2_Stream0->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA2_Stream0->CR = DMA_SxCR_MINC | DMA_SxCR_TCIE; // ன   USART2 ६ , 祭 뢠  襭 ਥ
	DMA2_Stream0->NDTR = 256; // ⢮   ।  USART3      7
	DMA2_Stream0->PAR = (uint32_t)&USART2->RDR; //   㤠  
	DMA2_Stream0->M0AR = (uint32_t)&AsuRX; // 㪠뢠  ᨢ 㤠 

	DMA2_Stream1->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA2_Stream1->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA2_Stream1->CR = DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE; // ன   USART2 ६ , ।   ---> USART2
	DMA2_Stream1->NDTR = 0; // ⢮   ।  USART3   
	DMA2_Stream1->PAR = (uint32_t)&USART2->TDR; //   㤠  
	DMA2_Stream1->M0AR = (uint32_t)&AsuTX; // 㪠뢠  ᨢ 㤠 

	NVIC_ClearPendingIRQ(DMA2_Stream0_IRQn); // ࠭஢  䫠 뢠
	NVIC_ClearPendingIRQ(DMA2_Stream1_IRQn); // ࠭஢  䫠 뢠
	NVIC_SetPriority(DMA2_Stream1_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(DMA1_Stream1_IRQn);
	NVIC_SetPriority(DMA2_Stream1_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(DMA1_Stream1_IRQn);

	USART2->CR1 &= ~USART_CR1_UE; // ⪫祭 USART2  ன
	while(USART2->CR1 & USART_CR1_UE); // ஢塞   祭 USART2 襭

	MODIFY_REG(USART2->RTOR, USART_RTOR_RTO, 35);

	USART2->CR1 = 0
			| 0*USART_CR1_RXFFIE // 몫祭 뢠  ਥ
			| 0*USART_CR1_TXFEIE // 몫祭 뢠  ।
			| 0*USART_CR1_FIFOEN // 몫祭  ਥ ।稪
			| 0*USART_CR1_M1     // 祭 8 ⭮ ०
			| 0*USART_CR1_EOBIE  // 몫祭 뢠  
			| 0*USART_CR1_RTOIE  // 몫祭 뢠 ⠩
			| 1*USART_CR1_DEAT_0 // 祭 ६ প
			| 1*USART_CR1_DEAT_1
			| 1*USART_CR1_DEAT_2
			| 1*USART_CR1_DEAT_3
			| 1*USART_CR1_DEDT_0
			| 1*USART_CR1_DEDT_1
			| 1*USART_CR1_DEDT_2
			| 1*USART_CR1_DEDT_3 // -||-
			| 0*USART_CR1_OVER8  // 祭 16 ⭮
			| 0*USART_CR1_CMIE
			| 0*USART_CR1_MME
			| 0*USART_CR1_M0
			| 0*USART_CR1_WAKE
			| 0*USART_CR1_PCE
			| 0*USART_CR1_PS
			| 0*USART_CR1_PEIE
			| 0*USART_CR1_TXEIE_TXFNFIE
			| 0*USART_CR1_TCIE
			| 0*USART_CR1_RXNEIE_RXFNEIE
			| 0*USART_CR1_IDLEIE
			| 1*USART_CR1_TE
			| 1*USART_CR1_RE
			| 0*USART_CR1_UESM
			| 0*USART_CR1_UE  // 몫祭 usart
			;

	USART2->CR2 = 0
			| 1*USART_CR2_RTOEN
			| 1*USART_CR2_STOP_1
			;

	WRITE_REG(USART2->ICR, USART_ICR_RTOCF);
	SET_BIT(USART2->CR1, USART_CR1_RTOIE);
	while(!(USART2->CR1 & USART_CR1_RTOIE));

	USART2->CR3 = 0
			| 1*USART_CR3_DMAT
			| 1*USART_CR3_DMAR
			| 0*USART_CR3_DEP
			| 1*USART_CR3_DEM
			;

	USART2->PRESC = 0; // ।⥫ ⠪⮢ 

	switch(SysMem.DIO_MIN[0].DIO_00.ASU_P_Speed)
	{
	case 1:
		USART2->BRR = 1041;
		break;
	default :
		USART2->BRR = 1041; // ᪮ 115200  㬮砭
		break;
	}

    DMA2_Stream0->CR |= DMA_SxCR_EN; // ਥ
    //DMA2_Stream1->CR |= DMA_SxCR_EN; // ।

	USART2->CR1 |= USART_CR1_UE; // 砥 USART2
	while (!(USART2->CR1 & USART_CR1_UE)); // ஢塞   祭 USART2 ⠭

	USART2->ICR = 1* USART_ICR_PECF   |
				  1* USART_ICR_FECF   |
				  1* USART_ICR_RTOCF  |
				  1* USART_ICR_NECF   |
				  1* USART_ICR_ORECF  |
				  1* USART_ICR_IDLECF |
				  1* USART_ICR_TXFECF |
				  1* USART_ICR_TCCF   |
				  1* USART_ICR_TCBGTCF|
				  1* USART_ICR_LBDCF  |
				  1* USART_ICR_CTSCF  |
				  1* USART_ICR_EOBCF  |
				  1* USART_ICR_UDRCF  |
				  1* USART_ICR_CMCF   |
				  1* USART_ICR_WUCF
				  ;

	NVIC_ClearPendingIRQ(USART2_IRQn);       // ࠭஢  䫠 뢠
	NVIC_SetPriority(USART2_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(USART2_IRQn);
}


void initSPIEeprom(void) // 樠 SPI4  EEPROM
{
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE6, 0x2 << GPIO_MODER_MODE6_Pos); // ॢ   ୠ⨢ 㭪 MOSI --- SI
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE5, 0x2 << GPIO_MODER_MODE5_Pos); // ॢ   ୠ⨢ 㭪 MISO --- SO
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE4, 0x1 << GPIO_MODER_MODE4_Pos); // ॢ   ୠ⨢ 㭪 NSS --- CS
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE3, 0x1 << GPIO_MODER_MODE3_Pos); // ॢ   ୠ⨢ 㭪 WR
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE2, 0x2 << GPIO_MODER_MODE2_Pos); // ॢ   ୠ⨢ 㭪 SCK
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE0, 0x1 << GPIO_MODER_MODE0_Pos); // ॢ   ୠ⨢ 㭪 HOLD

	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED6, 0x0 << GPIO_OSPEEDR_OSPEED6_Pos); // ன ᪮ ஭ ᪮ 
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED5, 0x0 << GPIO_OSPEEDR_OSPEED5_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED4, 0x0 << GPIO_OSPEEDR_OSPEED4_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED3, 0x0 << GPIO_OSPEEDR_OSPEED3_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED2, 0x0 << GPIO_OSPEEDR_OSPEED2_Pos); // ன ᪮ ஭
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED0, 0x0 << GPIO_OSPEEDR_OSPEED0_Pos); // ன ᪮ ஭

	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD6, 0x00 << GPIO_PUPDR_PUPD6_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD5, 0x00 << GPIO_PUPDR_PUPD5_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD4, 0x00 << GPIO_PUPDR_PUPD4_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD3, 0x00 << GPIO_PUPDR_PUPD3_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD2, 0x00 << GPIO_PUPDR_PUPD2_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD0, 0x00 << GPIO_PUPDR_PUPD0_Pos); // ⪫祭 寧

	MODIFY_REG(GPIOE->AFR[0], GPIO_AFRL_AFSEL6, 0x5 << GPIO_AFRL_AFSEL6_Pos); // ४祭  ୠ⨢ ० ࠡ  AF5
	MODIFY_REG(GPIOE->AFR[0], GPIO_AFRL_AFSEL5, 0x5 << GPIO_AFRL_AFSEL5_Pos);
	MODIFY_REG(GPIOE->AFR[0], GPIO_AFRL_AFSEL2, 0x5 << GPIO_AFRL_AFSEL2_Pos);

	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS0); // HOLD
	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS3); // WR
	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS4); // CS

	SPI4->CR1 = 0x00;
    SPI4->CFG1 = 0x00;
    SPI4->CFG1 = (0x7 << SPI_CFG1_DSIZE_Pos); // ᨬ쭠  40 
    SPI4->CFG2 = 0x00;
    SPI4->CFG2 = SPI_CFG2_SSOE | SPI_CFG2_MASTER ;
    SPI4->CR2 = 0;
    SPI4->CR1 |= SPI_CR1_SPE;
    while(!(SPI4->CR1 & SPI_CR1_SPE));
    SPI4->CR1 |= SPI_CR1_CSTART;
}


void initLed(void)
{
	/*ன ᢥ⮤ VD2*/
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE2, 0x1 << GPIO_MODER_MODE2_Pos);            // ॢ   室
	MODIFY_REG(GPIOB->OSPEEDR, GPIO_OSPEEDR_OSPEED2, 0x0 << GPIO_OSPEEDR_OSPEED2_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD2, 0x00 << GPIO_PUPDR_PUPD2_Pos);           // ⪫祭 寧

	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE7, 0x1 << GPIO_MODER_MODE7_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED7, 0x0 << GPIO_OSPEEDR_OSPEED7_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD7, 0x00 << GPIO_PUPDR_PUPD7_Pos);           // ⪫祭 寧

	/*ன ᢥ⮤ VD3*/
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE8, 0x1 << GPIO_MODER_MODE8_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED8, 0x0 << GPIO_OSPEEDR_OSPEED8_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD8, 0x00 << GPIO_PUPDR_PUPD8_Pos);           // ⪫祭 寧

	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE9, 0x1 << GPIO_MODER_MODE9_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED9, 0x0 << GPIO_OSPEEDR_OSPEED9_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD9, 0x00 << GPIO_PUPDR_PUPD9_Pos);           // ⪫祭 寧

	/*ன ᢥ⮤ VD4*/
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE10, 0x1 << GPIO_MODER_MODE10_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED10, 0x0 << GPIO_OSPEEDR_OSPEED10_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD10, 0x00 << GPIO_PUPDR_PUPD10_Pos);           // ⪫祭 寧

	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE11, 0x1 << GPIO_MODER_MODE11_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED11, 0x0 << GPIO_OSPEEDR_OSPEED11_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD11, 0x00 << GPIO_PUPDR_PUPD11_Pos);           // ⪫祭 寧

	/*ன ᢥ⮤ VD5*/
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE12, 0x1 << GPIO_MODER_MODE12_Pos);           // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED12, 0x0 << GPIO_OSPEEDR_OSPEED12_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD12, 0x00 << GPIO_PUPDR_PUPD12_Pos);           // ⪫祭 寧

	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE13, 0x1 << GPIO_MODER_MODE13_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED13, 0x0 << GPIO_OSPEEDR_OSPEED13_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD13, 0x00 << GPIO_PUPDR_PUPD13_Pos);           // ⪫祭 寧

	/*ன ᢥ⮤ VD6*/
	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE14, 0x1 << GPIO_MODER_MODE14_Pos);           // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED14, 0x0 << GPIO_OSPEEDR_OSPEED14_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD14, 0x00 << GPIO_PUPDR_PUPD14_Pos);           // ⪫祭 寧

	MODIFY_REG(GPIOE->MODER, GPIO_MODER_MODE15, 0x1 << GPIO_MODER_MODE15_Pos);            // ॢ   室
	MODIFY_REG(GPIOE->OSPEEDR, GPIO_OSPEEDR_OSPEED15, 0x0 << GPIO_OSPEEDR_OSPEED15_Pos);  // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOE->PUPDR, GPIO_PUPDR_PUPD15, 0x00 << GPIO_PUPDR_PUPD15_Pos);           // ⪫祭 寧

	/*ன ᢥ⮤ VD7*/
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE14, 0x1 << GPIO_MODER_MODE14_Pos);           // ॢ   室
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED14, 0x0 << GPIO_OSPEEDR_OSPEED14_Pos); // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD14, 0x00 << GPIO_PUPDR_PUPD14_Pos);          // ⪫祭 寧

	MODIFY_REG(GPIOC->MODER, GPIO_MODER_MODE6, 0x1 << GPIO_MODER_MODE6_Pos);             // ॢ   室
	MODIFY_REG(GPIOC->OSPEEDR, GPIO_OSPEEDR_OSPEED6, 0x0 << GPIO_OSPEEDR_OSPEED6_Pos);   // ன ᪮ ஭  ५ ᪮ 
	MODIFY_REG(GPIOC->PUPDR, GPIO_PUPDR_PUPD6, 0x00 << GPIO_PUPDR_PUPD6_Pos);            // ⪫祭 寧
}


void initDisplay(void)
{
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE14, 0x2 << GPIO_MODER_MODE14_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USART_TX
	MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE15, 0x2 << GPIO_MODER_MODE15_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USART_RX

	MODIFY_REG(GPIOB->OSPEEDR, GPIO_OSPEEDR_OSPEED14,0x0 << GPIO_OSPEEDR_OSPEED14_Pos); // ன ᪮ ஭ USART ᪮ 
	MODIFY_REG(GPIOB->OSPEEDR, GPIO_OSPEEDR_OSPEED15,0x0 << GPIO_OSPEEDR_OSPEED15_Pos); // ன ᪮ ஭ USART ᪮ 

	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD14, 0x00 << GPIO_PUPDR_PUPD14_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD15, 0x00 << GPIO_PUPDR_PUPD15_Pos); // ⪫祭 寧

	MODIFY_REG(GPIOB->AFR[1], GPIO_AFRH_AFSEL14, 0x4 << GPIO_AFRH_AFSEL14_Pos); // ४祭  ୠ⨢ ० ࠡ  AF4
	MODIFY_REG(GPIOB->AFR[1], GPIO_AFRH_AFSEL15, 0x4 << GPIO_AFRH_AFSEL15_Pos); // ४祭  ୠ⨢ ० ࠡ  AF4

	DMAMUX1_Channel3->CCR = (41 << DMAMUX_CxCR_DMAREQ_ID_Pos); // 祭 MUXDMA RX
	DMAMUX1_Channel4->CCR = (42 << DMAMUX_CxCR_DMAREQ_ID_Pos); // TX

	DMA1_Stream3->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA1_Stream3->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1_Stream3->CR = DMA_SxCR_MINC | DMA_SxCR_TCIE ; // ன   USART3 ६ , 祭 뢠  襭 ਥ
	DMA1_Stream3->NDTR = 0; // ⢮   ।  USART1   
	DMA1_Stream3->PAR =  (uint32_t)&USART1->RDR; //   㤠  
	DMA1_Stream3->M0AR = (uint32_t)&USART1_RX; // 㪠뢠  ᨢ 㤠 

	DMA1_Stream4->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA1_Stream4->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1_Stream4->CR = DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE; // ன   USART1 ६ , ।   ---> USART1
	DMA1_Stream4->NDTR = 0; // ⢮   ।  USART1   
	DMA1_Stream4->PAR = (uint32_t)&USART1->TDR; //   㤠  
	DMA1_Stream4->M0AR = (uint32_t)&USART1_TX; // 㪠뢠  ᨢ 㤠 

	NVIC_SetPriority(DMA1_Stream3_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(DMA1_Stream3_IRQn);

	NVIC_SetPriority(DMA1_Stream4_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ।稪
    NVIC_EnableIRQ(DMA1_Stream4_IRQn);

	USART1->CR1 &= ~USART_CR1_UE; // ⪫祭 USART1  ன
	while (USART1->CR1 & USART_CR1_UE); // ஢塞   祭 USART1 襭
	USART1->CR2 = 0x00;
	USART1->CR3 = USART_CR3_DMAT | USART_CR3_DMAR; // 祭 DMA

	USART1->PRESC = 0; // ।⥫ ⠪⮢  室 ⠪⮢ 120
	USART1->BRR = 521; // ᪮ 230400

	USART1->CR1 = 0
			| 0*USART_CR1_RXFFIE // 몫祭 뢠  ਥ
			| 0*USART_CR1_TXFEIE // 몫祭 뢠  ।
	        | 0*USART_CR1_FIFOEN // 몫祭  ਥ ।稪
			| 0*USART_CR1_M1     // 祭 8 ⭮ ०
			| 0*USART_CR1_EOBIE  // 몫祭 뢠  
			| 0*USART_CR1_RTOIE  // 몫祭 뢠 ⠩
			| 0*USART_CR1_DEAT   // 몫祭 ६ প
			| 0*USART_CR1_DEDT   // -||-
			| 0*USART_CR1_OVER8  // 祭 16 ⭮
			| 0*USART_CR1_CMIE
			| 0*USART_CR1_MME
			| 0*USART_CR1_M0
			| 0*USART_CR1_WAKE
			| 0*USART_CR1_PCE
			| 0*USART_CR1_PS
			| 0*USART_CR1_PEIE
			| 0*USART_CR1_TXEIE_TXFNFIE
			| 0*USART_CR1_TCIE
			| 0*USART_CR1_RXNEIE_RXFNEIE
			| 0*USART_CR1_IDLEIE
			| 1*USART_CR1_TE
			| 1*USART_CR1_RE
			| 0*USART_CR1_UESM
			| 0*USART_CR1_UE  // 몫祭 usart
			;

	USART1->CR1 |= USART_CR1_UE;
	while(!(USART1->CR1 & USART_CR1_UE)); // ஢塞   祭 USART1 ⠭
}


void initUsartExtBloks(void) // 樠   ࠡ  譥 
{
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE8, 0x2 << GPIO_MODER_MODE8_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USART_TX
	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE9, 0x2 << GPIO_MODER_MODE9_Pos); // ॢ   ୠ⨢ 㭪  ⭮ USART_RX
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED8,0x0 << GPIO_OSPEEDR_OSPEED8_Pos); // ன ᪮ ஭ USART ᪮ 
	MODIFY_REG(GPIOD->OSPEEDR, GPIO_OSPEEDR_OSPEED9,0x0 << GPIO_OSPEEDR_OSPEED9_Pos); // ன ᪮ ஭ USART ᪮ 
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD8, 0x00 << GPIO_PUPDR_PUPD8_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD9, 0x00 << GPIO_PUPDR_PUPD9_Pos); // ⪫祭 寧
	MODIFY_REG(GPIOD->AFR[1], GPIO_AFRH_AFSEL8, 0x7 << GPIO_AFRH_AFSEL8_Pos); // ४祭  ୠ⨢ ० ࠡ  AF7
	MODIFY_REG(GPIOD->AFR[1], GPIO_AFRH_AFSEL9, 0x7 << GPIO_AFRH_AFSEL9_Pos); // ४祭  ୠ⨢ ० ࠡ  AF7

	MODIFY_REG(GPIOD->MODER, GPIO_MODER_MODE10, 0x1 << GPIO_MODER_MODE10_Pos); // ॢ   室 RE
	MODIFY_REG(GPIOD->OSPEEDR,GPIO_OSPEEDR_OSPEED10,0x0 << GPIO_OSPEEDR_OSPEED10_Pos); // ன ᪮ ஭  RE ᪮ 
	MODIFY_REG(GPIOD->PUPDR, GPIO_PUPDR_PUPD10, 0x00 << GPIO_PUPDR_PUPD10_Pos); // ⪫祭 寧
	SET_BIT(GPIOD->BSRR, GPIO_BSRR_BR10); //⠭ ᪮    RE

	DMAMUX1_Channel1->CCR = (45 << DMAMUX_CxCR_DMAREQ_ID_Pos); // 祭 MUXDMA
	DMAMUX1_Channel2->CCR = (46 << DMAMUX_CxCR_DMAREQ_ID_Pos);

	DMA1_Stream1->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA1_Stream1->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1_Stream1->CR = DMA_SxCR_TRBUFF | DMA_SxCR_MINC | DMA_SxCR_TCIE; // ன   USART3 ६ , 祭 뢠  襭 ਥ
	DMA1_Stream1->NDTR = 0; // ⢮   ।  USART3      7
	DMA1_Stream1->PAR = (uint32_t)&USART3->RDR; //   㤠  
	DMA1_Stream1->M0AR = (uint32_t)&ExternalsBlocks_RX[0]; // 㪠뢠  ᨢ 㤠 

	DMA1_Stream2->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA1_Stream2->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1_Stream2->CR = DMA_SxCR_TRBUFF | DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE; // ன   USART3 ६ , ।   ---> USART3
	DMA1_Stream2->NDTR = 0; // ⢮   ।  USART3   
	DMA1_Stream2->PAR = (uint32_t)&USART3->TDR; //   㤠  
	DMA1_Stream2->M0AR = (uint32_t)&ExternalsBlocks_TX[0]; // 㪠뢠  ᨢ 㤠 

	NVIC_ClearPendingIRQ(DMA1_Stream1_IRQn); // ࠭஢  䫣 뢠
	NVIC_SetPriority(DMA1_Stream1_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ਥ
    NVIC_EnableIRQ(DMA1_Stream1_IRQn);

    NVIC_ClearPendingIRQ(DMA1_Stream2_IRQn); // ࠭஢  䫣 뢠
	NVIC_SetPriority(DMA1_Stream2_IRQn, NVIC_EncodePriority(NVIC_GetPriorityGrouping(), 1, 0)); // 祭 뢠 ।稪
    NVIC_EnableIRQ(DMA1_Stream2_IRQn);


	USART3->CR1 &= ~USART_CR1_UE; // ⪫祭 USART 3  ன
	while (USART3->CR1 & USART_CR1_UE); // ஢塞   祭 USART3 襭
	USART3->CR1 = 0
			| 0*USART_CR1_RXFFIE // 몫祭 뢠  ਥ
			| 0*USART_CR1_TXFEIE // 몫祭 뢠  ।
	        | 0*USART_CR1_FIFOEN // 몫祭  ਥ ।稪
			| 0*USART_CR1_M1     // 祭 9 ⭮ ०
			| 0*USART_CR1_EOBIE  // 몫祭 뢠  
			| 0*USART_CR1_RTOIE  // 몫祭 뢠 ⠩
			| 0*USART_CR1_DEAT   // 몫祭 ६ প
			| 0*USART_CR1_DEDT   // -||-
			| 0*USART_CR1_OVER8  // 祭 16 ⭮
			| 0*USART_CR1_CMIE
			| 0*USART_CR1_MME
			| 1*USART_CR1_M0
			| 0*USART_CR1_WAKE
			| 1*USART_CR1_PCE
			| 0*USART_CR1_PS
			| 0*USART_CR1_PEIE
			| 0*USART_CR1_TXEIE_TXFNFIE
			| 0*USART_CR1_TCIE    // 祭 ⪫祭 뢠  ।
			| 0*USART_CR1_RXNEIE_RXFNEIE // 祭  ਥ 
			| 0*USART_CR1_IDLEIE
			| 1*USART_CR1_TE
			| 1*USART_CR1_RE
			| 0*USART_CR1_UESM
			| 0*USART_CR1_UE  // 몫祭 usart
			;

	USART3->CR2 = 0x00;
	USART3->CR3 = USART_CR3_DMAT | USART_CR3_DMAR; // 祭 DMA
	USART3->PRESC = 0; // ।⥫ ⠪⮢ 
	USART3->BRR = 521; // ⠭ ᪮ ⭠ 521, ⮢ ᪮ 뫠 19200 6250, 115200 1041
	USART3->ISR;
	USART3->ICR;
	USART3->ICR = 0;
	USART3->RTOR = 0;

	USART3->CR1 |= USART_CR1_UE; // 砥 USART3
	while (!(USART3->CR1 & USART_CR1_UE)); // ஢塞   祭 USART3 ⠭
}


void Error_Handler(void)
{

}

#ifdef  USE_FULL_ASSERT

void assert_failed(uint8_t *file, uint32_t line)
{ 
}
#endif

