#include "font.h"

const char fnt_4x6[] = {
		0x20,0x20,0xdc,0xdc, 0x20,0xdb,0x20,0xdb, 0x20,0xdb,0xdc,0xdf,  // 0
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0xdb,0x20, 0x20,0x20,0xdb,0x20,  // 1
		0x20,0xdc,0xdc,0x20, 0x20,0x20,0xdc,0xdf, 0x20,0xdb,0xdc,0xdc,  // 2
		0x20,0xdc,0xdc,0x20, 0x20,0x20,0xdc,0xdf, 0x20,0xdc,0xdc,0xdf,  // 3
		0x20,0x20,0x20,0xdc, 0x20,0xdb,0xdc,0xdb, 0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc, 0x20,0xdb,0xdc,0x20, 0x20,0xdc,0xdc,0xdf,  // 5
		0x20,0x20,0xdc,0x20, 0x20,0xdb,0xdc,0x20, 0x20,0xdf,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc, 0x20,0x20,0xdc,0xdb, 0x20,0x20,0xdb,0x20,  // 7
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0xdc,0xdf, 0x20,0xdf,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0xdc,0xdb, 0x20,0x20,0xdc,0xdf,  // 9
		0x20,0x20,0x20,0x20, 0x20,0xdc,0xdc,0xdc, 0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20, 0x20,0xdc,0xdb,0xdc, 0x20,0x20,0xdf,0x20,  // +
		0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0xdc,0x20,  // .
		0x20,0xdc,0xdc,0xdc, 0x20,0xdb,0xdc,0x20, 0x20,0xdb,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20   // space
		};


const char fnt_4x8[] = {
		0x20,0x20,0xdc,0x20, 0x20,0xdb,0x20,0xdb, 0x20,0xdb,0x20,0xdb, 0x20,0xdf,0xdc,0xdf,  // 0
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0xdb,0x20, 0x20,0x20,0xdb,0x20, 0x20,0xdc,0xdb,0xdc,  // 1
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0x20,0xdb, 0x20,0xdc,0xdf,0x20, 0x20,0xdb,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0x20, 0x20,0xdf,0x20,0xdb, 0x20,0x20,0xdf,0xdc, 0x20,0xdf,0xdc,0xdf,  // 3
		0x20,0xdc,0x20,0xdc, 0x20,0xdb,0x20,0xdb, 0x20,0xdb,0xdc,0xdb, 0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc, 0x20,0xdb,0xdc,0x20, 0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdf,  // 5
		0x20,0x20,0xdc,0x20, 0x20,0xdb,0x20,0x20, 0x20,0xdb,0xdf,0xdc, 0x20,0xdf,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc, 0x20,0x20,0x20,0xdb, 0x20,0x20,0xdb,0x20, 0x20,0x20,0xdb,0x20,  // 7
		0x20,0x20,0xdc,0x20, 0x20,0xdb,0x20,0xdb, 0x20,0xdc,0xdf,0xdc, 0x20,0xdf,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0x20, 0x20,0xdb,0x20,0xdb, 0x20,0x20,0xdf,0xdb, 0x20,0x20,0xdc,0xdf,  // 9
		0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0xdf,0xdf,0xdf, 0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20, 0x20,0x20,0xdc,0x20, 0x20,0xdf,0xdb,0xdf, 0x20,0x20,0x20,0x20,  // +
		0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20, 0x20,0xdb,0xdf,0xdf, 0x20,0xdb,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20   // space
		};


const char fnt_5x8[] = {
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0xdb,
		0x20,0xdf,0xdc,0xdc,0xdf,  // 0
		0x20,0x20,0xdc,0x20,0x20, 0x20,0xdf,0xdb,0x20,0x20, 0x20,0x20,0xdb,0x20,0x20,
		0x20,0xdc,0xdb,0xdc,0x20,  // 1
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0xdb, 0x20,0x20,0xdc,0xdf,0x20,
		0x20,0xdb,0xdc,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0xdb, 0x20,0x20,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdf,  // 3
		0x20,0x20,0x20,0x20,0xdc, 0x20,0x20,0xdc,0xdf,0xdb, 0x20,0xdb,0xdc,0xdc,0xdb,
		0x20,0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdc,0xdc,0x20, 0x20,0x20,0x20,0x20,0xdb,
		0x20,0xdf,0xdc,0xdc,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0x20, 0x20,0xdc,0xdf,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0x20,0x20,0x20,0xdb, 0x20,0x20,0xdc,0xdf,0x20,
		0x20,0x20,0xdb,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdc,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0x20,0xdf,0xdf,0xdb,
		0x20,0x20,0xdc,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0xdf,0xdf,0xdf,0x20,
		0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0xdc,0x20,0x20, 0x20,0xdf,0xdb,0xdf,0x20,
		0x20,0x20,0x20,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0xdb,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0x20,
		0x20,0xdb,0xdc,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20   // space
		};


const char fnt_5x10[] = {
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0xdb,
		0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,  // 0
		0x20,0x20,0x20,0xdc,0x20, 0x20,0x20,0xdf,0xdb,0x20, 0x20,0x20,0x20,0xdb,0x20,
		0x20,0x20,0x20,0xdb,0x20, 0x20,0x20,0xdc,0xdb,0xdc,  // 1
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0xdb, 0x20,0x20,0x20,0xdc,0xdf,
		0x20,0xdc,0xdf,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0xdb, 0x20,0x20,0xdc,0xdc,0xdf,
		0x20,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,  // 3
		0x20,0xdc,0x20,0x20,0xdc, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0xdb,
		0x20,0xdf,0xdf,0xdf,0xdb, 0x20,0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20, 0x20,0xdf,0xdf,0xdf,0xdc,
		0x20,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0x20, 0x20,0xdc,0xdf,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0xdc,
		0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0xdf,0x20,0x20,0xdb, 0x20,0x20,0x20,0xdc,0xdf,
		0x20,0x20,0xdb,0x20,0x20, 0x20,0x20,0xdb,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,
		0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0xdb,
		0x20,0x20,0xdf,0xdf,0xdb, 0x20,0x20,0xdc,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0xdc,0xdc,0xdc,0x20,
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0xdc,0xdb,0xdc,0x20,
		0x20,0x20,0xdf,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0x20,
		0x20,0xdb,0x20,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20   // space
		};


const char fnt_6x8[] = {
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0x20,0xdb,
		0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 0
		0x20,0x20,0x20,0xdc,0x20,0x20, 0x20,0x20,0xdf,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0x20,0x20,
		0x20,0x20,0xdc,0xdb,0xdc,0x20,  // 1
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0x20,0xdb, 0x20,0x20,0xdc,0xdf,0xdf,0x20,
		0x20,0xdb,0xdc,0xdc,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0x20,0xdb, 0x20,0x20,0x20,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 3
		0x20,0x20,0x20,0x20,0xdc,0xdc, 0x20,0x20,0xdc,0xdf,0x20,0xdb, 0x20,0xdb,0xdc,0xdc,0xdc,0xdb,
		0x20,0x20,0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdc,0xdc,0xdc,0x20, 0x20,0x20,0x20,0x20,0x20,0xdb,
		0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdc,0xdf,0x20,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0x20,0x20,0x20,0xdc,0xdf, 0x20,0x20,0xdc,0xdf,0x20,0x20,
		0x20,0x20,0xdb,0x20,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdc,0xdf,0xdf,0xdf,0xdc,
		0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0x20,0xdf,0xdf,0xdf,0xdb,
		0x20,0x20,0xdc,0xdc,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0xdf,0xdf,0xdf,0xdf,0xdf,
		0x20,0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdb,0x20,0x20, 0x20,0xdf,0xdf,0xdb,0xdf,0xdf,
		0x20,0x20,0x20,0xdf,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0xdf,0x20,
		0x20,0xdb,0xdc,0xdc,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20  // space
		};


const char fnt_6x10[] = {
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0x20,0xdb,
		0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 0
		0x20,0x20,0x20,0xdc,0x20,0x20, 0x20,0x20,0xdf,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0x20,0x20,
		0x20,0x20,0x20,0xdb,0x20,0x20, 0x20,0x20,0xdc,0xdb,0xdc,0x20,  // 1
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0x20,0xdb, 0x20,0x20,0x20,0x20,0xdc,0xdf,
		0x20,0x20,0xdc,0xdf,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdf,0x20,0x20,0x20,0xdb, 0x20,0x20,0xdc,0xdc,0xdc,0xdf,
		0x20,0x20,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 3
		0x20,0xdc,0x20,0x20,0x20,0xdc, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0x20,0xdb,
		0x20,0xdf,0xdf,0xdf,0xdf,0xdb, 0x20,0x20,0x20,0x20,0x20,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20,0x20, 0x20,0xdf,0xdf,0xdf,0xdf,0xdc,
		0x20,0x20,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0xdc,0x20, 0x20,0xdc,0xdf,0x20,0x20,0x20, 0x20,0xdb,0xdf,0xdf,0xdf,0xdc,
		0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdf,0x20,0x20,0x20,0xdb, 0x20,0x20,0x20,0x20,0xdc,0xdf,
		0x20,0x20,0x20,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,
		0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdf,0xdc,0xdc,0xdc,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0x20,0x20,0x20,0xdb, 0x20,0xdb,0x20,0x20,0x20,0xdb,
		0x20,0x20,0xdf,0xdf,0xdf,0xdb, 0x20,0x20,0xdc,0xdc,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0xdc,0xdc,0xdc,0xdc,0xdc,
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdc,0x20,0x20, 0x20,0xdc,0xdc,0xdb,0xdc,0xdc,
		0x20,0x20,0x20,0xdb,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdb,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0x20,0x20,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0xdc,0x20,
		0x20,0xdb,0x20,0x20,0x20,0x20, 0x20,0xdb,0xdc,0xdc,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20   // space
		};


const char fnt_7x10[] = {
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf,  // 0
		0x20,0x20,0x20,0xdc,0xdc,0x20,0x20, 0x20,0xdc,0xdb,0xdb,0xdb,0x20,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0xdb,0x20,0x20,
		0x20,0xdc,0xdc,0xdb,0xdb,0xdc,0xdc,  // 1
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0xdc,0xdb,0xdf, 0x20,0x20,0xdc,0xdb,0xdf,0x20,0x20,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0xdc,  // 2
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0x20,0x20,0xdc,0xdc,0xdb,0xdf, 0x20,0xdc,0xdc,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf,  // 3
		0x20,0xdc,0xdc,0x20,0x20,0xdc,0xdc, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdf,0xdf,0xdf,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0x20,0xdb,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdb,0x20,0x20,0x20,0x20,
		0x20,0xdf,0xdf,0xdf,0xdf,0xdb,0xdc, 0x20,0x20,0x20,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdc,0xdb,0xdf,0x20,0x20,0x20,
		0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdc, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdf,0xdf,0x20,0x20,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0xdc,0xdb,0xdb, 0x20,0x20,0x20,0xdb,0xdb,0xdf,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0x20,0xdf,0xdf,0xdf,0xdb,0xdb,
		0x20,0x20,0xdc,0xdc,0xdb,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdf,0xdf,0xdf,0xdf,0xdf,0xdf,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdc,0xdc,0x20,0x20,
		0x20,0xdc,0xdc,0xdb,0xdb,0xdc,0xdc, 0x20,0xdf,0xdf,0xdb,0xdb,0xdf,0xdf,
		0x20,0x20,0x20,0xdf,0xdf,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0xdb,0xdb,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdb,0x20,0x20,0x20,0x20,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0x20,0x20,0x20,0x20,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0xdc,  // E
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20  // space
		};


const char fnt_7x12[] = {
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0xdc,0xdb,0xdb, 0x20,0xdb,0xdb,0xdb,0xdf,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdf,  // 0
		0x20,0x20,0x20,0xdc,0xdc,0x20,0x20, 0x20,0xdc,0xdb,0xdb,0xdb,0x20,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0xdb,0x20,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,  // 1
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0x20,0xdb,0xdb, 0x20,0x20,0x20,0xdc,0xdb,0xdf,0x20,
		0x20,0xdc,0xdb,0xdf,0x20,0x20,0x20, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,  // 2
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0x20,0x20,0xdc,0xdc,0xdb,0xdf, 0x20,0x20,0x20,0xdf,0xdf,0xdb,0xdc,
		0x20,0xdc,0xdc,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdf,  // 3
		0x20,0xdc,0xdc,0x20,0x20,0xdc,0xdc, 0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0x20,0xdb,0xdb, 0x20,0x20,0x20,0x20,0x20,0xdb,0xdb,  // 4
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdb,0xdf,0xdf,0xdf,0xdf,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0x20, 0x20,0xdf,0xdf,0xdf,0xdf,0xdb,0xdb,
		0x20,0xdc,0xdc,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdf,  // 5
		0x20,0x20,0x20,0xdc,0xdc,0xdc,0x20, 0x20,0xdc,0xdb,0xdb,0xdf,0xdf,0x20,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdf,  // 6
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdf,0xdf,0xdf,0xdf,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0xdc,0xdb,0xdb, 0x20,0x20,0x20,0xdb,0xdb,0xdf,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0x20,0x20,0xdb,0xdb,0x20,0x20,  // 7
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0xdf,0xdb,0xdc,0xdc,0xdb,0xdf, 0x20,0xdc,0xdb,0xdf,0xdf,0xdb,0xdc,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdf,  // 8
		0x20,0x20,0xdc,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdb,0xdb,
		0x20,0xdb,0xdb,0x20,0x20,0xdb,0xdb, 0x20,0xdf,0xdb,0xdb,0xdb,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0xdc,0xdb,0xdb, 0x20,0x20,0xdb,0xdb,0xdb,0xdf,0x20,  // 9
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,  // -
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,
		0x20,0x20,0x20,0xdb,0xdb,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,  // +
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0xdb,0xdb,0x20,0x20,  // .
		0x20,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc, 0x20,0xdb,0xdb,0xdf,0xdf,0xdf,0xdf,
		0x20,0xdb,0xdb,0xdc,0xdc,0xdc,0x20, 0x20,0xdb,0xdb,0xdf,0xdf,0xdf,0x20,
		0x20,0xdb,0xdb,0x20,0x20,0x20,0x20, 0x20,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,  // E
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,
		0x20,0x20,0x20,0x20,0x20,0x20,0x20, 0x20,0x20,0x20,0x20,0x20,0x20,0x20,  // space
		};


char tBoolUp[256];
int16_t cntBool = 0;


void outputBoldPrint(uint8_t *str, uint8_t type)
{
		switch(type)
		{
		case 0: paintStrFnt_4x6(str);  break;
		case 1: paintStrFnt_4x8(str);  break;
		case 2: paintStrFnt_5x8(str);  break;
		case 3: paintStrFnt_5x10(str); break;
		case 4: paintStrFnt_6x8(str);  break;
		case 5: paintStrFnt_6x10(str); break;
		case 6: paintStrFnt_7x10(str); break;
		case 7: paintStrFnt_7x12(str); break;
		default : break;
		}
}


void printStrBool(uint8_t* str, uint32_t y, uint32_t x)
{
	uint16_t len = strnlen((char*)str,80), i;
	move(y, x);

	if((sizeWindowAxisX - xGrid[NumberWindows] - len) <= 0)
	{
		len = sizeWindowAxisX - xGrid[NumberWindows];
	}

	if(sizeWindowAxisY - yGrid[NumberWindows] <= 0)
	{
		return;
	}

	for(i = 0; i < len; i++)
	{
		SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = str[i];
		SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
		SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];

		if(NumberWindows == ExecWindows)
		{
			addch(str[i]);
		}

		xGrid[NumberWindows] ++;
	}
}


void limitBool(uint32_t y, uint32_t x, uint32_t len, uint32_t size)
{
	if(sizeWindowAxisY - y <= 0)
	{
		yGrid[NumberWindows] = sizeWindowAxisY;
	}
	else
		{
			yGrid[NumberWindows] = y;
		}

	if(x + len * size > sizeWindowAxisX)
	{
	xGrid[NumberWindows] = 80;
	}
	else
		{
		xGrid[NumberWindows] = x + len * size;
		}
		move(yGrid[NumberWindows], xGrid[NumberWindows]);
}


void paintChFnt_4x6(uint8_t ch, int16_t offset)
{
   uint16_t i;

	for(i = 0; i < 4; i++)
	{
		   switch(fnt_4x6[ch*12 + offset*4 + i])
		   {
		   case ' ': tBoolUp[cntBool + i] = ' '; break;

		   case '': tBoolUp[cntBool + i] = ''; break;

		   case '': tBoolUp[cntBool + i] = ''; break;

		   case '': tBoolUp[cntBool + i] = ''; break;

		   default : break;
		   }
	}

	cntBool += 4;
}


void paintStrFnt_4x6(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 3; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_4x6(0, cnt); break;
				case '1': paintChFnt_4x6(1, cnt); break;
				case '2': paintChFnt_4x6(2, cnt); break;
				case '3': paintChFnt_4x6(3, cnt); break;
				case '4': paintChFnt_4x6(4, cnt); break;
				case '5': paintChFnt_4x6(5, cnt); break;
				case '6': paintChFnt_4x6(6, cnt); break;
				case '7': paintChFnt_4x6(7, cnt); break;
				case '8': paintChFnt_4x6(8, cnt); break;
				case '9': paintChFnt_4x6(9, cnt); break;
				case '-': paintChFnt_4x6(10, cnt); break;
				case '+': paintChFnt_4x6(11, cnt); break;
				case '.': paintChFnt_4x6(12, cnt); break;
				case 'E': paintChFnt_4x6(13, cnt); break;
				default : paintChFnt_4x6(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 4);
}


void paintChFnt_4x8(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 4; i++)
		{
			   switch(fnt_4x8[ch*16 + offset*4 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 4;
}


void paintStrFnt_4x8(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 4; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_4x8(0, cnt); break;
				case '1': paintChFnt_4x8(1, cnt); break;
				case '2': paintChFnt_4x8(2, cnt); break;
				case '3': paintChFnt_4x8(3, cnt); break;
				case '4': paintChFnt_4x8(4, cnt); break;
				case '5': paintChFnt_4x8(5, cnt); break;
				case '6': paintChFnt_4x8(6, cnt); break;
				case '7': paintChFnt_4x8(7, cnt); break;
				case '8': paintChFnt_4x8(8, cnt); break;
				case '9': paintChFnt_4x8(9, cnt); break;
				case '-': paintChFnt_4x8(10, cnt); break;
				case '+': paintChFnt_4x8(11, cnt); break;
				case '.': paintChFnt_4x8(12, cnt); break;
				case 'E': paintChFnt_4x8(13, cnt); break;
				default : paintChFnt_4x8(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;

	}

	limitBool(Y, X, len, 4);
}


void paintChFnt_5x8(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 5; i++)
		{
			   switch(fnt_5x8[ch*20 + offset*5 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 5;
}


void paintStrFnt_5x8(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 4; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_5x8(0, cnt); break;
				case '1': paintChFnt_5x8(1, cnt); break;
				case '2': paintChFnt_5x8(2, cnt); break;
				case '3': paintChFnt_5x8(3, cnt); break;
				case '4': paintChFnt_5x8(4, cnt); break;
				case '5': paintChFnt_5x8(5, cnt); break;
				case '6': paintChFnt_5x8(6, cnt); break;
				case '7': paintChFnt_5x8(7, cnt); break;
				case '8': paintChFnt_5x8(8, cnt); break;
				case '9': paintChFnt_5x8(9, cnt); break;
				case '-': paintChFnt_5x8(10, cnt); break;
				case '+': paintChFnt_5x8(11, cnt); break;
				case '.': paintChFnt_5x8(12, cnt); break;
				case 'E': paintChFnt_5x8(13, cnt); break;
				default : paintChFnt_5x8(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 5);
}


void paintChFnt_5x10(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 5; i++)
		{
			   switch(fnt_5x10[ch*25 + offset*5 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;
			   default : break;
			   }
		}

		cntBool += 5;
}


void paintStrFnt_5x10(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 5; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_5x10(0, cnt); break;
				case '1': paintChFnt_5x10(1, cnt); break;
				case '2': paintChFnt_5x10(2, cnt); break;
				case '3': paintChFnt_5x10(3, cnt); break;
				case '4': paintChFnt_5x10(4, cnt); break;
				case '5': paintChFnt_5x10(5, cnt); break;
				case '6': paintChFnt_5x10(6, cnt); break;
				case '7': paintChFnt_5x10(7, cnt); break;
				case '8': paintChFnt_5x10(8, cnt); break;
				case '9': paintChFnt_5x10(9, cnt); break;
				case '-': paintChFnt_5x10(10, cnt); break;
				case '+': paintChFnt_5x10(11, cnt); break;
				case '.': paintChFnt_5x10(12, cnt); break;
				case 'E': paintChFnt_5x10(13, cnt); break;
				default : paintChFnt_5x10(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 5);
}


void paintChFnt_6x8(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 6; i++)
		{
			   switch(fnt_6x8[ch*24 + offset*6 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 6;
}


void paintStrFnt_6x8(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 4; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_6x8(0, cnt); break;
				case '1': paintChFnt_6x8(1, cnt); break;
				case '2': paintChFnt_6x8(2, cnt); break;
				case '3': paintChFnt_6x8(3, cnt); break;
				case '4': paintChFnt_6x8(4, cnt); break;
				case '5': paintChFnt_6x8(5, cnt); break;
				case '6': paintChFnt_6x8(6, cnt); break;
				case '7': paintChFnt_6x8(7, cnt); break;
				case '8': paintChFnt_6x8(8, cnt); break;
				case '9': paintChFnt_6x8(9, cnt); break;
				case '-': paintChFnt_6x8(10, cnt); break;
				case '+': paintChFnt_6x8(11, cnt); break;
				case '.': paintChFnt_6x8(12, cnt); break;
				case 'E': paintChFnt_6x8(13, cnt); break;
				default : paintChFnt_6x8(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 6);
}


void paintChFnt_6x10(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 6; i++)
		{
			   switch(fnt_6x10[ch*30 + offset*6 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 6;
}


void paintStrFnt_6x10(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 5; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_6x10(0, cnt); break;
				case '1': paintChFnt_6x10(1, cnt); break;
				case '2': paintChFnt_6x10(2, cnt); break;
				case '3': paintChFnt_6x10(3, cnt); break;
				case '4': paintChFnt_6x10(4, cnt); break;
				case '5': paintChFnt_6x10(5, cnt); break;
				case '6': paintChFnt_6x10(6, cnt); break;
				case '7': paintChFnt_6x10(7, cnt); break;
				case '8': paintChFnt_6x10(8, cnt); break;
				case '9': paintChFnt_6x10(9, cnt); break;
				case '-': paintChFnt_6x10(10, cnt); break;
				case '+': paintChFnt_6x10(11, cnt); break;
				case '.': paintChFnt_6x10(12, cnt); break;
				case 'E': paintChFnt_6x10(13, cnt); break;
				default : paintChFnt_6x10(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 6);
}


void paintChFnt_7x10(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 7; i++)
		{
			   switch(fnt_7x10[ch*35 + offset*7 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 7;
}


void paintStrFnt_7x10(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 5; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_7x10(0, cnt); break;
				case '1': paintChFnt_7x10(1, cnt); break;
				case '2': paintChFnt_7x10(2, cnt); break;
				case '3': paintChFnt_7x10(3, cnt); break;
				case '4': paintChFnt_7x10(4, cnt); break;
				case '5': paintChFnt_7x10(5, cnt); break;
				case '6': paintChFnt_7x10(6, cnt); break;
				case '7': paintChFnt_7x10(7, cnt); break;
				case '8': paintChFnt_7x10(8, cnt); break;
				case '9': paintChFnt_7x10(9, cnt); break;
				case '-': paintChFnt_7x10(10, cnt); break;
				case '+': paintChFnt_7x10(11, cnt); break;
				case '.': paintChFnt_7x10(12, cnt); break;
				case 'E': paintChFnt_7x10(13, cnt); break;
				default : paintChFnt_7x10(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 7);
}


void paintChFnt_7x12(uint8_t ch, int16_t offset)
{
	   uint16_t i;

		for(i = 0; i < 7; i++)
		{
			   switch(fnt_7x12[ch*42 + offset*7 + i])
			   {
			   case ' ': tBoolUp[cntBool + i] = ' '; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   case '': tBoolUp[cntBool + i] = ''; break;

			   default : break;
			   }
		}

		cntBool += 7;
}


void paintStrFnt_7x12(uint8_t *str)
{
	int16_t cnt, i;
	uint32_t X = xGrid[NumberWindows], Y = yGrid[NumberWindows];
	int32_t len = strnlen((char*)str, 80);

	for(cnt = 0; cnt < 6; cnt++)
	{
		memset(tBoolUp, 0, sizeof(tBoolUp));
		cntBool = 0;

			for(i = 0; i < len; i++)
			{
				switch(str[i])
				{
				case '0': paintChFnt_7x12(0, cnt); break;
				case '1': paintChFnt_7x12(1, cnt); break;
				case '2': paintChFnt_7x12(2, cnt); break;
				case '3': paintChFnt_7x12(3, cnt); break;
				case '4': paintChFnt_7x12(4, cnt); break;
				case '5': paintChFnt_7x12(5, cnt); break;
				case '6': paintChFnt_7x12(6, cnt); break;
				case '7': paintChFnt_7x12(7, cnt); break;
				case '8': paintChFnt_7x12(8, cnt); break;
				case '9': paintChFnt_7x12(9, cnt); break;
				case '-': paintChFnt_7x12(10, cnt); break;
				case '+': paintChFnt_7x12(11, cnt); break;
				case '.': paintChFnt_7x12(12, cnt); break;
				case 'E': paintChFnt_7x12(13, cnt); break;
				default : paintChFnt_7x12(14, cnt); break;
				}
			}

			printStrBool((uint8_t*)tBoolUp, yGrid[NumberWindows], xGrid[NumberWindows]);
			yGrid[NumberWindows] ++;
			xGrid[NumberWindows] = X;
	}

	limitBool(Y, X, len, 7);
}
