#include "byte_code.h"
#include "SysVar.h"
#include <stdlib.h>

void END(void)  //   
{
	ByteCode = ByteCode >> 8;
}

void RUN(void)  // 㦠    
{
	ByteCode = ByteCode >> 8;

	uint16_t step = 0, timeout = 0, attribute = 0, numberTasks = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		attribute = popMcalcI(&MCALC);
	}
	else{
		attribute = (int16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		timeout = popMcalcI(&MCALC);
	}
	else{
		timeout = (int16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		step = popMcalcI(&MCALC);
	}
	else{
		step = (int16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		numberTasks = popMcalcI(&MCALC);
	}
	else{
		numberTasks = (int16_t)roundf(popMcalcF(&MCALC));
	}

	if( numberTasks <= NumberTasks && Manager.task[numberTasks].ptr != 0)
	{
		Manager.task[numberTasks].step       = step;
		Manager.task[numberTasks].timeout    = timeout;
		if(attribute != 0)
		{
			Manager.task[numberTasks].counterRun ++;
		}
	}

}

void STOP(void) // ⮯ ணࠬ
{
	ByteCode = ByteCode >> 8;

	int16_t numberTasks;

	if(popHiMcalc(&MCALC) == 0xffff){
		numberTasks = popMcalcI(&MCALC);
	}
	else{
		numberTasks = (int16_t)roundf(popMcalcF(&MCALC));
	}

	Manager.task[numberTasks].step = 0;
	Manager.task[numberTasks].counterRun = 0;
}

void ESC(void)  // ⠭  믮
{
	//ByteCode = ByteCode >> 8;

	startFileSystem();
}

void NEWS(void) // 祭   ப
{
	ByteCode = ByteCode >> 8;

	LineNum = ByteCode & 0xffffff;

    ByteCode = ByteCode >> 24;
}


void EDIT(void) // 室  ० ।஢
{
	//ByteCode = ByteCode >> 8;

	startFileSystem();
}


void ADD(void)  // ᫮ ᥫ  ⮮। ଠ
{
      ByteCode = ByteCode >> 8; // 믮   ᤥ ᬥ饭

      float Af = 0.0, Bf = 0.0, res = 0.0;

  	  if(popHiMcalc(&MCALC) == 0xffff){
  		Bf = (float)popMcalcI(&MCALC);
  	  }
  	  else{
  		Bf = popMcalcF(&MCALC);
  	  }

  	  if(popHiMcalc(&MCALC) == 0xffff){
  		Af = (float)popMcalcI(&MCALC);
  	  }
  	  else{
  		Af = popMcalcF(&MCALC);
  	  }

  	   res = Af + Bf;

  	  pushMcalcF(&MCALC,res);
}


void ADDI(void) // ᫮ 楫 ᥫ
{

}


void ADDF(void) // ᫮ ⢥ ᥫ
{

}


void SUB(void)  // ⠭ ᥫ  ⮮। ଠ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Bf = popMcalcF(&MCALC);
	  }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	  res = Af - Bf;

	  pushMcalcF(&MCALC,res);
}


void SUBI(void) // ⠭ 楫 ᥫ
{

}


void SUBF(void) // ⠭ ⢥ ᥫ
{

}


void MUL(void)  // 㬭  ⮯। ଠ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Bf = popMcalcF(&MCALC);
	  }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	   res = Af * Bf;

	  // if(isnanf(res)){
		// res = 0.0;
	  // }

	  pushMcalcF(&MCALC,res);
}


void MULI(void) // 㬭 楫 ᥫ
{

}


void MULF(void) // 㬭 ⢥ ᥫ
{

}


void DIV(void)  //  ᥫ  ⮮। ଠ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
	}
	else{
		Bf = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)popMcalcI(&MCALC);
	}
	else{
		Af = popMcalcF(&MCALC);
	}

	if(Bf != 0){
	res = Af/Bf;
	}
	else{
	res = 0;
	}

	pushMcalcF(&MCALC,res);
}


void DIVI(void) //   
{

}


void DIVF(void) //  ⢥ ᥫ
{

}


void DIVM(void) //   
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
	}
	else{
		Bf = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)popMcalcI(&MCALC);
	}
	else{
		Af = popMcalcF(&MCALC);
	}

	res = fmodf(Af,Bf);

	/*if(isnanf(res)){
	res = 0.0;
	}
	if(finitef(res)){
	res = FLT_MAX;
	}*/
    pushMcalcF(&MCALC,res);
}


void SQR(void)  // ⨥ ⭮ 
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)popMcalcI(&MCALC);
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	if(Af <= 0.0)
	{
		Af = 0.0;
	}

	res = sqrtf(Af);

	pushMcalcF(&MCALC,res);
}


void POW(void)  //   ⥯
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Bf = (float)popMcalcI(&MCALC);
	}
	else{
	Bf = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)popMcalcI(&MCALC);
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	res = powf(Af,Bf);

	/*if(isinff(res)){
	res = FLT_MAX;
	}*/

	pushMcalcF(&MCALC,res);
}


void LOG(void)  //  筮 䬠
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
		Af = popMcalcF(&MCALC);
     }

	if(Af > 0.0)
	{
		res = log10f(Af);
	}

	pushMcalcF(&MCALC,res);
}


void LN(void)   //  ࠫ쭮 䬠
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	 }
	else{
		Af = popMcalcF(&MCALC);
	 }

	if(Af > 0.0)
	{
	   res = logf(Af);
	}
	pushMcalcF(&MCALC,res);
}


void SIN(void)  //  ᨭ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
		Af = popMcalcF(&MCALC);
	}

    res = sinf(Af);

	pushMcalcF(&MCALC,res);
}


void COS(void)  //  ᨭ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	 res = cosf(Af);

	 pushMcalcF(&MCALC,res);
}


void TAN(void)  // ⠭ 㣫
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	//if(cosf(Af) != 0)
	//{
	res = tanf(Af);
	//}

	pushMcalcF(&MCALC,res);
}


void ASIN(void) // ᨭ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
		Af = popMcalcF(&MCALC);
	}

	res = asinf(Af);

	pushMcalcF(&MCALC,res);
}


void ACOS(void) // પᨭ
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	   res = acosf(Af);

	   /*if(isnanf(res)){
		 res = 0.0;
	   }
	   if(finitef(res)){
		 res = FLT_MAX;
	   }*/

	  pushMcalcF(&MCALC,res);
}


void ATAN(void) // ⠭
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	  Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
	  Af = popMcalcF(&MCALC);
	}

	res = atanf(Af);

	if(isnanf(res)){
		 res = 0.0;
	}
    if(finitef(res)){
		 res = FLT_MAX;
	}

	  pushMcalcF(&MCALC,res);
}


void ABS(void)  //  ᫠  ⮮।
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	   res = fabsf(Af);

	  /* if(isnanf(res)){
		 res = 0.0;
	   }
	   if(finitef(res)){
		 res = FLT_MAX;
	   }*/

	  pushMcalcF(&MCALC,res);
}


void ABSI(void) //  楫 ᫠
{
}


void ABSF(void) //  ⢥ ᫠
{
}


void FIX(void)  // ஡  ⢥ ᫠
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0, b = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)roundf(popMcalcI(&MCALC));
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	res = modf(Af,(double*)&b);

	/*if(isnanf(res)){
		 res = 0.0;
	}
	if(finitef(res)){
	res = FLT_MAX;
	}*/

	pushMcalcF(&MCALC,res);
}


void SIGN(void) // ⨥  ⢥ ᫠
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)roundf(popMcalcI(&MCALC));
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	  if(Af > 0)
	  {
		res = 1.0;
	  }
	  if(Af == 0.0)
	  {
		res = 0.0;
	  }
	  if(Af < 0)
	  {
	   res = -1.0;
	  }

	  pushMcalcF(&MCALC, res);
}


void RND(void)
{
	ByteCode = ByteCode >> 8;

	float cc1 = 0.0, rnd = 0.0;
	float If = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		If = (float)popMcalcI(&MCALC);
	}
	else{
		If = popMcalcF(&MCALC);
	}

	if(If < 0)
	{
		initRNG();
	}

	if(If > 0)
	{
		if(If > 10){If = 10;}
		SysMem.RNDVAL = If;
	}

	rnd = modff(pow((SysMem.RNDVAL + M_PI),5),&cc1);

	SysMem.RNDVAL = rnd;

	pushMcalcF(&MCALC, rnd);
}


void SCL(void)  // 㭪 ⠡஢ ⮮।
{
	ByteCode = ByteCode >> 8;

      float Af = 0.0, Bf = 0.0, Cf = 0.0, Df = 0.0, Xf = 0.0, res = 0.0;

	  if(popHiMcalc(&MCALC) == 0xffff){
		Df = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Df = popMcalcF(&MCALC);
	   }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Cf = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Cf = popMcalcF(&MCALC);
	   }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Bf = popMcalcF(&MCALC);
	   }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Af = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Af = popMcalcF(&MCALC);
	   }

	  if(popHiMcalc(&MCALC) == 0xffff){
		Xf = (float)popMcalcI(&MCALC);
	  	}
	  else{
		Xf = popMcalcF(&MCALC);
	   }

	  res = (Xf-Af)*(Df-Cf)/(Bf-Af) + Cf;

	  if(res > Df){
		  res = Df;
	  }

	  if(res < Cf){
		  res = Cf;
	  }

	  pushMcalcF(&MCALC,res);
}


void TOI(void)  // ਮࠧ ᫠  楫 ଠ
{
	ByteCode = ByteCode >> 8;

	int16_t Ai = 0, Af = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Ai = popMcalcI(&MCALC);
	}
	else
		{
		Af = popMcalcF(&MCALC);
		if(Af > 32767)
		{
			Af = 32767;
		}
		else
		{
			if(Af < -32767)
			{
				Af = -32767;
			}
		}
			Ai = (int16_t)roundf(Af);
		}
	pushMcalcI(&MCALC, Ai);
}


void TOF(void)  // ਮࠧ ᫠  ⢥ ଠ
{
	ByteCode = ByteCode >> 8;

	float Af = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)popMcalcI(&MCALC);
	}
	else{
	Af = popMcalcF(&MCALC);
	}
	pushMcalcF(&MCALC,Af);
}


void SWAP(void) //  ⠬ x  y  
{
	ByteCode = ByteCode >> 8;

    float Af = 0.0, Bf = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Bf = (float)popMcalcI(&MCALC);
	}
	else{
	Bf = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)popMcalcI(&MCALC);
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	pushMcalcF(&MCALC,Af);
	pushMcalcF(&MCALC,Bf);
}


void FIXI(void) // ᥭ 楫᫥ ⠭  
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;

    var = ByteCode & 0xffff;

	pushMcalcI(&MCALC,var);

	ByteCode = ByteCode >> 16;
}


void FIXF(void) // ᥭ ⢥ ⠭  
{
	ByteCode = ByteCode >> 8;

	pushMcalcF(&MCALC,calcAddrVarF(ByteCode));

	ByteCode = ByteCode >> 24;
}


void SET0(void) // ᥭ ⢥   
{
	ByteCode = ByteCode >> 8;

	pushMcalcF(&MCALC,0.0);
}


void SET1(void) // ᥭ ⢥   
{
	ByteCode = ByteCode >> 8;

	pushMcalcF(&MCALC,1.0);
}


void SET2(void) // ᥭ ⢥ ᫠ 2  
{
	ByteCode = ByteCode >> 8;

	pushMcalcF(&MCALC,2.0);
}


void EQU(void)  // ࠢ ᥫ. ⨭ ᫨ ࠢ x = y
{
	ByteCode = ByteCode >> 8;

	float x = 0.0, y = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		y = (float)popMcalcI(&MCALC);
	}
	 else{
	    y = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   x = (float)popMcalcI(&MCALC);
	}
	else{
	   x = popMcalcF(&MCALC);
	}

	if(x == y){
	res = 1; // ⨭
	}
	else{
	res = 0; // 
	}

	pushMcalcI(&MCALC,res);
}


void NEQU(void) // ࠢ ᥫ. ⨭ ᫨  ࠢ
{
	ByteCode = ByteCode >> 8;

	float Af = 0.0, Bf = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Bf = (float)popMcalcI(&MCALC);
		}
	 else{
		Bf = popMcalcF(&MCALC);
		}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Af = (float)popMcalcI(&MCALC);
	   }
	else{
	   Af = popMcalcF(&MCALC);
	}


	if(Af != Bf){
	res = 1;
	}
	else{
	res = 0;
	}

	pushMcalcI(&MCALC,res);
}


void MORE(void) // ࠢ ᥫ. ⨭ ᫨ y  
{
	ByteCode = ByteCode >> 8;

	float x = 0.0, y = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		y = (float)popMcalcI(&MCALC);
	}
	 else{
		y = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   x = (float)popMcalcI(&MCALC);
	}
	else{
	   x = popMcalcF(&MCALC);
	}

	if(x > y){
	res = 1; // ⨭
	}
	else{
	res = 0; // 
	}

	pushMcalcI(&MCALC,res);
}


void LESS(void) // ࠢ ᥫ. ⨭ ᫨ y  
{
	ByteCode = ByteCode >> 8;

	float x = 0.0, y = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		y = (float)popMcalcI(&MCALC);
	}
	 else{
		y = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   x = (float)popMcalcI(&MCALC);
	}
	else{
	   x = popMcalcF(&MCALC);
	}

	if(y > x){
	res = 1;
	}
	else{
	res = 0;
	}

	pushMcalcI(&MCALC,res);
}


void MRE(void)  // ࠢ ᥫ. ⨭ ᫨ y   ࠢ 
{
	ByteCode = ByteCode >> 8;

	float x = 0.0, y = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		y = (float)popMcalcI(&MCALC);
	}
	 else{
		y = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   x = (float)popMcalcI(&MCALC);
	}
	else{
	   x = popMcalcF(&MCALC);
	}

	if(x >= y){
	res = 1;
	}
	else{
	res = 0;
	}

	pushMcalcI(&MCALC,res);
}


void LSE(void)  // ࠢ ᥫ. ⨭ ᫨ y   ࠢ 
{
	ByteCode = ByteCode >> 8;

	float x = 0.0, y = 0.0;
	int16_t	res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		y = (float)popMcalcI(&MCALC);
	}
	 else{
		y = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   x = (float)popMcalcI(&MCALC);
	}
	else{
	   x = popMcalcF(&MCALC);
	}

	if(x <= y){
	res = 1;
	}
	else{
	res = 0;
	}

	pushMcalcI(&MCALC,res);
}


void NOT(void)  // ᪠ 
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = popMcalcI(&MCALC);
	   }
	else{
	   Ai = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	res = ~Ai;

	pushMcalcI(&MCALC,res);
}


void AND(void)  // ᪮ 
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = popMcalcI(&MCALC);
	}
	else{
	   Bi = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = popMcalcI(&MCALC);
	}
	else{
	   Ai = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	res = Ai & Bi;

	pushMcalcI(&MCALC, res);
}


void ORL(void)  // ᪮ 
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = popMcalcI(&MCALC);
	   }
	else{
	   Bi = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = popMcalcI(&MCALC);
	   }
	else{
	   Ai = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	res = Ai | Bi;

	pushMcalcI(&MCALC,res);
}


void XOR(void)  // ᪠ 㬬   
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = (uint16_t)popMcalcI(&MCALC);
	   }
	else{
	   Bi = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = (uint16_t)popMcalcI(&MCALC);
	   }
	else{
	   Ai = popMcalcF(&MCALC);
	}

	res = Ai ^ Bi;

	pushMcalcI(&MCALC,res);
}


void EQV(void)  // ᪮ ⮢ ࠢ
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = (uint16_t)popMcalcI(&MCALC);
	   }
	else{
	   Bi = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = (uint16_t)popMcalcI(&MCALC);
	   }
	else{
	   Ai = popMcalcF(&MCALC);
	}

	res = ~(Ai ^ Bi);

	pushMcalcI(&MCALC,res);
}


void RLX(void)  // ᤢ 
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = (uint16_t)popMcalcI(&MCALC);
	}
	else{
	   Bi = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = (uint16_t)popMcalcI(&MCALC);
	}
	else{
	   Ai = popMcalcF(&MCALC);
	}

	res = Ai << Bi;

	pushMcalcI(&MCALC,res);
}


void RRX(void)  // ᤢ ࠢ
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0, Bi = 0, res = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
	   Bi = (uint16_t)popMcalcI(&MCALC);
	}
	else{
	   Bi = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	   Ai = (uint16_t)popMcalcI(&MCALC);
	}
	else{
	   Ai = popMcalcF(&MCALC);
	}

	res = Ai >> Bi;

	pushMcalcI(&MCALC,res);
}


void RVI(void)
{
	ByteCode = ByteCode >> 8;

	pushMcalcI(&MCALC,(uint16_t)calcAddrVarI(ByteCode));

	ByteCode = ByteCode >> 24;
}


void WVI(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t Ai = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Ai = popMcalcI(&MCALC);
	}
	else{
		Ai = (int16_t)popMcalcF(&MCALC);
	}

	SetCalcAddrVarI(ByteCode, Ai);

	ByteCode = ByteCode >> 24;
}


void RDN(void)  // ᥭ  ⥬᪨    ᨢ data
{
	ByteCode = ByteCode >> 8;

	typeDigit.i = *(uint32_t*)(BinFileHead->DataDNV_adr + AddressBeginByteCode + SysMem.DATA_PNT);

	if(typeDigit.UintP.hi == 0xffff){ // int ᫮
	pushMcalcI(&MCALC,typeDigit.i);
	}
	else{

	if(typeDigit.FloatP.exponent == 0xff){ // 
	pushMcalcAddr(&MCALC,typeDigit.FloatP.mantissa);
	}
	else{
	pushMcalcF(&MCALC,typeDigit.f);
	}

	}

	SysMem.DATA_PNT = SysMem.DATA_PNT + 4;
}


void RDS(void)  // ᥭ  ப  ப  ᨢ
{
	ByteCode = ByteCode >> 8;

	typeDigit.i = *(uint32_t*)(BinFileHead->DataDNV_adr + AddressBeginByteCode + SysMem.DATA_PNT);

	char text[256];
	memset(text,0,sizeof(0));

	if(typeDigit.UintP.hi == 0xffff){ // int ᫮
		pushStrCalc(&StrCalc,text);
	}
	else{

	if(typeDigit.FloatP.exponent == 0xff){ // 
		getCalcAddrStr(typeDigit.FloatP.mantissa,text);
		pushStrCalc(&StrCalc,text);
	}
	else{
		pushStrCalc(&StrCalc,text);
	}

	}

	SysMem.DATA_PNT = SysMem.DATA_PNT + 4;
}


void REST(void) //  冷 ⥭  ᨢ DATA
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0, i = 0;

	uint16_t ai = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		ai = popMcalcI(&MCALC);
	}
	else{
		ai = roundf(popMcalcF(&MCALC));
	}

	for(i = 0; i < BinFileHead->DataSTR_len * 8; i +=8){

	var = *(uint32_t*)(BinFileHead->DataSTR_adr + AddressBeginByteCode + i);

	if(var >= ai){
		RESTORE  = *(uint32_t*)(BinFileHead->DataSTR_adr + AddressBeginByteCode + i + 4);
		SysMem.DATA_PNT = RESTORE;
		return;
	}
	}

	RESTORE = 0;

	SysMem.DATA_PNT = RESTORE;
}


void RVF(void) //ᥭ   ᮤন ६ float
{
	ByteCode = ByteCode >> 8;

	pushMcalcF(&MCALC,calcAddrVarF(ByteCode));

	ByteCode = ByteCode >> 24;
}


void WVF(void)
{
	ByteCode = ByteCode >> 8;

	float Af = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
	Af = (float)popMcalcI(&MCALC);
	}
	else{
	Af = popMcalcF(&MCALC);
	}

	SetCalcAddrVarF(ByteCode,Af);

	ByteCode = ByteCode >> 24;
}


void READ(void) // ᥭ   ⠭  ᨢ DATA
{
	ByteCode = ByteCode >> 8;
}


void MIR(void)  // ᥭ   ᮤন 祩 ᨢ  楫 ᥫ INT16
{
	ByteCode = ByteCode >> 8;

	uint32_t selectingArray = 0, adr = 0;

	selectingArray = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	adr = adressDimData(selectingArray);

    adr =  adr & 0x7fffff;

    typeDigit.i = calcAddrVarI(adr);

	pushMcalcI(&MCALC,typeDigit.UintP.lo);
}


void MIW(void)  // ᥭ  祩 ᨢ  楫 ᥫ INT16 ᮤন 
{
	ByteCode = ByteCode >> 8;

	uint32_t selectingArray = 0, adr = 0, var = 0;

	selectingArray = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	adr = adressDimData(selectingArray);

    adr =  adr & 0x7fffff;

	if(popHiMcalc(&MCALC) == 0xffff){
	var = popMcalcI(&MCALC);
	}
	else{
	var = (uint16_t)roundf(popMcalcF(&MCALC));
	}

    SetCalcAddrVarI(adr, var);
}


void MFR(void)  // ᥭ   ᮤন 祩 ᨢ  ⢥ ᥫ
{
	ByteCode = ByteCode >> 8;

	uint32_t selectingArray = 0, adr = 0;

	selectingArray = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	adr = adressDimData(selectingArray);

    adr =  adr & 0x7fffff;

    typeDigit.f =  calcAddrVarF(adr);

    if(typeDigit.UintP.hi == 0xffff){
	pushMcalcF(&MCALC,(float)typeDigit.UintP.lo);
    }
    else{
     pushMcalcF(&MCALC,typeDigit.f);
    }
}

void MFW(void)  // ᥭ   祩 ᨢ ⢥ ᥫ ᮤন  
{
	ByteCode = ByteCode >> 8;

	uint32_t selectingArray = 0, adr = 0;

	float var = 0;

	selectingArray = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	adr = adressDimData(selectingArray);

    adr =  adr & 0x7fffff;

	if(popHiMcalc(&MCALC) == 0xffff){
	var = (float)popMcalcI(&MCALC);
	}
	else{
	var = popMcalcF(&MCALC);
	}

    SetCalcAddrVarF(adr, var);
}


void DUB(void)  // 㡫஢ 設 ⥪  
{
	ByteCode = ByteCode >> 8;
	uint16_t Ii = 0;
	float Fi = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff){
		Ii = popMcalcI(&MCALC);
		pushMcalcI(&MCALC,Ii);
		pushMcalcI(&MCALC,Ii);
	}
	else{
		Fi = popMcalcF(&MCALC);
		pushMcalcF(&MCALC,Fi);
		pushMcalcF(&MCALC,Fi);
	}
}


void BITR(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t var = 0, Ai = 0;
    var = ByteCode & 0xff;

    ByteCode = ByteCode >> 8;

	if(popHiMcalc(&MCALC) == 0xffff){
		Ai = popMcalcI(&MCALC);
	  	}
	else{
		Ai = (uint16_t)roundf(popMcalcF(&MCALC));
	  }

	Ai = Ai >> var;
	Ai = Ai & 0x01;

	pushMcalcI(&MCALC,Ai);
}


void BTWI(void)
{
	uint16_t offset = 0, Ai = 0, digit = 0, M = 0;

	ByteCode = ByteCode >> 8;

	offset = ByteCode & 0xf;

    ByteCode = ByteCode >> 8;

	typeDigit.i = popMcalcAddr(&MCALC);

	digit = calcAddrVarI(typeDigit.FloatP.mantissa);

	if(popHiMcalc(&MCALC) == 0xffff)
	{
		Ai = popMcalcI(&MCALC);
	}
	else
		{
		Ai = (uint16_t)roundf(popMcalcF(&MCALC));
		}

	M = 1 << offset;

	if(Ai & 1)
	{
		digit |= M;
	}
	else
		{
			digit &= (~M);
		}

		SetCalcAddrVarI(typeDigit.FloatP.mantissa, digit);
}


void BTWF(void)
{
	uint16_t offset = 0, Ai = 0, M = 0;

	float digitF = 0.0;

	int32_t digitI = 0;

	ByteCode = ByteCode >> 8;

	offset = ByteCode & 0xff;

    ByteCode = ByteCode >> 8;

	typeDigit.i = popMcalcAddr(&MCALC);

	digitF = calcAddrVarF(typeDigit.FloatP.mantissa);

	if(popHiMcalc(&MCALC) == 0xffff)
	{
		Ai = popMcalcI(&MCALC);
	}
	else
	{
		Ai = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	digitI = (int32_t)roundf(digitF);

	M = 1 << offset;

	if(Ai & 1)
	{
		digitI |= M;
	}
	else
		{
		digitI &= (~M);
		}

	SetCalcAddrVarF(typeDigit.FloatP.mantissa, (float)digitI);
}


void FIXA(void) //   ⥪  aaaaaa (⠭)
{
	ByteCode = ByteCode >> 8;

	pushMcalcAddr(&MCALC,ByteCode);

	ByteCode = ByteCode >> 24;
}


void FIXD(void) //   ⥪  祩 ᨢ dd.
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;

	var = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	pushMcalcI(&MCALC,var);
}


void INV(void) //   ᫠
{
	ByteCode = ByteCode >> 8;
	int16_t Ai = 0;
	float Af = 0.0;

	if(popHiMcalc(&MCALC) == 0xffff)
	{
		Ai = popMcalcI(&MCALC);
		Ai = Ai * (-1);
		pushMcalcI(&MCALC,Ai);
	}
	else
	{
		Af = popMcalcF(&MCALC);
	    Af = Af * (-1);
	    pushMcalcF(&MCALC,Af);
	}
}


/*ப */
void RSTR(void)
{
	ByteCode = ByteCode >> 8;

	char str[256];

	memset(str,0,sizeof(str));

	getCalcAddrStr(ByteCode, str);

	ByteCode = ByteCode >> 24;

	pushStrCalc(&StrCalc,str);
}


void WSTR(void)
{
	ByteCode = ByteCode >> 8;

	uint8_t var = ByteCode & 0xff;

	char str[256], str2[256];
	memset(str, 0, sizeof(str));
	memset(str2, 0, sizeof(str2));

	StrVarData = (_StrVarData*)(AddressBeginByteCode + BinFileHead->StrVar_adr + var*4);

	popStrCalc(&StrCalc,str);

	memcpy(str2, str, StrVarData->len - 1);

	setcalcAddrStr(StrVarData->adr, str2);

	ByteCode = ByteCode >> 8;
}


void SETS(void)
{
	ByteCode = ByteCode >> 8;

	char str[256];

	memset(str,0,sizeof(str));

	getCalcAddrStr(ByteCode, str);

	ByteCode = ByteCode >> 24;

	pushStrCalc(&StrCalc,str);
}


void CAT(void)
{
	ByteCode = ByteCode >> 8;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	strcat(text_1, text_2);

    pushStrCalc(&StrCalc, text_1);
}


void EQS(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc, text_1);

	popStrCalc(&StrCalc, text_2);

	if(strcmp(text_1, text_2) == 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void NEQS(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	if(strcmp(text_1, text_2) != 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void MRS(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	if(strcmp(text_1, text_2) > 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void LSS(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	if(strcmp(text_1, text_2) < 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void MRES(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	if(strcmp(text_1, text_2) >= 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void LSES(void)
{
	ByteCode = ByteCode >> 8;

	uint16_t res = 0;

	char text_1[256];

	char text_2[256];

	memset(text_1,0,sizeof(text_1));

	memset(text_2,0,sizeof(text_2));

	popStrCalc(&StrCalc,text_1);

	popStrCalc(&StrCalc,text_2);

	if(strcmp(text_1, text_2) <= 0){
		res = 1;
	}

	pushMcalcI(&MCALC,res);
}


void STRF(void)
{
	ByteCode = ByteCode >> 8;
	char text[256];
	char textOut[256];
	int32_t varI = 0;
	float    varF = 0.0;
	memset(text, 0, sizeof(text));
	memset(textOut, 0, sizeof(textOut));
	getCalcAddrStr(ByteCode, text);
	ByteCode = ByteCode >> 24;

	switch(text[0])
	{

	case '0':
		    text[0] = '%';
	        if(popHiMcalc(&MCALC) == 0xffff){
	           varI = popMcalcI(&MCALC);
	        }
	        else{
		       varI = (uint16_t)roundf(popMcalcF(&MCALC));
	        }

	        if(varI < 0)
	        {
	        	varI = 0;
		    }

	        snprintf(textOut, sizeWindowAxisX, text, varI);
		break;

	case '1':
        if(popHiMcalc(&MCALC) == 0xffff){
           varI = popMcalcI(&MCALC);
        }
        else{
	       varI = (uint16_t)roundf(popMcalcF(&MCALC));
        }

        varI = varI & 0x000f;

        text[0] = '%';

        snprintf(textOut, sizeWindowAxisX, text,varI);
		break;

	case '2':
        if(popHiMcalc(&MCALC) == 0xffff){
           varI = popMcalcI(&MCALC);
        }
        else{
	       varI = (uint16_t)roundf(popMcalcF(&MCALC));
        }

        varI = varI & 0x00ff;

        text[0] = '%';

        snprintf(textOut, sizeWindowAxisX, text, varI);
		break;

	case '3':
        if(popHiMcalc(&MCALC) == 0xffff){
           varI = popMcalcI(&MCALC);
        }
        else{
	       varI = (uint16_t)roundf(popMcalcF(&MCALC));
        }

        varI = varI & 0x0fff;

        text[0] = '%';

        snprintf(textOut, sizeWindowAxisX, text, varI);
		break;

	case '4':
        if(popHiMcalc(&MCALC) == 0xffff){
           varI = popMcalcI(&MCALC);
        }
        else{
	       varI = (uint16_t)roundf(popMcalcF(&MCALC));
        }

        varI = varI & 0xffff;

        text[0] = '%';

        snprintf(textOut, sizeWindowAxisX, text, varI);
		break;

	case '5':
        if(popHiMcalc(&MCALC) == 0xffff){
           varI = popMcalcI(&MCALC);
        }
        else{
	       varI = (uint16_t)roundf(popMcalcF(&MCALC));
        }

        text[0] = '%';

        snprintf(textOut, sizeWindowAxisX, text, varI);
		break;

	case '%':
        if(popHiMcalc(&MCALC) == 0xffff)
        {
        	varI = popMcalcI(&MCALC);
        	snprintf(textOut, sizeWindowAxisX, text, varI);
        }
        else
        	{
        	varF = popMcalcF(&MCALC);
        	snprintf(textOut, sizeWindowAxisX, text, varF);
        	}
		break;

	default :
		break;
	}

	pushStrCalc(&StrCalc, textOut);
}


void STR(void)
{
	ByteCode = ByteCode >> 8;

	int Bi = 0;
	float Bf = 0.0;
	char text[256];
	memset(text, 0, sizeof(text));

	if(popHiMcalc(&MCALC) == 0xffff){
	Bi = popMcalcI(&MCALC);
    snprintf(text, sizeWindowAxisX,"%d", Bi);
	}
	else{
	Bf = popMcalcF(&MCALC);
	snprintf(text, sizeWindowAxisX,"%.3f", Bf);
	}

	pushStrCalc(&StrCalc, text);
}


void BINS(void)
{
	ByteCode = ByteCode >> 8;

	int Bi = 0;
	char text[256];
    memset(text,0,sizeof(text));

	if(popHiMcalc(&MCALC) == 0xffff){
	Bi = popMcalcI(&MCALC);
	}
	else{
	Bi = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	sprintf(text,""BYTE_TO_BINARY_PATTERN" "BYTE_TO_BINARY_PATTERN"", BYTE_TO_BINARY(Bi>>8), BYTE_TO_BINARY(Bi));

	pushStrCalc(&StrCalc,text);
}


void HEXS(void)
{
	ByteCode = ByteCode >> 8;

	int Bi = 0;
	char text[16] = {0};

	if(popHiMcalc(&MCALC) == 0xffff){
	Bi = popMcalcI(&MCALC);
    sprintf(text,"%x",Bi);
	}
	else{
	Bi = (uint16_t)roundf(popMcalcF(&MCALC));
	sprintf(text,"%x",Bi);
	}

	pushStrCalc(&StrCalc,text);
}


void MID(void)
{
	ByteCode = ByteCode >> 8;

    uint16_t Ai = 0, Bi = 0;
	char text[256], str[256];
	memset(text, 0, sizeof(text));
	memset(str, 0, sizeof(str));

	if(popHiMcalc(&MCALC) == 0xffff){
	Bi = popMcalcI(&MCALC);
	}
	else{
	Bi = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
	Ai = popMcalcI(&MCALC);
	}
	else{
	Ai = (uint16_t)popMcalcF(&MCALC);
	}

	popStrCalc(&StrCalc, text);

	if(Ai > 0 && Bi > 0)
	{
		if(Ai + Bi < 254)
		{
		memcpy((void*)(str), (void*)(text + Ai), Ai + Bi);
		}
		else
			{
			Bi = 254 - Ai;
			memcpy((void*)(str), (void*)(text + Ai), Ai + Bi);
			}
	}
	else
		{
		Ai = 0; Bi = 0;
		memcpy((void*)(str), (void*)(text + Ai), Ai + Bi);
		}

		pushStrCalc(&StrCalc, str);
}


void LEN(void)
{
	ByteCode = ByteCode >> 8;

	uint32_t len = 0;

	char text[256];

	memset(text,0,sizeof(text));

	popStrCalc(&StrCalc,text);

	len = strlen(text);

	pushMcalcI(&MCALC, len);
}


void MSR(void)
{
	ByteCode = ByteCode >> 8;

	uint32_t selectingArray = 0, adr = 0;

	char text[256];

	memset(text, 0, sizeof(text));

	selectingArray = ByteCode & 0xff;

	ByteCode = ByteCode >> 8;

	adr = adressDimData(selectingArray);

	adr = adr & 0x7fffff;

	getCalcAddrStr(adr, text);

	pushStrCalc(&StrCalc, text);
}


void MSW(void)
{
	ByteCode = ByteCode >> 8;
	uint32_t adr = 0, len = 0;
	char text[256], text2[256];
	memset(text, 0, sizeof(text));
	memset(text2, 0, sizeof(text2));

	adr = adressDimData(ByteCode & 0xff);
	len = (adr & 0xFF000000) >> 24;
	adr = adr & 0x7fffff;

	popStrCalc(&StrCalc, text);
	memcpy(text2, text, len - 1);
	setcalcAddrStr(adr, text2);

    ByteCode = ByteCode >> 8;
}


void VAL(void)
{
	ByteCode = ByteCode >> 8;

	float resF = 0.0;

	uint32_t resI = 0;

	char text[256];

	memset(text,0,sizeof(text));

	popStrCalc(&StrCalc, text); // 㧪  ⥪

    char * p2=text;

	if(*p2 == '0'){
	        switch (*(p2+1)) {
	            case 'x':
	            case 'X':{
	        	    resI = strtol(p2+2,NULL,16);
	        	    	pushMcalcI(&MCALC,resI); // 㧪  ⥪
	        	    	return;
	                break;
	            };
	            case 'b':
	            case 'B': {
	        	    resI = strtol(p2+2,NULL,2);
	        	    	pushMcalcI(&MCALC,resI);
	        	    	return;
	                break;
	            };
	        }
	}
	else{

		if (strpbrk(text, ".eE") != NULL) {
			resF = (float)strtod(text,NULL);
			pushMcalcF(&MCALC,resF);
		}
		else{
	        resI = strtol(text,NULL,10);
	    	 pushMcalcI(&MCALC,resI);
		}
	}

}


void ASC(void)
{
	ByteCode = ByteCode >> 8;

	char text[256];

	memset(text,0,sizeof(text));

	popStrCalc(&StrCalc,text);

	pushMcalcI(&MCALC, text[0]);
}


void CHR(void)
{
	ByteCode = ByteCode >> 8;

	char text[256];

	memset(text,0,sizeof(text));

    uint16_t x = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
    x = popMcalcI(&MCALC);
	}
	else{
    x = (uint16_t)popMcalcF(&MCALC);
	}

	text[0] = x;

	pushStrCalc(&StrCalc,text);
}


void GOTO(void) // ᫮ 室
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;

    var = ByteCode;

    ByteCode = ByteCode >> 24;

    var = var - 64 - AddressOffsetByteCode;

    var = var / 4;

    stepExecBeteCode = var - 1;
}


void GOSB(void) // 맮 ணࠬ
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;

    var = ByteCode;

    ByteCode = ByteCode >> 24;

    var = var - 64 - AddressOffsetByteCode;

    var = var / 4;

    pushSubprog(&Subprog, AddressExecByteCode + 4);

    stepExecBeteCode = var - 1;
}


void IFGO(void) // 室 ᫨    
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;
	uint16_t res = 0;

	if(popHiMcalc(&MCALC) == 0xffff)
	{
		res = popMcalcI(&MCALC);
	}
	else
		{
		res = (uint16_t)roundf(popMcalcF(&MCALC));
		}

	if(res == 0)
	{
    var = ByteCode;

    ByteCode = ByteCode >> 24;

    var = var - 64 - AddressOffsetByteCode;

    var = var / 4;

    stepExecBeteCode = var - 1;
	}
	else  // ᫨   믮塞 if
		{
		ByteCode = ByteCode >> 24;
		}
}


void RET(void)
{
	ByteCode = ByteCode >> 8;

	stepExecBeteCode = ((popSubprog(&Subprog) - AddressBeginByteCode - 64 - AddressOffsetByteCode)/4) - 1;
}


void FOR(void)  // 横 樠
{
	ByteCode = ByteCode >> 8;

    float step = 0, to = 0;

    uint32_t var = 0;

    var = ByteCode;

    ByteCode = ByteCode >> 24;

	if(popHiMcalc(&MCALC) == 0xffff){
		step = (float)popMcalcI(&MCALC);
	}
	else{
		step = popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		to = (float)popMcalcI(&MCALC);
	}
	else{
		to = popMcalcF(&MCALC);
	}

	pushForNext(&FORNEXT, var, (AddressExecByteCode + 4 /*- AddressOffsetByteCode*/), step, to);
}


void NEXT(void) // 몠 横 NEXT
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;

	float i = 0.0; // ६ 横

    var = ByteCode;

    ByteCode = ByteCode >> 24;

    popForNext(&FORNEXT, var);

    i = calcAddrVarF(var);

    i = i + popFornext.step;

    SetCalcAddrVarF(var,i);

    if(popFornext.step >= 0){

    if(i <= popFornext.to){
    stepExecBeteCode = ((popFornext.begin - AddressBeginByteCode - 64 - AddressOffsetByteCode)/4) - 1;
    }
    else{
    	clearAddressForNext(&FORNEXT, var);
    }

    }
    else{
    	if(i >= popFornext.to){
    	stepExecBeteCode = ((popFornext.begin - AddressBeginByteCode - 64 - AddressOffsetByteCode)/4) - 1;
    	}
    	else{
    		clearAddressForNext(&FORNEXT, var);
    	}
    }
}


void SWGO(void) //   SWITCH .. GOTO
{
	ByteCode = ByteCode >> 8;

	uint32_t ai = 0, bi = 0;

	uint32_t var = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		bi = popMcalcI(&MCALC);
	}
	else{
		bi = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		ai = popMcalcI(&MCALC) + 0.5;
	}
	else{
		ai = (uint16_t)popMcalcF(&MCALC);
	}

	if(ai == bi){ // ᫨  
	var = ByteCode & 0xffffff;

	ByteCode = ByteCode >> 24;

	var = var - 64 - AddressOffsetByteCode;

	var = var / 4;

	stepExecBeteCode = var - 1;
	}

	if(ai != bi){

	bi = bi - 1;

	if(bi != 0){
	pushMcalcI(&MCALC,ai);

	pushMcalcI(&MCALC,bi);
	}

	}
}


void SWGS(void) //   SWITCH .. GOSUB
{
	ByteCode = ByteCode >> 8;

	uint32_t var = 0;
	uint16_t ai = 0, bi = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		bi = popMcalcI(&MCALC);
	}
	else{
		bi = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		ai = popMcalcI(&MCALC);
	}
	else{
		ai = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	if(ai == bi)
	{
	pushSubprog(&Subprog,(AddressExecByteCode + 4*bi));

    var = ByteCode & 0xffffff;

    ByteCode = ByteCode >> 24;

    var = var - 64 - AddressOffsetByteCode;

    var = var / 4;

    stepExecBeteCode = var - 1;
	}
	else
		{
		bi = bi - 1;

		if(bi != 0)
		{
		pushMcalcI(&MCALC,ai);
		pushMcalcI(&MCALC,bi);
		}

		ByteCode = ByteCode >> 24;
		}
}


/*㭪樨 ⮡ࠦ*/
void ATC(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

	int16_t x = 0, y = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		x = popMcalcI(&MCALC);
	}
	else{
		x = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		y = popMcalcI(&MCALC);
	}
	else{
		y = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	xGrid[NumberWindows] = x, yGrid[NumberWindows] = y;

	move(y,x); // ᭠砫 y ⮬ x
	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void SCR(void)
{
	ByteCode = ByteCode >> 8;

	if(popHiMcalc(&MCALC) == 0xffff){
		 ExecWindows = popMcalcI(&MCALC);
	}
	else{
		 ExecWindows = (uint16_t)roundf(popMcalcF(&MCALC));
	}
}


void CLS(void)
{
	ByteCode = ByteCode >> 8;

	int16_t x = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		x = popMcalcI(&MCALC);
	}
	else{
		x = (uint16_t)roundf(popMcalcF(&MCALC));
	}

   if(x == 4)
   {
	 attrset(((colorF[NumberWindows] & 0x7) << 8)|((colorB[NumberWindows] & 0x7) << 12));
	 clear();
	 clearDisp(NumberWindows, colorF[NumberWindows], colorB[NumberWindows]);
	 xGrid[NumberWindows] = 0, yGrid[NumberWindows] = 0;
	 move(0, 0);
   }

   if(x < 4)
   {
	   NumberWindows = x;
	   clearDisp(NumberWindows, colorF[NumberWindows], colorB[NumberWindows]);
   }

   /*
    * ⪠ ࠭ ନ   梥⮬ 䮭. ࠬ (0..4)   設 ⥪.
    * ᫨ ࠬ  4,    頥 ࠭. ᫨ ࠬ ࠢ 4,  頥 ⮡ࠦ ࠭.
    * ᫨ ࠬ , 祬 4,  ⪠  ந.
    * */
}



void INK(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

	uint32_t /*dim = 0,*/ color = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		color = popMcalcI(&MCALC);
	}
	else{
		color = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	colorF[NumberWindows] = color;

	//dim = color & 0x8;

	color = color & 0xf;

	color = color << 8;

	color = color &  F_COLOR;

	//if(dim == 0){
	attrset(color|((colorB[NumberWindows] & 0xf) << 12));
	//}
	//else{
	//attrset(color|((colorB[NumberWindows] & 0x7) << 12)|A_BOLD);
	//}

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void PAP(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

	uint32_t /*dim = 0,*/ color = 0;

	if(popHiMcalc(&MCALC) == 0xffff){
		color = popMcalcI(&MCALC);
	}
	else{
		color = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	colorB[NumberWindows] = color;

	//dim = color & 0x8;

	color = color & 0xf;

	color = color << 12;

	color = color & B_COLOR;

	//if(dim == 0){
	attrset(((colorF[NumberWindows] & 0xf) << 8)|color);
	//}
	//else{
	//attrset(((colorF[NumberWindows] & 0x7) << 8)|color|A_BOLD);
	//}

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void PST(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();

	ByteCode = ByteCode >> 8;
	int32_t lenStr, i;
	char text[256];
	memset(text, 0, sizeof(text));
	popStrCalc(&StrCalc, text);

	lenStr = strnlen(text,256);

	for(i = 0; i < lenStr; i++)
	{
		outputPrint(text[i]);
	}

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void STIN(void)
{
	ByteCode = ByteCode >> 8;

	if(popHiMcalc(&MCALC) == 0xffff){
		SysMem.READYINPUTMAX = popMcalcI(&MCALC);
	}
	else{
		SysMem.READYINPUTMAX = (uint16_t)roundf(popMcalcF(&MCALC));
	}

	clearInputDataKeyboard(&inputDataKeyboard);

	//InputEcho[NumberWindows]->Y = yGrid[NumberWindows];

	//InputEcho[NumberWindows]->X = xGrid[NumberWindows];

	SysMem.READYINPUT = 0;
}


void INPT(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();

	ByteCode = ByteCode >> 8;

	uint32_t i = 0;

    uint32_t quantity = 0;

    quantity = sizeInputDataKeyboard(&inputDataKeyboard);

    char text[256];

    memset(text, 0, sizeof(text));

    if(SysMem.READYINPUT == 1){

    for(i = 0; i < quantity; i++){
    	text[i] = popInputDataKeyboard(&inputDataKeyboard);
    }

    clearInputDataKeyboard(&inputDataKeyboard);

    SysMem.READYINPUT = -1;
    }

    pushStrCalc(&StrCalc, text);

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void INKS(void)
{
	ByteCode = ByteCode >> 8;

    char text[256];
    memset(text, 0, sizeof(text));

    SysMem.READYINPUT = -1;
    clearInputDataKeyboard(&inputDataKeyboard);

    text[0] = lastCharacterEntered;

    pushStrCalc(&StrCalc, text);

    lastCharacterEntered = 0;

    clearInputDataKeyboard(&inputDataKeyboard);
}


void PCST(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

    uint32_t adrrMem = 0, addrSysMem, addrSTATDATA, i;
	uint8_t  typeAdr = 0;
	int32_t lenStr = 0;
    char *uNameAddr = NULL;

	addrSysMem = (uint32_t)&SysMem;
	addrSTATDATA = (uint32_t)&SysMem.STATDATA;

	typeAdr = (ByteCode & 0xf00000) >> 20 ;
	adrrMem = ByteCode & 0xFFFFF;
	ByteCode = ByteCode >> 24;

	switch(typeAdr)
	{
	case 3:uNameAddr  = (char*)(addrSysMem + adrrMem);
		break;

	case 4:uNameAddr = (char*)(addrSTATDATA + adrrMem);
		break;

	case 6: uNameAddr = (char*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem);
		break;

	default :
		snprintf(SysMem.ERRORS, 79, " 騩  PCST");
		break;
	}

	lenStr = strlen(uNameAddr);

	for(i = 0; i < lenStr; i++)
	{
		outputPrint(*(uNameAddr+i));
	}

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void BPST(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

	char text[256];
	memset(text, 0, sizeof(text));
	popStrCalc(&StrCalc, text);

	outputBoldPrint((uint8_t*)text, FntBool);

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void BCST(void)
{
	CLEAR_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
	ByteCode = ByteCode >> 8;

    uint32_t adrrMem = 0, addrSysMem, addrSTATDATA;
	uint8_t  typeAdr = 0;
    char *uNameAddr = NULL;

	addrSysMem = (uint32_t)&SysMem;
	addrSTATDATA = (uint32_t)&SysMem.STATDATA;

	typeAdr = (ByteCode & 0xf00000) >> 20 ;
	adrrMem = ByteCode & 0xFFFFF;
	ByteCode = ByteCode >> 24;

	switch(typeAdr)
	{
	case 3:uNameAddr  = (char*)(addrSysMem + adrrMem);
		break;

	case 4:uNameAddr = (char*)(addrSTATDATA + adrrMem);
		break;

	case 6: uNameAddr = (char*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem);
		break;

	default :
		snprintf(SysMem.ERRORS, 79, " 騩  PCST");
		break;
	}

	outputBoldPrint((uint8_t*)uNameAddr, FntBool);

	SET_BIT(TIM17->DIER, TIM_DIER_UIE);
	__DSB();
}


void FNT(void)
{
	ByteCode = ByteCode >> 8;

	if(popHiMcalc(&MCALC) == 0xffff)
	{
		FntBool = popMcalcI(&MCALC);
	}
	else
		{
		FntBool = (uint16_t)roundf(popMcalcF(&MCALC));
		}
}


/*㭪樨  뢮  ࠭ */
void MBO(void) //    譥 
{
	ByteCode = ByteCode >> 8;

    uint16_t x = 0, y = 0, z= 0;
    /*
     * x - 
     * y -  
     * z - ⢮
     * */

	if(popHiMcalc(&MCALC) == 0xffff){
		z = popMcalcI(&MCALC);
	}
	else{
		z = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		y = popMcalcI(&MCALC);
	}
	else{
		y = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		x = popMcalcI(&MCALC);
	}
	else{
		x = (uint16_t)popMcalcF(&MCALC);
	}

	if(z > 1)
	{
	pushStackCommandExternalDevice(&StackCommandExternalDevice,x,0x10,y,z);
	}
	else
		{
		pushStackCommandExternalDevice(&StackCommandExternalDevice,x,0x6,y,z);
		}

    if((sizeStackCommandExternalDevice(&StackCommandExternalDevice) == 1) && (DMA1_Stream2->NDTR == 0) && (DMA1_Stream1->NDTR == 0)) // ᫨     ⥪  ந室 ᠬ
    {
    popStackCommandExternalDevice(&StackCommandExternalDevice);
    }
}


void MBI(void) // ਥ   譥 
{
	ByteCode = ByteCode >> 8;

    uint16_t x = 0, y = 0, z= 0;

    /*
     * x - 
     * y -  
     * z - ⢮
     * */

	if(popHiMcalc(&MCALC) == 0xffff){
		z = popMcalcI(&MCALC);
	}
	else{
		z = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		y = popMcalcI(&MCALC);
	}
	else{
		y = (uint16_t)popMcalcF(&MCALC);
	}

	if(popHiMcalc(&MCALC) == 0xffff){
		x = popMcalcI(&MCALC);
	}
	else{
		x = (uint16_t)popMcalcF(&MCALC);
	}

	pushStackCommandExternalDevice(&StackCommandExternalDevice, x, 0x3, y, z);

    if((sizeStackCommandExternalDevice(&StackCommandExternalDevice) == 1) && (DMA1_Stream2->NDTR == 0) && (DMA1_Stream1->NDTR == 0)) // ᫨     ⥪  ந室 ᠬ
    {
    	popStackCommandExternalDevice(&StackCommandExternalDevice);
    }
}


void EPRW(void) //   ࣮ᨬ  짮⥫
{
	ByteCode = ByteCode >> 8;

	if(popHiMcalc(&MCALC) == 0xffff){
		EepromWriteI((ByteCode & 0x7530), popMcalcI(&MCALC));
	}
	else{
		EepromWriteF((ByteCode & 0x7530), popMcalcF(&MCALC));
	}

    ByteCode = ByteCode >> 24;
}


void EPRR(void) // ⥭  ࣮ᨬ  짮⥫
{
	ByteCode = ByteCode >> 8;

	typeDigit.i = EepromReadI(ByteCode & 0x7530);

	if(typeDigit.UintP.hi == 0xffff){
		pushMcalcI(&MCALC,typeDigit.i);
	}
	else{
		pushMcalcF(&MCALC,typeDigit.f);
	}

	ByteCode = ByteCode >> 24;
}
