#include "main.h"
#include "stdbool.h"
#include "stdio.h"
#include "stdlib.h"
#include "zmodem.h"
#include "usb_device.h"

#define UPDC32(octet, crc) (crc_32_tab[((crc) ^ (octet)) & 0xff] ^ ((crc) >> 8))

//                          NEXT                PREVIOUS                       PARENT                         CHILD
ZMODEM(z_s1i1,				z_s1i2,				ZMODEM_NULL_ENTRY,			   z_s1i10   ,			          ZMODEM_NULL_ENTRY,			 ZMODEMSTARTRECEIVESEND, ZMODEM_RZ_CR ,		     ZMODEM_NULL_FUNC);
ZMODEM(z_s1i2,				z_s1i3,				ZMODEM_NULL_ENTRY,			   ZMODEM_NULL_ENTRY,			  ZMODEM_NULL_ENTRY,			 ZMODEMRECEIVE,          ZMODEM_ZRQINIT,		 ZMODEM_NULL_FUNC);
ZMODEM(z_s1i3,				z_s1i4,		     	ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_ZFILE,           ZMODEM_NULL_FUNC);
ZMODEM(z_s1i4,				z_s1i5,	     		ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_HEADER_FILE,     ZMODEM_NULL_FUNC);
ZMODEM(z_s1i5,				z_s1i6,			    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_ZDATA,           ZMODEM_NULL_FUNC);
ZMODEM(z_s1i6,				z_s1i7,			    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_DATA,            ZMODEM_NULL_FUNC);
ZMODEM(z_s1i7,				z_s1i8,			    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_ZEOF,            ZMODEM_NULL_FUNC);
ZMODEM(z_s1i8,				z_s1i9,			    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_ZFIN,            ZMODEM_NULL_FUNC);
ZMODEM(z_s1i9,				z_s1i1,		    	ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEMRECEIVE,          ZMODEM_OO,              ZMODEM_NULL_FUNC);

ZMODEM(z_s1i10,				z_s1i11,		    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_HEADER_FILE,       ZMODEM_TX_HEADER_FILE,  ZMODEM_NULL_FUNC);
ZMODEM(z_s1i11,				z_s1i12,		    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_ZRPOS,             ZMODEM_TX_ZRPOS,        ZMODEM_NULL_FUNC);
ZMODEM(z_s1i12,				z_s1i13,		    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_ZDATA,             ZMODEM_TX_ZDATA,        ZMODEM_NULL_FUNC);
ZMODEM(z_s1i13,				z_s1i14,		    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_DATA,              ZMODEM_TX_DATA,         ZMODEM_NULL_FUNC);
ZMODEM(z_s1i14,				z_s1i15,		    ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_ZRINIT,            ZMODEM_TX_ZRINIT,       ZMODEM_NULL_FUNC);
ZMODEM(z_s1i15,				z_s1i16,            ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_ZFIN,              ZMODEM_TX_ZFIN,         ZMODEM_NULL_FUNC);
ZMODEM(z_s1i16,				ZMODEM_NULL_ENTRY,  ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             ZMODEM_NULL_ENTRY,             SEND_OO,                ZMODEM_TX_OO,           ZMODEM_NULL_FUNC);


	uint8_t ch;
	uint8_t HeaderData[4];
	uint32_t GoodOffset;
	uint8_t bufZmodemTX[64];
	volatile uint16_t counterbufZmodemTX = 0;

    Stack_zmodem Stack_Zm = {0};

   _BufWriteZmodem BufWriteZmodem = {0};

   _ZsendByte ZsendByte;

   _placAdd placAdd;

   uint32_t LenDataZmodem = 0;
   int32_t numberByteReceived = 0;

   extern USBD_HandleTypeDef hUsbDeviceFS;

   uint8_t zmodemRxBuf[2048];

    /* CRC polynomial 0xedb88320 */
	/*static uint32_t crc_32_tab[] = {
	0x00000000, 0x77073096, 0xee0e612c, 0x990951ba, 0x076dc419, 0x706af48f, 0xe963a535, 0x9e6495a3,
	0x0edb8832, 0x79dcb8a4, 0xe0d5e91e, 0x97d2d988, 0x09b64c2b, 0x7eb17cbd, 0xe7b82d07, 0x90bf1d91,
	0x1db71064, 0x6ab020f2, 0xf3b97148, 0x84be41de, 0x1adad47d, 0x6ddde4eb, 0xf4d4b551, 0x83d385c7,
	0x136c9856, 0x646ba8c0, 0xfd62f97a, 0x8a65c9ec, 0x14015c4f, 0x63066cd9, 0xfa0f3d63, 0x8d080df5,
	0x3b6e20c8, 0x4c69105e, 0xd56041e4, 0xa2677172, 0x3c03e4d1, 0x4b04d447, 0xd20d85fd, 0xa50ab56b,
	0x35b5a8fa, 0x42b2986c, 0xdbbbc9d6, 0xacbcf940, 0x32d86ce3, 0x45df5c75, 0xdcd60dcf, 0xabd13d59,
	0x26d930ac, 0x51de003a, 0xc8d75180, 0xbfd06116, 0x21b4f4b5, 0x56b3c423, 0xcfba9599, 0xb8bda50f,
	0x2802b89e, 0x5f058808, 0xc60cd9b2, 0xb10be924, 0x2f6f7c87, 0x58684c11, 0xc1611dab, 0xb6662d3d,
	0x76dc4190, 0x01db7106, 0x98d220bc, 0xefd5102a, 0x71b18589, 0x06b6b51f, 0x9fbfe4a5, 0xe8b8d433,
	0x7807c9a2, 0x0f00f934, 0x9609a88e, 0xe10e9818, 0x7f6a0dbb, 0x086d3d2d, 0x91646c97, 0xe6635c01,
	0x6b6b51f4, 0x1c6c6162, 0x856530d8, 0xf262004e, 0x6c0695ed, 0x1b01a57b, 0x8208f4c1, 0xf50fc457,
	0x65b0d9c6, 0x12b7e950, 0x8bbeb8ea, 0xfcb9887c, 0x62dd1ddf, 0x15da2d49, 0x8cd37cf3, 0xfbd44c65,
	0x4db26158, 0x3ab551ce, 0xa3bc0074, 0xd4bb30e2, 0x4adfa541, 0x3dd895d7, 0xa4d1c46d, 0xd3d6f4fb,
	0x4369e96a, 0x346ed9fc, 0xad678846, 0xda60b8d0, 0x44042d73, 0x33031de5, 0xaa0a4c5f, 0xdd0d7cc9,
	0x5005713c, 0x270241aa, 0xbe0b1010, 0xc90c2086, 0x5768b525, 0x206f85b3, 0xb966d409, 0xce61e49f,
	0x5edef90e, 0x29d9c998, 0xb0d09822, 0xc7d7a8b4, 0x59b33d17, 0x2eb40d81, 0xb7bd5c3b, 0xc0ba6cad,
	0xedb88320, 0x9abfb3b6, 0x03b6e20c, 0x74b1d29a, 0xead54739, 0x9dd277af, 0x04db2615, 0x73dc1683,
	0xe3630b12, 0x94643b84, 0x0d6d6a3e, 0x7a6a5aa8, 0xe40ecf0b, 0x9309ff9d, 0x0a00ae27, 0x7d079eb1,
	0xf00f9344, 0x8708a3d2, 0x1e01f268, 0x6906c2fe, 0xf762575d, 0x806567cb, 0x196c3671, 0x6e6b06e7,
	0xfed41b76, 0x89d32be0, 0x10da7a5a, 0x67dd4acc, 0xf9b9df6f, 0x8ebeeff9, 0x17b7be43, 0x60b08ed5,
	0xd6d6a3e8, 0xa1d1937e, 0x38d8c2c4, 0x4fdff252, 0xd1bb67f1, 0xa6bc5767, 0x3fb506dd, 0x48b2364b,
	0xd80d2bda, 0xaf0a1b4c, 0x36034af6, 0x41047a60, 0xdf60efc3, 0xa867df55, 0x316e8eef, 0x4669be79,
	0xcb61b38c, 0xbc66831a, 0x256fd2a0, 0x5268e236, 0xcc0c7795, 0xbb0b4703, 0x220216b9, 0x5505262f,
	0xc5ba3bbe, 0xb2bd0b28, 0x2bb45a92, 0x5cb36a04, 0xc2d7ffa7, 0xb5d0cf31, 0x2cd99e8b, 0x5bdeae1d,
	0x9b64c2b0, 0xec63f226, 0x756aa39c, 0x026d930a, 0x9c0906a9, 0xeb0e363f, 0x72076785, 0x05005713,
	0x95bf4a82, 0xe2b87a14, 0x7bb12bae, 0x0cb61b38, 0x92d28e9b, 0xe5d5be0d, 0x7cdcefb7, 0x0bdbdf21,
	0x86d3d2d4, 0xf1d4e242, 0x68ddb3f8, 0x1fda836e, 0x81be16cd, 0xf6b9265b, 0x6fb077e1, 0x18b74777,
	0x88085ae6, 0xff0f6a70, 0x66063bca, 0x11010b5c, 0x8f659eff, 0xf862ae69, 0x616bffd3, 0x166ccf45,
	0xa00ae278, 0xd70dd2ee, 0x4e048354, 0x3903b3c2, 0xa7672661, 0xd06016f7, 0x4969474d, 0x3e6e77db,
	0xaed16a4a, 0xd9d65adc, 0x40df0b66, 0x37d83bf0, 0xa9bcae53, 0xdebb9ec5, 0x47b2cf7f, 0x30b5ffe9,
	0xbdbdf21c, 0xcabac28a, 0x53b39330, 0x24b4a3a6, 0xbad03605, 0xcdd70693, 0x54de5729, 0x23d967bf,
	0xb3667a2e, 0xc4614ab8, 0x5d681b02, 0x2a6f2b94, 0xb40bbe37, 0xc30c8ea1, 0x5a05df1b, 0x2d02ef8d
	};*/



static const unsigned short CRC_CCITT_TABLE[256] =
	{
	    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
	    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
	    0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
	    0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
	    0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
	    0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
	    0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
	    0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
	    0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
	    0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
	    0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
	    0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
	    0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
	    0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
	    0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
	    0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
	    0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
	    0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
	    0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
	    0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
	    0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
	    0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
	    0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
	    0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
	    0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
	    0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
	    0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
	    0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
	    0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
	    0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
	    0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
	    0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
	};



void rZModem_sendHexHeader(uint8_t hType)
{
	uint16_t crc = 0;
	uint8_t bufdataCrc[64];
	memset(bufdataCrc,0,sizeof(bufdataCrc));
	uint8_t counterCrc = 0;
	uint8_t i;
	counterbufZmodemTX = 0;
	switch(hType)
	{
	  case ZRINIT :
	  case ZFIN   :
	  case ZRQINIT:
	       for(i = 0; i < 4; i++)
	           HeaderData[i] = 0;
	       if(hType == ZRINIT)
	           HeaderData[3] = CANOVIO;
	  break;                           
	  
	  case ZRPOS  :  

	  case ZEOF :
	  case ZACK   :
	       for(i = 0; i < 4; i++)
	           HeaderData[i] = (uint8_t)(GoodOffset >> (uint8_t)(8 * i));
	  break;
	}

	putchar1(ZPAD);
	putchar1(ZPAD);
	putchar1(ZDLE);
    putchar1(ZHEX);
   	ch = hType;

   	bufdataCrc[counterCrc++] = ch;
	rZModem_sendHexChar();

	for(i = 0; i < 4; i++)
	{
	   	ch = HeaderData[i];
	   	bufdataCrc[counterCrc++] = ch;
    	rZModem_sendHexChar();
	}

    crc = rZModem_crcUpdate(bufdataCrc, counterCrc);

   	ch = (uint8_t)(crc >> 8);
	rZModem_sendHexChar();
   	ch = (uint8_t)crc;
	rZModem_sendHexChar();
	putchar1(CRZ^0x80);
	putchar1(LF^0x80);
	if(hType != ZFIN && hType != ZACK){
	   putchar1(XON);
	}

	rZmodemTxUsb(bufZmodemTX, counterbufZmodemTX);

	GoodOffset = 0;
}


void rZModem_sendBinHeader(uint8_t hType)
{
	uint16_t crc = 0;
	uint8_t i = 0;

	uint8_t bufdataCrc[64];
	memset(bufdataCrc,0,sizeof(bufdataCrc));
	uint8_t counterCrc = 0;

	counterbufZmodemTX = 0;

    switch(hType)
    {
      case ZFILE:
	       for(i = 0; i < 3; i++)  
	           HeaderData[i] = 0;
	       HeaderData[3] = ZCRECOV;
      break;
      
      case ZDATA:
	       for(i = 0; i < 4; i++) 
	           HeaderData[i] = (uint8_t)(GoodOffset >> (uint8_t)(8 * i));
      break;
    }

	putchar1(ZPAD);
	putchar1(ZDLE);
	putchar1(ZBIN);
   	ch = hType;

   	bufdataCrc[counterCrc++] = ch;

	rZModem_sendDLEChar(); 
	for(i = 0; i < 4; i++)
	{
	   	ch = HeaderData[i];
	   	bufdataCrc[counterCrc++] = ch;
    	rZModem_sendDLEChar(); 
	}

	crc = rZModem_crcUpdate(bufdataCrc, counterCrc);

   	ch = (uint8_t)(crc >> 8);
	rZModem_sendDLEChar(); 
   	ch = (uint8_t)crc;
	rZModem_sendDLEChar(); 

	rZmodemTxUsb(bufZmodemTX, counterbufZmodemTX);
}



uint8_t rZModem_positionMatch(void)
{
	uint16_t temp;
	temp = HeaderData[2]; 
	temp = (temp << 8) | HeaderData[1]; 
	temp = (temp << 8) | HeaderData[0]; 
	return (temp == GoodOffset);
}



uint8_t rZModem_getNextHexCh(uint8_t arg1 , uint8_t arg2)
{
	uint8_t tempCh = 0;
    uint8_t hex = 0;

		if ((arg1 >= '0') && (arg1 <= '9')){
			tempCh = arg1 - 0x30;
		}
		else {
			if ((arg1 >= 'a') && (arg1 <= 'f')){
			tempCh = 0x0a + (arg1 - 0x61);
			}
		}

			tempCh <<= 4;
			if ((arg2 >= '0') && (arg2 <= '9'))
				hex = arg2 - 0x30;
			else if ((arg2 >= 'a') && (arg2 <= 'f'))
				hex = 0x0a + (arg2 - 0x61);

			hex |= tempCh;

		return(hex); // 頥 ⮣ ᫮
}



void rZModem_sendDLEChar(void)
{
	switch(ch)
	{
	  case 015 :  // CR   = 0x0d =  13 (don't know why ...!?)
	  case 0215:  //      = 0x8d = 141 ( - // - // - // - )
   	  case ZDLE:  // CAN  = 0x18 =  24
   	  case 020 :  //      = 0x10 =  16
   	  case 0220:  //      = 0x90 = 144
	  case 021 :  // XON  = 0x11 =  17
	  case 0221:  //      = 0x91 = 145
	  case 023 :  // XOFF = 0x13 =  19
	  case 0223:  //      = 0x93 = 147
      	   putchar1(ZDLE);
		   ch ^= 0x40;
	}
    putchar1(ch);
}

void rZModem_sendHexChar(void)
{
    uint8_t hexDigit[] = "0123456789abcdef";
	putchar1(hexDigit[ch >> 4]);
   	putchar1(hexDigit[ch & 0x0f]);
}


void rZModem_sendCAN(void)
{
  uint8_t i;
  for(i = 0; i < 8; i++)
  {
      putchar1(CAN);
  }
}


void putchar1(char c)
{
   bufZmodemTX[counterbufZmodemTX++] = c;
}


uint16_t rZModem_crcUpdate(uint8_t *pBuffer, uint32_t BufferLength)
{
    CRC->CR = CRC_CR_POLYSIZE_0; // ன CRC
    CRC->POL = 0x1021; //
    CRC->INIT = 0X00000000; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    uint32_t i = 0;
    __IO uint16_t *pReg;
    uint16_t data;

    for (i = 0U; i < (BufferLength / 4U); i++)
    {
      CRC->DR = ((uint32_t)pBuffer[4U * i] << 24U) | \
                           ((uint32_t)pBuffer[(4U * i) + 1U] << 16U) | \
                           ((uint32_t)pBuffer[(4U * i) + 2U] << 8U)  | \
                           (uint32_t)pBuffer[(4U * i) + 3U];
    }
    if ((BufferLength % 4U) != 0U)
    {
      if ((BufferLength % 4U) == 1U)
      {
        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[4U * i];
      }
      if ((BufferLength % 4U) == 2U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;
      }
      if ((BufferLength % 4U) == 3U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;

        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[(4U * i) + 2U];
      }
    }
     return(CRC->DR);
}


uint16_t ZMODEM_CRC16_CHECK_DATA(Stack_zmodem *stack, uint32_t len) //  ஫쭮 㬬  ਥ 䠩
{
    CRC->CR = CRC_CR_POLYSIZE_0; // ன CRC
    CRC->POL = 0x1021; // 
    CRC->INIT = 0X00000000; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    uint32_t i = 0;
    for (i = 0; i <= len; i++)
    {
    *(__IO uint8_t *)(__IO void *)(&CRC->DR) = stack->data[i];
    }
     return(CRC->DR);
}


uint16_t ZMODEM_CRC16Stack_HEADER(Stack_zmodem *stack, uint32_t start, uint32_t len) //  crc16   ⥪   
{
    CRC->CR = CRC_CR_POLYSIZE_0; // ன CRC
    CRC->POL = 0x1021; // 
    CRC->INIT = 0X00000000; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    uint32_t i = 0;
    for (i = start; i < len; i++)
    {
    *(__IO uint8_t *)(__IO void *)(&CRC->DR) = stack->data[i];
    }
     return(CRC->DR);
}

unsigned short Calculate_CRC_CCITT(const unsigned char* buffer, int size)
{
    unsigned short tmp;
    unsigned short crc = 0x0000;

    for (int i=0; i < size ; i++)
    {
        tmp = (crc >> 8) ^ buffer[i];
        crc = (crc << 8) ^ CRC_CCITT_TABLE[tmp];
    }

    return crc;
}


uint32_t ZMODEM_CRC32Stack(Stack_zmodem *stack, uint32_t len) //  crc32   ⥪
{
    CRC->CR = 0x00; // ன CRC
    CRC->POL = 0xedb88320; // 
    CRC->INIT = 0XFFFFFFFF; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    uint32_t i = 0;
    __IO uint16_t *pReg;
    uint16_t data;

     for (i = 0U; i < (len / 4U); i++)
     {
       CRC->DR = ((uint32_t)stack->data[4U * i] << 24U) | \
                              ((uint32_t)stack->data[(4U * i) + 1U] << 16U) | \
                              ((uint32_t)stack->data[(4U * i) + 2U] << 8U)  | \
                              (uint32_t)stack->data[(4U * i) + 3U];
    }
    if ((len % 4U) != 0U)
     {
       if ((len % 4U) == 1U)
       {
         *(__IO uint8_t *)(__IO void *)(&CRC->DR) = stack->data[4U * i];
       }
       if ((len % 4U) == 2U)
       {
         data = ((uint16_t)(stack->data[4U * i]) << 8U) | (uint16_t)stack->data[(4U * i) + 1U];
         pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
         *pReg = data;
       }
       if ((len % 4U) == 3U)
       {
         data = ((uint16_t)(stack->data[4U * i]) << 8U) | (uint16_t)stack->data[(4U * i) + 1U];
         pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
         *pReg = data;

         *(__IO uint8_t *)(__IO void *)(&CRC->DR) = stack->data[(4U * i) + 2U];
       }
     }
     return(CRC->DR);
}


ZmodemItem  Null_Zmodem = {(void*)0, (void*)0, (void*)0, (void*)0, 0, ZMODEM_NULL_FUNC, ZMODEM_NULL_FUNC};


void ZMODEMChange(const ZmodemItem* NewMenu)
{
	if ((void*)NewMenu == (void*)&ZMODEM_NULL_ENTRY)
	  return;

	selectedZmodemItem = (ZmodemItem *)NewMenu;
}


void pushBufWriteZmodem(_BufWriteZmodem *stack, uint8_t var)
{
	if(stack->size < 1024){
	stack->buf[stack->size] = var;
	stack->size++;
	}
	else{
	writeFlashBufferBank2((uint8_t*)&stack->buf, stack->numberSector, stack->address, 1024);

	stack->address += 1024;
	stack->size = 0;


	stack->buf[stack->size] = var;
	stack->size++;
	}
}


void numberSectorBufZmodem(_BufWriteZmodem *stack, uint32_t numberSector)
{
	stack->numberSector = numberSector;
}


void clearBufZmodem(_BufWriteZmodem *stack)
{
	stack->size = 0;
    stack->address = 0;
    stack->numberSector = 0;
}


void writeBufZmodem(_BufWriteZmodem *stack)
{
	if(stack->size > 0 && stack->size < 1024){
	writeFlashBufferBank2((uint8_t*)&stack->buf, stack->numberSector, stack->address, stack->size);
	stack->size = 0;
	}
}


void initStack(Stack_zmodem *stack) // 樠 ⥪
{
    memset(stack->data,0,STACK_MAX_SIZE);
    stack->size = 0;
}

/*㭪樨 ࠡ  ⥪*/
void push(Stack_zmodem *stack, uint8_t value) // 頥  ⥪  
{
	   if(stack->size < STACK_MAX_SIZE) {
		  stack->data[stack->size] = value;
		  stack->size++;
	    }
}

uint8_t pop(Stack_zmodem *stack) // ६   ⥪  㤠   ⠫
{
    if (stack->size > 0){
        stack->size--;
        return (stack->data[stack->size]);
    }
    return(0);
}


uint8_t scanStack(Stack_zmodem *stack, uint32_t number) // ᪠஢ ⥪     
{
    if (stack->size >= number) {
       return (stack->data[number]);
    }
    return(0);
}


void modifiedCellStack(Stack_zmodem *stack, uint16_t number, uint8_t value) // 䨪 ।  祩
{
    if (stack->size >= number) { // ஢ઠ  祩 
       stack->data[number] = value;
    }
}


void deleteGropDataStack(Stack_zmodem *stack, uint32_t len)
{
	uint32_t i = 0;

    if (stack->size >= len) {
    		for(i = 0; i < stack->size; i++){
    			stack->data[i] = stack->data[i + len];
    		}
    			stack->size = stack->size - len;
    }
}


void deleteGropPopDataStack(Stack_zmodem *stack, uint32_t len)
{
	uint32_t i = 0;

    if (stack->size >= len) {

    	for(i = (stack->size - len); i < stack->size; i++){
    		stack->data[i] = 0;
    	}

    	stack->size = stack->size - len;
    }
}


void clearStack(Stack_zmodem *stack) // ⪠ ᥣ ⥪
{
    if (stack->size >= 0){
    	for(uint16_t i = 0; i < stack->size; i++){
    		stack->data[i] = 0;
    	}
    	stack->size = 0;
    }
}


void delCellWithShiftStack(Stack_zmodem *stack, uint32_t numberCel) // 㤠 祩  ⥪  ᤢ  
{
    if (stack->size >= numberCel){ // ஢塞  ࠧ ⥪  祬  㤠塞 

		for(uint32_t i = numberCel; i < stack->size; i++)
		{
			stack->data[i] = stack->data[i + 1];
		}

		stack->size = stack->size - 1;
    }
}


uint32_t sizeStack(const Stack_zmodem *stack) // 祭 ࠧ ⥪
{
	return(stack->size); // ࠧ ⥪
}


uint32_t rZModem_getNextHexLenPackage(Stack_zmodem *stack, uint32_t start) // ॢ ப  ᫮  ᪠  䠩
{
   if(stack->data[start] != 0x00){

	    int i, n;
	    n = 0;
	    for (i = start; stack->data[i] >= '0' && stack->data[i] <= '9'; ++i)
	    	n = (n * 10) + (stack->data[i] - '0');
	    deleteGropDataStack(&Stack_Zm,i+1);
	    return n;
   }
   else{
	   return(0xFFFFFFFF);
   }
}


uint32_t rZModem_getNextOctDataTimePackage(Stack_zmodem *stack, uint32_t start)
{
	   if(stack->data[start] != 0x00){

		long long int i, n;
		    n = 0;
		    for (i = start; stack->data[i] >= '0' && stack->data[i] <= '9'; ++i)
		    	n = (n * 8) + (stack->data[i] - '0');
		    deleteGropDataStack(&Stack_Zm,i+1);
		    return n;
	   }
	   else{
		   return(0xFFFFFFFF);
	   }
}


uint32_t rZModem_getNextOctModePackage(Stack_zmodem *stack, uint32_t start)
{
	   if(stack->data[start] != 0x00){

		long long int i, n;
		    n = 0;
		    for (i = start; stack->data[i] >= '0' && stack->data[i] <= '9'; ++i)
		    	n = (n * 8) + (stack->data[i] - '0');
		    deleteGropDataStack(&Stack_Zm,i+1);
		    return n;
	   }
	   else{
		   return(0xFFFFFFFF);
	   }
}


void rZModem_setNameFile(char *str) //⠭  䠩  ᪠
{
    strcpy(ZmodemHeadFile, str);
}



void ZMODEM_CHECK_ZDLE(Stack_zmodem *stack, uint16_t cell) // ஢ઠ  zdle
{
	uint8_t val = 0;
    val= scanStack(&Stack_Zm, cell);
	if((val & 0x60) == 0x40){
		val &= 0xbf;
		modifiedCellStack(&Stack_Zm, cell, val);
	}
}


void ZMODEM_WRITE_HEADER_FILE(Stack_zmodem *stack) // ।    䠩
{
   /*। ப    MCU*/
   uint32_t datatime = 0, i = 0, len = 0;
   int32_t numFile = 0;
   char text[32];
   memset(text, 0, sizeof(text));
   memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

   i = charInStr(stack->data, '.', stack->size);
   if(i >= 19)
   {
	 len = 19;
   }
   else
   	   {
	   len = i;
   	   }

   memcpy(&modifyFileHeaderList.name, &stack->data, len);
   deleteGropDataStack(&Stack_Zm, i+1);

   i = charInStr(stack->data, '\0', stack->size);
   if(i >= 3)
   {
	   len = 3;
   }
   else
   	   {
	   len = i;
   	   }

   memcpy(&modifyFileHeaderList.textExtension, &stack->data, len);
   deleteGropDataStack(&Stack_Zm, i+1);

   // 뢠   
   LenDataZmodem = rZModem_getNextHexLenPackage(&Stack_Zm,0); // ᫥  䠩

   datatime = rZModem_getNextOctDataTimePackage(&Stack_Zm,0);

   snprintf(text, sizeof(text),"%s%c%s", modifyFileHeaderList.name, '.', modifyFileHeaderList.textExtension);

   numFile = FileSearch(text);

   if(numFile >= 0){ // ᫨ 諨 䠩
	placAdd.head = (int16_t)numFile;

	if(quantityBusySector(HeaderFileList[numFile]->size)*SIZE_CLASTER >= LenDataZmodem){
		eraseSectorFileSystem(HeaderFileList[numFile]->numberSector,LenDataZmodem);
		numberSectorBufZmodem(&BufWriteZmodem, HeaderFileList[numFile]->numberSector); // 㪠뢠 㤠 뢠  䠩
		placAdd.section = HeaderFileList[numFile]->numberSector;
   }
    else{
   		placAdd.section = (uint16_t)searchesVoidSector();
   		numberSectorBufZmodem(&BufWriteZmodem, placAdd.section); // 㪠뢠 㤠 뢠  䠩
   		eraseSectorFileSystem(placAdd.section, LenDataZmodem);
	}

   }
   else
   	   {
	   	placAdd.head = (int16_t)searchesVoidHead();
	   	placAdd.section = (uint16_t)searchesVoidSector();
	   	numberSectorBufZmodem(&BufWriteZmodem, placAdd.section); // 㪠뢠 㤠 뢠  䠩
	   	eraseSectorFileSystem(placAdd.section, LenDataZmodem);
   	   }

   modifyFileHeaderList.size = LenDataZmodem;

   time_t rawtime = (time_t)datatime;
   struct tm  ts;
   ts = *localtime(&rawtime);

   modifyFileHeaderList.date.day    = ts.tm_mday;
   modifyFileHeaderList.date.mounts = ts.tm_mon;
   modifyFileHeaderList.date.year   = ts.tm_year - 100;

   modifyFileHeaderList.time.hour   = ts.tm_hour;
   modifyFileHeaderList.time.min    = ts.tm_min;
   modifyFileHeaderList.time.sec    = ts.tm_sec;

}


_ZsendByte ZSend_Byte(uint8_t current_byte)
{
    _ZsendByte SB;

    SB.retur = 0;
    SB.data[0] = 0;
    SB.data[1] = 0;

	switch(current_byte)
	{
	  case 015 :  // CR   = 0x0d =  13
	  case 0215:  //      = 0x8d = 141
   	  case ZDLE:  // CAN  = 0x18 =  24
   	  case 020 :  //      = 0x10 =  16
   	  case 0220:  //      = 0x90 = 144
	  case 021 :  // XON  = 0x11 =  17
	  case 0221:  //      = 0x91 = 145
	  case 023 :  // XOFF = 0x13 =  19
	  case 0223:  //      = 0x93 = 147
      	   SB.retur = 1;
      	   SB.data[0] = ZDLE;
      	   current_byte ^= 0x40;
	}
    SB.data[1] = current_byte;

    return(SB);
}


void rZmodemTxUsb(uint8_t *buf, uint32_t len)
{
	int32_t size = 0;
	uint32_t i = 0;

	if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED){

		for (i = 0, size = len; i < len; i += 32, size -= 32)
		{
		while(((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState){
		}
			while (CDC_Transmit_FS((unsigned char *)buf + i, (size > 32) ? 32 : size) != USBD_OK);
		}
	}
}


void ZMODEM_RZ_CR(void) // 諠  RZ+CR
{
	uint8_t buf[64], bufcomand[7];
	memset(buf,0,sizeof(buf));
	memset(bufcomand, 0, sizeof(bufcomand));

	for(uint8_t i = 0; i < sizeStack(&Stack_Zm); i++)
	{
    lastCharacterEntered = buf[i] = scanStack(&Stack_Zm,i);

	if(SysMem.READYINPUT == 0){
		if(sizeInputDataKeyboard(&inputDataKeyboard) < SysMem.READYINPUTMAX && buf[i] != 0x0d)
		{
		pushInputDataKeyboard(&inputDataKeyboard,buf[i]);
		}
		else{
			SysMem.READYINPUT = 1;
		}
	}
	}

     if(buf[0] == 'r' &&  buf[1] == 'z' && buf[2] == CRZ){ // ᫨ 諠   zmodem
    	 blockingWorkMenu = 1;
    	 clearStack(&Stack_Zm);
     	 ZMODEMChange(ZMODEM_NEXT);
     }
     else{
    		if(buf[0] == ZPAD && buf[1] == ZPAD && buf[2] == ZDLE && buf[3] == ZHEX){ // hex ଠ "ZPAD , ZPAD, ZDLE, ZHEX"

    			if(buf[18] == (CRZ^0x80) && buf[19] == (LF^0x80) && buf[20]== XON) // 諨 ᫥  騥   
    			{
    	         for(uint8_t i = 0; i < 7; i++){
    	        	 bufcomand[i] = rZModem_getNextHexCh(buf[4 + i*2], buf[4 + i*2 + 1]); // 4 5   6 7   8 9    10 11    12 13  14 15    16 17
    	         }
    	         if(!rZModem_crcUpdate(bufcomand,7)){
    	        	 if(bufcomand[0] == ZRINIT){
    	        	 clearStack(&Stack_Zm);
    	        	 ZMODEMChange(ZMODEM_PARENT); // 室  ᫥騩 ⠯
    	        	 blockingWorkMenu = 1;
    	        	 }
    	         }

    			}
    		}
    		else{
    			clearStack(&Stack_Zm);
    		}
     }
}


void ZMODEM_ZRQINIT(void)  // ࠡ⪠ ZRQINIT
{
	uint8_t buf[64]; //  襣 ࠧ
	memset(buf,0,sizeof(buf));

	uint8_t bufcomand[7];
	memset(bufcomand,0,sizeof(bufcomand)); // 㡨   

	for(uint8_t i = 0; i < sizeStack(&Stack_Zm); i++){
		buf[i] = scanStack(&Stack_Zm,i);
	}

	if(buf[0] == ZPAD && buf[1] == ZPAD && buf[2] == ZDLE && buf[3] == ZHEX){ // hex ଠ "ZPAD , ZPAD, ZDLE, ZHEX"

		if(buf[18] == (CRZ^0x80) && buf[19] == (LF^0x80) && buf[20]== XON) // 諨 ᫥  騥   
		{
         for(uint8_t i = 0; i < 7; i++){
        	 bufcomand[i] = rZModem_getNextHexCh(buf[4 + i*2], buf[4 + i*2 + 1]);
         }
         if(!rZModem_crcUpdate(bufcomand,7)){
        	 if(bufcomand[0] == ZRQINIT){
        	 clearStack(&Stack_Zm); // ⪠ ⥪
        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
        	 numberByteReceived = 0;
        	 rZModem_sendHexHeader(ZRINIT); // ⢥  ZRQINIT
        	 }
         }
         else{
          clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
          ZMODEMChange(&z_s1i1); //  諮 crc 稭 ᭠砫
         }

		}
	}
	else{
		if(!(buf[18] == 0 && buf[19] == 0 && buf[20]== 0)){
		clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
		ZMODEMChange(&z_s1i1); // 訡 頥  ஬ 
		}
	}
}


void ZMODEM_ZFILE(void)
{
	if(sizeStack(&Stack_Zm) >= 4){

	if(scanStack(&Stack_Zm,0) == ZPAD && scanStack(&Stack_Zm,1) == ZDLE && scanStack(&Stack_Zm,2) == ZBIN){ // ᫨ 3  bin ଠ

		uint32_t i = 0; // ६ 稪

	      for(i = 3; i < sizeStack(&Stack_Zm); i++){ //  砩 ᫨ 稫 ஢  zdle,   㦥?   
	  		if(scanStack(&Stack_Zm, i)  == ZDLE){
	  			delCellWithShiftStack(&Stack_Zm,i); // 㤠塞 zdle  ஢塞  ᫥騥   㦭 ஢
	  			ZMODEM_CHECK_ZDLE(&Stack_Zm, i); // 㥬 ᫨  
	  		}
	      }
	             if(!ZMODEM_CRC16Stack_HEADER(&Stack_Zm,3,i)){
	            	 if(scanStack(&Stack_Zm,3) == ZFILE){
	            	   deleteGropDataStack(&Stack_Zm, i); // ⪠ ⥪
	            	   ZMODEMChange(ZMODEM_NEXT); //   ਭ  zmodem
	            	   if(sizeStack(&Stack_Zm) != 0){ // ᫨     ⥪    - 㠫쭮  
	            	   CALLSELECTFUNC; //    ᫠ ନ    䠩
	            	   }
	            	 }
	    	}
	}
	}
}


void ZMODEM_HEADER_FILE(void) // ਥ  䠩  䠩   
{
	uint32_t i = 0;
	for(i = 0; i < sizeStack(&Stack_Zm); i++){
		if(scanStack(&Stack_Zm, i)  == ZDLE){
			delCellWithShiftStack(&Stack_Zm,i); // 㤠塞 zdle  ஢塞  ᫥騥   㦭 ஢
			ZMODEM_CHECK_ZDLE(&Stack_Zm, i); // 㥬 ᫨  
		}
    }

	if(!ZMODEM_CRC16Stack_HEADER(&Stack_Zm, 0, i)){
		ZMODEM_WRITE_HEADER_FILE(&Stack_Zm);
		clearStack(&Stack_Zm);
		ZMODEMChange(ZMODEM_NEXT); //   ਭ ZDATA zmodem
		rZModem_sendHexHeader(ZRPOS); // ⢥   ᫥   ZDATA
	}
}


void ZMODEM_ZDATA(void) // ਥ  ZDATA
{

	if(sizeStack(&Stack_Zm) >= 4){

	if(scanStack(&Stack_Zm,0) == ZPAD && scanStack(&Stack_Zm,1) == ZDLE && scanStack(&Stack_Zm,2) == ZBIN){ // ᫨ 3  bin ଠ

		uint32_t i = 0; // ६ 稪

	      for(i = 3; i < sizeStack(&Stack_Zm); i++){ //  砩 ᫨ 稫 ஢  zdle,   㦥?   
	  		if(scanStack(&Stack_Zm, i)  == ZDLE){
	  			delCellWithShiftStack(&Stack_Zm,i); // 㤠塞 zdle  ஢塞  ᫥騥   㦭 ஢
	  			ZMODEM_CHECK_ZDLE(&Stack_Zm, i); // 㥬 ᫨  
	  		}
	      }
	             if(!ZMODEM_CRC16Stack_HEADER(&Stack_Zm,3,i)){
	            	 if(scanStack(&Stack_Zm,3) == ZDATA){
	            	   deleteGropDataStack(&Stack_Zm, i); // ⪠ ⥪
	            	   ZMODEMChange(ZMODEM_NEXT); //   ਭ  zmodem
	            	   if(sizeStack(&Stack_Zm) != 0){ // ᫨     ⥪   - 㠫쭮  
	            	   CALLSELECTFUNC; //    ᫠ ନ  -
	            	   }
	            	 }
	    	}
	}
	}
}


void ZMODEM_DATA(void) // ࠧ 䠩     䫥
{
	static uint32_t start;

	uint32_t i = 0; //  稪    䠩

    for(i = start; i < sizeStack(&Stack_Zm); i++){

      	start ++;

    	if(scanStack(&Stack_Zm, i)  == ZDLE){
    		if((sizeStack(&Stack_Zm) - i) > 1){ // ஢ઠ   ᫥騩   ᨢ
    		delCellWithShiftStack(&Stack_Zm,i); // 㤠塞 zdle  ஢塞  ᫥騥   㦭 ஢
    		ZMODEM_CHECK_ZDLE(&Stack_Zm, i);
    		}
    		else{
    			start --;
    		}
    	}

		if(i > 0){

		if(!ZMODEM_CRC16_CHECK_DATA(&Stack_Zm,i)) //  CRC
		{

		  if(scanStack(&Stack_Zm, i-2) == ZCRCG){

		  deleteGropPopDataStack(&Stack_Zm,3);

		  for(uint32_t j = 0; j < i - 2; j ++){
			  pushBufWriteZmodem(&BufWriteZmodem, Stack_Zm.data[j]);
		  }

		  numberByteReceived += (i - 2);

		  start = 0;

		  clearStack(&Stack_Zm);

		  break;
		}

		if(scanStack(&Stack_Zm, i-2) == ZCRCE){

			deleteGropPopDataStack(&Stack_Zm,3);

			for(uint32_t j = 0; j < i - 2; j ++){
				pushBufWriteZmodem(&BufWriteZmodem, Stack_Zm.data[j]);
			}

			writeBufZmodem(&BufWriteZmodem);

			clearStack(&Stack_Zm);

			clearBufZmodem(&BufWriteZmodem);

			numberByteReceived += (i - 2);

			start = 0;

			modifyFileHeaderList.numberSector = placAdd.section;

			modifyFileHeaderList.crc = crcFile(0x08100000 + SIZE_CLASTER*modifyFileHeaderList.numberSector, LenDataZmodem);

				eraseHeaderFile(placAdd.head);

					writeHeaderFile((uint8_t*)&modifyFileHeaderList, placAdd.head);

			ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯

	   	    if(sizeStack(&Stack_Zm) != 0){ // ᫥騥     ⮬  
	   	    CALLSELECTFUNC;
	   	    }

	   	 break;
		}


		if(scanStack(&Stack_Zm, i-2) == ZCRCQ){

			deleteGropPopDataStack(&Stack_Zm,3);

			for(uint32_t j = 0; j < i - 2; j ++){
				pushBufWriteZmodem(&BufWriteZmodem,Stack_Zm.data[j]);
			}

			clearStack(&Stack_Zm);

			numberByteReceived += (i - 2);

		    start = 0;

		    GoodOffset = numberByteReceived;

		    rZModem_sendHexHeader(ZACK); // ⢥ ACK

	   	 break;
		}

		}

		}
    }

}


void ZMODEM_ZEOF(void)
{
	uint8_t i = 0;
	if(scanStack(&Stack_Zm, 0) == ZPAD && scanStack(&Stack_Zm, 1) == ZPAD && scanStack(&Stack_Zm, 2) == ZDLE && scanStack(&Stack_Zm, 3) == ZHEX){

			uint8_t bufcomand[7];
			memset(bufcomand,0,sizeof(bufcomand)); // 㡨   
			uint8_t counterComand = 0;

	         for(i = 0; i < 14; i += 2){
	        	 bufcomand[counterComand++] = rZModem_getNextHexCh(scanStack(&Stack_Zm, 4 + i), scanStack(&Stack_Zm, 4 + i + 1)); // 21 22 23 24
	         }

	         if(!rZModem_crcUpdate(bufcomand,counterComand)){
	        	 if(bufcomand[0] == ZEOF){

	     		if(scanStack(&Stack_Zm, 18) == (CRZ^0x80) && scanStack(&Stack_Zm, 19) == (LF^0x80) && scanStack(&Stack_Zm, 20)== XON) // 諨 ᫥  騥   
	     		{
	     		clearStack(&Stack_Zm);
	     		}

	        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
	        	 rZModem_sendHexHeader(ZRINIT); // ⢥  ZEOF
	        	 }
	         }
       }
}


void ZMODEM_ZFIN(void) // 襫  ZFINE
{
	uint8_t buf[64]; //  襣 ࠧ
	memset(buf,0,sizeof(buf)); // ⪠ 

	for(uint8_t i = 0; i < sizeStack(&Stack_Zm); i++){
		buf[i] = scanStack(&Stack_Zm,i);
	}

	if(buf[0] == ZPAD && buf[1] == ZPAD && buf[2] == ZDLE && buf[3] == ZHEX){ // hex ଠ "ZPAD , ZPAD, ZDLE, ZHEX"

		if(buf[18] == (CRZ^0x80) && buf[19] == (LF^0x80)) // 諨 ᫥  騥   
		{
			uint8_t bufcomand[7];
			memset(bufcomand,0,sizeof(bufcomand)); // 㡨   
         for(uint8_t i = 0; i < 7; i++){
        	 bufcomand[i] = rZModem_getNextHexCh(buf[4 + i*2], buf[4 + i*2 + 1]); // 4 5   6 7   8 9    10 11    12 13  14 15    16 17
         }
         if(!rZModem_crcUpdate(bufcomand,7)){
        	 if(bufcomand[0] == ZFIN){
        	 deleteGropDataStack(&Stack_Zm, 20); // ⪠ ⥪
        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
        	 rZModem_sendHexHeader(ZFIN); // ⢥  ZFIN
        	 updateDispZmodem = 1;
        	 }
         }
         else{
          clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
          ZMODEMChange(&z_s1i1); //  諮 crc 稭 ᭠砫
         }

		}
	}
	else{
		if(!(buf[18] == 0 && buf[19] == 0 && buf[20]== 0)){
		clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
		ZMODEMChange(&z_s1i1); // 訡 頥  ஬ 
		}
	}
}


void ZMODEM_OO(void) // 襫  "OO"
{
 if(scanStack(&Stack_Zm,0) == 'O' && scanStack(&Stack_Zm,1) == 'O'){
	clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
	ZMODEMChange(ZMODEM_NEXT); // 頥   ⠯ ᪠஢
	blockingWorkMenu = 0;
	GoodOffset = 0;
 }
}



void ZMODEM_TX_ZRQINIT(void) // ।   ZMODEM ZRQINIT
{
	rZModem_sendHexHeader(ZRQINIT); // । ZRQINIT   ZRINIT
}


void ZMODEM_TX_HEADER_FILE(void) // ।  䠩
{
	memset(bufZmodemTX,0,sizeof(bufZmodemTX));
	int len = 0;
	uint16_t crc = 0;
	int32_t numFile = 0;
	char str[32], name[sizeName], textExtension[sizeTextExtension];
	memset(str, 0, sizeof(str));
	memset(name,0,sizeof(name));
	memset(textExtension,0,sizeof(textExtension));
	struct tm t;
	time_t t_of_day;
	memcpy(name, HeaderFileList[ListFileItem[Num_File]]->name, (sizeName - 1));
	memcpy(textExtension, HeaderFileList[ListFileItem[Num_File]]->textExtension, (sizeTextExtension - 1));
	snprintf(str, sizeof(str),"%s%c%s", name, '.', textExtension);

    rZModem_sendBinHeader(ZFILE);

	strcpy(ZmodemHeadFile, str);

	numFile = FileSearch(ZmodemHeadFile);

    t.tm_year = HeaderFileList[numFile]->date.year + 2000 -1900;
    t.tm_mon =  HeaderFileList[numFile]->date.mounts;
    t.tm_mday = HeaderFileList[numFile]->date.day;
    t.tm_hour = HeaderFileList[numFile]->time.hour;
    t.tm_min =  HeaderFileList[numFile]->time.min;
    t.tm_sec =  HeaderFileList[numFile]->time.sec;
    t.tm_isdst = -1;
    t_of_day = mktime(&t);

	memcpy(name, HeaderFileList[numFile]->name, (sizeName - 1));
	memcpy(textExtension, HeaderFileList[numFile]->textExtension, (sizeTextExtension - 1));

    len = snprintf((char*)bufZmodemTX, sizeof(bufZmodemTX), "%s%s%s%c%d%c%llo%c%o", name, ".",
    		     textExtension, 0,
    		(int)HeaderFileList[numFile]->size, ' ', (long long unsigned int)t_of_day, ' ', 0x81a4);

    bufZmodemTX[len] = ZCRCW;

    crc = rZModem_crcUpdate(bufZmodemTX,len+1);

    bufZmodemTX[len] = ZDLE;

    bufZmodemTX[++len] = ZCRCW;

	ZsendByte = ZSend_Byte((crc >> 8) & 0xff);
		if(ZsendByte.retur){
			bufZmodemTX[++len] = ZsendByte.data[0];
			bufZmodemTX[++len] = ZsendByte.data[1];
					}
					else{
						bufZmodemTX[++len] = ZsendByte.data[1];
						}


		ZsendByte = ZSend_Byte(crc & 0xff);
			if(ZsendByte.retur){
				bufZmodemTX[++len] = ZsendByte.data[0];
				bufZmodemTX[++len] = ZsendByte.data[1];
						}
						else{
							bufZmodemTX[++len] = ZsendByte.data[1];
							}
								len ++;

    rZmodemTxUsb(bufZmodemTX, len);

	ZMODEMChange(ZMODEM_NEXT);
}


void ZMODEM_TX_ZRPOS(void) // ਥ ZRPOS
{
	uint8_t i = 0;
	if(scanStack(&Stack_Zm, 0) == ZPAD && scanStack(&Stack_Zm, 1) == ZPAD && scanStack(&Stack_Zm, 2) == ZDLE && scanStack(&Stack_Zm, 3) == ZHEX){

			uint8_t bufcomand[7];
			memset(bufcomand,0,sizeof(bufcomand)); // 㡨   
			uint8_t counterComand = 0;

	         for(i = 0; i < 14; i += 2){
	        	 bufcomand[counterComand++] = rZModem_getNextHexCh(scanStack(&Stack_Zm, 4 + i), scanStack(&Stack_Zm, 4 + i + 1)); // 21 22 23 24
	         }

	         if(!rZModem_crcUpdate(bufcomand,counterComand)){
	        	 if(bufcomand[0] == ZRPOS){

	     		if(scanStack(&Stack_Zm, 18) == (CRZ^0x80) && scanStack(&Stack_Zm, 19) == (LF^0x80) && scanStack(&Stack_Zm, 20)== XON) // 諨 ᫥  騥   
	     		{
	     		clearStack(&Stack_Zm);
	     		}
	        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
	        	 }
	         }
       }
}


void ZMODEM_TX_ZDATA(void) // ।  ZDATA
{
	 rZModem_sendBinHeader(ZDATA);
	 	 ZMODEMChange(ZMODEM_NEXT);
}


void ZMODEM_TX_DATA(void) //
{
	uint32_t adrr = 0;
	uint32_t i = 0,
			len = 0,
			countSendData = 0;
	int32_t size = 0, quant = 0, numFile = 0;
	uint16_t CRC16 = 0;

	numFile = FileSearch(ZmodemHeadFile);

	if(numFile >= 0){

	adrr = 	HeaderFileList[numFile]->numberSector * 4096 + ADDR_FLASH_SECTOR_0_BANK2;

	GoodOffset = HeaderFileList[numFile]->size;

	if(HeaderFileList[numFile]->size < 980){

		len = HeaderFileList[numFile]->size;

		memcpy(zmodemRxBuf, (uint8_t*)adrr, len);

			zmodemRxBuf[len] = ZCRCE;

				CRC16 = Calculate_CRC_CCITT(zmodemRxBuf, len + 1);

		for(i = 0; i < len; i++){

			ZsendByte = ZSend_Byte(*(uint8_t*)(adrr + i));
				if(ZsendByte.retur){
					zmodemRxBuf[countSendData] = ZsendByte.data[0];
							zmodemRxBuf[++countSendData] = ZsendByte.data[1];
							}
							else{
									zmodemRxBuf[countSendData] = ZsendByte.data[1];
								}
										countSendData ++;
		}
		zmodemRxBuf[countSendData] = ZDLE;
			zmodemRxBuf[++countSendData] = ZCRCE;
				ZsendByte = ZSend_Byte((CRC16 >> 8) & 0xff);
					if(ZsendByte.retur){
						zmodemRxBuf[++countSendData] = ZsendByte.data[0];
							zmodemRxBuf[++countSendData] = ZsendByte.data[1];

					}
					else{
						zmodemRxBuf[++countSendData] = ZsendByte.data[1];
					}

						ZsendByte = ZSend_Byte(CRC16 & 0xff);
							if(ZsendByte.retur){
								zmodemRxBuf[++countSendData] = ZsendByte.data[0];
									zmodemRxBuf[++countSendData] = ZsendByte.data[1];

								}
								else{
										zmodemRxBuf[++countSendData] = ZsendByte.data[1];
									}

							rZmodemTxUsb(zmodemRxBuf, countSendData+1);

	}else{
		quant = 1;

		size = HeaderFileList[numFile]->size;

		while(size > (980 * quant))
		{
			len = 980;
			countSendData = 0;

			memcpy(zmodemRxBuf, (uint8_t*)adrr, len);
			zmodemRxBuf[len] = ZCRCG;
			CRC16 = Calculate_CRC_CCITT(zmodemRxBuf, len + 1);

			for(i = 0; i < len; i++){

				ZsendByte = ZSend_Byte(*(uint8_t*)(adrr + i));
					if(ZsendByte.retur){
						zmodemRxBuf[countSendData] = ZsendByte.data[0];
								zmodemRxBuf[++countSendData] = ZsendByte.data[1];
								}
								else{
										zmodemRxBuf[countSendData] = ZsendByte.data[1];
									}
											countSendData ++;
			}
			zmodemRxBuf[countSendData] = ZDLE;
				zmodemRxBuf[++countSendData] = ZCRCG;
					ZsendByte = ZSend_Byte((CRC16 >> 8) & 0xff);
						if(ZsendByte.retur){
							zmodemRxBuf[++countSendData] = ZsendByte.data[0];
								zmodemRxBuf[++countSendData] = ZsendByte.data[1];

						}
						else{
							zmodemRxBuf[++countSendData] = ZsendByte.data[1];
						}

							ZsendByte = ZSend_Byte(CRC16 & 0xff);
								if(ZsendByte.retur){
									zmodemRxBuf[++countSendData] = ZsendByte.data[0];
										zmodemRxBuf[++countSendData] = ZsendByte.data[1];

									}
									else{
											zmodemRxBuf[++countSendData] = ZsendByte.data[1];
										}
												rZmodemTxUsb(zmodemRxBuf, countSendData+1);

											adrr = 	HeaderFileList[numFile]->numberSector * 4096 + ADDR_FLASH_SECTOR_0_BANK2 + 980*quant;
												quant ++;
		}

		quant --;
		adrr = 	HeaderFileList[numFile]->numberSector * 4096 + ADDR_FLASH_SECTOR_0_BANK2 + 980*quant;

		len = HeaderFileList[numFile]->size - 980 * quant;
		countSendData = 0;

		memcpy(zmodemRxBuf, (uint8_t*)adrr, len);

			zmodemRxBuf[len] = ZCRCE;

				CRC16 = Calculate_CRC_CCITT(zmodemRxBuf, len + 1);

		for(i = 0; i < len; i++){

			ZsendByte = ZSend_Byte(*(uint8_t*)(adrr + i));
				if(ZsendByte.retur){
					zmodemRxBuf[countSendData] = ZsendByte.data[0];
							zmodemRxBuf[++countSendData] = ZsendByte.data[1];
							}
							else{
									zmodemRxBuf[countSendData] = ZsendByte.data[1];
								}
										countSendData ++;
		}
		zmodemRxBuf[countSendData] = ZDLE;
			zmodemRxBuf[++countSendData] = ZCRCE;
				ZsendByte = ZSend_Byte((CRC16 >> 8) & 0xff);
					if(ZsendByte.retur){
						zmodemRxBuf[++countSendData] = ZsendByte.data[0];
							zmodemRxBuf[++countSendData] = ZsendByte.data[1];

					}
					else{
						zmodemRxBuf[++countSendData] = ZsendByte.data[1];
					}

						ZsendByte = ZSend_Byte(CRC16 & 0xff);
							if(ZsendByte.retur){
								zmodemRxBuf[++countSendData] = ZsendByte.data[0];
									zmodemRxBuf[++countSendData] = ZsendByte.data[1];

								}
								else{
										zmodemRxBuf[++countSendData] = ZsendByte.data[1];
									}

									rZmodemTxUsb(zmodemRxBuf, countSendData+1);
	}
	  ZMODEMChange(ZMODEM_NEXT);

	  	  rZModem_sendHexHeader(ZEOF); // ਧ  䠩
	}

}


void ZMODEM_TX_ZRINIT(void) // 祭 ZRINIT
{
	uint8_t buf[64]; //  襣 ࠧ
	memset(buf,0,sizeof(buf));

	uint8_t bufcomand[7];
	memset(bufcomand,0,sizeof(bufcomand)); // 㡨   

	for(uint8_t i = 0; i < sizeStack(&Stack_Zm); i++){
		buf[i] = scanStack(&Stack_Zm,i);
	}

	if(buf[0] == ZPAD && buf[1] == ZPAD && buf[2] == ZDLE && buf[3] == ZHEX){ // hex ଠ "ZPAD , ZPAD, ZDLE, ZHEX"

		if(buf[18] == (CRZ^0x80) && buf[19] == (LF^0x80) && buf[20]== XON) // 諨 ᫥  騥   
		{
         for(uint8_t i = 0; i < 7; i++){
        	 bufcomand[i] = rZModem_getNextHexCh(buf[4 + i*2], buf[4 + i*2 + 1]);
         }
         if(!rZModem_crcUpdate(bufcomand,7)){
        	 if(bufcomand[0] == ZRINIT){
        	 clearStack(&Stack_Zm); // ⪠ ⥪
        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
        	 rZModem_sendHexHeader(ZFIN); // ⢥  ZRQINIT
        	 }
         }
         else{
          clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
          ZMODEMChange(&z_s1i1); //  諮 crc 稭 ᭠砫
         }

		}
	}
}


void ZMODEM_TX_ZFIN(void)   // 襫  ZFINE
{
	uint8_t buf[64]; //  襣 ࠧ
	memset(buf,0,sizeof(buf)); // ⪠ 

	for(uint8_t i = 0; i < sizeStack(&Stack_Zm); i++){
		buf[i] = scanStack(&Stack_Zm,i);
	}

	if(buf[0] == ZPAD && buf[1] == ZPAD && buf[2] == ZDLE && buf[3] == ZHEX){ // hex ଠ "ZPAD , ZPAD, ZDLE, ZHEX"

		if(buf[18] == (CRZ^0x80) && buf[19] == (LF^0x80)) // 諨 ᫥  騥   
		{
			uint8_t bufcomand[7];
			memset(bufcomand,0,sizeof(bufcomand)); // 㡨   
         for(uint8_t i = 0; i < 7; i++){
        	 bufcomand[i] = rZModem_getNextHexCh(buf[4 + i*2], buf[4 + i*2 + 1]); // 4 5   6 7   8 9    10 11    12 13  14 15    16 17
         }
         if(!rZModem_crcUpdate(bufcomand,7)){
        	 if(bufcomand[0] == ZFIN){
        	 clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
        	 ZMODEMChange(ZMODEM_NEXT); // 室  ᫥騩 ⠯
        	 }
         }
         else{
          clearStack(&Stack_Zm); // ⪠ ᥣ ⥪  直 砩
          ZMODEMChange(&z_s1i1); //  諮 crc 稭 ᭠砫
         }

		}
	}
}


void ZMODEM_TX_OO(void) // । "OO"
{
	bufZmodemTX[0] = 'O';
	bufZmodemTX[1] = 'O';
	rZmodemTxUsb(bufZmodemTX,2);
	blockingWorkMenu = 0;
	ZMODEMChange(&z_s1i1);
}

