#include <string.h>
#include "SysVar.h"
#include "byte_code.h"

_SysMem SysMem __attribute__((section(".D1"))) = {0};
Mcalc MCALC __attribute__((section(".D1"))) = {0};
_BinFileHead *BinFileHead;
_Manager Manager /*__attribute__((section(".SYS")))*/;

const headerFileList *HeaderFileList[sizeFileSystem];

_DimData *DimData;
_modifyFileHeaderList modifyFileHeaderList __attribute__((section(".dma_buffer"))) = {{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
																					  {0,0,0,0},
																					  0,
																					  {{0,0,0}},
																					  {{0,0,0,0}},
																					  0,0,
																					  {0,0,0,0,0}};
_RtcTime Rtctime __attribute__((section(".dma_buffer"))) = {0,0,0,0};
_RtcData Rtcdata __attribute__((section(".dma_buffer"))) = {0,0,0,0};
uint32_t ByteCode = 0;
_StrCalc StrCalc __attribute__((section(".dma_buffer"))) = {{"","","",""},0};
_FORNEXT FORNEXT __attribute__((section(".dma_buffer"))) = {0};
_popFornext popFornext __attribute__((section(".dma_buffer"))) = {0,0,0.0,0.0};

_retTxDispData retTxDispData __attribute__((section(".dma_buffer"))) = {0,0,0,0};

_txDispData txDispData = {0};

_DispDataUpdate DispDataUpdate __attribute__((section(".dma_buffer")));

_UpdateMonitor UpdateMonitor __attribute__((section(".dma_buffer")));

_typeDigit typeDigit = {0};

_StackCommandExternalDevice StackCommandExternalDevice;

_Subprog Subprog;

_inputDataKeyboard inputDataKeyboard;

_StrVarData *StrVarData;

__attribute__((section(".dma_buffer")))
uint8_t ExternalsBlocks_TX[256]; //  ।    譥 
__attribute__((section(".dma_buffer")))
uint8_t ExternalsBlocks_RX[256]; //  ਥ    譥 

TERM MirrorDISP[30][95] __attribute__((section(".dma_buffer")));

__attribute__((section(".dma_buffer")))
uint8_t EEPROM_TX[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
__attribute__((section(".dma_buffer")))
uint8_t EEPROM_RX[16] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

uint32_t RESTORE = 0;

uint32_t LineNum = 0;

uint32_t AddressBeginByteCode = 0;  //  砫  㤠 稭  
uint32_t AddressExecByteCode = 0; //  믮  
uint32_t AddressOffsetByteCode = 0; //  ᬥ饭
uint32_t stepExecBeteCode = 0; // 蠣 믠  

uint32_t lenRx = 0, lenTx = 0; //   । 

int32_t addrRegRx = 0;

uint32_t counterExternTx = 0;

uint32_t NumberWindows    = 0;
uint32_t ExecWindows = 0;
int32_t xGrid[4]   = {0,0,0,0};
int32_t yGrid[4]   = {0,0,0,0};
int32_t colorF[4] = {7,7,7,7};
int32_t colorB[4] = {0,0,0,0};

__attribute__((section(".dma_buffer")))
uint8_t bufTxUSB[64]  = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
						 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
						 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
						 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

uint32_t sizeTXUSB = 0;

char lastCharacterEntered = 0;
uint16_t FntBool = 0;


 uint8_t  typeAdr = 0;
 uint32_t adrrMem = 0;
 uint32_t addrSysMem = 0;
 uint32_t addrSTATDATA = 0;


_InputEcho *InputEcho[4];


__attribute__((section(".dma_buffer")))
uint8_t USART1_RX[256] = {0};
__attribute__((section(".dma_buffer")))
uint8_t USART1_TX[256] = {0};


const char *errorText[] = {
		"   ᨢ",
		"९ ⨬᪮ ",
		"९ ப ",
		"९ ⥪   ணࠬ",
		"९ ⥪ for-next",
		"  for-next",
		" ୠ ஫쭠 㬬",
};


funcByteCode fn[] =
{
[0x1]  = END,
[0x2]  = RUN,
[0x3]  = STOP,
[0xff] = ESC,
[0x4]  = NEWS,
[0x5]  = EDIT,
[0x41] = ADD ,
[0x42] = ADDI,
[0x43] = ADDF,
[0x44] = SUB,
[0x45] = SUBI,
[0x46] = SUBF,
[0x47] = MUL,
[0x48] = MULI,
[0x49] = MULF,
[0x4a] = DIV,
[0x4b] = DIVI,
[0x4c] = DIVF,
[0x4d] = DIVM,
[0x4e] = SQR,
[0x4f] = POW,
[0x50] = LOG,
[0x51] = LN,
[0x52] = SIN,
[0x53] = COS,
[0x54] = TAN,
[0x55] = ASIN,
[0x56] = ACOS,
[0x57] = ATAN,
[0x58] = ABS,
[0x59] = ABSI,
[0x5a] = ABSF,
[0x5b] = FIX,
[0x5c] = SIGN,
[0x5d] = RND,
[0x5e] = SCL,
[0x5f] = TOI,
[0x60] = TOF,
[0x61] = SWAP,
[0x62] = FIXI,
[0x63] = FIXF,
[0x64] = SET0,
[0x65] = SET1,
[0x66] = SET2,
[0x67] = EQU,
[0x68] = NEQU,
[0x69] = MORE,
[0x6a] = LESS,
[0x6b] = MRE,
[0x6c] = LSE,
[0x6d] = NOT,
[0x6e] = AND,
[0x6f] = ORL,
[0x70] = XOR,
[0x71] = EQV,
[0x72] = RLX,
[0x73] = RRX,
[0x74] = RVI,
[0x75] = WVI,
[0x76] = RVF,
[0x77] = WVF,
[0x78] = RDN,
[0x79] = RDS,
[0x7a] = REST,
[0x7b] = MIR,
[0x7c] = MIW,
[0x7d] = MFR,
[0x7e] = MFW,
[0x7f] = DUB,
[0x81] = BITR,
[0x82] = BTWI,
[0x83] = BTWF,
[0x84] = FIXA,
[0x85] = FIXD,
[0x86] = INV,
[0x90] = RSTR,
[0x91] = WSTR,
[0x92] = SETS,
[0x93] = CAT,
[0x94] = EQS,
[0x95] = NEQS,
[0x96] = MRS,
[0x97] = LSS,
[0x98] = MRES,
[0x99] = LSES,
[0x9a] = STRF,
[0x9b] = STR,
[0x9c] = BINS,
[0x9d] = HEXS,
[0x9e] = MID,
[0x9f] = LEN,
[0xa0] = MSR,
[0xa1] = MSW,
[0xa2] = VAL,
[0xa3] = ASC,
[0xa4] = CHR,
[0xb0] = GOTO,
[0xb1] = GOSB,
[0xb2] = IFGO,
[0xb3] = RET,
[0xb4] = FOR,
[0xb5] = NEXT,
[0xb6] = SWGO,
[0xb7] = SWGS,
[0xc0] = ATC,
[0xc1] = SCR,
[0xc2] = CLS,
[0xc3] = INK,
[0xc4] = PAP,
[0xc5] = PST,
[0xc6] = STIN,
[0xc7] = INPT,
[0xc8] = INKS,
[0xc9] = PCST,
[0xd0] = MBO,
[0xd1] = MBI,
[0xd2] = EPRW,
[0xd3] = EPRR,
[0xca] = BPST,
[0xcb] = BCST,
[0xcc] = FNT
};



const _DimData fSysDimData[]= {
    {2,  1,  0x00300000,   {32, 0,    0,   0}},  // DIO00
    {2,  1,  0x00300040,   {32, 0,    0,   0}},  // DIO01
    {2,  1,  0x00300080,   {32, 0,    0,   0}},  // DIO02
    {2,  1,  0x003000c0,   {32, 0,    0,   0}},  // DIO03
    {2,  1,  0x00300100,   {32, 0,    0,   0}},  // DIO04
    {2,  1,  0x00300140,   {32, 0,    0,   0}},  // DIO05
    {2,  1,  0x00300180,   {32, 0,    0,   0}},  // DIO06
    {2,  1,  0x003001c0,   {32, 0,    0,   0}},  // DIO07
    {2,  1,  0x00300200,   {32, 0,    0,   0}},  // DIO08
    {2,  1,  0x00300240,   {32, 0,    0,   0}},  // DIO09
    {2,  1,  0x00300280,   {32, 0,    0,   0}},  // DIO10
    {2,  1,  0x003002c0,   {32, 0,    0,   0}},  // DIO11
    {2,  1,  0x00300300,   {32, 0,    0,   0}},  // DIO12
    {2,  1,  0x00300340,   {32, 0,    0,   0}},  // DIO13
    {2,  1,  0x00300380,   {32, 0,    0,   0}},  // DIO14
    {2,  1,  0x003003c0,   {32, 0,    0,   0}},  // DIO15
    {2,  1,  0x00300400,   {32, 0,    0,   0}},  // DIO16
    {2,  1,  0x00300440,   {32, 0,    0,   0}},  // DIO17
    {2,  1,  0x00300480,   {32, 0,    0,   0}},  // DIO18
    {2,  1,  0x003004c0,   {32, 0,    0,   0}},  // DIO19
    {2,  1,  0x00300500,   {32, 0,    0,   0}},  // DIO20
    {2,  1,  0x00300540,   {32, 0,    0,   0}},  // DIO21
    {2,  1,  0x00300580,   {32, 0,    0,   0}},  // DIO22
    {2,  1,  0x003005c0,   {32, 0,    0,   0}},  // DIO23
    {2,  1,  0x00300600,   {32, 0,    0,   0}},  // DIO24
    {2,  1,  0x00300640,   {32, 0,    0,   0}},  // DIO25
    {2,  1,  0x00300680,   {32, 0,    0,   0}},  // DIO26
    {2,  1,  0x003006c0,   {32, 0,    0,   0}},  // DIO27
    {2,  1,  0x00300700,   {32, 0,    0,   0}},  // DIO28
    {2,  1,  0x00300740,   {32, 0,    0,   0}},  // DIO29
    {2,  1,  0x00300780,   {32, 0,    0,   0}},  // DIO30
    {2,  1,  0x003007c0,   {32, 0,    0,   0}},  // DIO31
    {2,  1,  0x00300800,   {32, 0,    0,   0}},  // DIO32
    {2,  1,  0x00300840,   {32, 0,    0,   0}},  // DIO33
    {2,  1,  0x00300880,   {32, 0,    0,   0}},  // DIO34
    {2,  1,  0x003008c0,   {32, 0,    0,   0}},  // DIO35
    {2,  1,  0x00300900,   {32, 0,    0,   0}},  // DIO36
    {2,  1,  0x00300940,   {32, 0,    0,   0}},  // DIO37
    {2,  1,  0x00300980,   {32, 0,    0,   0}},  // DIO38
    {2,  1,  0x003009c0,   {32, 0,    0,   0}},  // DIO39
    {2,  1,  0x00300a00,   {32, 0,    0,   0}},  // DIO40
    {2,  1,  0x00300a40,   {32, 0,    0,   0}},  // DIO41
    {2,  1,  0x00300a80,   {32, 0,    0,   0}},  // DIO42
    {2,  1,  0x00300ac0,   {32, 0,    0,   0}},  // DIO43
    {2,  1,  0x00300b00,   {32, 0,    0,   0}},  // DIO44
    {2,  1,  0x00300b40,   {32, 0,    0,   0}},  // DIO45
    {2,  1,  0x00300b80,   {32, 0,    0,   0}},  // DIO46
    {2,  1,  0x00300bc0,   {32, 0,    0,   0}},  // DIO47
    {2,  1,  0x00300c00,   {32, 0,    0,   0}},  // DIO48
    {2,  1,  0x00300c40,   {32, 0,    0,   0}},  // DIO49
    {2,  1,  0x00300c80,   {32, 0,    0,   0}},  // DIO50
    {2,  1,  0x00300cc0,   {32, 0,    0,   0}},  // DIO51
    {2,  1,  0x00300d00,   {32, 0,    0,   0}},  // DIO52
    {2,  1,  0x00300d40,   {32, 0,    0,   0}},  // DIO53
    {2,  1,  0x00300d80,   {32, 0,    0,   0}},  // DIO54
    {2,  1,  0x00300dc0,   {32, 0,    0,   0}},  // DIO55
    {2,  1,  0x00300e00,   {32, 0,    0,   0}},  // DIO56
    {2,  1,  0x00300e40,   {32, 0,    0,   0}},  // DIO57
    {2,  1,  0x00300e80,   {32, 0,    0,   0}},  // DIO58
    {2,  1,  0x00300ec0,   {32, 0,    0,   0}},  // DIO59
    {2,  1,  0x00300f00,   {32, 0,    0,   0}},  // DIO60
    {2,  1,  0x00300f40,   {32, 0,    0,   0}},  // DIO61
    {2,  1,  0x00300f80,   {32, 0,    0,   0}},  // DIO62
    {2,  1,  0x00300fc0,   {32, 0,    0,   0}},  // DIO63
    {2,  1,  0x00301000,  {128, 0,    0,   0}},  // DIO64
    {2,  1,  0x00301100,  {128, 0,    0,   0}},  // DIO65
    {2,  1,  0x00301200,  {128, 0,    0,   0}},  // DIO66
    {2,  1,  0x00301300,  {128, 0,    0,   0}},  // DIO67
    {2,  1,  0x00301400,  {128, 0,    0,   0}},  // DIO68
    {2,  1,  0x00301500,  {128, 0,    0,   0}},  // DIO69
    {2,  1,  0x00301600,  {128, 0,    0,   0}},  // DIO70
    {2,  1,  0x00301700,  {128, 0,    0,   0}},  // DIO71
    {2,  1,  0x00301800,  {128, 0,    0,   0}},  // DIO72
    {2,  1,  0x00301900,  {128, 0,    0,   0}},  // DIO73
    {2,  1,  0x00301a00,  {128, 0,    0,   0}},  // DIO74
    {2,  1,  0x00301b00,  {128, 0,    0,   0}},  // DIO75
    {2,  1,  0x00301c00,  {128, 0,    0,   0}},  // DIO76
    {2,  1,  0x00301d00,  {128, 0,    0,   0}},  // DIO77
    {2,  1,  0x00301e00,  {128, 0,    0,   0}},  // DIO78
    {2,  1,  0x00301f00,  {128, 0,    0,   0}},  // DIO79
    {2,  1,  0x00302000,  {128, 0,    0,   0}},  // DIO80
    {2,  1,  0x00302100,  {128, 0,    0,   0}},  // DIO81
    {2,  1,  0x00302200,  {128, 0,    0,   0}},  // DIO82
    {2,  1,  0x00302300,  {128, 0,    0,   0}},  // DIO83
    {2,  1,  0x00302400,  {128, 0,    0,   0}},  // DIO84
    {2,  1,  0x00302500,  {128, 0,    0,   0}},  // DIO85
    {2,  1,  0x00302600,  {128, 0,    0,   0}},  // DIO86
    {2,  1,  0x00302700,  {128, 0,    0,   0}},  // DIO87
    {2,  1,  0x00302800,  {128, 0,    0,   0}},  // DIO88
    {2,  1,  0x00302900,  {128, 0,    0,   0}},  // DIO89
    {2,  1,  0x00302a00,  {128, 0,    0,   0}},  // DIO90
    {2,  1,  0x00302b00,  {128, 0,    0,   0}},  // DIO91
    {2,  1,  0x00302c00,  {128, 0,    0,   0}},  // DIO92
    {2,  1,  0x00302d00,  {128, 0,    0,   0}},  // DIO93
    {2,  1,  0x00302e00,  {128, 0,    0,   0}},  // DIO94
    {2,  1,  0x00302f00,  {128, 0,    0,   0}},  // DIO95
    {2,  1,  0x00303000, {4096, 0,    0,   0}},  // DIO96
    {2,  1,  0x00305000, {4096, 0,    0,   0}},  // DIO97
    {2,  1,  0x00307000, {4096, 0,    0,   0}},  // DIO98
    {2,  1,  0x00309000, {4096, 0,    0,   0}},  // DIO99
    {0,  1,  0x0030b000, {8192, 0,    0,   0}},  // GLOB
    {2,  1,  0x00313000, {4096, 0,    0,   0}}   // ASUIO
};



void callByteCode(int code) // ⨥  
{
	if(fn[code]) fn[code]();
}


void initStackMcalc(Mcalc *stack)
{
	memset(&MCALC, 0, sizeof(MCALC));
}

void pushMcalcF(Mcalc *stack, float value) //   ⥬᪨ ⥪
{
 stack->data[stack->size++].f = value;
 if(stack->size >= McalcSize)
 {
	snprintf(SysMem.ERRORS, 79, "%s",errorText[1]);
 }
 stack->size &= McalcSizeMask;
}

float popMcalcF(Mcalc *stack) //   ⥬᪮ ⥪
{
 static float val = 0.0;
 if(stack->size != 0){
 val = stack->data[--stack->size].f;
 stack->size &= McalcSizeMask;
 }
 return(val);
}

void pushMcalcI(Mcalc *stack, int16_t value) //   ⥪ int
{
	stack->data[stack->size].lo = value;
	stack->data[stack->size].hi = 0xffff;
	stack->size++;
	 if(stack->size >= McalcSize)
	 {
		snprintf(SysMem.ERRORS, 79, "%s",errorText[1]);
	 }
	stack->size &= McalcSizeMask;
}

int16_t popMcalcI(Mcalc *stack) // ⨥  ⥪ int
{
	static int16_t val = 0;
	if(stack->size != 0){
	val = stack->data[--stack->size].lo;
	stack->size &= McalcSizeMask;
	}
	return(val);
}

void pushMcalcAddr(Mcalc *stack, uint32_t value)
{
	stack->data[stack->size].i = value;
	stack->data[stack->size].b3 = 0xff;
	stack->size++;
	 if(stack->size >= McalcSize)
	 {
		snprintf(SysMem.ERRORS, 79, "%s",errorText[1]);
	 }
	stack->size &= McalcSizeMask;
}

uint32_t popMcalcAddr(Mcalc *stack)
{
	static int val = 0;
	if(stack->size != 0){
	val = (stack->data[--stack->size].i & 0xffffff);
	stack->size &= McalcSizeMask;
	}
	return(val);
}

int popHiMcalc(Mcalc *stack)
{
  if(stack->size > 0)
  {
  return(stack->data[stack->size - 1].hi);
  }
  return(0);
}


void initStrCalc()
{
	memset(&StrCalc, 0, sizeof(StrCalc));
}


void pushStrCalc(_StrCalc *stack, char *str) //   ⥪
{
	strcpy(&stack->str[stack->sizeStr][0], str);
	stack->sizeStr = stack->sizeStr + 1;
	stack->sizeStr &= 3;
}


void popStrCalc(_StrCalc *stack, char *str) // ⨥  ⥪
{
	static char *p = NULL;
	if(stack->sizeStr != 0){
	stack->sizeStr = stack->sizeStr - 1;
	p = &stack->str[stack->sizeStr][0];
	strcpy(str,p);
	memset(p, 0, 256);
	stack->sizeStr &= 3;
	}
}


void clearStrcalc(_StrCalc *stack) // ⪠ 設 ⥪
{

}


void initForNext(void)
{
	memset(&FORNEXT, 0, sizeof(FORNEXT));
}


void pushForNext( _FORNEXT *ForNext, uint32_t var, uint32_t begin, float step, float to)
{
	uint32_t i;
	for(i = 0; i < MaxQuantityForNext; i++){

		if(ForNext->FOR[i].var == var)
		{
			ForNext->FOR[i].begin = begin;
			ForNext->FOR[i].step = step;
			ForNext->FOR[i].to = to;
			return;
		}
	}

	for(i = 0; i < MaxQuantityForNext; i++)
	{
		if(ForNext->FOR[i].var == 0)
		{
			ForNext->FOR[i].var = var;
			ForNext->FOR[i].begin = begin;
			ForNext->FOR[i].step = step;
			ForNext->FOR[i].to = to;
	        return;
		}
	}
	snprintf(SysMem.ERRORS,79,"%s",errorText[5]);
}


void popForNext( _FORNEXT *ForNext, uint32_t var)
{
	uint32_t i;
	for(i = 0; i < MaxQuantityForNext; i++){

		if(ForNext->FOR[i].var == var)
		{
			popFornext.begin = ForNext->FOR[i].begin;
			popFornext.step = ForNext->FOR[i].step;
			popFornext.to = ForNext->FOR[i].to;
			return;
		}
	}
	snprintf(SysMem.ERRORS,79,"%s",errorText[4]);
}


void clearAddressForNext(_FORNEXT *ForNext, uint32_t value) //    ⥪ for-next
{
	uint32_t i;
	for(i = 0; i < MaxQuantityForNext; i++){

		if(ForNext->FOR[i].var == value)
		{
			ForNext->FOR[i].var = 0;
			ForNext->FOR[i].begin = 0;
			ForNext->FOR[i].step = 0;
			ForNext->FOR[i].to = 0;
			return;
		}
	}
}


void initSubprog(void)
{
	memset(&Subprog, 0, sizeof(Subprog));
}


void pushSubprog(_Subprog *stack, uint32_t value)
{
	stack->addr[stack->size] = value;
	stack->size++;
	stack->size &= SubprogSizeMask;
}


uint32_t popSubprog(_Subprog *stack)
{
	static int32_t val = 0;
	if(stack->size != 0){
	val = stack->addr[--stack->size];
	stack->size &= SubprogSizeMask;
	}
	return(val);
}


void managerTaskInit(void)
{
   memset(&Manager,0,sizeof(Manager));
}


uint32_t searchFile(_Manager *manager, char* str)
{
   for(int16_t i = 0; i < sizeFileSystem; i++)
   {
	   if(strncmp(&HeaderFileList[i]->textExtension[0], str, 3) == 0)
	   {
		   manager->task[0].ptr = ADDR_FLASH_SECTOR_0_BANK2 + 4096*HeaderFileList[i]->numberSector;
		   return(1); // ᫨ 襫  頥  ᥪ
	   }
   }

   return(0); // ᫨  襫 頥 
}



void searchExecFile(_Manager *manager)
{
	uint32_t number = 0;

	   for(uint32_t i = 0; i < sizeFileSystem; i++)
	   {
		   if(HeaderFileList[i]->textExtension[0] == 'b')
		   {
			   number |= (HeaderFileList[i]->textExtension[1] - '0') * 10;
			   number |= (HeaderFileList[i]->textExtension[2] - '0');

			   if(number >= 0  && number < 64)
			   {
				   manager->task[number].ptr = ADDR_FLASH_SECTOR_0_BANK2 + 4096 * HeaderFileList[i]->numberSector;
				   manager->size++;
			   }
			   number = 0;
		   }
	   }
}


void managerInitTaskBoo(void)
{
	Manager.task[0].attribute = 1;

	BinFileHead = (_BinFileHead*)(Manager.task[0].ptr);

	AddressBeginByteCode = Manager.task[0].ptr;

	stepExecBeteCode = 0;

	ByteCode = readByteCode(Manager.task[0].ptr + 64 + Manager.task[0].offset);

	if((ByteCode & 0xff) != 0x01){

	DimData = (_DimData*)(BinFileHead->DataDIM_adr + AddressBeginByteCode);

	uint32_t byte = 0;

	AddressOffsetByteCode = Manager.task[0].offset;

	while(1){

	byte = ByteCode & 0xff;

	if(byte != 0)
	{
	callByteCode(byte);
	}
	else{
		stepExecBeteCode ++;
		AddressExecByteCode = Manager.task[0].ptr + 4*stepExecBeteCode + 64 + AddressOffsetByteCode;
		ByteCode = readByteCode(AddressExecByteCode);

		if(ByteCode == 0x01)
		{
    	Manager.task[0].offset = BinFileHead->Begin_adr - 0x40;
    	break;
		}

		if(Manager.task[0].flagTimeout)
		{
			Manager.task[0].flagTimeout = 0;
			break;
		}
	}

	}

	}

	Manager.task[0].counterRun --;

}


void managerTask(_Manager *manager, uint32_t numberTask)
{
	if(manager->task[numberTask].counterRun > 0){

		DWT->CYCCNT = 0; // 塞 稪

		manager->task[numberTask].attribute = 1;

	    BinFileHead = (_BinFileHead*)(Manager.task[numberTask].ptr);

		AddressBeginByteCode = Manager.task[numberTask].ptr;

		DimData = (_DimData*)(BinFileHead->DataDIM_adr + AddressBeginByteCode);

		stepExecBeteCode = 0;

		uint32_t byte = 0;

		AddressOffsetByteCode = Manager.task[numberTask].offset;

		ByteCode = readByteCode(Manager.task[numberTask].ptr + 64 + Manager.task[numberTask].offset);

		while(1){

		byte = ByteCode & 0xff;

		if(byte != 0){

		callByteCode(byte);

		}
		else{

		stepExecBeteCode ++;

		AddressExecByteCode = Manager.task[numberTask].ptr + 4*stepExecBeteCode + 64 + AddressOffsetByteCode;

	    ByteCode = readByteCode(AddressExecByteCode);

	    if(ByteCode == 0x01){
	    	Manager.task[numberTask].offset = BinFileHead->Begin_adr - 0x40;
	    	break;
	    }

	    if(ByteCode == 0xff)
	    {
	    	startFileSystem();
	    	break;
	    }

	    if(ByteCode == 0x5)
	    {
	    	break;
	    }

		}

		if(Manager.task[numberTask].flagTimeout)
		{
			Manager.task[numberTask].flagTimeout = 0;
			break;
		}

		}

		manager->task[numberTask].counterRun --;
		manager->task[numberTask].attribute = 0;
		if(manager->task[numberTask].counterRun == 0)
		{
			manager->queueTask --;
		}

		manager->timeExecTask += (((float)DWT->CYCCNT)/480000000);
	}
}


float calcAddrVarF(uint32_t addr)
{
   typeAdr = (addr & 0xf00000) >> 20 ;
   adrrMem = addr & 0xFFFFF;
   addrSysMem   = (uint32_t)&SysMem;
   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

   static float var = 0.0;

   switch(typeAdr){
   case 0x0:  var = *(float*)adrrMem;
	   break;

   case 0x1:  var = *(__IO float*)(adrrMem + ADDR_FLASH_SECTOR_0_BANK1);
	   break;

   case 0x2:  var = *(__IO float*)(adrrMem + ADDR_FLASH_SECTOR_0_BANK2);
       break;

   case 0x3:  var = *(__IO float*)(addrSysMem + adrrMem);
	   break;

   case 0x4:  var = *(__IO float*)(addrSTATDATA + adrrMem + Manager.numberCurrentTask*0x800);
	   break;

   case 0x5:  var = *(__IO float*)(BinFileHead->NumConst_adr + AddressBeginByteCode + adrrMem);
	   break;

   case 0x6:  var = *(__IO float*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem);
	   break;
   }

   return(var);
}


uint16_t calcAddrVarI(uint32_t addr) // ᫥   㤠  ६ int
{
   typeAdr = (addr & 0xf00000) >> 20 ;
   adrrMem = addr & 0xFFFFF;
   addrSysMem = (uint32_t)&SysMem;
   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

   static uint16_t var = 0;

   switch(typeAdr){

   case 0x0: var = *(__IO uint16_t*) adrrMem;
	   break;

   case 0x1: var = *(__IO uint16_t*) (adrrMem + ADDR_FLASH_SECTOR_0_BANK1);
	   break;

   case 0x2: var = *(__IO uint16_t*) (adrrMem + ADDR_FLASH_SECTOR_0_BANK2);
       break;

   case 0x3: var = *(__IO uint16_t*)(addrSysMem + adrrMem);
	   break;

   case 0x4: var = *(__IO uint16_t*)(addrSTATDATA + adrrMem + Manager.numberCurrentTask*0x800);
	   break;

   case 0x5: var = *(__IO uint16_t*)(BinFileHead->NumConst_adr + AddressBeginByteCode + adrrMem);
	   break;

   case 0x6: var = *(__IO uint16_t*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem);
	   break;
   }

   return(var);
}


void SetCalcAddrVarI(uint32_t addr, __IO uint16_t var)// ᫨ 㤠 뢠  ६ int
{
   typeAdr = (addr & 0xf00000) >> 20;
   adrrMem = addr & 0xFFFFF;
   addrSysMem = (uint32_t)&SysMem;
   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

   switch(typeAdr){

   case 0x0:  *(__IO uint16_t*) addr = var;
	   break;

   case 0x3: *(__IO uint16_t*)(addrSysMem + adrrMem) = var;
	   break;

   case 0x4: *(__IO uint16_t*)(addrSTATDATA + adrrMem + Manager.numberCurrentTask*0x800) = var;
	   break;

   case 0x5: *(__IO uint16_t*)(BinFileHead->NumConst_adr + AddressBeginByteCode + addr) = var;
	   break;

   case 0x6: *(__IO uint16_t*)(BinFileHead->StrConst_adr + AddressBeginByteCode + addr) = var;
	   break;
   }

}


void SetCalcAddrVarF(uint32_t addr, __IO float var) // ᫨ 㤠 뢠  ६ float
{
   typeAdr = (addr & 0xf00000) >> 20;
   adrrMem = addr & 0xFFFFF;
   addrSysMem = (uint32_t)&SysMem;
   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

   switch(typeAdr){

   case 0x0:  *(__IO uint32_t*) adrrMem = var;
	   break;

   case 0x3: *(__IO float*)(addrSysMem + adrrMem) = var;
	   break;

   case 0x4: *(__IO float*)(addrSTATDATA + adrrMem + Manager.numberCurrentTask*0x800) = var;
	   break;

   case 0x5: *(__IO float*)(BinFileHead->NumConst_adr + AddressBeginByteCode + adrrMem) = var;
	   break;

   case 0x6: *(__IO float*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem) = var;
	   break;

   }

   //__UNALIGNED_UINT32_WRITE(BinFileHead->StrConst_adr, var);
}


void setcalcAddrStr(uint32_t addr, char *str)
{
   typeAdr = (addr & 0xf00000) >> 20;
   adrrMem = addr & 0xFFFFF;
   addrSysMem = (uint32_t)&SysMem;
   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

   static char *p = NULL;

   switch(typeAdr){

   case 0x3: p = (char*)(addrSysMem + adrrMem);
	   strcpy(p, str);
	   break;

   case 0x4: p = (char*)(addrSTATDATA + adrrMem);
	   strcpy(p,str);
	   break;
   }
}


void getCalcAddrStr(uint32_t addr, char *str)
{
	   static char *p = NULL;
	   typeAdr = (addr & 0xf00000) >> 20;
	   adrrMem = addr & 0xFFFFF;
	   addrSysMem = (uint32_t)&SysMem;
	   addrSTATDATA = (uint32_t)&SysMem.STATDATA;

	   switch(typeAdr){

	   case 0x3: p = (char*)(addrSysMem + adrrMem);
		   strcpy(str,p);
		   break;

	   case 0x4: p = (char*)(addrSTATDATA + adrrMem);
		   strcpy(str,p);
		   break;

	   case 0x6: p = (char*)(BinFileHead->StrConst_adr + AddressBeginByteCode + adrrMem);
		   strcpy(str,p);
		   break;
	   }
}


void initRNG(void)
{
	static double rnd = 0.0;
	rnd = (double)RNG->DR;
	rnd = rnd/(2147483647.0);
	SysMem.RNDVAL = (float)rnd;
}


void    initInputDataKeyboard(void)
{
	memset(&inputDataKeyboard,0,sizeof(inputDataKeyboard));
}


void    pushInputDataKeyboard(_inputDataKeyboard *stack, uint8_t value)
{
	stack->data[stack->head] = value;
	stack->head ++;
	stack->head &= 256-1;
}


uint8_t popInputDataKeyboard(_inputDataKeyboard *stack)
{
    uint8_t var = 0;
    var = stack->data[stack->tail];
	stack->tail ++;

	stack->tail  &= 256-1;
	return(var);
}


int     sizeInputDataKeyboard(_inputDataKeyboard *stack)
{
	return((stack->head - stack->tail)&(256-1));
}


void    clearInputDataKeyboard(_inputDataKeyboard *stack)
{
	stack->head = 0;
	stack->tail = 0;
}




void    initStacktxDispData(_txDispData *stack)
{
	   for(uint32_t i = 0; i < sizeTxDispData; i++)
	   {
	   stack->data[i] = 0;
	   stack->Y[i] = 0;
	   stack->X[i] = 0;
	   }
       stack->head = 0;
       stack->tail = 0;
}

void    pushtxDispData(_txDispData *stack, uint8_t value, uint8_t y, uint8_t x)
{
		stack->data[stack->head] = value;
		stack->Y[stack->head] = y;
		stack->X[stack->head] = x;
		stack->head ++;

		stack->head &= TxDispDataMask;
}

_retTxDispData poptxDispData(_txDispData *stack)
{
	    _retTxDispData Disp;
	    Disp.ch = stack->data[stack->tail];
	    Disp.y  = stack->Y[stack->tail];
	    Disp.x  = stack->X[stack->tail];
		stack->tail ++;
		stack->tail  &= TxDispDataMask;
		return(Disp);
}


_retTxDispData peektxDispData(_txDispData *stack)
{
    _retTxDispData Disp;
    Disp.ch = stack->data[stack->tail];
    Disp.y  = stack->Y[stack->tail];
    Disp.x  = stack->X[stack->tail];
	stack->tail  &= TxDispDataMask;
	return(Disp);
}


int sizeStackTxDispData(_txDispData *stack)
{
	 return((stack->head - stack->tail)&TxDispDataMask);
}

void    initStackDispDataUpdate(_DispDataUpdate *stack)
{
	   for(uint32_t i = 0; i < sizeTxDispData; i++)
	   {
	   stack->data[i] = 0;
	   }
       stack->head = 0;
       stack->tail = 0;
}

void    pushDispDataUpdate(_DispDataUpdate *stack, uint8_t value)
{
	  stack->data[stack->head] = value;
	  stack->head ++;
	  stack->head &= TxDispDataMask;
}

uint8_t popDispDataUpdate(_DispDataUpdate *stack)
{
    uint8_t var = 0;
    var = stack->data[stack->tail];
	stack->tail ++;

	stack->tail  &= TxDispDataMask;
	return(var);
}

int sizeStackDispDataUpdate(_DispDataUpdate *stack)
{
	return((stack->head - stack->tail)&TxDispDataMask);
}


void    initUpdateMonitor(void)
{
	memset(&UpdateMonitor, 0, sizeof(UpdateMonitor));
}

void    pushUpdateMonitor(_UpdateMonitor *stack, uint8_t value)
{
	  stack->data[stack->head] = value;
	  stack->head ++;
	  stack->head &= (sizeBufUpdateMonitor - 1);
}

uint8_t popUpdateMonitor(_UpdateMonitor *stack)
{
    uint8_t var = 0;
    var = stack->data[stack->tail];
    stack->tail ++;
    stack->tail  &= (sizeBufUpdateMonitor - 1);
    return(var);
}

int sizeUpdateMonitor(_UpdateMonitor *stack)
{
	return((stack->head - stack->tail)&(sizeBufUpdateMonitor - 1));
}


void    callTxDispData(void)
{
	if(STARTM != MENU_START){

	if(counterUpdateDisp < 15000)
	{
		if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED && (((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState == 0))
		{
			if(sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff)
			{
				sizeTXUSB = sizeStackTxDispData(&txDispData);
				if(sizeTXUSB >= 63)
				{
					sizeTXUSB = 63;
				}
				if(sizeTXUSB > 0)
				{
					for(uint32_t i = 0; i < sizeTXUSB; i++)
					{
					retTxDispData = poptxDispData(&txDispData);
					bufTxUSB[i] = retTxDispData.ch;
					}
					transmitDataTerminal(bufTxUSB,sizeTXUSB);
					CDC_Transmit_FS(bufTxUSB, sizeTXUSB );
				}
			}

			flagTryTransmitionUsbDisp = 0;
		}
		else
			{

			if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED && ((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState != 0)
			{
				counterTryTransmitionUsbDisp ++;

				if(counterTryTransmitionUsbDisp > 1000){
					counterTryTransmitionUsbDisp = 0;
					flagTryTransmitionUsbDisp = 1;
				}
			}

			if( flagTryTransmitionUsbDisp == 1 && (sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff) && hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED)
			{
				sizeTXUSB = sizeStackTxDispData(&txDispData);
				if(sizeTXUSB >= 63)
				{
					sizeTXUSB = 63;
				}

				if(sizeTXUSB > 0)
				{
					for(int i = 0; i < sizeTXUSB; i++)
					{
					retTxDispData = poptxDispData(&txDispData);
					bufTxUSB[i] = retTxDispData.ch;
					}
					transmitDataTerminal(bufTxUSB, sizeTXUSB);
				}
			}

				if( hUsbDeviceFS.dev_state != USBD_STATE_CONFIGURED && (sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff) )
				{
					sizeTXUSB = sizeStackTxDispData(&txDispData);
					if(sizeTXUSB >= 63)
					{
						sizeTXUSB = 63;
					}

					if(sizeTXUSB > 0)
					{
						for(int i = 0; i < sizeTXUSB; i++)
						{
						retTxDispData = poptxDispData(&txDispData);
						bufTxUSB[i] = retTxDispData.ch;
						}
						transmitDataTerminal(bufTxUSB, sizeTXUSB);
					}
				}
			}
			counterUpdateDisp ++;
	}
	else{
        if(updateDisplay() == 1)
        {
        	counterUpdateDisp = 0;
        }
	}
	}
	else{

		if(workRedactor == 1){
			//updateWindowMenu();
			asm("nop");
		}
		else{
		if(counterUpdateDisp < 5000){
				updateWindowMenu();
				counterUpdateDisp ++;
		}
		else{
	        if(fullUpdateMenuWindows() == 1){
	        	counterUpdateDisp = 0;
	        }
		}
		}
	}
}


void   transmitDataTerminal(uint8_t *buf, uint32_t size)
{
	int i, len;

	len = sizeUpdateMonitor(&UpdateMonitor);

	if(len < (sizeBufUpdateMonitor - size - 0xff))
	{
		for(i = 0; i < size; i++)
		{
		pushUpdateMonitor(&UpdateMonitor, buf[i]);
		}
	}

	if(DMA1_Stream4->NDTR == 0){

	len = sizeUpdateMonitor(&UpdateMonitor);

	if(len >= 256)
	{
	len = 256;
	}

		for(i = 0; i < len; i++)
		{
			USART1_TX[i] = popUpdateMonitor(&UpdateMonitor);
		}

	/*DMA1_Stream3->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA1_Stream3->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF3); //  䫠 뢠
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF3);
	SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF3);
	DMA1_Stream3->CR = DMA_SxCR_MINC | DMA_SxCR_TCIE ; // ன   USART3 ६ , 祭 뢠  襭 ਥ
	DMA1_Stream3->NDTR = size + 32; // ⢮   ।  USART1   
	DMA1_Stream3->PAR =  (uint32_t)&USART1->RDR; //   㤠  
	DMA1_Stream3->M0AR = (uint32_t)&USART1_RX; // 㪠뢠  ᨢ 㤠 
	DMA1_Stream3->CR |= DMA_SxCR_EN; // 砥 DMA*/

	DMA1_Stream4->CR &= ~DMA_SxCR_EN;
	while (DMA1_Stream4->CR & DMA_SxCR_EN);

	DMA1->HIFCR;
	SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTCIF4);
	SET_BIT(DMA1->HIFCR,DMA_HIFCR_CHTIF4);
	SET_BIT(DMA1->HIFCR,DMA_HIFCR_CTEIF4);
	SET_BIT(DMA1->HIFCR,DMA_HIFCR_CDMEIF4);
	SET_BIT(DMA1->HIFCR,DMA_HIFCR_CFEIF4);

	DMA1_Stream4->CR = DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE;
	DMA1_Stream4->NDTR = len;
	DMA1_Stream4->PAR = (uint32_t)&USART1->TDR;
	DMA1_Stream4->M0AR = (uint32_t)&USART1_TX;
	DMA1_Stream4->CR |= DMA_SxCR_EN;
	}
}


void updateWindowMenu(void)
{
	if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED && (((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState == 0))
	{
	if(sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff)
	{
		sizeTXUSB = sizeStackMenu(&Menu);
		if(sizeTXUSB >= 63)
		{
		sizeTXUSB = 63;
		}
		if(sizeTXUSB > 0)
		{
			for(int i = 0; i < sizeTXUSB; i++)
			{
				retMenu = popMenu(&Menu);
				bufTxUSB[i] = retMenu.ch;
			}
			transmitDataTerminal(bufTxUSB, sizeTXUSB);
			CDC_Transmit_FS(bufTxUSB, sizeTXUSB);
		}
	}
	}
	else
		{
			if(hUsbDeviceFS.dev_state != USBD_STATE_CONFIGURED)
			{
				if(sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff)
				{
					sizeTXUSB = sizeStackMenu(&Menu);
					if(sizeTXUSB >= 63)
					{
						sizeTXUSB = 63;
					}
					if(sizeTXUSB > 0)
					{
						for(int i = 0; i < sizeTXUSB; i++)
						{
							retMenu = popMenu(&Menu);
							bufTxUSB[i] = retMenu.ch;
						}
						transmitDataTerminal(bufTxUSB, sizeTXUSB);
					}
				}
			}
		}
}


void searchESCM(void)
{
	int size = sizeStackMenu(&Menu);
		for(int i = 0; i < size; i++)
		{
			retMenu = peekMenu(&Menu);
				if(retMenu.ch == 0x1b){
				break;
				}
				else{
					popMenu(&Menu);
				}
		}
}


int8_t searchESCB(void)
{
	while(sizeStackTxDispData(&txDispData))
	{
	retTxDispData = peektxDispData(&txDispData);
	if(retTxDispData.ch == 0x1b)
	{
	return(1);
	}
	else
		{
		retTxDispData = poptxDispData(&txDispData);
		pushDispDataUpdate(&DispDataUpdate, retTxDispData.ch);
		}
	}
	return(2);
}


void clearDisp(uint32_t num, uint32_t colF, uint32_t colB)
{
	uint32_t y, x;
	for(y = 0; y < sizeWindowAxisY; y++){

		for(x = 0; x < sizeWindowAxisX; x++){
	    SysMem.DISP[num][y][x].B_C = colB;
	    SysMem.DISP[num][y][x].F_C = colF;
	    SysMem.DISP[num][y][x].ch  =  ' ';
		}
	}
}


void initStackSysMem(void)
{
memset(&SysMem,0,sizeof(SysMem));

uint32_t i = 0, j = 0, k = 0;

for(i = 0; i < 4; i++){
	for(j = 0; j < 30; j++){
		for(k = 0; k < 95; k++){
			SysMem.DISP[i][j][k].F_C = 7;
			SysMem.DISP[i][j][k].B_C = 0;
			SysMem.DISP[i][j][k].ch = ' ';
		}
	}
}

SysMem.READYINPUT = -1;
}


void  initStackCommandExternalDevice(void) // 樠 ⥪ ⥬᪮ 
{
	memset(&StackCommandExternalDevice, 0, sizeof(StackCommandExternalDevice));
}


void  pushStackCommandExternalDevice(_StackCommandExternalDevice *stack, uint8_t addr, uint8_t funct, uint16_t addrReg, uint16_t countReg) //   ⥪ ।  int
{
	if(addr > 0 && addr <=63)
	{
	 if(addrReg > 31){ snprintf(SysMem.ERRORS,79,"  騩  ॣ,   %d",addr); return;}
	 if(addrReg < 0) { snprintf(SysMem.ERRORS,79,"  騩  ॣ,   %d",addr); return;};
	 if((countReg + addrReg) > 32){ snprintf(SysMem.ERRORS,79,"ਢ襭  ᭮ ࠭⢠   %d",addr); return; }
	}

	if(addr > 63 && addr <=95)
	{
	 if(addrReg > 127){ snprintf(SysMem.ERRORS,79,"  騩  ॣ, ।  %d",addr); return;}
	 if(addrReg < 0) { snprintf(SysMem.ERRORS,79,"  騩  ॣ, ।  %d",addr); return;};
	 if((countReg + addrReg) > 128){ snprintf(SysMem.ERRORS,79,"ਢ襭  ᭮ ࠭⢠ ।  %d",addr); return; }
	}

	if(addr > 95 && addr <=99)
	{
	 if(addrReg > 4095){ snprintf(SysMem.ERRORS,79,"  騩  ॣ, 襣  %d",addr); return;}
	 if(addrReg < 0) { snprintf(SysMem.ERRORS,79,"  騩  ॣ, 襣  %d",addr); return;};
	 if((countReg + addrReg) > 4096){ snprintf(SysMem.ERRORS,79,"ਢ襭  ᭮ ࠭⢠ 襣  %d",addr); return; }
	}

	if(countReg > 125)
	{
		snprintf(SysMem.ERRORS,79,"祭 稪 ॣ஢ ॢ蠥 祭 125"); return;
	}

	if(countReg <= 0)
	{
		snprintf(SysMem.ERRORS,79,"祭 稪 ॣ஢ ࠢ 0"); return;
	}

	if(sizeStackCommandExternalDevice(&StackCommandExternalDevice) >= MaskStackExtBloks)
	{
		snprintf(SysMem.ERRORS,79,"⥪ ।   譥  ९"); return;
	}

     stack->ExtBlock[stack->head].addr = addr;
     stack->ExtBlock[stack->head].function = funct;
	 stack->ExtBlock[stack->head].addrReg.word = addrReg;
	 stack->ExtBlock[stack->head].countReg.word = countReg;

	 stack->head ++;
     stack->head &= MaskStackExtBloks; // ⮡ 横 ⥪
}


void  popStackCommandExternalDevice(_StackCommandExternalDevice *stack) // ନ஢   । 
{
	uint16_t crc = 0; //  ஫쭮 㬬
	uint32_t i,j;

	if(sizeStackCommandExternalDevice(&StackCommandExternalDevice) > 0)
	{

	ExternalsBlocks_TX[0] = stack->ExtBlock[stack->tail].addr;     // ।  ன⢠
	ExternalsBlocks_TX[1] = stack->ExtBlock[stack->tail].function; // । 㭪樨 ன⢠

	switch(stack->ExtBlock[stack->tail].function) // 롮  㭪    ਥ ।
	{
	case 0x03: //⥭ 㯯 ॣ஢

		ExternalsBlocks_TX[2] = stack->ExtBlock[stack->tail].addrReg.Ho;
		ExternalsBlocks_TX[3] = stack->ExtBlock[stack->tail].addrReg.Lo;

		ExternalsBlocks_TX[4] = stack->ExtBlock[stack->tail].countReg.Ho;
		ExternalsBlocks_TX[5] = stack->ExtBlock[stack->tail].countReg.Lo;

		addrRegRx = (int32_t)stack->ExtBlock[stack->tail].addrReg.word;

	    crc = CRCModbus(ExternalsBlocks_TX, 6);

	    ExternalsBlocks_TX[6] = *((unsigned char *)&crc+0);
		ExternalsBlocks_TX[7] = *((unsigned char *)&crc+1);

		lenRx = 3 + stack->ExtBlock[stack->tail].countReg.word*2 + 2;
		lenTx = 8;
		TxRXData(lenRx, lenTx); // ன ।  ਥ
		break;

	case 0x6:

		ExternalsBlocks_TX[2] = stack->ExtBlock[stack->tail].addrReg.Ho;
		ExternalsBlocks_TX[3] = stack->ExtBlock[stack->tail].addrReg.Lo;

		if(stack->ExtBlock[stack->tail].addr > 0 && stack->ExtBlock[stack->tail].addr <= 63)
		{
		ExternalsBlocks_TX[4] =	SysMem.DIO_MIN[stack->ExtBlock[stack->tail].addr].DIO_MIN[stack->ExtBlock[stack->tail].addrReg.word].Ho;
		ExternalsBlocks_TX[5] =	SysMem.DIO_MIN[stack->ExtBlock[stack->tail].addr].DIO_MIN[stack->ExtBlock[stack->tail].addrReg.word].Lo;
		}

		if(stack->ExtBlock[stack->tail].addr > 63 && stack->ExtBlock[stack->tail].addr <= 95)
		{
		ExternalsBlocks_TX[4] =	SysMem.DIO_MID[64 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word].Ho;
		ExternalsBlocks_TX[5] =	SysMem.DIO_MID[64 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word].Lo;
		}

		if(stack->ExtBlock[stack->tail].addr > 95 && stack->ExtBlock[stack->tail].addr <= 100)
		{
		ExternalsBlocks_TX[4] =	SysMem.DIO_MAX[96 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word].Ho;
		ExternalsBlocks_TX[5] =	SysMem.DIO_MAX[96 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word].Lo;
		}

		crc = CRCModbus(ExternalsBlocks_TX,6);

	    ExternalsBlocks_TX[6] = *((unsigned char *)&crc+0);
		ExternalsBlocks_TX[7] = *((unsigned char *)&crc+1);

		lenRx = 8;
		lenTx = 8;
		TxRXData(lenRx, lenTx); // ன ।  ਥ
		break;

	case 0x10:
		ExternalsBlocks_TX[2] = stack->ExtBlock[stack->tail].addrReg.Ho;
		ExternalsBlocks_TX[3] = stack->ExtBlock[stack->tail].addrReg.Lo;

		ExternalsBlocks_TX[4] = stack->ExtBlock[stack->tail].countReg.Ho;
		ExternalsBlocks_TX[5] = stack->ExtBlock[stack->tail].countReg.Lo;

		ExternalsBlocks_TX[6] = stack->ExtBlock[stack->tail].countReg.word * 2;

		if(stack->ExtBlock[stack->tail].addr > 0 && stack->ExtBlock[stack->tail].addr <= 63)
		{
			for(i = 0, j = 0; i < stack->ExtBlock[stack->tail].countReg.word * 2; i+=2, j++)
			{
				ExternalsBlocks_TX[7 + i] =	SysMem.DIO_MIN[stack->ExtBlock[stack->tail].addr].DIO_MIN[stack->ExtBlock[stack->tail].addrReg.word + j].Ho;
				ExternalsBlocks_TX[8 + i] =	SysMem.DIO_MIN[stack->ExtBlock[stack->tail].addr].DIO_MIN[stack->ExtBlock[stack->tail].addrReg.word + j].Lo;
			}
		}

		if(stack->ExtBlock[stack->tail].addr > 63 && stack->ExtBlock[stack->tail].addr <= 95)
		{
			for(i = 0, j = 0; i < stack->ExtBlock[stack->tail].countReg.word * 2; i+=2, j++)
			{
				ExternalsBlocks_TX[7 + i] =	SysMem.DIO_MID[64 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word + j].Ho;
				ExternalsBlocks_TX[8 + i] =	SysMem.DIO_MID[64 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word + j].Lo;
			}
		}

		if(stack->ExtBlock[stack->tail].addr > 95 && stack->ExtBlock[stack->tail].addr <= 100)
		{
			for(i = 0, j = 0; i < stack->ExtBlock[stack->tail].countReg.word * 2; i+=2, j++)
			{
				ExternalsBlocks_TX[7 + i] =	SysMem.DIO_MAX[96 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word + j].Ho;
				ExternalsBlocks_TX[8 + i] =	SysMem.DIO_MAX[96 - stack->ExtBlock[stack->tail].addr][stack->ExtBlock[stack->tail].addrReg.word + j].Lo;
			}
		}

	    crc = CRCModbus(ExternalsBlocks_TX, 7 + stack->ExtBlock[stack->tail].countReg.word * 2);

	    ExternalsBlocks_TX[7 + stack->ExtBlock[stack->tail].countReg.word * 2 + 0] = *((unsigned char *)&crc+0);
		ExternalsBlocks_TX[7 + stack->ExtBlock[stack->tail].countReg.word * 2 + 1] = *((unsigned char *)&crc+1);

		lenTx = 7 + stack->ExtBlock[stack->tail].countReg.word * 2 + 2;
        lenRx =8;

        TxRXData(lenRx, lenTx); // ன ।  ਥ
		break;
	}

	if(errorsExchangeDio > 0)
	{
		SET_DIO_ERRORS;
	}

	stack->tail ++;
	stack->tail  &= MaskStackExtBloks;

	}
	else
		{
			if(sizeStackCommandExternalDevice(&StackCommandExternalDevice) == 0)
			{
				CLEAR_BIT(DMA1_Stream1->CR,DMA_SxCR_EN);
				while (READ_BIT(DMA1_Stream1->CR,DMA_SxCR_EN)); //  ⮡ ࠭஢  ⪫祭 DMA
				DMA1->LIFCR;
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF1); //  䫠 뢠
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF1);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF1);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF1);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF1);

				DMA1_Stream1->CR = DMA_SxCR_TRBUFF | DMA_SxCR_MINC | DMA_SxCR_TCIE; // ன   USART3 ६ , 祭 뢠  襭 ਥ
				DMA1_Stream1->NDTR = 0; // ⢮   ।  USART3   
				DMA1_Stream1->PAR = (uint32_t)&USART3->RDR; //   㤠  
				DMA1_Stream1->M0AR = (uint32_t)&ExternalsBlocks_RX[0]; // 㪠뢠  ᨢ 㤠 


				CLEAR_BIT(DMA1_Stream2->CR,DMA_SxCR_EN); // 몫砥 DMA
				while (READ_BIT(DMA1_Stream2->CR,DMA_SxCR_EN)); //  ⮡ ࠭஢  ⪫祭 DMA
				DMA1->LIFCR;
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTCIF2); //  䫠 뢠
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CHTIF2);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CTEIF2);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CDMEIF2);
				SET_BIT(DMA1->LIFCR,DMA_LIFCR_CFEIF2);

				DMA1_Stream2->CR = DMA_SxCR_TRBUFF | DMA_SxCR_MINC| DMA_SxCR_DIR_0 | DMA_SxCR_TCIE; // ன   USART3 ६ , ।   ---> USART3
				DMA1_Stream2->NDTR = 0; // ⢮   ।  USART3   
				DMA1_Stream2->PAR = (uint32_t)&USART3->TDR; //   㤠  
				DMA1_Stream2->M0AR = (uint32_t)&ExternalsBlocks_TX[0]; // 㪠뢠  ᨢ 㤠 
			}
		}

	/*
	 * 㭪 0x03 - ⥭ 㯯 ॣ஢
	 * 㭪 0x06 -  筮 ॣ
	 * 㭪 0x10 -  㯯 ॣ஢
	 *  筮 ॣ ---> , 㭪,
	 *  㯯 ॣ஢    ---> , 㭪,  砫 , ᫮ ॣ஢, ᫮ , 祭  
	 * ⥭ 㯯 ॣ஢    <--- , 㭪,
	 * */
}


int sizeStackCommandExternalDevice(_StackCommandExternalDevice *stack)
{
	return((stack->head - stack->tail)&MaskStackExtBloks);
}


void outputPrint(uint8_t ch)
{
	switch(ch){

	case DISP_LEFT :
		xGrid[NumberWindows] = 0;
		move(yGrid[NumberWindows], xGrid[NumberWindows]);
	break;

	case DISP_DOWN :
		if(yGrid[NumberWindows] < sizeWindowAxisY)
		{
		yGrid[NumberWindows]++;
		move(yGrid[NumberWindows], xGrid[NumberWindows]);
		}
	break;

	case DISP_STEP_ONE_LEFT :
		if(xGrid[NumberWindows] > 0)
		{
		xGrid[NumberWindows] --;
		move(yGrid[NumberWindows], xGrid[NumberWindows]);
		}
		break;

	case DISP_TAB :
		if(xGrid[NumberWindows] + (8 - xGrid[NumberWindows]%8) < (sizeWindowAxisX - xGrid[NumberWindows]))
		{
		xGrid[NumberWindows] = xGrid[NumberWindows] + (8 - xGrid[NumberWindows]%8);
		move(yGrid[NumberWindows], xGrid[NumberWindows]);
		}
		break;

	case DISP_UNIT_SEPARATOR :

		if(xGrid[NumberWindows]%16 != 0)
		{
        uint32_t space = (16 - xGrid[NumberWindows]%16);

        for(uint32_t i = 0; i < space; i++)
        {
        if(NumberWindows == ExecWindows)
        {
        addch(' ');
    	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = ' ';
    	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
    	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];
		xGrid[NumberWindows]++;
        }
        else
        	{
        	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = ' ';
        	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
        	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];
    		xGrid[NumberWindows]++;
        	}
        }

		}

		break;

	default :
	if(sizeWindowAxisX > xGrid[NumberWindows])
	{
	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = ch;
	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
	SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];

	if(NumberWindows == ExecWindows)
	{
	addch(ch);
	}

	xGrid[NumberWindows] ++;
	}
	break;

	}
}


void TxRXData(uint32_t lenRx, uint32_t lenTx) // ।稪
{
	CLEAR_BIT(DMA1_Stream1->CR, DMA_SxCR_EN);
	while(READ_BIT(DMA1_Stream1->CR, DMA_SxCR_EN)); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1->LIFCR;
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CTCIF1); //  䫠 뢠
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CHTIF1);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CTEIF1);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CDMEIF1);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CFEIF1);

	DMA1_Stream1->CR = DMA_SxCR_TRBUFF | DMA_SxCR_MINC | DMA_SxCR_TCIE; // ன   USART3 ६ , 祭 뢠  襭 ਥ
	DMA1_Stream1->NDTR = lenRx; // ⢮   ।  USART3   
	DMA1_Stream1->PAR = (uint32_t)&USART3->RDR; //   㤠  
	DMA1_Stream1->M0AR = (uint32_t)&ExternalsBlocks_RX[0]; // 㪠뢠  ᨢ 㤠 

    CLEAR_BIT(DMA1_Stream2->CR,DMA_SxCR_EN); // 몫砥 DMA
	while(READ_BIT(DMA1_Stream2->CR,DMA_SxCR_EN)); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA1->LIFCR;
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CTCIF2); //  䫠 뢠
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CHTIF2);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CTEIF2);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CDMEIF2);
	SET_BIT(DMA1->LIFCR, DMA_LIFCR_CFEIF2);

	DMA1_Stream2->CR = DMA_SxCR_TRBUFF |  DMA_SxCR_MINC | DMA_SxCR_DIR_0 | DMA_SxCR_TCIE; // ன   USART3 ६ , ।   ---> USART3
	DMA1_Stream2->NDTR = lenTx; // ⢮   ।  USART3   
	DMA1_Stream2->PAR = (uint32_t)&USART3->TDR; //   㤠  
	DMA1_Stream2->M0AR = (uint32_t)&ExternalsBlocks_TX[0]; // 㪠뢠  ᨢ 㤠 

	DMA1_Stream1->CR |= DMA_SxCR_EN; // 砥 DMA ਥ RX
	DMA1_Stream2->CR |= DMA_SxCR_EN; // 砥 DMA ।稪 TX

	TIM16->ARR = lenRx + lenTx + 4;
    TIM16->CNT = 0;
    TIM16->CR1 |= TIM_CR1_CEN;
}


void RXData(void)
{
	switch (ExternalsBlocks_RX[1])
	{
	case 0x03:
		if(CRCModbus(ExternalsBlocks_RX,3 + ExternalsBlocks_RX[2] + 2) == 0)
		{

		for(uint32_t i = 0; i < ExternalsBlocks_RX[2]; i+=2)
		{
			if(ExternalsBlocks_RX[0] > 0 && ExternalsBlocks_RX[0] <= 63)
			{
				SysMem.DIO_MIN[ExternalsBlocks_RX[0]].DIO_MIN[addrRegRx].Ho = ExternalsBlocks_RX[3 + i];
				SysMem.DIO_MIN[ExternalsBlocks_RX[0]].DIO_MIN[addrRegRx].Lo = ExternalsBlocks_RX[3 + i + 1];
			}

			if(ExternalsBlocks_RX[0] > 63 && ExternalsBlocks_RX[0] <= 95)
			{
				SysMem.DIO_MID[ExternalsBlocks_RX[0] - 64][addrRegRx].Ho = ExternalsBlocks_RX[3 + i];
				SysMem.DIO_MID[ExternalsBlocks_RX[0] - 64][addrRegRx].Lo = ExternalsBlocks_RX[3 + i + 1];
			}

			if(ExternalsBlocks_RX[0] > 95 && ExternalsBlocks_RX[0] <= 99)
			{
				SysMem.DIO_MAX[ExternalsBlocks_RX[0] - 96][addrRegRx].Ho = ExternalsBlocks_RX[3 + i];
				SysMem.DIO_MAX[ExternalsBlocks_RX[0] - 96][addrRegRx].Lo = ExternalsBlocks_RX[3 + i + 1];
			}

			addrRegRx++;
		}

		counterExternTx = 0;

		popStackCommandExternalDevice(&StackCommandExternalDevice);
	    }
		else{
            if(counterExternTx < QuantityErrorsExtBlocks){
			TxRXData(lenRx,lenTx);
            }
            else
            	{
            	snprintf(SysMem.ERRORS,79,"%s%d",errorText[7], ExternalsBlocks_RX[0]);
            	counterExternTx = 0;
            	popStackCommandExternalDevice(&StackCommandExternalDevice);
            	}
            	counterExternTx ++;
		}
		break;

	case 0x06:
	case 0x10:
		if(CRCModbus(ExternalsBlocks_RX,8) == 0) // ᫨ CRC 諠  ⢥  ।  
		{
			counterExternTx = 0;
			popStackCommandExternalDevice(&StackCommandExternalDevice);
		}
		else
			{
				if(counterExternTx <= QuantityErrorsExtBlocks){
					TxRXData(lenRx,lenTx); // ன ।  ਥ
				}
				else
					{
					counterExternTx = 0;
					popStackCommandExternalDevice(&StackCommandExternalDevice);
					}
					counterExternTx ++;
			}


/*		break;

	case 0x10:
		if(CRCModbus(ExternalsBlocks_RX,8) == 0)
		{
			counterExternTx = 0;
			popStackCommandExternalDevice(&StackCommandExternalDevice);
		}
		else{
			if(counterExternTx <= QuantityErrorsExtBlocks){
			TxRXData(lenRx,lenTx); // ன ।  ਥ
			}
			counterExternTx ++;
		}*/
		break;

	default :
		popStackCommandExternalDevice(&StackCommandExternalDevice);
		break;
	}

	/*᫨ 諨 0x06 0x10   ஢塞 CRC*/
}


void TimeOutRxData(void)
{
	static uint8_t countErrConnect;
    if(countErrConnect < QuantityErrorsExtBlocks)
    {
	TxRXData(lenRx, lenTx);
	countErrConnect ++;
    }
    else
    	{
    	snprintf(SysMem.ERRORS,79,"訡 裡  : %02d",ExternalsBlocks_TX[0]);

    		USART3->CR1 &= ~USART_CR1_UE; // ⪫祭 USART 3  ன
    		while (USART3->CR1 & USART_CR1_UE); // ஢塞   祭 USART3 襭
    		USART3->CR1 = 0
    				| 0*USART_CR1_RXFFIE // 몫祭 뢠  ਥ
    				| 0*USART_CR1_TXFEIE // 몫祭 뢠  ।
    		        | 0*USART_CR1_FIFOEN // 몫祭  ਥ ।稪
    				| 0*USART_CR1_M1     // 祭 9 ⭮ ०
    				| 0*USART_CR1_EOBIE  // 몫祭 뢠  
    				| 0*USART_CR1_RTOIE  // 몫祭 뢠 ⠩
    				| 0*USART_CR1_DEAT   // 몫祭 ६ প
    				| 0*USART_CR1_DEDT   // -||-
    				| 0*USART_CR1_OVER8  // 祭 16 ⭮
    				| 0*USART_CR1_CMIE
    				| 0*USART_CR1_MME
    				| 1*USART_CR1_M0
    				| 0*USART_CR1_WAKE
    				| 1*USART_CR1_PCE
    				| 0*USART_CR1_PS
    				| 0*USART_CR1_PEIE
    				| 0*USART_CR1_TXEIE_TXFNFIE
    				| 0*USART_CR1_TCIE    // 祭 ⪫祭 뢠  ।
    				| 0*USART_CR1_RXNEIE_RXFNEIE // 祭  ਥ 
    				| 0*USART_CR1_IDLEIE
    				| 1*USART_CR1_TE
    				| 1*USART_CR1_RE
    				| 0*USART_CR1_UESM
    				| 0*USART_CR1_UE  // 몫祭 usart
    				;
    		USART3->CR2 = 0x00;
    		USART3->CR3 = USART_CR3_DMAT | USART_CR3_DMAR; // 祭 DMA
    		USART3->PRESC = 0; // ।⥫ ⠪⮢ 
    		USART3->BRR = 521;
    		USART3->CR1 |= USART_CR1_UE; // 砥 USART3
    		while (!(USART3->CR1 & USART_CR1_UE)); // ஢塞   祭 USART3 ⠭


        	popStackCommandExternalDevice(&StackCommandExternalDevice);
        	countErrConnect = 0;
        	errorsExchangeDio += 64;
    	}
}


uint16_t CRCModbus(uint8_t *pBuffer, uint32_t BufferLength) //  crc  
{
    CRC->CR = CRC_CR_REV_OUT |CRC_CR_POLYSIZE_0 | CRC_CR_REV_IN_0; // ன CRC
    CRC->POL = 0x8005; //  0xA001 ࠥ  modbus0x8005
    CRC->INIT = 0XFFFFFFFF; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    __IO uint16_t *pReg;
    uint32_t i;
    uint16_t data;
    for (i = 0U; i < (BufferLength / 4U); i++)
    {
      CRC->DR = ((uint32_t)pBuffer[4U * i] << 24U) | \
                           ((uint32_t)pBuffer[(4U * i) + 1U] << 16U) | \
                           ((uint32_t)pBuffer[(4U * i) + 2U] << 8U)  | \
                           (uint32_t)pBuffer[(4U * i) + 3U];
    }
    if ((BufferLength % 4U) != 0U)
    {
      if ((BufferLength % 4U) == 1U)
      {
        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[4U * i];
      }
      if ((BufferLength % 4U) == 2U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;
      }
      if ((BufferLength % 4U) == 3U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;

        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[(4U * i) + 2U];
      }
    }

    return(CRC->DR);
}


void execByteCode(_Manager *manager)
{
	uint32_t i;

	for(i = 0; i < sizeTaskExec; i ++)
	{
		if(manager->task[i].step > 0)
		{

			if(manager->task[i].timeWork >= manager->task[i].step) //  
			{
				manager->task[i].timeWork = 0;

				if(((float)manager->queueTask/(float)manager->size)*100.0 <= 40)
				{
					LOAD_CPU_40;
				}

				if(((float)manager->queueTask/(float)manager->size)*100.0 > 40 && ((float)manager->queueTask/(float)manager->size)*100.0 <= 80)
				{
					LOAD_CPU_80;
				}

				if(((float)manager->queueTask/(float)manager->size)*100.0 > 80)
				{
					LOAD_CPU_100;
				}

				manager->task[i].counterRun ++; // ਬ 稪 ᮢ  
				if(manager->task[i].counterRun >= 100)
				{
				manager->task[i].counterRun = 100;
				}
				else
					{
						if(manager->task[i].counterRun == 1)
						{
							manager->queueTask++;
						}
					}
			}

			if(manager->task[i].attribute == 1) // ਡ ࠢ    騭
			{
				if(manager->task[i].timeoutWork >= manager->task[i].timeout) // ॢ襭  믮   
				{
				manager->task[i].flagTimeout = 1;
				manager->task[i].timeoutWork = 0;

				SysMem.DIO_MIN[0].DIO_00.numberHandTask = i;
				SysMem.DIO_MIN[0].DIO_00.counterHandTask ++;

					if(SysMem.DIO_MIN[0].DIO_00.counterHandTask >= 0xffff)
					{
					SysMem.DIO_MIN[0].DIO_00.counterHandTask = 0;
					}
				}
				manager->task[i].timeoutWork ++;
			}
			else
				{
				manager->task[i].timeoutWork = 0;
				}

				manager->task[i].timeWork ++; // ६ 稪 뢠騩 ६ (横)   ᪠
	    }
	}

	manager->counterTimeExecTask ++;

	if(manager->counterTimeExecTask >= 1000)
	{
		SysMem.DIO_MIN[0].DIO_00.loadCPU = (uint16_t)(manager->timeExecTask*100);
		manager->counterTimeExecTask = 0;
		manager->timeExecTask = 0;
	}

}


uint8_t checkTask(_Manager *manager)
{
	uint16_t i;

	for(i = 0; i < sizeTaskExec; i++)
	{
		if(manager->task[i].step != 0)
		{
			return(0);
		}
	}
	return(1);
}


void execTask(void)
{
	if(READ_BIT(TIM15->CR1, TIM_CR1_CEN))
	{
		managerTask(&Manager, Manager.numberCurrentTask);
		Manager.numberCurrentTask ++;
		if(Manager.numberCurrentTask >= sizeTaskExec)
		{
			Manager.numberCurrentTask = 0;
			if(checkTask(&Manager))
			{
    		startFileSystem();
			}
		}
	}
}


void startFileSystem(void)
{
	managerTaskInit();
	TIM15->CR1 &= ~TIM_CR1_CEN;
	menuChange(&m_s1i2);
	WORK_EDIT;
	counterUpdateDisp = 0xFFFFFFF;
	clpbrd_len = 0;
}


int32_t charInStr(uint8_t *str, uint8_t ch, uint32_t size)
{
	uint16_t i = 0;
	while(str[i] != ch)
	{
	if(i >= size){ return(-1); }
	i++;
	}
	return(i);
}


uint32_t adressDimData(uint32_t n)
{
	uint32_t adr = 0;
	int j = 0, k = 0;
	uint16_t a[4];

	_DimData *d;

    if(n > 127) d = (_DimData*)&fSysDimData[n-128];
    else        d = &DimData[n];

	if ( d->type==3 ) k = 1; // ᫨ ᨢ ப,   㤥 ॡ  ஢ 㫥 ࠧ୮ ( ࠧ ப)
	else k = 0;

	for ( int i=d->size-1; i>=k; i-- ) { // ॡࠥ  ᯮ㥬 ࠧ୮
        //  ।   ⥪
		if(popHiMcalc(&MCALC) == 0xffff) j = popMcalcI(&MCALC);
		else j = (uint16_t)roundf(popMcalcF(&MCALC));
		// ஢ਬ ।   ᮮ⢥⢨ ⨬ 
		if ( j<0 || j>=d->dim[i]) return -eIncorrectDimIndex; //   
		a[i]=j; //    ᫥ ⮢
	}
	for ( ; k<d->size; k++ )   // ॡࠥ  ᯮ㥬 ࠧ୮
		adr=adr*d->dim[k]+a[k]; // ⠥ ᬥ饭  ᨢ ⭮ (  )

    switch(d->type) {
        case 0:
        case 1:  adr*=4; break; //ᨢ 4-
        case 2:  adr*=2; break; //ᨢ 2-
        default: adr*=d->dim[0]; break; //ᨢ ப,   ࠧ ப
    }

    adr+=d->adr; // ᫨  㦭 祩

    adr &= 0xFFFFFF;

    adr |= ((d->dim[0] & 0xff) << 24);

    return(adr);
}


void inputEcho(uint8_t ch)
{
	/*uint32_t lenStr = 0, i = 0;
	char text[256];
	memset(text, 0, sizeof(text));

	popStrCalc(&StrCalc,text);

	lenStr = strlen(text);

	if((sizeWindowAxisX - xGrid[NumberWindows]) > lenStr){
		for(i = 0; i < lenStr; i++){
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = text[i];
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];
			xGrid[NumberWindows] ++;

			if(NumberWindows == ExecWindows){
			addch(text[i]);
			}
		}
	}
	else{
		lenStr = sizeWindowAxisX - xGrid[NumberWindows];
		for(i = 0; i < lenStr; i++){
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].ch = text[i];
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].F_C = colorF[NumberWindows];
			SysMem.DISP[NumberWindows][yGrid[NumberWindows]][xGrid[NumberWindows]].B_C = colorB[NumberWindows];
			xGrid[NumberWindows] ++;

			if(NumberWindows == ExecWindows){
			addch(text[i]);
			}
		}
	}*/
}


int32_t updateDisplay(void) //  ᯫ ᥣ
{
    static uint32_t x, y, colFold, colBold, esc;
    uint32_t i, colB = 0, colF = 0/*, dim = 0*/;

    if(sizeStackDispDataUpdate(&DispDataUpdate) == 0){

    if(!esc)
    {
    esc = searchESCB();
    return(0);
    }

     if(x == 0 && y == 0){

    	for(i = 0; i < sizeWindowAxisY; i++)
    	{
    		for(uint32_t j = 0; j < sizeWindowAxisX; j++)
    		{
    	    	MirrorDISP[i][j].F_C = SysMem.DISP[NumberWindows][i][j].F_C;
    	    	MirrorDISP[i][j].B_C = SysMem.DISP[NumberWindows][i][j].B_C;
    	    	MirrorDISP[i][j].ch  = SysMem.DISP[NumberWindows][i][j].ch;
    		}
    	}

    	colF = MirrorDISP[y][x].F_C;
    	colB = MirrorDISP[y][x].B_C;

    	//dim = colF & 0x8;

    	colF = colF & 0xf;

    	colB = colB & 0xf;

    	colF = colF << 8;

    	colB = colB << 12;

    	colF = colF & F_COLOR;

    	colB= colB & B_COLOR;

    	curs_setDISP(0); // ⪫祭 

    	//if(dim == 0){
    	attrsetDISP(colF|colB);
    	//}
    	//else{
    	//attrsetDISP(colF|colB|A_BOLD);
    	//}

    	colFold = MirrorDISP[y][x].F_C;
        colBold = MirrorDISP[y][x].B_C;
     }

    if(y < sizeWindowAxisY){

    moveDISP(y,x);

    for(i = 0; i < sizeWindowAxisX; i++){

    if(colBold !=  MirrorDISP[y][i].B_C || colFold !=  MirrorDISP[y][i].F_C){

    	colF = MirrorDISP[y][i].F_C;
    	colB = MirrorDISP[y][i].B_C;

    	//dim = colF & 0x8;

    	colF = colF & 0xf;

    	colB = colB & 0xf;

    	colF = colF << 8;

    	colB = colB << 12;

    	colF = colF & F_COLOR;

    	colB= colB & B_COLOR;

    	//if(dim == 0){
    	attrsetDISP(colF|(colB));
    //	}
    	//else{
    	//attrsetDISP(colF|(colB)|A_BOLD);
    	//}
    }

    addchDISP(MirrorDISP[y][i].ch);
    colFold = MirrorDISP[y][i].F_C;
    colBold = MirrorDISP[y][i].B_C;
    }
    }

       x = 0;
	   y ++;

	  if(y == sizeWindowAxisY){
		  if(sizeStackTxDispData(&txDispData))
		  {
		  retTxDispData = peektxDispData(&txDispData);
		  moveDISP(retTxDispData.y,retTxDispData.x);
		  }
	  }

      if(y > sizeWindowAxisY){
        	x = 0;
        	y = 0;
        	colFold = 0;
        	colBold = 0;
        	esc = 0;
        	return(1);
      }
      else{
    	  extraditionDispUsb();
      }

    }
    else{
    	extraditionDispUsb();
    }

    return(0);
}




void extraditionDispUsb(void)
{
	if(hUsbDeviceFS.dev_state == USBD_STATE_CONFIGURED && (((USBD_CDC_HandleTypeDef*)hUsbDeviceFS.pClassData)->TxState == 0) && (sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff))
	{
		sizeTXUSB = sizeStackDispDataUpdate(&DispDataUpdate);
		if(sizeTXUSB >= 63)
		{
		sizeTXUSB = 63;
		}

		if(sizeTXUSB > 0)
		{
		if(sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff)
		{
			for(int i = 0; i < sizeTXUSB; i++)
			{
				bufTxUSB[i] = popDispDataUpdate(&DispDataUpdate);
			}
			transmitDataTerminal(bufTxUSB,sizeTXUSB);
			CDC_Transmit_FS(bufTxUSB, sizeTXUSB );
		}
		else
			{
			transmitDataTerminal(bufTxUSB,0);
			}
		}
	}
	else
		{
			if(hUsbDeviceFS.dev_state != USBD_STATE_CONFIGURED && (sizeUpdateMonitor(&UpdateMonitor) < sizeBufUpdateMonitor - 0xff))
			{
				sizeTXUSB = sizeStackDispDataUpdate(&DispDataUpdate);
				if(sizeTXUSB >= 63)
				{
				sizeTXUSB = 63;
				}

				for(int i = 0; i < sizeTXUSB; i++)
				{
					bufTxUSB[i] = popDispDataUpdate(&DispDataUpdate);
				}
				transmitDataTerminal(bufTxUSB,sizeTXUSB);
			}
			else
				{
				transmitDataTerminal(bufTxUSB,0);
				}
		}
}


uint8_t ReadStatus(void)
{
	memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
	memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

	while(!(SPI4->SR & SPI_SR_TXP)); // ஢५   fifo  
	*((__IO uint8_t*)&SPI4->TXDR) = EEPROM_RDSR;

	while(!(SPI4->SR & SPI_SR_RXP));
	*((uint8_t *)&EEPROM_RX[0]) = *((__IO uint8_t *)&SPI4->RXDR);

	while(!(SPI4->SR & SPI_SR_TXP)); // ஢५   fifo  
	*((__IO uint8_t*)&SPI4->TXDR) = 0x0;

	while(!(SPI4->SR & SPI_SR_RXP));
	*((uint8_t *)&EEPROM_RX[0]) = *((__IO uint8_t *)&SPI4->RXDR);

	while(!(SPI4->SR & SPI_SR_TXC)); //  襭 ।
	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS4);

	return(EEPROM_RX[0]);
}


void SetWriteEnableLatch(void)
{
    memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
    memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
    SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

    EEPROM_TX[0] = EEPROM_WREN;

    *((__IO uint8_t*)&SPI4->TXDR) = EEPROM_TX[0];
    while(!(SPI4->SR & SPI_SR_DXP));
    *((uint8_t *)&EEPROM_RX[0]) = *((__IO uint8_t *)&SPI4->RXDR);

    while(!(SPI4->SR & SPI_SR_TXC));
    SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS4);
}


void EepromWriteF(uint32_t adrr, float val)
{
	if(adrr < 0x7FFF )
	{
	SetWriteEnableLatch();
	memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
	memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
	EEPROM_TX[0] = EEPROM_WRITE;
	EEPROM_TX[1] = (adrr >> 8) & 0xff;
	EEPROM_TX[2] = adrr & 0xff;

	EEPROM_TX[3] = *((uint8_t*)&val + 0);
	EEPROM_TX[4] = *((uint8_t*)&val + 1);
	EEPROM_TX[5] = *((uint8_t*)&val + 2);
	EEPROM_TX[6] = *((uint8_t*)&val + 3);

	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

    for(uint32_t i = 0; i < 7; i++)
    {
     *((__IO uint8_t*)&SPI4->TXDR) = EEPROM_TX[i];
     while(!(SPI4->SR & SPI_SR_DXP));
     *((uint8_t *)&EEPROM_RX[i]) = *((__IO uint8_t *)&SPI4->RXDR);
    }

    while(!(SPI4->SR & SPI_SR_TXC)); //  襭 ।
	SPI4->IFCR = 0xFF8;
	SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS4);
	}
}


void EepromWriteI(uint32_t adrr, uint32_t val)
{
	if(adrr < 0x7FFF )
	{
	SetWriteEnableLatch();
	memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
	memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
	EEPROM_TX[0] = EEPROM_WRITE;
	EEPROM_TX[1] = (adrr >> 8) & 0xff;
	EEPROM_TX[2] = adrr & 0xff;

	EEPROM_TX[3] = *((uint8_t*)&val + 0);
	EEPROM_TX[4] = *((uint8_t*)&val + 1);
	EEPROM_TX[5] = *((uint8_t*)&val + 2);
	EEPROM_TX[6] = *((uint8_t*)&val + 3);

	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

    for(uint32_t i = 0; i < 7; i++)
    {
     *((__IO uint8_t*)&SPI4->TXDR) = EEPROM_TX[i];
     while(!(SPI4->SR & SPI_SR_DXP));
     *((uint8_t *)&EEPROM_RX[i]) = *((__IO uint8_t *)&SPI4->RXDR);
    }

    while(!(SPI4->SR & SPI_SR_TXC)); //  襭 ।
	SPI4->IFCR = 0xFF8;
	SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS4);
	}
}


uint32_t EepromReadI(uint32_t adrr)
{
	uint32_t val = 0;

	if(adrr < 0x7FFF )
	{
	memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
	memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
	EEPROM_TX[0] = EEPROM_READ;
	EEPROM_TX[1] = (adrr >> 8) & 0xff;
	EEPROM_TX[2] = adrr & 0xff;

	EEPROM_TX[3] = 0;
	EEPROM_TX[4] = 0;
	EEPROM_TX[5] = 0;
	EEPROM_TX[6] = 0;

	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

    for(uint32_t i = 0; i < 7; i++)
    {
     *((__IO uint8_t*)&SPI4->TXDR) = EEPROM_TX[i];
     while(!(SPI4->SR & SPI_SR_DXP));
     *((uint8_t *)&EEPROM_RX[i]) = *((__IO uint8_t *)&SPI4->RXDR);
    }

	while(!(SPI4->SR & SPI_SR_TXC)); //  襭 ।
	SPI4->IFCR = 0xFF8;
	SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS4);

	((unsigned char*)&val)[0] = EEPROM_RX[3];
	((unsigned char*)&val)[1] = EEPROM_RX[4];
	((unsigned char*)&val)[2] = EEPROM_RX[5];
	((unsigned char*)&val)[3] = EEPROM_RX[6];
	}

	return(val);
}


float EepromReadF(uint32_t adrr)
{
	float val = 0;

	if(adrr < 0x7FFF )
	{
	memset(EEPROM_RX, 0, sizeof(EEPROM_RX));
	memset(EEPROM_TX, 0, sizeof(EEPROM_TX));
	EEPROM_TX[0] = EEPROM_READ;
	EEPROM_TX[1] = (adrr >> 8) & 0xff;
	EEPROM_TX[2] = adrr & 0xff;

	EEPROM_TX[3] = 0;
	EEPROM_TX[4] = 0;
	EEPROM_TX[5] = 0;
	EEPROM_TX[6] = 0;

	SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR4);

    for(uint32_t i = 0; i < 7; i++)
    {
     *((__IO uint8_t*)&SPI4->TXDR) = EEPROM_TX[i];
     while(!(SPI4->SR & SPI_SR_DXP));
     *((uint8_t *)&EEPROM_RX[i]) = *((__IO uint8_t *)&SPI4->RXDR);
    }

	while(!(SPI4->SR & SPI_SR_TXC)); //  襭 ।
	SPI4->IFCR = 0xFF8;
	SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS4);

	((unsigned char*)&val)[0] = EEPROM_RX[3];
	((unsigned char*)&val)[1] = EEPROM_RX[4];
	((unsigned char*)&val)[2] = EEPROM_RX[5];
	((unsigned char*)&val)[3] = EEPROM_RX[6];
	}

	return(val);
}


void setTime(_RtcTime *stime)
{
	WRITE_REG(RTC->WPR,0xca);
	WRITE_REG(RTC->WPR,0x53);
	RTC->ISR = (uint32_t)RTC_INIT_MASK;
    while(!READ_BIT(RTC->ISR,RTC_ISR_INITF));
    if(!(RTC->CR & RTC_CR_FMT))
    {
    RTC->TR = (uint32_t)(((uint32_t)RTC_ByteToBcd(stime->hours)   << RTC_TR_HU_Pos)  | \
              ((uint32_t)RTC_ByteToBcd(stime->minutes) << RTC_TR_MNU_Pos) | \
              ((uint32_t)RTC_ByteToBcd(stime->seconds) << RTC_TR_SU_Pos)  | \
              (((uint32_t)0) << RTC_TR_PM_Pos));
    }
    CLEAR_BIT(RTC->ISR, RTC_ISR_INIT);
    WRITE_REG(RTC->WPR,0xff);
}


void setData(_RtcData *sdate)
{
	unsigned short int mn, yr;
    mn = sdate->month;
    yr = 2000 + sdate->year;
    if (mn < 3)
    {
      mn += 12;
      yr -= 1;
    }

    int weekday = (sdate->day + (13 * mn - 2) / 5 + yr + yr / 4 - 20 + 5 + ZELLER_OFFSET) % 7;
    if (weekday == 0){
        weekday = 0x07;
    }

	WRITE_REG(RTC->WPR,0xca);
	WRITE_REG(RTC->WPR,0x53);
	RTC->ISR = (uint32_t)RTC_INIT_MASK;
    while(!READ_BIT(RTC->ISR,RTC_ISR_INITF));

    if(!(RTC->CR & RTC_CR_FMT)){
        RTC->DR = (((uint32_t)RTC_ByteToBcd(sdate->year)  << RTC_DR_YU_Pos) | \
                      ((uint32_t)RTC_ByteToBcd(sdate->month) << RTC_DR_MU_Pos) | \
                      ((uint32_t)RTC_ByteToBcd(sdate->day)  << RTC_DR_DU_Pos) | \
                      ((uint32_t)weekday              << RTC_DR_WDU_Pos));
    }

    CLEAR_BIT(RTC->ISR, RTC_ISR_INIT);
    WRITE_REG(RTC->WPR,0xff);
}


void getTime(_RtcTime *gtime)
{
	  uint32_t tmpreg = (uint32_t)(RTC->TR & RTC_TR_RESERVED_MASK);

	  gtime->hours      = (uint8_t)((tmpreg & (RTC_TR_HT  | RTC_TR_HU))  >> RTC_TR_HU_Pos);
	  gtime->minutes    = (uint8_t)((tmpreg & (RTC_TR_MNT | RTC_TR_MNU)) >> RTC_TR_MNU_Pos);
	  gtime->seconds    = (uint8_t)((tmpreg & (RTC_TR_ST  | RTC_TR_SU))  >> RTC_TR_SU_Pos);

	  gtime->hours   = (uint8_t)RTC_BcdToByte(gtime->hours);
	  gtime->minutes = (uint8_t)RTC_BcdToByte(gtime->minutes);
	  gtime->seconds = (uint8_t)RTC_BcdToByte(gtime->seconds);
}


void getData(_RtcData *gdata)
{
	  uint32_t datetmpreg;
	  datetmpreg = (uint32_t)(RTC->DR & RTC_DR_RESERVED_MASK);

	  gdata->year    = (uint8_t)((datetmpreg & (RTC_DR_YT | RTC_DR_YU)) >> RTC_DR_YU_Pos);
	  gdata->month   = (uint8_t)((datetmpreg & (RTC_DR_MT | RTC_DR_MU)) >> RTC_DR_MU_Pos);
	  gdata->day    = (uint8_t)((datetmpreg & (RTC_DR_DT | RTC_DR_DU)) >> RTC_DR_DU_Pos);
	  gdata->weekDay = (uint8_t)((datetmpreg & (RTC_DR_WDU))           >> RTC_DR_WDU_Pos);

	  gdata->year = (uint8_t)RTC_BcdToByte(gdata->year);
	  gdata->month = (uint8_t)RTC_BcdToByte(gdata->month);
	  gdata->day = (uint8_t)RTC_BcdToByte(gdata->day);
	  gdata->weekDay = (uint8_t)RTC_BcdToByte(gdata->weekDay);
}


uint8_t RTC_ByteToBcd(uint8_t Value)
{
  uint32_t bcdhigh = 0U;
  uint8_t  bcdlow  = Value;

  while (bcdlow >= 10U)
  {
    bcdhigh++;
    bcdlow -= 10U;
  }
  return ((uint8_t)(bcdhigh << 4U) | bcdlow);
}


uint8_t RTC_BcdToByte(uint8_t Value)
{
  uint8_t tmp;
  tmp = ((Value & 0xF0U) >> 4U) * 10U;
  return (tmp + (Value & 0x0FU));
}


void initMirrorDISP(void)
{
	memset(&MirrorDISP, 0, sizeof(MirrorDISP));
}


/*			ASU			*/
void modbasRTU(void)
{
	static uint16_t start_addr = 0;
	static uint16_t count_reg  = 0;
	uint32_t addrSTATDATA = (uint32_t)&SysMem.ASUIO;
	uint16_t crc16 = 0;
	int32_t i = 0;


	if(AsuRX[1] == 0x01) // ⥭ ﭨ ५ 室
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x01;
		AsuTX[2] = count_reg % 8 ? count_reg/8 + 1 : count_reg/8;

		for(i = 0; i < count_reg; i++)
		{
			AsuTX[i/8 + 3] |= ((*(__IO uint8_t*)(addrSTATDATA + (start_addr+i)/8)) & (1 << (start_addr + i)%8) ? 1 : 0) << i%8;
		}

	    crc16 = AsuCRC16(AsuTX, (3 + AsuTX[2]));

	    AsuTX[3 + AsuTX[2] + 0] = *((uint8_t *)&crc16 + 0);
	    AsuTX[3 + AsuTX[2] + 1] = *((uint8_t *)&crc16 + 1);

	    initTxRxModbasRTU(3 + AsuTX[2] + 2);
	}


	if(AsuRX[1] == 0x02) // ⥭ ﭨ  室
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x02;
		AsuTX[2] = count_reg % 8 ? count_reg/8 + 1 : count_reg/8;

		for(i = 0; i < count_reg; i++)
		{
			AsuTX[i/8 + 3] |= ((*(__IO uint8_t*)(addrSTATDATA + (start_addr+i)/8)) & (1 << (start_addr + i)%8) ? 1 : 0) << i%8;
		}

	    crc16 = AsuCRC16(AsuTX, (3 + AsuTX[2]));

	    AsuTX[3 + AsuTX[2] + 0] = *((uint8_t *)&crc16 + 0);
	    AsuTX[3 + AsuTX[2] + 1] = *((uint8_t *)&crc16 + 1);

	    initTxRxModbasRTU(3 + AsuTX[2] + 2);
	}


	if(AsuRX[1] == 0x03) // ⥭ ࠬ஢ ॣ஢
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];
		memset(AsuTX, 0, sizeof(AsuTX));

		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x03;
		AsuTX[2] = count_reg*2;

		for(int32_t i = 0; i < count_reg*2; i+=2)
		{
			AsuTX[3+i] =  *(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 1);
			AsuTX[3+i+1] =*(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 0);
		}
	    crc16 = AsuCRC16(AsuTX, (3 + count_reg*2));

	    AsuTX[3 + count_reg*2 + 0] = *((uint8_t *)&crc16 + 0);
	    AsuTX[3 + count_reg*2 + 1] = *((uint8_t *)&crc16 + 1);

	    initTxRxModbasRTU(3 + count_reg*2 + 2);
	}


	if(AsuRX[1] == 0x04) // ⥭  ॣ஢
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];
		memset(AsuTX, 0, sizeof(AsuTX));

		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x04;
		AsuTX[2] = count_reg*2;

		for(i = 0; i < count_reg*2; i+=2)
		{
			AsuTX[3+i] =  *(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 1);
			AsuTX[3+i+1] =*(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 0);
		}
	    crc16 = AsuCRC16(AsuTX, (3 + count_reg*2));

	    AsuTX[3 + count_reg*2 + 0] = *((uint8_t *)&crc16 + 0);
	    AsuTX[3 + count_reg*2 + 1] = *((uint8_t *)&crc16 + 1);

		initTxRxModbasRTU(3 + count_reg*2 + 2);
	}


	if(AsuRX[1] == 0x05) //  ﭨ  ५ 室, ⮢ 
	{
		uint16_t M = 0;

		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		M = 1 << start_addr%8;

		if(AsuRX[4] == 0xff && AsuRX[5] == 0x00) // ﭨ 祭
		{
			*(__IO uint8_t*)(addrSTATDATA + start_addr/8) |= M;
		}
		else
			{
			*(__IO uint8_t*)(addrSTATDATA + start_addr/8) &= (~M);
			}

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x05;
		AsuTX[2] = AsuRX[2];
		AsuTX[3] = AsuRX[3];
		AsuTX[4] = AsuRX[4];
		AsuTX[5] = AsuRX[5];
	    crc16 = AsuCRC16(AsuTX, 6);
	    AsuTX[6] = *((uint8_t *)&crc16 + 0);
	    AsuTX[7] = *((uint8_t *)&crc16 + 1);

	    initTxRxModbasRTU(8);
	}


	if(AsuRX[1] == 0x0f) //  ﭨ ᪮쪨 ५ 室, ⮢ 
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];

		for(i = 0; i < count_reg; i++)
		{
		   (*(__IO uint8_t*)(addrSTATDATA + (start_addr + i)/8)) |= (AsuRX[6 + i/8] & (1 << (start_addr + i)%8) ? 1 : 0) << i%8;
		}

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x05;
		AsuTX[2] = AsuRX[2];
		AsuTX[3] = AsuRX[3];
		AsuTX[4] = AsuRX[4];
		AsuTX[5] = AsuRX[5];
	    crc16 = AsuCRC16(AsuTX, 6);
	    AsuTX[6] = *((uint8_t *)&crc16 + 0);
	    AsuTX[7] = *((uint8_t *)&crc16 + 1);

	    initTxRxModbasRTU(8);
	}


	if(AsuRX[1] == 0x06) //   ॣ ࠬ஢
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		*(__IO uint8_t*)(addrSTATDATA + start_addr*2  + 1) = AsuRX[4];
		*(__IO uint8_t*)(addrSTATDATA + start_addr*2  + 0) = AsuRX[5];

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x06;
		AsuTX[2] = AsuRX[2];
		AsuTX[3] = AsuRX[3];
		AsuTX[4] = AsuRX[4];
		AsuTX[5] = AsuRX[5];
	    crc16 = AsuCRC16(AsuTX, 6);
	    AsuTX[6] = *((uint8_t *)&crc16 + 0);
	    AsuTX[7] = *((uint8_t *)&crc16 + 1);
	    initTxRxModbasRTU(8);
	}


	if(AsuRX[1] == 0x10) //  ⢠ ॣ஢ ࠬ஢
	{
		((uint8_t*)&start_addr)[0] = AsuRX[3];
		((uint8_t*)&start_addr)[1] = AsuRX[2];
		((uint8_t*)&count_reg)[0]  = AsuRX[5];
		((uint8_t*)&count_reg)[1]  = AsuRX[4];

		for(i = 0; i < count_reg*2; i+=2)
		{
			*(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 1) = AsuRX[6+i];
			*(__IO uint8_t*)(addrSTATDATA + start_addr*2 + i + 0) = AsuRX[6+i+1];
		}

		memset(AsuTX, 0, sizeof(AsuTX));
		AsuTX[0] = SysMem.DIO_MIN[0].DIO_00.ASU_P_Adr;
		AsuTX[1] = 0x10;
		AsuTX[2] = AsuRX[2];
		AsuTX[3] = AsuRX[3];
		AsuTX[4] = AsuRX[4];
		AsuTX[5] = AsuRX[5];
	    crc16 = AsuCRC16(AsuTX, 6);
	    AsuTX[6] = *((uint8_t *)&crc16 + 0);
	    AsuTX[7] = *((uint8_t *)&crc16 + 1);
	    initTxRxModbasRTU(8);
	}

}


void initTxRxModbasRTU(uint32_t len)
{
	memset(AsuRX, 0, sizeof(AsuRX)); // ⪠ ਥ 
	DMA2_Stream0->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA2_Stream0->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA2->LIFCR;
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTCIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CHTIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTEIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CDMEIF0);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CFEIF0);

	DMA2_Stream0->NDTR = 256; // ⢮   ।  USART2   
	DMA2_Stream0->CR |= DMA_SxCR_EN; // ਥ

	DMA2_Stream1->CR &= ~DMA_SxCR_EN; // 몫砥 DMA
	while (DMA2_Stream1->CR & DMA_SxCR_EN); //  ⮡ ࠭஢  ⪫祭 DMA
	DMA2->LIFCR;
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTCIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CHTIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CTEIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CDMEIF1);
	SET_BIT(DMA2->LIFCR,DMA_LIFCR_CFEIF1);

	DMA2_Stream1->NDTR = len;
	DMA2_Stream1->CR |= DMA_SxCR_EN; // ।
}


void Send_String(char *str)
{
  uint8_t i = 0;

  while (str[i] != 0)
    i++;
  while (CDC_Transmit_FS((unsigned char *)str, i) != USBD_OK)
    ;
}


void Send_USB_data(unsigned char *message, unsigned short int data_length)
{
  unsigned short int i, len;

  for (i = 0, len = data_length; i < data_length; i += 32, len -= 32)
  {
    while (CDC_Transmit_FS((unsigned char *)message + i, (len > 32) ? 32 : len) != USBD_OK)
      ;
  }
}


void Send_USB_short_int(unsigned short int Value){
  unsigned char XBuffer[128] = "";

  *(unsigned char *)(&XBuffer[0] + 0) = *((unsigned char *)&Value + 0);
  *(unsigned char *)(&XBuffer[0] + 1) = *((unsigned char *)&Value + 1);
  while (CDC_Transmit_FS((unsigned char *)(&XBuffer[0] + 0), 2) != USBD_OK)
    ;
}


void Send_USB_long_int(unsigned long int Value){
  unsigned char XBuffer[128] = "";

  *(unsigned char *)(&XBuffer[0] + 0) = *((unsigned char *)&Value + 0);
  *(unsigned char *)(&XBuffer[0] + 1) = *((unsigned char *)&Value + 1);
  *(unsigned char *)(&XBuffer[0] + 2) = *((unsigned char *)&Value + 2);
  *(unsigned char *)(&XBuffer[0] + 3) = *((unsigned char *)&Value + 3);
  while (CDC_Transmit_FS((unsigned char *)(&XBuffer[0] + 0), 4) != USBD_OK)
    ;
}


void Send_USB_float(float Value){
  unsigned char XBuffer[128] = "";

  *(unsigned char *)(&XBuffer[0] + 0) = *((unsigned char *)&Value + 0);
  *(unsigned char *)(&XBuffer[0] + 1) = *((unsigned char *)&Value + 1);
  *(unsigned char *)(&XBuffer[0] + 2) = *((unsigned char *)&Value + 2);
  *(unsigned char *)(&XBuffer[0] + 3) = *((unsigned char *)&Value + 3);
  while (CDC_Transmit_FS((unsigned char *)(&XBuffer[0] + 0), 4) != USBD_OK)
    ;
}
