#include "Glob.h"

uint16_t ADC[6] __attribute__((section(".dma_buffer"))) = {0,0,0,0,0,0};

__attribute__((section(".dma_buffer")))
uint8_t AsuRX[256];
__attribute__((section(".dma_buffer")))
uint8_t AsuTX[256];

const uint8_t aucCRCHi[] = {
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40, 0x00, 0xC1, 0x81, 0x40,
    0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0, 0x80, 0x41, 0x00, 0xC1,
    0x81, 0x40, 0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41,
    0x00, 0xC1, 0x81, 0x40, 0x01, 0xC0, 0x80, 0x41, 0x01, 0xC0,
    0x80, 0x41, 0x00, 0xC1, 0x81, 0x40
};

const uint8_t aucCRCLo[] = {
    0x00, 0xC0, 0xC1, 0x01, 0xC3, 0x03, 0x02, 0xC2, 0xC6, 0x06,
    0x07, 0xC7, 0x05, 0xC5, 0xC4, 0x04, 0xCC, 0x0C, 0x0D, 0xCD,
    0x0F, 0xCF, 0xCE, 0x0E, 0x0A, 0xCA, 0xCB, 0x0B, 0xC9, 0x09,
    0x08, 0xC8, 0xD8, 0x18, 0x19, 0xD9, 0x1B, 0xDB, 0xDA, 0x1A,
    0x1E, 0xDE, 0xDF, 0x1F, 0xDD, 0x1D, 0x1C, 0xDC, 0x14, 0xD4,
    0xD5, 0x15, 0xD7, 0x17, 0x16, 0xD6, 0xD2, 0x12, 0x13, 0xD3,
    0x11, 0xD1, 0xD0, 0x10, 0xF0, 0x30, 0x31, 0xF1, 0x33, 0xF3,
    0xF2, 0x32, 0x36, 0xF6, 0xF7, 0x37, 0xF5, 0x35, 0x34, 0xF4,
    0x3C, 0xFC, 0xFD, 0x3D, 0xFF, 0x3F, 0x3E, 0xFE, 0xFA, 0x3A,
    0x3B, 0xFB, 0x39, 0xF9, 0xF8, 0x38, 0x28, 0xE8, 0xE9, 0x29,
    0xEB, 0x2B, 0x2A, 0xEA, 0xEE, 0x2E, 0x2F, 0xEF, 0x2D, 0xED,
    0xEC, 0x2C, 0xE4, 0x24, 0x25, 0xE5, 0x27, 0xE7, 0xE6, 0x26,
    0x22, 0xE2, 0xE3, 0x23, 0xE1, 0x21, 0x20, 0xE0, 0xA0, 0x60,
    0x61, 0xA1, 0x63, 0xA3, 0xA2, 0x62, 0x66, 0xA6, 0xA7, 0x67,
    0xA5, 0x65, 0x64, 0xA4, 0x6C, 0xAC, 0xAD, 0x6D, 0xAF, 0x6F,
    0x6E, 0xAE, 0xAA, 0x6A, 0x6B, 0xAB, 0x69, 0xA9, 0xA8, 0x68,
    0x78, 0xB8, 0xB9, 0x79, 0xBB, 0x7B, 0x7A, 0xBA, 0xBE, 0x7E,
    0x7F, 0xBF, 0x7D, 0xBD, 0xBC, 0x7C, 0xB4, 0x74, 0x75, 0xB5,
    0x77, 0xB7, 0xB6, 0x76, 0x72, 0xB2, 0xB3, 0x73, 0xB1, 0x71,
    0x70, 0xB0, 0x50, 0x90, 0x91, 0x51, 0x93, 0x53, 0x52, 0x92,
    0x96, 0x56, 0x57, 0x97, 0x55, 0x95, 0x94, 0x54, 0x9C, 0x5C,
    0x5D, 0x9D, 0x5F, 0x9F, 0x9E, 0x5E, 0x5A, 0x9A, 0x9B, 0x5B,
    0x99, 0x59, 0x58, 0x98, 0x88, 0x48, 0x49, 0x89, 0x4B, 0x8B,
    0x8A, 0x4A, 0x4E, 0x8E, 0x8F, 0x4F, 0x8D, 0x4D, 0x4C, 0x8C,
    0x44, 0x84, 0x85, 0x45, 0x87, 0x47, 0x46, 0x86, 0x82, 0x42,
    0x43, 0x83, 0x41, 0x81, 0x80, 0x40
};


int32_t counterUpdateDisp = 0;

uint8_t startCompile = 0;
uint8_t thereNoSpaceFlash = 0;
uint8_t workRedactor = 0;
uint8_t onOffCursor = 0;
uint8_t readyClock = 0;
uint8_t updateDispZmodem = 0;
uint8_t outFileSistem = 0;
int32_t errorsExchangeDio = 0;
int16_t counterChar = 0;
int32_t usbConect = 0;

int16_t counterTryTransmitionUsbDisp = 0;
uint8_t flagTryTransmitionUsbDisp    = 0;

void centerText(char *textinput, char* textoutput, int fieldWidth) {
    int padlen = (fieldWidth - strlen(textinput)) / 2;
    sprintf(textoutput,"%*s%s%*s", padlen, "", textinput, padlen, "");
}

void addCharStr(uint8_t *textinput, char ch, int16_t *cell)
{
	uint16_t i, j, size;
	size = strnlen((char*)textinput, 63) + 1;
	if(size>=64)
	{
		return;
	}
    uint8_t str[size + 4];
    memset(str, 0, sizeof(str));

    for(i = 0, j = 0; i < size; i++)
    {
    	if(i == *cell)
    	{
    		str[i] = ch;
    	}
    	else
    		{
    		str[i] = textinput[j++];
    		}
    }
    *cell = *cell + 1;
    strcpy((char*)textinput, (char*)str);
}


void dellCharStr(uint8_t *textinput, int16_t *cell)
{
	uint16_t i, j, size;
	size = strnlen((char*)textinput, 63);
	if(size>=64 || size == 0 || *cell == 0)
	{
		return;
	}
    uint8_t str[size + 4];
    memset(str, 0, sizeof(str));

    for(i = 0, j = 0; i < size; i++)
    {
    	if(i != (*cell - 1))
    	{
    		str[j++] = textinput[i];
    	}
    }
    *cell = *cell - 1;
    strcpy((char*)textinput, (char*)str);
}


uint8_t* addSpaceInStr(uint8_t *text, int32_t size)
{
	static char str[80];
	memset(str, 0, 80);
	int16_t i, len;

	if(strnlen((char*)text,79) < (80 - size))
	{
		strcpy((char*)str, (char*)text);
		len = strlen((char*)text);
		for(i = len; i < size; i++)
		{
			str[i] = ' ';
		}
		return((uint8_t*)&str);
	}

	return((uint8_t*)&str);
}


uint16_t filter24V(uint16_t x)
{
	static uint16_t n;
	static uint16_t m[N];
	static uint32_t y;
	y=y+(x-m[n]);
	m[n]=x;
	n=(n+1)%N;
	return y/N;
}

uint16_t filterCurrent24(uint16_t x)
{
	static uint16_t n;
	static uint16_t m[N];
	static uint32_t y;
	y=y+(x-m[n]);
	m[n]=x;
	n=(n+1)%N;
	return y/N;
}

uint16_t filter5V(uint16_t x)
{
	static uint16_t n;
	static uint16_t m[N];
	static uint32_t y;
	y=y+(x-m[n]);
	m[n]=x;
	n=(n+1)%N;
	return y/N;
}

uint16_t filterCurrent5V(uint16_t x)
{
	static uint16_t n;
	static uint16_t m[N];
	static uint32_t y;
	y=y+(x-m[n]);
	m[n]=x;
	n=(n+1)%N;
	return y/N;
}

uint16_t filterReserve24V(uint16_t x)
{
	static uint16_t n;
	static uint16_t m[N];
	static uint32_t y;
	y=y+(x-m[n]);
	m[n]=x;
	n=(n+1)%N;
	return y/N;
}


uint16_t AsuCRC16(uint8_t *pucFrame, uint32_t usLen)
{
	uint8_t           ucCRCHi = 0xFF;
	uint8_t           ucCRCLo = 0xFF;
	int32_t iIndex;

	while( usLen-- )
	{
		iIndex = ucCRCLo ^ *( pucFrame++ );
		ucCRCLo = ucCRCHi ^ aucCRCHi[iIndex];
		ucCRCHi = aucCRCLo[iIndex];;
	}
	return ucCRCHi << 8 | ucCRCLo;
}


void DebugSetup (void)
{
   // uint32_t SWOSpeed = 2000000;/* we have default 2 Mbps SWO speed in ST-Link SWV viewer */
   // uint32_t SWOPrescaler = (SystemCoreClock / SWOSpeed) - 1; /* SWOSpeed in Hz */

   // DBGMCU->CR |= DBGMCU_CR_DBG_CKD3EN | DBGMCU_CR_DBG_CKD1EN | DBGMCU_CR_DBG_TRACECKEN;
   //UNLOCK FUNNEL
  // *(__IO uint32_t*)(0x5C004FB0) = 0xC5ACCE55; // SWTF_LAR
  // *(__IO uint32_t*)(0x5C003FB0) = 0xC5ACCE55; // SWO_LAR

   //SWO current output divisor register
   //This divisor value (0x000000C7) corresponds to 400Mhz
   //To change it, you can use the following rule
   // value = (CPU Freq/sw speed )-1
  // *(__IO uint32_t*)(0x5C003010) = SWOPrescaler; // SWO_CODR

   //SWO selected pin protocol register
  //*(__IO uint32_t*)(0x5C0030F0) = 0x00000002; // SWO_SPPR NRZ

  //Enable ITM input of SWO trace funnel
  //*(__IO uint32_t*)(0x5C004000) |= 0x00000001; // SWFT_CTRL

 // TPI->SPPR = 0x00000002;        /* 'Selected PIN Protocol Register': Select which protocol to use for trace output (2: SWO UART NRZ, 1: SWO Manchester encoding) */
 // TPI->ACPR = SWOPrescaler;      /* 'Async Clock Prescaler Register'. Scale the baud rate of the asynchronous output */

 //ITM->LAR = 0xC5ACCE55;

// ITM->TCR = ITM_TCR_SWOENA_Msk | ITM_TCR_ITMENA_Msk;
// ITM->TER = 0x1;
// ITM->TPR = ITM_TPR_PRIVMASK_Msk;

 MODIFY_REG(GPIOB->MODER, GPIO_MODER_MODE3, 0x2 << GPIO_MODER_MODE3_Pos);
 MODIFY_REG(GPIOB->OSPEEDR,GPIO_OSPEEDR_OSPEED3,0x0 << GPIO_OSPEEDR_OSPEED3_Pos);
 MODIFY_REG(GPIOB->PUPDR, GPIO_PUPDR_PUPD3, 0x00 << GPIO_PUPDR_PUPD3_Pos);
 MODIFY_REG(GPIOB->AFR[0], GPIO_AFRL_AFSEL3, 0x0 << GPIO_AFRL_AFSEL3_Pos);
}


