#include "Flash.h"
#include <string.h>

int32_t ChoiceNumberFile = 0;
uint32_t numberFilesInSystem = 0; // ⢮ 䠩  ⥬
uint32_t busySector = 0;
uint32_t defSpace = 0;

uint16_t ListFileItem[sizeFileSystem] __attribute__((section(".D2")));

_sortHead sortHead[sizeFileSystem];
_sortExpData sortExpData[sizeFileSystem];

uint8_t mirrorMemory[0x20000] __attribute__((section(".D2")));


void writeFlashBufferBank2(uint8_t *pBuffer, uint32_t NumberSector, uint32_t addrBegin, uint32_t Size)
{
	uint32_t NumOfPage = 0, NumOfSingle = 0, Addr = 0;

	Addr = ADDR_FLASH_SECTOR_0_BANK2 + 32*128*NumberSector + addrBegin;

	NumOfPage = Size / FLASH_PAGESIZE;

	NumOfSingle = Size % FLASH_PAGESIZE;

	if (NumOfPage == 0)
	{
		writeFlashPageBank2((uint8_t*)pBuffer, (uint32_t*)Addr, Size);
	}
	else
	{
	  while (NumOfPage--)
	  {
	   writeFlashPageBank2((uint8_t*)pBuffer, (uint32_t*)Addr, FLASH_PAGESIZE);
	   Addr += FLASH_PAGESIZE;
	   pBuffer += FLASH_PAGESIZE;
	 }

	 if( NumOfSingle != 0){
	 writeFlashPageBank2((uint8_t*)pBuffer, (uint32_t*)Addr, NumOfSingle);
	 }
	}
}


void writeFlashBufferBank1(uint8_t *pBuffer, uint32_t NumberSector, uint32_t addrBegin, uint32_t Size)
{
	uint32_t NumOfPage = 0, NumOfSingle = 0, Addr = 0;

	Addr = ADDR_FLASH_SECTOR_0_BANK1 + 32*128*NumberSector + addrBegin;

	NumOfPage = Size / FLASH_PAGESIZE;

	NumOfSingle = Size % FLASH_PAGESIZE;

	if (NumOfPage == 0)
	{
		writeFlashPageBank1((uint8_t*)pBuffer, (uint32_t*)Addr, Size);
	}
	else
	{
	  while (NumOfPage--)
	  {
	   writeFlashPageBank1((uint8_t*)pBuffer, (uint32_t*)Addr, FLASH_PAGESIZE);
	   Addr += FLASH_PAGESIZE;
	   pBuffer += FLASH_PAGESIZE;
	 }

	 if( NumOfSingle != 0){
	 writeFlashPageBank1((uint8_t*)pBuffer, (uint32_t*)Addr, NumOfSingle);
	 }
	}
}


void writeFlashCopySector(uint32_t *addr)
{
	uint32_t NumOfPage = 0x20000 / FLASH_PAGESIZE;
	uint8_t row_index;

	__IO uint32_t *dest_addr = (__IO uint32_t*)&mirrorMemory;
	__IO uint32_t *src_addr = addr;

	while (NumOfPage--)
	{
		row_index = 8;
		do
		{
			*dest_addr = *src_addr;
			dest_addr++;
			src_addr++;
			row_index--;
		}while (row_index != 0U);
	}
}


void writeFlashPageBank1(uint8_t *pBuffer, uint32_t *addr, uint8_t size)
{
	if(size > 0 && size <= 32)
	{
	uint8_t buf[32];
	memset(buf,0xff,sizeof(buf));
    memcpy(buf, (uint8_t*)pBuffer, size);
	__IO uint32_t *src_addr = (__IO uint32_t*)&buf;
	__IO uint32_t *dest_addr = addr;

	FLASH->CCR1 = 0xFEF0000; //  䫠 

	while(FLASH->SR1 & FLASH_SR_QW);//      

	if(READ_BIT(FLASH->CR1, FLASH_CR_LOCK) != 0U)
	{
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY1);
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY2);
	}

	while(READ_BIT(FLASH->CR1, FLASH_CR_LOCK));

	MODIFY_REG(FLASH->CR1, FLASH_CR_PSIZE, 0x3 << FLASH_CR_PSIZE_Pos);
	SET_BIT(FLASH->CR1, FLASH_CR_PG);
	  __ISB();
	  __DSB();
	uint8_t row_index = 8;
	do
	{
	  *dest_addr = *src_addr;
	  dest_addr++;
	  src_addr++;
	  row_index--;
	}while (row_index != 0U);
	  __ISB();
	  __DSB();
	while(FLASH->SR1 & FLASH_SR_QW);//     樨 ࠡ  
	CLEAR_BIT(FLASH->CR1, FLASH_CR_PG);
	SET_BIT(FLASH->CR1, FLASH_CR_LOCK);

	}
}


void writeFlashPageBank2(uint8_t *pBuffer, uint32_t *dest_addr, uint8_t size)
{
	if(size > 0 && size <= 32)
	{
	static uint8_t buf[32];
	memset(buf, 0xff, sizeof(buf));
    memcpy(buf, pBuffer, size);
	__IO uint32_t *src_addr = (__IO uint32_t*)&buf;
	__IO uint32_t *destAdr = dest_addr;

	FLASH->CCR2 = 0xFEF0000; //  䫠 

	while(FLASH->SR2 & FLASH_SR_QW);//      

	if(READ_BIT(FLASH->CR2, FLASH_CR_LOCK) != 0U)
	{
	  WRITE_REG(FLASH->KEYR2, FLASH_KEY1);
	  WRITE_REG(FLASH->KEYR2, FLASH_KEY2);
	}
	while(READ_BIT(FLASH->CR2, FLASH_CR_LOCK));
	MODIFY_REG(FLASH->CR2, FLASH_CR_PSIZE, 0x3 << FLASH_CR_PSIZE_Pos);
	SET_BIT(FLASH->CR2, FLASH_CR_PG);
	  __ISB();
	  __DSB();
	uint8_t row_index = 8;
	do
	{
	  *destAdr = *src_addr;
	   destAdr++;
	   src_addr++;
	   row_index--;
	}while (row_index != 0U);
	  __ISB();
	  __DSB();
	while(FLASH->SR2 & FLASH_SR_QW);//     樨 ࠡ  
	CLEAR_BIT(FLASH->CR2, FLASH_CR_PG);
	SET_BIT(FLASH->CR2, FLASH_CR_LOCK);
	}
}


uint32_t readByteCode(uint32_t addr) // ⥭   4 
{
   return(*(uint32_t*) addr);
}


void eraseSectorFileSystem(uint32_t numberSector, uint32_t len)
{
	uint32_t AddrMin = 0, AddrMax = 0, min = 0, max = 0, i = 0;
	AddrMin = ADDR_FLASH_SECTOR_0_BANK2 + 4096*numberSector;
	AddrMax = ADDR_FLASH_SECTOR_0_BANK2 + 4096*numberSector + 4096*(quantityBusySector(len) - 1);
	min = numberSector;
	max = numberSector + quantityBusySector(len) - 1;

	// ᫨  室   min max  㦭  뢠   

	if(AddrMin >= ADDR_FLASH_SECTOR_0_BANK2 && AddrMax < ADDR_FLASH_SECTOR_1_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_0_BANK2); // ९ᠫ  
		eraseBank2Sector(0); // ⥫  

		for(i = 0; i < 32; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_1_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_0_BANK2 && AddrMin < ADDR_FLASH_SECTOR_1_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_0_BANK2); // ९ᠫ  
				eraseBank2Sector(0); // ⥫  
				for(i = 0; i < 32; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_1_BANK2); // ९ᠫ  
				eraseBank2Sector(1); // ⥫  
				for(i = 32; i < 64; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}


	if(AddrMin >= ADDR_FLASH_SECTOR_1_BANK2 && AddrMax < ADDR_FLASH_SECTOR_2_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_1_BANK2); // ९ᠫ  
		eraseBank2Sector(1); // ⥫  

		for(i = 32; i < 64; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_2_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_1_BANK2 && AddrMin < ADDR_FLASH_SECTOR_2_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_1_BANK2); // ९ᠫ  
				eraseBank2Sector(1); // ⥫  
				for(i = 32; i < 64; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_2_BANK2); // ९ᠫ  
				eraseBank2Sector(2); // ⥫  
				for(i = 64; i < 96; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}


	if(AddrMin >= ADDR_FLASH_SECTOR_2_BANK2 && AddrMax < ADDR_FLASH_SECTOR_3_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_2_BANK2); // ९ᠫ  
		eraseBank2Sector(2); // ⥫  

		for(i = 64; i < 96; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_3_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_2_BANK2 && AddrMin < ADDR_FLASH_SECTOR_3_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_2_BANK2); // ९ᠫ  
				eraseBank2Sector(2); // ⥫  
				for(i = 64; i < 96; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_3_BANK2); // ९ᠫ  
				eraseBank2Sector(3); // ⥫  
				for(i = 96; i < 128; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}


	if(AddrMin >= ADDR_FLASH_SECTOR_3_BANK2 && AddrMax < ADDR_FLASH_SECTOR_4_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_3_BANK2); // ९ᠫ  
		eraseBank2Sector(3); // ⥫  

		for(i = 96; i < 128; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_4_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_3_BANK2 && AddrMin < ADDR_FLASH_SECTOR_4_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_3_BANK2); // ९ᠫ  
				eraseBank2Sector(3); // ⥫  
				for(i = 96; i < 128; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_4_BANK2); // ९ᠫ  
				eraseBank2Sector(4); // ⥫  
				for(i = 128; i < 160; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}

	if(AddrMin >= ADDR_FLASH_SECTOR_4_BANK2 && AddrMax < ADDR_FLASH_SECTOR_5_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_4_BANK2); // ९ᠫ  
		eraseBank2Sector(4); // ⥫  

		for(i = 128; i < 160; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_5_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_4_BANK2 && AddrMin < ADDR_FLASH_SECTOR_5_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_4_BANK2); // ९ᠫ  
				eraseBank2Sector(4); // ⥫  
				for(i = 128; i < 160; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_5_BANK2); // ९ᠫ  
				eraseBank2Sector(5); // ⥫  
				for(i = 160; i < 192; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}

	if(AddrMin >= ADDR_FLASH_SECTOR_5_BANK2 && AddrMax < ADDR_FLASH_SECTOR_6_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_5_BANK2); // ९ᠫ  
		eraseBank2Sector(5); // ⥫  

		for(i = 160; i < 192; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_6_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_5_BANK2 && AddrMin < ADDR_FLASH_SECTOR_6_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_5_BANK2); // ९ᠫ  
				eraseBank2Sector(5); // ⥫  
				for(i = 160; i < 192; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_6_BANK2); // ९ᠫ  
				eraseBank2Sector(6); // ⥫  
				for(i = 192; i < 224; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}


	if(AddrMin >= ADDR_FLASH_SECTOR_6_BANK2 && AddrMax < ADDR_FLASH_SECTOR_7_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_6_BANK2); // ९ᠫ  
		eraseBank2Sector(6); // ⥫  

		for(i = 192; i < 224; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}
	else
		{
			if(AddrMax >= ADDR_FLASH_SECTOR_7_BANK2 && AddrMin >= ADDR_FLASH_SECTOR_6_BANK2 && AddrMin < ADDR_FLASH_SECTOR_7_BANK2)
			{
				sectorReserve(ADDR_FLASH_SECTOR_6_BANK2); // ९ᠫ  
				eraseBank2Sector(6); // ⥫  
				for(i = 192; i < 224; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}

				sectorReserve(ADDR_FLASH_SECTOR_7_BANK2); // ९ᠫ  
				eraseBank2Sector(7); // ⥫  
				for(i = 224; i < 256; i++){
					if(!(i >= min && i <= max)){
						copyReserveSector(i);
					}
				}
			}
		}

	if(AddrMin >= ADDR_FLASH_SECTOR_7_BANK2)
	{
		sectorReserve(ADDR_FLASH_SECTOR_7_BANK2); // ९ᠫ  
		eraseBank2Sector(7); // ⥫  

		for(i = 224; i < 256; i++){
		if(!(i >= min && i <= max)){
		copyReserveSector(i);
		}
		}
	}

}


void sectorReserve(uint32_t addr)
{
	writeFlashCopySector((uint32_t*)addr);
}


void copyReserveSector(uint32_t NumberSector)
{
	uint32_t NumOfPage = 128;
	__IO uint32_t *src_addr = (__IO uint32_t*)&mirrorMemory + ((32*128*(NumberSector%32))/4);
	__IO uint32_t *dest_addr = ADDR_FLASH_SECTOR_0_BANK2 + 32*128*NumberSector; //  

	while (NumOfPage--)
	{
		writeFlashPageBank2((uint8_t*)(src_addr), (uint32_t*)dest_addr, 32);
		dest_addr+=8;
		src_addr+=8;
	}
}


void copyReserveHeaderSector(uint32_t number) // ஢ ᥪ 
{
	int32_t NumOfPage = 2;
	__IO uint32_t *src_addr = (__IO uint32_t*)&mirrorMemory + 64*number/4; 	//  㤠 ஢
	__IO uint32_t *dest_addr = ADDR_FLASH_SECTOR_7_BANK1 + 64*number;	    //    

	while (NumOfPage--)
	{
		writeFlashPageBank1((uint8_t*)(src_addr), (uint32_t*)dest_addr, 32);
		dest_addr+=8;
		src_addr+=8;
	}
}


void eraseBank1Sector(uint32_t sector)
{
	if(sector > 7){ return; }

	FLASH->CCR1 = 0xFEF0000; //  䫠 

	while(FLASH->SR1 & FLASH_SR_QW); //     樨 ࠡ ᯠ
	if(READ_BIT(FLASH->CR1, FLASH_CR_LOCK) != 0U) // ࠧ஢   䫥
	{
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY1);
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY2);
	}

	MODIFY_REG(FLASH->CR1, FLASH_CR_SNB, sector << FLASH_CR_SNB_Pos); // ⠭ ࠭ ᥪ
	SET_BIT(FLASH->CR1,FLASH_CR_SER);
	SET_BIT(FLASH->CR1,FLASH_CR_START);
	while(FLASH->SR1 & FLASH_SR_QW); //     樨 ࠡ ᯠ
	SET_BIT(FLASH->CR1, FLASH_CR_LOCK);
}


void eraseBank2Sector(uint32_t sector)
{
	if(sector > 7){ return; }

	FLASH->CCR2 = 0xFEF0000; //  䫠 

	if(READ_BIT(FLASH->CR2, FLASH_CR_LOCK) != 0U) // ࠧ஢   䫥
	{
	  WRITE_REG(FLASH->KEYR2, FLASH_KEY1);
	  WRITE_REG(FLASH->KEYR2, FLASH_KEY2);
	}

	MODIFY_REG(FLASH->CR2, FLASH_CR_SNB, sector << FLASH_CR_SNB_Pos); // ⠭ ࠭ ᥪ 0
	SET_BIT(FLASH->CR2,FLASH_CR_SER);
	SET_BIT(FLASH->CR2,FLASH_CR_START);
	while(FLASH->SR2 & FLASH_SR_QW); //     樨 ࠡ ᯠ
	SET_BIT(FLASH->CR2, FLASH_CR_LOCK);
}


void writeHeaderFile(uint8_t *pBuffer, uint32_t number) //   䠩
{
	uint32_t NumOfPage = 0, Addr = 0;

	Addr = ADDR_FLASH_SECTOR_7_BANK1 + 64*number;

	NumOfPage = 64 / FLASH_PAGESIZE;

	while (NumOfPage--)
	{
	   writeFlashPageBank1((uint8_t*)pBuffer, (uint32_t*)Addr, FLASH_PAGESIZE);
	   Addr += FLASH_PAGESIZE;
	   pBuffer += FLASH_PAGESIZE;
	}
}


void eraseHeaderFile(uint32_t number) // 㤠  䠩
{
	uint32_t i;
	sectorReserve(ADDR_FLASH_SECTOR_7_BANK1); // ९ᠫ  
	eraseBank1Sector(7); // ⥫  
	for(i = 0; i < sizeFileSystem; i++)
	{
		if(i != number)
		{
			copyReserveHeaderSector(i);
		}
	}
}


int32_t FileSearch(char *str)
{
	   char text[32], name[sizeName], textExtension[sizeTextExtension];
	   memset(text,0,sizeof(text));
	   memset(name,0,sizeof(name));
	   memset(textExtension,0,sizeof(textExtension));

	   for(uint32_t i = 0; i < sizeFileSystem; i++)
	   {
		memcpy(name, HeaderFileList[i]->name, (sizeName - 1));
		memcpy(textExtension, HeaderFileList[i]->textExtension, (sizeTextExtension - 1));
		snprintf(text, sizeof(text) - 1,"%s%c%s", name, '.', textExtension);

		if(strncmp(text, str, 24) == 0)
		{
		return(i);
		}

		memset(text, 0, sizeof(text));
		memset(name, 0, sizeof(name));
		memset(textExtension, 0, sizeof(textExtension));
	   }

	   return(-1);
}


uint32_t crcFile(uint32_t adrr, uint32_t size)
{
    CRC->CR = CRC_CR_POLYSIZE_0; // ன CRC
    CRC->POL = 0x1021; // 
    CRC->INIT = 0X00000000; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    __IO uint16_t *pReg = NULL;

    uint32_t i = 0;
    uint16_t data = 0;
    uint8_t *pBuffer = ( uint8_t*)adrr;

    for (i = 0U; i < (size / 4U); i++)
    {
      CRC->DR = ((uint32_t)pBuffer[4U * i] << 24U) | \
                           ((uint32_t)pBuffer[(4U * i) + 1U] << 16U) | \
                           ((uint32_t)pBuffer[(4U * i) + 2U] << 8U)  | \
                           (uint32_t)pBuffer[(4U * i) + 3U];
    }
    if ((size % 4U) != 0U)
    {
      if ((size % 4U) == 1U)
      {
        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[4U * i];
      }
      if ((size % 4U) == 2U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;
      }
      if ((size % 4U) == 3U)
      {
        data = ((uint16_t)(pBuffer[4U * i]) << 8U) | (uint16_t)pBuffer[(4U * i) + 1U];
        pReg = (__IO uint16_t *)(__IO void *)(&CRC->DR);
        *pReg = data;

        *(__IO uint8_t *)(__IO void *)(&CRC->DR) = pBuffer[(4U * i) + 2U];
      }
    }

    return(CRC->DR);
}


uint32_t crcBootFlash(uint32_t adrr, uint32_t size)
{
    CRC->CR = 0; // ன CRC
    CRC->POL = 0x4C11DB7; // 
    CRC->INIT = 0xFFFFFFFF; // 樠
    CRC->CR |=  CRC_CR_RESET; // ।⥫   CRC
    while(CRC->CR & CRC_CR_RESET);// ࠭஢ 

    uint32_t i;

    for(i = 0; i < size; i+=4)
    {
    	CRC->DR = *(uint32_t*)(adrr + i);
    }

    return(CRC->DR);
}


uint32_t crcBank1Flash(uint32_t adrr, uint32_t size)
{
	while(FLASH->SR1 & FLASH_SR_QW);
	if(READ_BIT(FLASH->CR1, FLASH_CR_LOCK) != 0U)
	{
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY1);
	  WRITE_REG(FLASH->KEYR1, FLASH_KEY2);
	}
	while(READ_BIT(FLASH->CR1, FLASH_CR_LOCK));

	SET_BIT(FLASH->CR1, FLASH_CR_CRC_EN);

	FLASH->CCR1 = 0xFEF0000; //  䫠 

	FLASH->CRCCR1 = FLASH_CRCCR_CRC_BURST_1 | FLASH_CRCCR_CRC_BURST_0 | FLASH_CRCCR_CLEAN_CRC | FLASH_CRCCR_CLEAN_SECT | 2 << FLASH_CRCCR_CRC_SECT_Pos;

	FLASH->CRCSADD1 = adrr;
	FLASH->CRCEADD1 = adrr + size;

	FLASH->CRCCR1 |= FLASH_CRCCR_START_CRC;

	while(!(FLASH->SR1 & FLASH_SR_CRCEND));
	SET_BIT(FLASH->CR1, FLASH_CR_LOCK);

	return( FLASH->CRCDATA );
}


int32_t delFile(int32_t num)
{
	eraseHeaderFile(num);
	return(1);
}


int32_t renameFile(int32_t num, uint8_t *str)
{
	int32_t posPoint, len;
	char name[sizeName], textExtension[sizeTextExtension];
	memset(name,0,sizeof(name));
	memset(textExtension,0,sizeof(textExtension));
	memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

	len = strnlen((char*)str, 24);
	posPoint = charInStr(str, '.', (sizeName + sizeTextExtension));

	if(len > 0 && len <= 23 && posPoint != -1)
	{
		memcpy(name, str, posPoint);
		memcpy(textExtension, str + (posPoint + 1), (len - posPoint - 1));

		textExtension[sizeTextExtension - 1] = 0;

		memcpy(modifyFileHeaderList.name, name, sizeName);
		memcpy(modifyFileHeaderList.textExtension, textExtension, sizeTextExtension);

		modifyFileHeaderList.date = HeaderFileList[num]->date;
		modifyFileHeaderList.time = HeaderFileList[num]->time;
		modifyFileHeaderList.numberSector = HeaderFileList[num]->numberSector;
		modifyFileHeaderList.size = HeaderFileList[num]->size;
		modifyFileHeaderList.crc = HeaderFileList[num]->crc;

		eraseHeaderFile(num);
		writeHeaderFile((uint8_t*)&modifyFileHeaderList, num);
		return(1);
	}

	return(-1);
}


int32_t copyFile(uint8_t *str, int32_t num)
{
	int ret = -1, freeHead = 0, freeSector = 0, len, posPoint;
	char name[sizeName], textExtension[sizeTextExtension];
	memset(name,0,sizeof(name));
	memset(textExtension,0,sizeof(textExtension));

	len = strnlen((char*)str, 24);
	posPoint = charInStr(str, '.', (sizeName + sizeTextExtension));

	if(len > 0 && len <= 23 && posPoint != -1){
	freeHead = searchesVoidHead();

	if(freeHead >= 0){

		freeSector = searchesVoidSector();

		if((numbeSectors - freeSector)*SIZE_CLASTER >= HeaderFileList[num]->size)
		{
			memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

			memcpy(name, str, posPoint);
			memcpy(textExtension, str + (posPoint + 1), (len - posPoint - 1));

			memcpy(modifyFileHeaderList.name, name, sizeName);
			memcpy(modifyFileHeaderList.textExtension, textExtension, sizeTextExtension);

			modifyFileHeaderList.date = HeaderFileList[num]->date;
			modifyFileHeaderList.time = HeaderFileList[num]->time;
			modifyFileHeaderList.size = HeaderFileList[num]->size;
			modifyFileHeaderList.crc = HeaderFileList[num]->crc;
			modifyFileHeaderList.numberSector = freeSector;

			eraseSectorFileSystem(freeSector, HeaderFileList[num]->size);
			eraseHeaderFile(freeHead);
			writeHeaderFile((uint8_t*)&modifyFileHeaderList, freeHead);
			writeFlashBufferBank2((uint8_t*)(HeaderFileList[num]->numberSector*SIZE_CLASTER + ADDR_FLASH_SECTOR_0_BANK2), freeSector, 0, HeaderFileList[num]->size);
			ret = 0;
		}
	}

	}

	return(ret);
}


int32_t fileSearchBC(char *str)
{
	   int32_t addr = 0;
	   uint32_t i = 0;
	   char text[32], name[sizeName], textExtension[sizeTextExtension];
	   memset(text, 0, sizeof(text));
	   memset(name, 0, sizeof(name));
	   memset(textExtension, 0, sizeof(textExtension));

	   for(i = 0; i < sizeFileSystem; i++)
	   {
		   memcpy(name, HeaderFileList[i]->name, (sizeName - 1));
		   memcpy(textExtension, HeaderFileList[i]->textExtension, (sizeTextExtension - 1));
		   snprintf(text, ((sizeName - 1) + (sizeTextExtension - 1)),"%s%c%s", name, '.', textExtension);
		   if(strncmp(text, str, ((sizeName - 1) + (sizeTextExtension - 1))) == 0)  /////////////////////////   ⮬ 訡
		   {
		   	addr = (ADDR_FLASH_SECTOR_7_BANK1 + 64*i);
		   	return(addr);
		   }
		  memset(text, 0, sizeof(text));
		  memset(name, 0, sizeof(name));
		  memset(textExtension, 0, sizeof(textExtension));
	   }
	   	   return(addr);
}


void compileFile(uint32_t num)
{
	char str[32], name[sizeName], textExtension[sizeTextExtension];
	memset(str, 0, sizeof(str));
	memset(name, 0, sizeof(name));
	memset(textExtension, 0, sizeof(textExtension));
	uint32_t *addr = NULL;

	memcpy(name, HeaderFileList[num]->name, (sizeName - 1));
	memcpy(textExtension, HeaderFileList[num]->textExtension, (sizeTextExtension - 1));
	snprintf(str, sizeof(str),"%s%c%s", name, '.', textExtension);
	addr = compile(str);

	uint32_t adr = *(uint32_t*)&(addr);

	if(adr != 0)
	{
		writeExecFileByteCode((uint8_t*)name, adr);
	}
	drawErrors(ERRORS_Y, ERRORS_X);
}


void writeExecFileByteCode(uint8_t * name, uint32_t addr)
{
	int16_t numFile = 0;
	int32_t sector = 0;
	char str[32];
	memset(str, 0, sizeof(str));

	BinFileHead = (_BinFileHead*)(addr);
	snprintf(str, sizeof(str),"%s%c%c%02d", name, '.', 'b', (int)BinFileHead->TaskNum);
	numFile = FileSearch((char*)str);
	memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

	memcpy(modifyFileHeaderList.name, name, strlen((char*)name) > (sizeName - 1) ? (sizeName - 1) : strlen((char*)name));
	memset(str, 0, sizeof(str));
	snprintf(str, sizeof(str),"%c%02d", 'b', (int)BinFileHead->TaskNum);
	memcpy(modifyFileHeaderList.textExtension, str, strlen(str) > (sizeTextExtension - 1) ? (sizeTextExtension - 1) : strlen(str));

	modifyFileHeaderList.date.day    = SysMem.DIO_MIN[0].DIO_00.RTC_Day;
	modifyFileHeaderList.date.mounts = SysMem.DIO_MIN[0].DIO_00.RTC_Mon;
	modifyFileHeaderList.date.year   = SysMem.DIO_MIN[0].DIO_00.RTC_Year - 2000;

	modifyFileHeaderList.time.hour   = SysMem.DIO_MIN[0].DIO_00.RTC_Hour;
	modifyFileHeaderList.time.min    = SysMem.DIO_MIN[0].DIO_00.RTC_Min;
	modifyFileHeaderList.time.sec    = SysMem.DIO_MIN[0].DIO_00.RTC_Sec;

	modifyFileHeaderList.crc = crcFile(addr, BinFileHead->FileSize);
	modifyFileHeaderList.size = BinFileHead->FileSize;

	if(numFile >= 0){ // 諨 䠩

			if(HeaderFileList[numFile]->size/4096 >= BinFileHead->FileSize/4096){

			sector = HeaderFileList[numFile]->numberSector;
			modifyFileHeaderList.numberSector = sector;

			eraseHeaderFile(numFile); // 㤠塞  䠩
			writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);
			eraseSectorFileSystem(sector, BinFileHead->FileSize);
			writeFlashBufferBank2((uint8_t*)addr, sector, 0, BinFileHead->FileSize);
			}
			else{
				sector = searchesVoidSector();
				modifyFileHeaderList.numberSector = sector;

				eraseHeaderFile(numFile); // 㤠塞  䠩
				writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);
				eraseSectorFileSystem(sector, BinFileHead->FileSize);
				writeFlashBufferBank2((uint8_t*)addr, sector, 0, BinFileHead->FileSize);
			}
		}
		else{

			numFile = searchesVoidHead();
			sector = searchesVoidSector();
			modifyFileHeaderList.numberSector = sector;

			if(numFile != -1 && sector != -1){
				eraseHeaderFile(numFile); // 㤠塞  䠩
				writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);

				eraseSectorFileSystem(sector, BinFileHead->FileSize);
				writeFlashBufferBank2((uint8_t*)addr, sector, 0, BinFileHead->FileSize);
			}
			else
				{
				 thereNoSpaceFlash = 1; //  
				}
		}
}



void startEditor(int num)
{
	char str[32], name[sizeName], textExtension[sizeTextExtension];
	memset(str, 0, sizeof(str));
	memset(name, 0, sizeof(name));
	memset(textExtension, 0, sizeof(textExtension));
	memcpy(name, HeaderFileList[num]->name, (sizeName - 1));
	memcpy(textExtension, HeaderFileList[num]->textExtension, (sizeTextExtension - 1));

	snprintf(str, sizeof(str) - 1,"%s%c%s", name, '.', textExtension);

	if(editor(str))
	{
	numberFilesInSystem = quantityFileInSystem();
	}
	else
		{
		drawErrors(ERRORS_Y, ERRORS_X);
		}
		DrawFrame();
}



void writeFileEditor(uint8_t* name, uint32_t addr, uint32_t size)
{
	int32_t len = 0, posPoint = 0, numFile = 0;
	int32_t sector = 0;
		char text[32];
		memset(text, 0, sizeof(text));

		numFile = FileSearch((char*)name);
		memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));
		len = strlen((char*)name);
		posPoint = charInStr(name, '.', len);
		memcpy(&modifyFileHeaderList.name, name, posPoint);
		memcpy(&modifyFileHeaderList.textExtension, (name + posPoint + 1), (len - posPoint - 1));

		modifyFileHeaderList.date.day    = SysMem.DIO_MIN[0].DIO_00.RTC_Day;
		modifyFileHeaderList.date.mounts =  SysMem.DIO_MIN[0].DIO_00.RTC_Mon;
		modifyFileHeaderList.date.year   =  SysMem.DIO_MIN[0].DIO_00.RTC_Year - 2000;
		modifyFileHeaderList.time.hour   = SysMem.DIO_MIN[0].DIO_00.RTC_Hour;
		modifyFileHeaderList.time.min    = SysMem.DIO_MIN[0].DIO_00.RTC_Min;
		modifyFileHeaderList.time.sec    = SysMem.DIO_MIN[0].DIO_00.RTC_Sec;
		modifyFileHeaderList.crc = crcFile(addr, size);
		modifyFileHeaderList.size = size;

		if(numFile >= 0){ // 諨 䠩

				if(quantityBusySector(HeaderFileList[numFile]->size)*SIZE_CLASTER >= size){ // ᫨ ࠧ 䠩 頥   䫥 १ᠭ 䠩

				sector = HeaderFileList[numFile]->numberSector;
				modifyFileHeaderList.numberSector = sector;

				eraseHeaderFile(numFile); // 㤠塞  䠩
				writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);
				eraseSectorFileSystem(sector, size);
				writeFlashBufferBank2((uint8_t*)addr, sector, 0, size);
				}
				else{
					sector = searchesVoidSector();
					modifyFileHeaderList.numberSector = sector;

					eraseHeaderFile(numFile); // 㤠塞  䠩
					writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);
					eraseSectorFileSystem(sector, size);
					writeFlashBufferBank2((uint8_t*)addr, sector, 0, size);
				}
			}
			else{

				numFile = searchesVoidHead();
				sector = searchesVoidSector();
				modifyFileHeaderList.numberSector = sector;

				if(numFile != -1 && sector != -1){
					eraseHeaderFile(numFile); // 㤠塞  䠩
					writeHeaderFile((uint8_t*)&modifyFileHeaderList, numFile);

					eraseSectorFileSystem(sector, size);
					writeFlashBufferBank2((uint8_t*)addr, sector, 0, size);
				}
				else
					{
					 thereNoSpaceFlash = 1; //  
					}
			}

		numberFilesInSystem = quantityFileInSystem();
}


/*  ࠡ  䠩*/


int32_t searchesVoidSector(void)
{
	uint32_t quantitySector = 0, oldquantitySector = 0, numberSector = 0, i = 0;

	for(i = 0; i < sizeFileSystem; i++)
	{
		if(busyHeaderName(i))
		{
			quantitySector = HeaderFileList[i]->numberSector + quantityBusySector(HeaderFileList[i]->size);
			if(quantitySector > oldquantitySector)
			{
			 numberSector = quantitySector;
			oldquantitySector = quantitySector;
			}
		}
	}
	return(numberSector);
}


int32_t busyHeaderName(int32_t num)
{
	int16_t i;
	for(i = 0; i < sizeName; i++)
	{
		if(HeaderFileList[num]->name[i] != 0xff)
		{
			return(1);
		}
	}
	return(0);
}


int32_t searchesVoidHead(void)
{
	uint32_t i;
	for(i = 0; i < sizeFileSystem; i++)
	{
		if(busyHeaderName(i) == 0)
		{
		return(i);
		}
	}

	return(-1);
}


uint32_t quantityFileInSystem(void)
{
	uint32_t i, countFile = 0;
	struct tm t;

	for(i = 0; i < sizeFileSystem; i++)
	{
		if(busyHeaderName(i))
		{
			sortExpData[countFile].numHead = i;
			strncpy((char*)sortExpData[countFile].exp, HeaderFileList[i]->textExtension, sizeTextExtension - 1);
			strncpy((char*)sortExpData[countFile].name, HeaderFileList[i]->name, sizeName - 1);

		    t.tm_year = HeaderFileList[i]->date.year + 2000 -1900;
		    t.tm_mon =  HeaderFileList[i]->date.mounts;
		    t.tm_mday = HeaderFileList[i]->date.day;
		    t.tm_hour = HeaderFileList[i]->time.hour;
		    t.tm_min =  HeaderFileList[i]->time.min;
		    t.tm_sec =  HeaderFileList[i]->time.sec;
		    t.tm_isdst = -1;
		    sortExpData[countFile].data = mktime(&t);

			ListFileItem[countFile++] = i;
		}
	}

	if(countFile > 0)
	{
		//qsort(sortExpData, countFile, sizeof(_sortExpData), exp_c);
		qsort(sortExpData, countFile, sizeof(_sortExpData),  strcasecmp_withNumbers);
		//qsort(sortExpData, countFile, sizeof(_sortExpData), data_c);

		for(i = 0; i < countFile; i++)
		{
			ListFileItem[i] = sortExpData[i].numHead;
		}
	}

	return(countFile);
}


int32_t quantityBusySectorSystem(void)
{
	uint32_t i;
	int32_t quantitySector = 0;

	for(i = 0; i < numberFilesInSystem; i++)
	{
		quantitySector += quantityBusySector(HeaderFileList[ListFileItem[i]]->size);
	}
	return(quantitySector);
}


int32_t defragmentedSpace(void)
{
	uint32_t i = 0, sector = 0;
	int32_t quantitySector = 0;
	copyHead();
	qsort(sortHead, numberFilesInSystem, sizeof(_sortHead), cmpSector);

			for(i = 0; i < numberFilesInSystem; i++)
			{
				if(i == 0)
				{
					if(sortHead[i].sector != sector)
					{
						quantitySector += (sortHead[i].sector - sector);
						sector += (sortHead[i].sector - sector);
					}
				}
				else
				{
					if(sortHead[i].sector != sector)
					{
						quantitySector += (sortHead[i].sector - sector);
						sector += (sortHead[i].sector - sector);
					}
				}
				sector += quantityBusySector(sortHead[i].size);
			}

	return(quantitySector);
}


int32_t quantityBusySector(int32_t n)
{
	int sector = 0;

	do{
		n = n - 4096;
		sector++;
	}while(n > 0);

	return(sector);
}


int32_t createFile(uint8_t *name, int size)
{
	int freeHeader = 0, len = 0, posPoint = 0;
	char text[32];
	memset(text, 0, sizeof(text));

	freeHeader = searchesVoidHead(); // 饬  㤠 뢠 

		if(freeHeader >= 0)
		{
			len = strlen((char*)name);
			posPoint = charInStr(name, '.', len);

			if(len > 0 && len <= 23 && posPoint != -1)
			{
					memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

					memcpy(&modifyFileHeaderList.name, name, posPoint);
					memcpy(&modifyFileHeaderList.textExtension, (name + posPoint + 1), (len - posPoint - 1));

					modifyFileHeaderList.name[19] = 0;
					modifyFileHeaderList.textExtension[3] = 0;

					modifyFileHeaderList.date.day    =  SysMem.DIO_MIN[0].DIO_00.RTC_Day;
					modifyFileHeaderList.date.mounts =  SysMem.DIO_MIN[0].DIO_00.RTC_Mon;
					modifyFileHeaderList.date.year   =  SysMem.DIO_MIN[0].DIO_00.RTC_Year - 2000;
					modifyFileHeaderList.time.hour   =  SysMem.DIO_MIN[0].DIO_00.RTC_Hour;
					modifyFileHeaderList.time.min    =  SysMem.DIO_MIN[0].DIO_00.RTC_Min;
					modifyFileHeaderList.time.sec    =  SysMem.DIO_MIN[0].DIO_00.RTC_Sec;
					modifyFileHeaderList.size = size;
					modifyFileHeaderList.numberSector = searchesVoidSector();

					eraseHeaderFile(freeHeader); // ⪠  䠩
					writeHeaderFile((uint8_t*)&modifyFileHeaderList, freeHeader);
					numberFilesInSystem = quantityFileInSystem();

					return(1);
			}
		}

	return(-1);
}


/*ࠣ*/
void copyHead(void)
{
	for(int16_t i = 0; i < numberFilesInSystem; i++)
	{
	sortHead[i].numHead = ListFileItem[i];
	sortHead[i].sector = HeaderFileList[ListFileItem[i]]->numberSector;
	sortHead[i].size = HeaderFileList[ListFileItem[i]]->size;
	}
}


int cmpSector(const void *a1, const void *a2)
{
	return (((_sortHead*)a1)->sector - ((_sortHead*)a2)->sector);
}


int transferSector(uint32_t inSector, uint32_t outSector, uint32_t len)
{
	uint32_t i, size = 0, adr = 0;

	adr = ADDR_FLASH_SECTOR_0_BANK2 + outSector*SIZE_CLASTER;

	size = quantityBusySector(len);

	for(i = 0; i < size; i ++)
	{
		eraseSectorFileSystem((inSector + i), SIZE_CLASTER-1);
		writeFlashBufferBank2((uint8_t*)(adr + i*SIZE_CLASTER), (inSector + i), 0, SIZE_CLASTER);
	}
	return(1);
}


int overwritingFile(void)
{
uint32_t i, inSector = 0;

for(i = 0; i < numberFilesInSystem; i ++)
{

	memset(&modifyFileHeaderList, 0, sizeof(modifyFileHeaderList));

	if(i == 0)
	{
		if(sortHead[i].sector != inSector)
		{
			memcpy(modifyFileHeaderList.name, HeaderFileList[sortHead[i].numHead]->name, sizeName);
			memcpy(modifyFileHeaderList.textExtension, HeaderFileList[sortHead[i].numHead]->textExtension, sizeTextExtension);

			modifyFileHeaderList.date = HeaderFileList[sortHead[i].numHead]->date;
			modifyFileHeaderList.time = HeaderFileList[sortHead[i].numHead]->time;
			modifyFileHeaderList.numberSector = inSector;
			modifyFileHeaderList.size = HeaderFileList[sortHead[i].numHead]->size;
			modifyFileHeaderList.crc = HeaderFileList[sortHead[i].numHead]->crc;

			transferSector(inSector, sortHead[i].sector, modifyFileHeaderList.size);
			eraseHeaderFile(sortHead[i].numHead);
			writeHeaderFile((uint8_t*)&modifyFileHeaderList, sortHead[i].numHead);
		}
	}
	else
	{
		if(sortHead[i].sector != inSector)
		{
			memcpy(modifyFileHeaderList.name, HeaderFileList[sortHead[i].numHead]->name, sizeName);
			memcpy(modifyFileHeaderList.textExtension, HeaderFileList[sortHead[i].numHead]->textExtension, sizeTextExtension);

			modifyFileHeaderList.date = HeaderFileList[sortHead[i].numHead]->date;
			modifyFileHeaderList.time = HeaderFileList[sortHead[i].numHead]->time;
			modifyFileHeaderList.numberSector = inSector;
			modifyFileHeaderList.size = HeaderFileList[sortHead[i].numHead]->size;
			modifyFileHeaderList.crc = HeaderFileList[sortHead[i].numHead]->crc;

			eraseHeaderFile(sortHead[i].numHead);
			writeHeaderFile((uint8_t*)&modifyFileHeaderList, sortHead[i].numHead);
			transferSector(inSector, sortHead[i].sector, modifyFileHeaderList.size);
		}
	}

	inSector += quantityBusySector(sortHead[i].size);

	outputScaleProgressbar(&popUpProgressbar, (int16_t)(((float)i/(float)(numberFilesInSystem - 1))*100.0));
}
closePopUpProgressbar(&popUpProgressbar);

return(1);
}


int exp_c(const void * a, const void * b)
{
   return(strcmpi((char*)((_sortExpData *)a)->exp, (char*)((_sortExpData *)b)->exp));
}

int name_c(const void * a, const void * b)
{
	return(strcmpi((char*)((_sortExpData *)a)->name, (char*)((_sortExpData *)b)->name));
}

int strcasecmp_withNumbers(const void *void_a, const void *void_b) {
   const char *a = (const char*)((_sortExpData *)void_a)->name;
   const char *b = (const char*)((_sortExpData *)void_b)->name;

   if (!a || !b) { // if one doesn't exist, other wins by default
      return a ? 1 : b ? -1 : 0;
   }
   if (isdigit(*a) && isdigit(*b)) { // if both start with numbers
      char *remainderA;
      char *remainderB;
      long valA = strtol(a, &remainderA, 10);
      long valB = strtol(b, &remainderB, 10);
      if (valA != valB)
         return valA - valB;
      // if you wish 7 == 007, comment out the next two lines
      else if (remainderB - b != remainderA - a) // equal with diff lengths
         return (remainderB - b) - (remainderA - a); // set 007 before 7
      else // if numerical parts equal, recurse
         return strcasecmp_withNumbers(remainderA, remainderB);
   }
   if (isdigit(*a) || isdigit(*b)) { // if just one is a number
      return isdigit(*a) ? -1 : 1; // numbers always come first
   }
   while (*a && *b) { // non-numeric characters
      if (isdigit(*a) || isdigit(*b))
         return strcasecmp_withNumbers(a, b); // recurse
      if (tolower(*a) != tolower(*b))
         return tolower(*a) - tolower(*b);
      a++;
      b++;
   }
   return *a ? 1 : *b ? -1 : 0;
}


int data_c(const void * a, const void * b)
{
   return(((_sortExpData *)a)->data - ((_sortExpData *)b)->data);
}
