#ifndef   zmodem
#define   zmodem

#include "SysVar.h"
#include "Flash.h"
#include <string.h>
#include <time.h>
#include "menu.h"
#include "Glob.h"

#define ZPAD			'*'
#define ZBIN 			'A'
#define ZHEX 			'B'
#define ZBIN32 			'C'

#define ZRQINIT			0	/* Request attention */
#define ZRINIT			1	/* Attention header */
#define ZSINIT			2	/* */
#define ZACK			3	/* Acknowlege request */
#define ZFILE			4	/* File name from sender */
#define ZSKIP			5	/* To sender: skip this file */
#define ZNAK			6	/* Last packet was garbled */
#define ZABORT			7	/* Abort batch transfers */
#define ZFIN   			8	/* Finish session */
#define ZRPOS			9	/* Resume data trans at this position */
#define ZDATA			10	/* Data packet(s) follow */
#define ZEOF			11	/* End of file */
#define ZFERR			12	/* Fatal Read or Write error Detected */
#define ZCRC			13	/* Request for file CRC and response */
#define ZCHALLENGE		14	/* Receiver's Challenge */
#define ZCOMPL			15	/* Request is complete */
#define ZCAN			16	/* Other end canned session with CAN*5 */
#define ZFREECNT		17	/* Request for free bytes on filesystem */
#define ZCOMMAND		18	/* Command from sending program */
#define ZSTDERR			19	/* Output to standard error, data follows */

#define ZCRCE 'h'	/* CRC next, frame ends, header packet follows */
#define ZCRCG 'i'	/* CRC next, frame continues nonstop */
#define ZCRCQ 'j'	/* CRC next, frame continues, ZACK expected */
#define ZCRCW 'k'	/* CRC next, ZACK expected, end of frame */
#define ZRUB0 'l'	/* Translate to rubout 0177 */
#define ZRUB1 'm'	/* Translate to rubout 0377 */

#define CANFC32		0x20
#define CANFDX		0x01
#define CANOVIO		0x02

#define ZDLE		0x18
#define CAN			0x18
#define ZCNL		0x02
#define ZCBIN		0x01
#define ZCRECOV		0x03

#define SM_SENDZDATA	0
#define SM_SENDZEOF		1
#define SM_SENDDATA		2
#define SM_ACTIONRPOS	3
#define SM_WAITZRINIT	4
#define SM_GETHEADER	5

#define NO_ERROR    				0x00
#define ZMODEM_INIT					0x01
#define ZMODEM_POS					0x02
#define ZMODEM_CRC  				0x04
#define ZMODEM_LONGSP				0x05
#define ZMODEM_CRC32				0x06
#define ZMODEM_FILEDATA				0x07
#define ZMODEM_BADHEX				0x08
#define ZMODEM_TIMEOUT				0x09
#define ZMODEM_GOTZCAN				0x0A
#define ZMODEM_ABORTFROMOUTSIDE		0x0B
#define ZMODEM_ERROR_FILE			0x0C

#define CRZ      		0x0D
#define LF				0x0A
#define XON				0x11

#define START           0x80

#define ZMODEMSTARTRECEIVESEND 0xe0

#define ZMODEMRECEIVE   0x80 // ਥ
#define ZMODEMSEND      0xC0 // ।




#define ZMODEM_NULL_ENTRY Null_Zmodem
#define ZMODEM_NULL_FUNC  (void*)0

#define ZMODEM(Name, Next, Previous, Parent, Child, Select, SelectFunc, EnterFunc) \
	extern const ZmodemItem Next;     \
	extern const ZmodemItem Previous; \
	extern const ZmodemItem Parent;   \
	extern const ZmodemItem Child;    \
    const ZmodemItem Name = {(void*)&Next, (void*)&Previous, (void*)&Parent, (void*)&Child, (uint8_t)Select, (FuncPtr)SelectFunc, (FuncPtr)EnterFunc}


#define ZMODEM_PREVIOUS   ((ZmodemItem*)(selectedZmodemItem->Previous))
#define ZMODEM_NEXT       ((ZmodemItem*)(selectedZmodemItem->Next))
#define ZMODEM_PARENT     ((ZmodemItem*)(selectedZmodemItem->Parent))
#define ZMODEM_CHILD      ((ZmodemItem*)(selectedZmodemItem->Child))
#define ZMODEM_SELECT	   (selectedZmodemItem->Select)
#define ZMODEM_SELECTFUNC  ((FuncPtr)(selectedZmodemItem->SelectFunc))
#define ZMODEM_ENTERFUNC   ((FuncPtr)(selectedZmodemItem->EnterFunc))

#define CALLSELECTFUNC if(ZMODEM_SELECTFUNC != (FuncPtr)ZMODEM_NULL_FUNC) \
                          { \
                          ZMODEM_SELECTFUNC(); \
                          }


#define STACK_MAX_SIZE 2048 // ࠧ ⥪ 2048 
#define cleanBuf(buf) memset(buf,0,sizeof(buf));

#define  resetTim17  TIM17->CNT = 0x00; \
                     TIM17->SR = 0; \
                     TIM17->CR1 |= TIM_CR1_CEN;


extern uint32_t LenDataZmodem; // ।  १ zmodem
extern int32_t numberByteReceived; // ⢮ ਭ ⮢


extern uint8_t zmodemRxBuf[2048];

typedef void (*FuncPtr)(void);
        
typedef struct {
	void       *Next;
	void       *Previous;
	void       *Parent;
	void       *Child;
	const char Select;
    FuncPtr    SelectFunc;
    FuncPtr    EnterFunc;
} const ZmodemItem;
extern const ZmodemItem z_s1i1;

ZmodemItem* selectedZmodemItem;

char ZmodemHeadFile[32];

void ZMODEMChange(const ZmodemItem* NewMenu);


enum{
	SEND_HEADER_FILE = 1,
	SEND_ZRPOS,
    SEND_ZDATA,
	SEND_DATA,
	SEND_ZEOF,
	SEND_ZRINIT,
	SEND_ZFIN,
	SEND_OO,
};


typedef struct {
	uint8_t retur;
	uint8_t data[2];
	uint8_t reserve;
} _ZsendByte;
extern _ZsendByte ZsendByte;


typedef struct {
	uint16_t section;
	int16_t head;
} _placAdd;
extern _placAdd placAdd;


typedef struct Stack_tag {
	uint8_t data[STACK_MAX_SIZE];
    uint32_t size;
} Stack_zmodem;
extern Stack_zmodem Stack_Zm;


typedef struct{
	uint8_t buf[1024];
	uint32_t size;
	uint32_t address;
	uint32_t numberSector;
} _BufWriteZmodem;
extern _BufWriteZmodem BufWriteZmodem;

/*㭪樨 ஢    ZMODEM*/
void pushBufWriteZmodem(_BufWriteZmodem *stack, uint8_t var); //    ZMODEM ᫨ 㤥 ⨣ 1024   襬  
void numberSectorBufZmodem(_BufWriteZmodem *stack, uint32_t numberSector); // ⠭ ᥪ 㤠 
void clearBufZmodem(_BufWriteZmodem *stack);
void writeBufZmodem(_BufWriteZmodem *stack);


/*㭪樨 ࠡ  ⥪ zmodem*/
void initStack(Stack_zmodem *stack); // 樠 ⥪
void push(Stack_zmodem *stack, uint8_t value); // 頥  ⥪  
uint8_t pop(Stack_zmodem *stack); // ⨥   ⥪  㤠 孥 
uint8_t scanStack(Stack_zmodem *stack, uint32_t number); // ᪠஢ ⥪     
void modifiedCellStack(Stack_zmodem *stack, uint16_t number, uint8_t value); // 䨪 ।  祩
void deleteGropDataStack(Stack_zmodem *stack, uint32_t len); // 㤠   ⥪ । 
void deleteGropPopDataStack(Stack_zmodem *stack, uint32_t len); // 㤠  設  ⥪
void clearStack(Stack_zmodem *stack); // ⪠ ᥣ ⥪
void delCellWithShiftStack(Stack_zmodem *stack, uint32_t numberCel); // 㤠 祩  ⥪  ᤢ  
uint32_t sizeStack(const Stack_zmodem *stack); // 祭 ࠧ ⥪


void rZModem_sendCAN(void);
void rZModem_sendHexHeader(uint8_t hType);
void rZModem_sendBinHeader(uint8_t hType);
void rZModem_sendHexChar(void);
void rZModem_sendDLEChar(void);
uint8_t rZModem_getNextHexCh(uint8_t arg1 , uint8_t arg2);
uint16_t rZModem_crcUpdate(uint8_t *pBuffer, uint32_t BufferLength);
void putchar1(char c);


uint16_t ZMODEM_CRC16_CHECK_DATA(Stack_zmodem *stack, uint32_t len); //  ஫쭮 㬬  ਥ 䠩
uint16_t ZMODEM_CRC16Stack_HEADER(Stack_zmodem *stack, uint32_t start, uint32_t len); //  crc16   ⥪   ᬥ饭

unsigned short Calculate_CRC_CCITT(const unsigned char* buffer, int size);

uint32_t ZMODEM_CRC32Stack(Stack_zmodem *stack, uint32_t len); //  crc32   ⥪

uint32_t rZModem_getNextHexLenPackage(Stack_zmodem *stack, uint32_t start); // ॢ ப  ᫮  ᪠  䠩
uint32_t rZModem_getNextOctDataTimePackage(Stack_zmodem *stack, uint32_t start); // ॢ ப   ६
uint32_t rZModem_getNextOctModePackage(Stack_zmodem *stack, uint32_t start); // ॢ   hex

void rZModem_setNameFile(char *str); //⠭  䠩  ᪠  ᫥饩 ।

void ZMODEM_CHECK_ZDLE(Stack_zmodem *stack, uint16_t cell); // ஢ઠ  zdle

void ZMODEM_WRITE_HEADER_FILE(Stack_zmodem *stack); // ।    䠩

_ZsendByte ZSend_Byte(uint8_t current_byte); // ஢騪  ।稪

void rZmodemTxUsb(uint8_t *buf, uint32_t len); // ।  ZMODEM १ USB


void ZMODEM_RZ_CR(void);        // 諠  RZ+CR
void ZMODEM_ZRQINIT(void);      // ࠡ⪠ ZRQINIT
void ZMODEM_ZFILE(void);        // ࠡ⪠ ZFILE
void ZMODEM_HEADER_FILE(void);  // ਥ  䠩
void ZMODEM_ZDATA(void);        // ਥ  ZDATA
void ZMODEM_DATA(void);         // ⢥   䠩
void ZMODEM_ZEOF(void);         // 室  䠩
void ZMODEM_ZFIN(void);         // 襫  ZFINE
void ZMODEM_OO(void);           // 襫  "OO"


void ZMODEM_TX_ZRQINIT(void);     // ।   ZMODEM ZRQINIT
void ZMODEM_TX_HEADER_FILE(void); // ।  䠩
void ZMODEM_TX_ZRPOS(void);       // ਥ ZRPOS
void ZMODEM_TX_ZDATA(void);       // ।  ZDATA
void ZMODEM_TX_DATA(void);        // । 䠩
void ZMODEM_TX_ZRINIT(void);      // 祭 ZRINIT
void ZMODEM_TX_ZFIN(void);        // 襫  ZFINE
void ZMODEM_TX_OO(void);          // । "OO"


#endif
