#ifndef   _MENU_H_
#define   _MENU_H_

#include "SysVar.h"
#include "mcurses.h"
#include "Glob.h"
#include "zmodem.h"
#include "Flash.h"

#define NULL_ENTRY Null_Menu
#define NULL_FUNC  (void*)0

#define MAKE_MENU(Name, Next, Previous, Parent, Child, Dell, Copy, Start, Editor, Compilation, Help, Defrag, Creature, StartM, Select, SelectFunc, EnterFunc, PopFunc, Text_RUS,Text_ENG) \
	extern const menuItem Next;        \
	extern const menuItem Previous;    \
	extern const menuItem Parent;      \
	extern const menuItem Child;       \
	extern const menuItem Dell;        \
	extern const menuItem Copy;        \
	extern const menuItem Start;       \
	extern const menuItem Editor;      \
	extern const menuItem Compilation; \
    extern const menuItem Help;        \
	extern const menuItem Defrag;      \
	extern const menuItem Creature;    \
    const menuItem Name = {(void*)&Next, (void*)&Previous, (void*)&Parent, (void*)&Child, (void*)&Dell, (void*)&Copy, (void*)&Start, (void*)&Editor, (void*)&Compilation, (void*)&Help, (void*)&Defrag, (void*)&Creature, \
    					   (uint8_t)StartM, (uint8_t)Select, (FuncPtr)SelectFunc, (FuncPtr)EnterFunc, (FuncPtr)PopFunc, { Text_RUS }, { Text_ENG }}



#define NEXTM        ((menuItem*)(selectedMenuItem->Next))
#define PREVIOUSM    ((menuItem*)(selectedMenuItem->Previous))
#define PARENTM      ((menuItem*)(selectedMenuItem->Parent))
#define CHILDM       ((menuItem*)(selectedMenuItem->Child))
#define DELLM        ((menuItem*)(selectedMenuItem->Dell))
#define COPYM        ((menuItem*)(selectedMenuItem->Copy))
#define STARTB       ((menuItem*)(selectedMenuItem->Start))
#define EDITORM      ((menuItem*)(selectedMenuItem->Editor))
#define COMPILM      ((menuItem*)(selectedMenuItem->Compilation))
#define HELPM        ((menuItem*)(selectedMenuItem->Help))
#define DEFRAG       ((menuItem*)(selectedMenuItem->Defrag))
#define NEWFILE      ((menuItem*)(selectedMenuItem->Creature))
#define STARTM       (selectedMenuItem->StartM)
#define SELECTM	     (selectedMenuItem->Select)
#define SELECTFUNCM  ((FuncPtr)(selectedMenuItem->SelectFunc))
#define ENTERFUNCM   ((FuncPtr)(selectedMenuItem->EnterFunc))
#define POPFUNCM     ((FuncPtr)(selectedMenuItem->PopFunc))


#define Black   0 // 
#define Red     1 // 
#define Green   2 // 
#define Yellow  3 // 
#define Blue    4 // ᨭ
#define Magenta 5 // 䨠⮢
#define Cyan    6 // १
#define White   7 // 

#define X_NameColumn_1 11 //  "" 1
#define Y_NameColumn_1 1

#define X_NameColumn_2 35 //  "" 2
#define Y_NameColumn_2 1

#define X_NameFileColumn_1 1 //    1
#define Y_NameFileColumn_1 2

#define X_NameFileColumn_2 32 //    2
#define Y_NameFileColumn_2 2

#define X_ContentFile 53 // 樨 ᮤন
#define Y_ContentFile 2

#define ERRORS_X 0 //  뢮 ᮮ饭  訡
#define ERRORS_Y 28

#define numberCellWatch 186
#define stepWatch 15 // 蠣 饭  祭 ࠬ஢ ᮢ

// Typedefs:
typedef void (*FuncPtr)(void);

typedef struct {
	void       *Next;
	void       *Previous;
	void       *Parent;
	void       *Child;
	void	   *Dell;
	void       *Copy;
	void       *Start;
	void       *Editor;
	void       *Compilation;
	void       *Help;
	void       *Defrag;
	void       *Creature;
	const char  StartM;
	const char  Select;
    FuncPtr     SelectFunc;   // ணࠬ  ⮡ࠦ  ᠬ 
    FuncPtr     EnterFunc;    // ணࠬ ࠡ, 뢠  ⨨ Enter  
    FuncPtr     PopFunc;      // ணࠬ ᬥ饭 
	const char  Text_RUS[20];
    const char  Text_ENG[20];
} const menuItem;

extern const menuItem m_s1i1;
extern const menuItem m_s1i2;

menuItem* selectedMenuItem; // ⥪騩 㭪 

enum{
    MENU_CANCEL=1,
    MENU_START,
	MENU_EDIT,
    MENU_W1,
    MENU_POP_UP,
	MENU_PROGRESSBAR,
	MENU_SETTINGS,
	MENU_CREATURE,
	MENU_DELL,
	MENU_COPY,
	MENU_STARTB,
	MENU_WARNING,
	MENU_HELP,
	MENU_COMPIL,
	MENU_DEFRAG,
	MENU_CLOCK,
	MENU_SAVE_AS,
	MENU_FS_BUSY,
	MENU_ACK_BOOT
};


enum{
	SETTINGS_CLOCK = 1,
	SETTINGS_BOOT,
};


extern uint16_t blockingWorkMenu; // ஢ ࠡ  ⮫쪮  ।  ਥ  १ ZMODEM
extern int32_t cursorInputX, cursorInputY;
extern uint8_t textPopUp[32];
extern int16_t counterTextPopUp;
extern int16_t offsetFile;        // ᬥ饭 䠩  ⠭
extern int16_t shiftButtonPopUp;  //   롮 ⢨  ᯫ뢠 
extern int16_t popButtonPopUp;    // ᬥ饭   
extern int32_t cursorText;        //  ⥪
extern int16_t choiceSettings;    //  㤥 ࠨ ,  - 㣮

extern const uint8_t functionkeys[15][6];

typedef struct{
	const char     numStr[4];       //  
	const char     str[32];         // ⥪⮢ 
	const uint32_t y;               //  y न
	const uint32_t x;               //  x न
	const uint32_t numColF;         // 梥 
	const uint32_t numColB;         // 梥 
	const uint32_t strColF;         // 梥 
	const uint32_t strColB;         // 梥 䮭
} const _TypeButonPressed;


typedef struct{
	const uint32_t Y;                 //   y न
	const uint32_t X;                 //   x न
	const uint32_t sizeY;             // ࠧ  Y 
	const uint32_t sizeX;             // ࠧ  X 
	const uint32_t frameColF;         // 梥 䮭 
	const uint32_t frameColB;         // 梥  

	const uint32_t srtHeadY;          //    y
	const uint32_t srtHeadX;          //    x
	const uint32_t HeadColF;          // 梥  
	const uint32_t HeadColB;          // 梥  
	const char     Headstr[64];       // ⥪⮢  

	const uint32_t srt1Y;         	  //  ப 1  y
	const uint32_t srt1X;          	  //  ப 1  x
	const uint32_t str1ColF;          // 梥 ப 1 
	const uint32_t str1ColB;          // 梥 ப 1 
	const char     str1[64];          // ⥪⮢  

	const uint32_t inputFieldY;       //   न y
	const uint32_t inputFieldX;       //   न x
	const uint32_t inputFieldOnF;     // 梥    祭
	const uint32_t inputFieldOnB;     // 梥    祭
	const uint32_t inputFieldOffF;    // 梥    몫祭
	const uint32_t inputFieldOffB;    // 梥    몫祭
	const char     inputFieldStr[64]; //  

	const uint32_t ButEnterY;         //   y न
	const uint32_t ButEnterX;         //   x न
	const uint32_t ButEnterOnF;       // 梥  
	const uint32_t ButEnterOnB;       // 梥 䮭 
	const uint32_t ButEnterOffF;      // 梥  
	const uint32_t ButEnterOffB;      // 梥 䮭 
	const char     ButEnterStr[32];   //  

	const uint32_t ButEscY;           //   y न
	const uint32_t ButEscX;           //   x न
	const uint32_t ButEscOnF;         // 梥  
	const uint32_t ButEscOnB;         // 梥 䮭 
	const uint32_t ButEscOffF;        // 梥  
	const uint32_t ButEscOffB;        // 梥 䮭 
	const char     ButEscStr[32];     //  

	const uint32_t ButCancelY;        //   y न
	const uint32_t ButCancelX;        //   x न
	const uint32_t ButCancelOnF;      // 梥  
	const uint32_t ButCancelOnB;      // 梥 䮭 
	const uint32_t ButCancelOffF;     // 梥  
	const uint32_t ButCancelOffB;     // 梥 䮭 
	const char     ButCancelStr[32];  //  

	const char     *frame[];          // ⨯ ࠬ
} const _popUp;


typedef struct{
	const uint32_t Y;                 //   y न
	const uint32_t X;                 //   x न
	const uint32_t sizeY;             // ࠧ  Y 
	const uint32_t sizeX;             // ࠧ  X 
	const uint32_t frameColF;         // 梥 䮭 
	const uint32_t frameColB;         // 梥  

	const uint32_t srtHeadY;          //    y
	const uint32_t srtHeadX;          //    x
	const uint32_t HeadColF;          // 梥  
	const uint32_t HeadColB;          // 梥  
	const char     Headstr[64];       // ⥪⮢  

	const uint32_t srt1Y;         	  //  ப 1  y
	const uint32_t srt1X;          	  //  ப 1  x
	const uint32_t str1OnF;           // 梥 ப 1  祭
	const uint32_t str1OnB;           // 梥 ப 1  祭
	const uint32_t str1OffF;          // 梥 ப 1  몫祭
	const uint32_t str1OffB;          // 梥 ப 1  몫祭
	const char     str1On[64];        // ⥪⮢   ࠭
	const char     str1Off[64];       // ⥪⮢    ࠭

	const uint32_t srt2Y;         	  //  ப 2  y
	const uint32_t srt2X;          	  //  ப 2  x
	const uint32_t str2OnF;           // 梥 ப 2  祭
	const uint32_t str2OnB;           // 梥 ப 2  祭
	const uint32_t str2OffF;          // 梥 ப 2  몫祭
	const uint32_t str2OffB;          // 梥 ப 2  몫祭
	const char     str2On[64];        // ⥪⮢   ࠭
	const char     str2Off[64];       // ⥪⮢    ࠭


	const uint32_t srt3Y;         	  //  ப 3  y
	const uint32_t srt3X;          	  //  ப 3  x
	const uint32_t str3OnF;           // 梥 ப 3  祭
	const uint32_t str3OnB;           // 梥 ப 3  祭
	const uint32_t str3OffF;          // 梥 ப 3  몫祭
	const uint32_t str3OffB;          // 梥 ப 3  몫祭
	const char     str3On[64];        // ⥪⮢   ࠭
	const char     str3Off[64];       // ⥪⮢    ࠭

	const uint32_t srt4Y;         	  //  ப 4  y
	const uint32_t srt4X;          	  //  ப 4  x
	const uint32_t str4OnF;           // 梥 ப 4  祭
	const uint32_t str4OnB;           // 梥 ப 4  祭
	const uint32_t str4OffF;          // 梥 ப 4  몫祭
	const uint32_t str4OffB;          // 梥 ப 4  몫祭
	const char     str4On[64];        // ⥪⮢   ࠭
	const char     str4Off[64];       // ⥪⮢    ࠭

	const uint32_t srt5Y;         	  //  ப 5  y
	const uint32_t srt5X;          	  //  ப 5  x
	const uint32_t str5OnF;           // 梥 ப 5  祭
	const uint32_t str5OnB;           // 梥 ப 5  祭
	const uint32_t str5OffF;          // 梥 ப 5  몫祭
	const uint32_t str5OffB;          // 梥 ப 15  몫祭
	const char     str5On[64];        // ⥪⮢   ࠭
	const char     str5Off[64];       // ⥪⮢    ࠭

	const uint32_t inputFieldY;       //   न y
	const uint32_t inputFieldX;       //   न x
	const uint32_t inputFieldColF;    // 梥 ⥪ 
	const uint32_t inputFieldColB;    // 梥  
	const char     inputFieldStr[64]; //  

	const uint32_t ButEnterY;         //   y न
	const uint32_t ButEnterX;         //   x न
	const uint32_t ButEnterOnF;       // 梥  
	const uint32_t ButEnterOnB;       // 梥 䮭 
	const uint32_t ButEnterOffF;      // 梥  
	const uint32_t ButEnterOffB;      // 梥 䮭 
	const char     ButEnterStr[32];   //  

	const uint32_t ButEscY;           //   y न
	const uint32_t ButEscX;           //   x न
	const uint32_t ButEscOnF;         // 梥  
	const uint32_t ButEscOnB;         // 梥 䮭 
	const uint32_t ButEscOffF;        // 梥  
	const uint32_t ButEscOffB;        // 梥 䮭 
	const char     ButEscStr[32];     //  

	const uint32_t ButCancelY;        //   y न
	const uint32_t ButCancelX;        //   x न
	const uint32_t ButCancelOnF;      // 梥  
	const uint32_t ButCancelOnB;      // 梥 䮭 
	const uint32_t ButCancelOffF;     // 梥  
	const uint32_t ButCancelOffB;     // 梥 䮭 
	const char     ButCancelStr[32];  //  

	const char     *frame[];          // ⨯ ࠬ
} const _settings;



typedef struct{
	const uint32_t Y;                 //   y न
	const uint32_t X;                 //   x न
	const uint32_t sizeY;             // ࠧ  Y 
	const uint32_t sizeX;             // ࠧ  X 
	const uint32_t frameColF;         // 梥 䮭 
	const uint32_t frameColB;         // 梥  

	const uint32_t srtY1;             //    y
	const uint32_t srtX1;             //    x
	const uint32_t strColF1;          // 梥 䮭 
	const uint32_t strColB1;          // 梥  
	const char     Str1[64];          // ⥪⮢  

	const uint32_t srtY2;             //    y
	const uint32_t srtX2;             //    x
	const uint32_t strColF2;          // 梥 䮭 
	const uint32_t strColB2;          // 梥  
	const char     Str2[64];          // ⥪⮢  

	const uint32_t ProgBarY;          // 뢮 ண  न y
	const uint32_t ProgBarX;          // 뢮 ண  न x
	const uint32_t ProgBarColF;       // 梥 ⥪ 
	const uint32_t ProgBarColB;       // 梥  
	const char     ProgBarStr[64];    //  

	const char     *frame[];          // ⨯ ࠬ
} const _popUpProgressbar;


/* */
typedef union{
 struct{
	const uint32_t Y;                 //   y न
	const uint32_t X;                 //   x न
	const uint32_t sizeY;             // ࠧ    Y
	const uint32_t sizeX;             // ࠧ    X
	const uint32_t frameColF;         // 梥 䮭 
	const uint32_t frameColB;         // 梥              //6

	const uint32_t srtY0;             //   y
	const uint32_t srtX0;             //   x
	const uint32_t strColF0;          // 梥 䮭 
	const uint32_t strColB0;          // 梥  
	const char     Str0[64];          // ⥪⮢   //20

	const uint32_t srtY1;             //   y
	const uint32_t srtX1;             //   x
	const uint32_t strColF1;          // 梥 䮭 
	const uint32_t strColB1;          // 梥  
	const char     Str1[64];          // ⥪⮢   //20

	const uint32_t srtY2;             //   y
	const uint32_t srtX2;             //   x
	const uint32_t strColF2;          // 梥 䮭 
	const uint32_t strColB2;          // 梥  
	const char     Str2[64];          // ⥪⮢   // 20

	const uint32_t srtY3;             //   y
	const uint32_t srtX3;             //   x
	const uint32_t strColF3;          // 梥 䮭 
	const uint32_t strColB3;          // 梥  
	const char     Str3[64];          // ⥪⮢   // 20

	const uint32_t srtY4;             //   y
	const uint32_t srtX4;             //   x
	const uint32_t strColF4;          // 梥 䮭 
	const uint32_t strColB4;          // 梥  
	const char     Str4[64];          // ⥪⮢   // 20 + 106

	const uint32_t srtY5;             //   y
	const uint32_t srtX5;             //   x
	const uint32_t strColF5;          // 梥 䮭 
	const uint32_t strColB5;          // 梥  
	const char     Str5[64];          // ⥪⮢   // 20

	const uint32_t srtY6;             //   y
	const uint32_t srtX6;             //   x
	const uint32_t strColF6;          // 梥 䮭 
	const uint32_t strColB6;          // 梥  
	const char     Str6[64];          // ⥪⮢   // 20

	const uint32_t srtY7;             //   y
	const uint32_t srtX7;             //   x
	const uint32_t strColF7;          // 梥 䮭 
	const uint32_t strColB7;          // 梥  
	const char     Str7[64];          // ⥪⮢   // 20

	const uint32_t srtY8;             //   y
	const uint32_t srtX8;             //   x
	const uint32_t strColF8;          // 梥 䮭 
	const uint32_t strColB8;          // 梥  
	const char     Str8[64];          // ⥪⮢   // 20 + 186

	const uint32_t dayY;              //   y +
	const uint32_t dayX;              //   x
	const uint32_t dayColOnF;         // 梥 䮭 
	const uint32_t dayColOnB;         // 梥  
	const uint32_t dayColOffF;        // 梥 䮭  ࠭  
	const uint32_t dayColOffB;        // 梥   ࠭  
	const char     day[16];           // ⥪⮢                     // 10

	const uint32_t pDayY;             //   y
	const uint32_t pDayX;             //   x
	const uint32_t pDayColF;          // 梥 䮭 
	const uint32_t pDayColB;          // 梥  
	const char     pDay[4];           // ⥪⮢                      // 5

	const uint32_t monY;              //   y
	const uint32_t monX;              //   x
	const uint32_t monColOnF;         // 梥 䮭 
	const uint32_t monColOnB;         // 梥  
	const uint32_t monColOffF;        // 梥 䮭  ࠭  
	const uint32_t monColOffB;        // 梥   ࠭  
	const char     mon[16];           // ⥪⮢                       // 10

	const uint32_t pMonY;             //   y
	const uint32_t pMonX;             //   x
	const uint32_t pMonColF;          // 梥 䮭 
	const uint32_t pMonColB;          // 梥  
	const char     pMon[4];           // ⥪⮢                       // 5

	const uint32_t yearY;             //   y
	const uint32_t yearX;             //   x
	const uint32_t yearColOnF;        // 梥 䮭 
	const uint32_t yearColOnB;        // 梥  
	const uint32_t yearColOffF;       // 梥 䮭 
	const uint32_t yearColOffB;       // 梥  
	const char     year[16];          // ⥪⮢                         // 10

	const uint32_t reserve0[5];       //  ७   ᫥騥  // 5

	const uint32_t hourY;             //   y
	const uint32_t hourX;             //   x
	const uint32_t hourColOnF;        // 梥 䮭 
	const uint32_t hourColOnB;        // 梥  
	const uint32_t hourColOffF;       // 梥 䮭 
	const uint32_t hourColOffB;       // 梥  
	const char     hour[16];          // ⥪⮢                         // 10

	const uint32_t pHourY;            //   y
	const uint32_t pHourX;            //   x
	const uint32_t pHourColF;         // 梥 䮭 
	const uint32_t pHourColB;         // 梥  
	const char     pHour[4];          // ⥪⮢                          // 5

	const uint32_t minY;              //   y
	const uint32_t minX;              //   x
	const uint32_t minColOnF;         // 梥 䮭 
	const uint32_t minColOnB;         // 梥  
	const uint32_t minColOffF;        // 梥 䮭 
	const uint32_t minColOffB;        // 梥  
	const char     min[16];           // ⥪⮢                           // 10

	const uint32_t pMinY;             //   y
	const uint32_t pMinX;             //   x
	const uint32_t pMinColF;          // 梥 䮭 
	const uint32_t pMinColB;          // 梥  
	const char     pMin[4];           // ⥪⮢                           // 5

	const uint32_t secY;              //   y
	const uint32_t secX;              //   x
	const uint32_t secColOnF;         // 梥 䮭 
	const uint32_t secColOnB;         // 梥  
	const uint32_t secColOffF;        // 梥 䮭 
	const uint32_t secColOffB;        // 梥  
	const char     sec[16];           // ⥪⮢                           // 10

	const uint32_t reserve1[5];      //  ७   ᫥騥  // 5

	const uint32_t butEnterY;         //  y
	const uint32_t butEnterX;         //  x
	const uint32_t butEnterOnF;       // 梥 
	const uint32_t butEnterOnB;       // 梥 
	const uint32_t butEnterOffF;      // 梥 
	const uint32_t butEnterOffB;      // 梥 
	const char     butEnterStr[16];   // ⥪                        // 14

	const uint32_t reserve2[5];      //  ७   ᫥騥  // 5

	const uint32_t butCancelY;         //  y
	const uint32_t butCancelX;         //  x
	const uint32_t butCancelOnF;       // 梥 
	const uint32_t butCancelOnB;       // 梥 
	const uint32_t butCancelOffF;      // 梥 
	const uint32_t butCancelOffB;      // 梥 
	const char     butCancelStr[16];   // ⥪                        // 14

} const field;

const uint32_t buf[309];

}const _watch;


extern const _TypeButonPressed ReadBut;
extern const _TypeButonPressed DelBut;
extern const _TypeButonPressed ChangeNameBut;
extern const _TypeButonPressed CopyBut;
extern const _TypeButonPressed DefragmentingBut;
extern const _TypeButonPressed startB00;
extern const _TypeButonPressed CopyFile;
extern const _TypeButonPressed DataTimeBut;
extern const _TypeButonPressed createBut;
extern const _TypeButonPressed ReserveBut;


extern const _popUp popUpName;    	 //   
extern const _popUp popUpNewFile;  	 // ᮧ  䠩
extern const _popUp popUpDellFile;   // 㤠 䠩
extern const _popUp popUpCopy;       // ஢ 䠩
extern const _popUp popUpCompil;     // ஢
extern const _popUp popUpDefrag;     // ࠣࢠ
extern const _popUp popUpWarning;    // ।ਦ
extern const _popUp popUpSaveAS;     //  筮  १  
extern const _settings settings;     //  ந
extern const _popUp popUpBoot;       //  ᪠ 稪

extern const _popUpProgressbar popUpProgressbar; // ண  

extern const _watch watch; // 

extern uint32_t MenuX, MenuY;
extern uint32_t MenuColorF, MenuColorB;

void menuChange(const menuItem* NewMenu);
void menuEnterFunc(const menuItem* NewMenu);


/* */
extern TERM MenuDISP[30][95];
extern TERM MirrorMenuDISP[30][95];
extern TERM PopUpDisp[sizeWindowAxisY][sizeWindowAxisX];
extern const char *frame[]; // ࠬ  
extern const char *frameClock[];

extern int16_t watchCell;         // न ன
extern int16_t counterWatch[6];   // 稪  祩 㤠 뢠  ᮢ

typedef union{

	struct{
		uint8_t day[12];
		uint8_t mon[12];
		uint8_t year[12];

		uint8_t hour[12];
		uint8_t min[12];
		uint8_t sec[12];
	} field;

	uint8_t buf[6][12];
} _bufWatch;
extern _bufWatch bufWatch;   //    ६


typedef struct{
	uint8_t ch;
	uint8_t y;
	uint8_t x;
	uint8_t reserve;
} _retMenu;
extern _retMenu retMenu;


typedef struct{
	uint8_t data[sizeTxDispData];
	uint8_t Y[sizeTxDispData];
	uint8_t X[sizeTxDispData];
    int head; // 
    int tail; // 墮
} _Menu;
extern _Menu Menu;

void    initStackMenu(void);
void    pushMenu(_Menu *stack, uint8_t value, uint8_t y, uint8_t x);
_retMenu popMenu(_Menu *stack);
_retMenu peekMenu(_Menu *stack);
int sizeStackMenu(_Menu *stack);


typedef struct{
	uint8_t data[sizeTxDispData];
    int head; // 
    int tail; // 墮
} _MenuUpdate;
extern _MenuUpdate MenuUpdate;

void    initStackMenuUpdate(_MenuUpdate *stack);
void    pushMenuUpdate(_MenuUpdate *stack, uint8_t value);
uint8_t popMenuUpdate(_MenuUpdate *stack);
int     sizeStackMenuUpdate(_MenuUpdate *stack);

/*				樠 ᨢ  			*/
void initMenuDisp(void);
uint32_t fullUpdateMenuWindows(void); //  ᥣ ࠭
void extraditionMenuDisp(void); // 뮤  ࠭ 


/*					  					*/
void inputMenuCh(uint8_t *buf, uint32_t len);   //    
int8_t codeComande(void);                       // 祭  
void parserCommandKeyBoard(int16_t size);       //    


/*						   					*/
void moveM(uint32_t y, uint32_t x);
void colorM(uint32_t colF, uint32_t colB);
void chM(uint8_t ch); // 뤮 ᨬ  
void strM(uint8_t *str); // 뤠 ப  
void writeWindow(uint32_t y, uint32_t x, uint32_t colF, uint32_t colB, char *str, uint32_t len);


/*㭪樨   堭*/
typedef struct{
	uint8_t data[sizeBufInputKeyBoard];
	int head;
	int tail;
} _inputKeyBoard;
extern _inputKeyBoard inputKeyBoard;

void    initInputKeyBoard(void); // 栫
void    pushInputKeyBoard(_inputKeyBoard *stack, uint8_t value); //    
uint8_t popInputKeyBoard(_inputKeyBoard *stack); //      㤠
uint8_t peekInputKeyBoard(_inputKeyBoard *stack); //      㤠
int     sizeInputKeyBoard(_inputKeyBoard *stack); // ࠧ 
void outSymbolEditor(char ch); // 뢮 ᨬ  ନ
void outStrEditor(char *str); // 뢮 ப  ନ



void DrawFrame(void); //  ࠬ
void DraWClock(uint32_t y, uint32_t x, uint8_t hours, uint8_t minutes, uint8_t seconds, uint16_t year, uint8_t month, uint8_t day); // ⮡ࠦ ᮢ
void drawTypeFile(uint32_t y, uint32_t x); // ⮡ࠦ 䠩  砫  䠩
void drawContentFile(uint32_t y, uint32_t x, uint32_t num); // ⮡ࠦ ᮤন 䠩
void infoFileSystem(void);                                  // ଠ  䠩 ⥬ ᥣ 뢮
void Button(_TypeButonPressed *but);                        //    ࠭

void drawErrors(uint32_t y, uint32_t x); // 뢮 ᮮ饭  訡 樨


void openPopUpRename(_popUp *popUp); 	     // ᯫ騥  २ 
void openPopUpNewFile(_popUp *popUp); 	     // ᯫ騥  ᮧ  䠩
void openPopUpDellFile(_popUp *popUp);       // ᯫ뢠騥  㤠 䠩
void openPopUpCopyFile(_popUp *popUp);       // ᯫ뢠騥  ஢
void openPopUpCompilFile(_popUp *popUp);     // ᯫ뢠騥  ஢
void openPopUpDefrag(_popUp *popUp);         // ᯫ뢠騥  ࠣ
void openPopUpWarning(_popUp *popUp);        // ᯫ뢠騥   ।ਦ
void openPopUpSaveAs(_popUp *popUp);         // ᯫ뢠騥   ।ਦ  १ 䠩
void openPopUpSettings(_settings *popUp);    // ᯫ뢠騥   ன
void openPopUpBoot(_popUp *popUp);           // ᯫ뢠騥  ⫮

void closePopUp(_popUp *popUp);      		 // ᯫ騥  
void closePopUpSettings(_settings *popUp);   //   ஥
void outputMessagesPopUp(uint8_t buf);       // 뢮 ᮡ饭  ᯫ뢠饬 


/*					ண  ࠣ樨												*/
void openPopUpProgressbar(_popUpProgressbar *popUp);   					 // ᯫ騥 ணᡠ  
void outputScaleProgressbar(_popUpProgressbar *popUp, int16_t percent);  // 뢮 誠 ண 
void closePopUpProgressbar(_popUpProgressbar *popUp); 					 // ⨥ ணᡠ


/*																								*/
void openClock(_watch *clock);  										 // ன ᮢ
void closeClock(_watch *clock); 										 // ⨥ ᮢ
void setLeftDataTime(_watch *clock);   									 // ⠭   
void setRightDataTime(_watch *clock);  									 // ⠭  ࠢ 
void setUpDataTime(_watch *clock);   									 // ⠭   
void setDownDataTime(_watch *clock);  									 // ⠭   
void inputStrDataTime(_watch *clock, uint8_t *str);  					 //  ६  ࠭
void saveDataTime(void); 												 // ࠭  ६


/*						 										*/
void fileChoiceUp(uint32_t y, uint32_t x);   // 롮 䠩
void fileChoiceDown(uint32_t y, uint32_t x); // ப⪠  


/*						㭪樮 							*/

void startByteCode(void);          //   

void clickingRenamefile(void);     // २ 䠩
void shiftButRenameFile(void);     // ⢨  

void clikingNewFile(void);         // ᮧ  䠩
void shiftclikingNewFile(void);    // ⢨  

void clickingDeleteBut(void);      //  㤠 䠩
void shiftClickingDeleteBut(void); // ⢨  

void clickingCopyBut(void);        //  ᮧ  䠩
void shiftClickingCopyBut(void);   // ⢨  

void clickingCompilBut(void);       //   ஢ 䠩
void shiftClickingCompilBut(void);  // ⢨  

void clickingDefragBut(void);       //   ஢ 䠩
void shiftClickingDefragBut(void);  // ⢨  
void processingDefrag(void);        //  믮 ࠣ樨

void clickingEditorBut(void);       //  ।

void clickingSettingsBut(void);     //  ஥
void shiftSettingsBut(void);        // ⢨  
void popSettingsBut(void);          // ⢨   蠣   

void clickingClockBut(void);        //  ன ᮢ

void clickingWarningBut(void);      // ।ਦ    㦥 

void clickingSaveAsBut(void);       // ।ਦ  १ 䠩

void clickingBoot(void);            //   ⢥ত ᪠ ⫮
void shiftClickingBoot(void);       // ⢨  


/* ⪫  ⨥ */
void EscKey(void);    //
void EnterKey(void);  //
void backSpace(void); // 㤠 ᨬ
void delete(void);    // 㤠 ᨬ
void tab(void);       // 室     tab

void checkInputChar(_popUp *popUp, uint8_t buf); // ஫  ᨬ
void checkInputPoint(_popUp *popUp);             // ஫  窨
void checkBackSpace(_popUp *popUp);              // ஫ 㤠

#endif
