#ifndef SysVar_h
#define SysVar_h

#include "main.h"
#include "usb_device.h"
#include "usbd_cdc_if.h"
#include "Flash.h"
#include "Glob.h"
#include "font.h"
extern USBD_HandleTypeDef hUsbDeviceFS;


#define NumberTasks 64 // ⢮ 
#define MaskStackExtBloks 63 // ࠧ ⥪  譥 
#define McalcSize 32 // ࠧ ⥬᪮ 
#define StrSize   2 // ࠧ ப 
#define StrSizeMask (StrSize - 1) // ᪠ ப 
#define McalcSizeMask (McalcSize - 1) // ᪠
#define attributeStart 1 // ਡ ᪠
#define SubprogSize    32 // ࠧ ⥪  ணࠬ
#define SubprogSizeMask (SubprogSize - 1) // ᪠   ணࠬ
#define StackCommandExternalDeviceSizeMask 32
#define QuantityErrorsExtBlocks 1 // ⢮ 譥 ᮢ ᫨ ந諠 訡
#define MaxQuantityForNext 16 // ᨬ쭮 ⢮ 横 FOR-NEXT



#define BYTE_TO_BINARY_PATTERN "%c%c%c%c%c%c%c%c"
#define BYTE_TO_BINARY(byte)  \
   (byte & 0x80 ? '1' : '0'), \
   (byte & 0x40 ? '1' : '0'), \
   (byte & 0x20 ? '1' : '0'), \
   (byte & 0x10 ? '1' : '0'), \
   (byte & 0x08 ? '1' : '0'), \
   (byte & 0x04 ? '1' : '0'), \
   (byte & 0x02 ? '1' : '0'), \
   (byte & 0x01 ? '1' : '0')


#define DISP_LEFT '\r'            // ॢ   ࠩ  
#define DISP_STEP_ONE_LEFT '\b'   //    蠣  
#define DISP_DOWN '\n'            // ॢ ப 
#define DISP_TAB '\t'             // ⠡ ⭠ 8 ᨬ ᥣ 㦭 ⠡஢
#define DISP_UNIT_SEPARATOR 0x1f  // ࠧ⥫   16 ᨬ


#define EEPROM_WREN  0x6 //  
#define EEPROM_WRDI  0x4 //   
#define EEPROM_RDSR  0x5 // ⥭ ᭮ ॣ
#define EEPROM_WRSR  0x1 //  ᭮ ॣ
#define EEPROM_READ  0x3 // ⥭ ଠ樨
#define EEPROM_FSTRD 0xb // ஥ ⥭ ଠ樨
#define EEPROM_WRITE 0x2 //  
#define EEPROM_SLEEP 0xb9 // ᮭ
#define EEPROM_RDID  0x9f // ⥭ id


extern uint8_t bufTxUSB[64];  //   ।  १ USB
extern uint32_t sizeTXUSB;    // ࠧ  । 

extern uint32_t RESTORE;      //  冷 ⥭  ᨢ DATA
extern uint32_t LineNum;      // ப  ஬ 訡

extern uint8_t ExternalsBlocks_TX[256]; //  ।    譥 
extern uint8_t ExternalsBlocks_RX[256]; //  ਥ    譥 

extern uint8_t EEPROM_TX[16];
extern uint8_t EEPROM_RX[16];


extern uint32_t AddressBeginByteCode;  //  砫  㤠 稭  
extern uint32_t AddressExecByteCode;   //  믮  
extern uint32_t AddressOffsetByteCode; //  ᬥ饭
extern uint32_t stepExecBeteCode;      // 蠣 믠  


extern uint32_t lenRx, lenTx;     //   । 
extern int32_t addrRegRx;         // ६   ਥ 
extern uint32_t counterExternTx;  // 稪 訡  ਥ  । 譥 


extern int32_t xGrid[4], yGrid[4];     // न  
extern uint32_t NumberWindows;         //  㤠 뢮 
extern uint32_t ExecWindows;           // ⮡ࠦ ࠭
extern int32_t colorF[4];              // 梥 ᨬ
extern int32_t colorB[4];              // 梥 䮭


extern char lastCharacterEntered; // ᫥  ᨬ
extern uint16_t FntBool;          // ࠧ 

extern  uint8_t  typeAdr;
extern  uint32_t adrrMem;
extern  uint32_t addrSysMem;
extern  uint32_t addrSTATDATA;


__attribute__((section(".dma_buffer")))
extern uint8_t USART1_RX[256]; //  ।
__attribute__((section(".dma_buffer")))
extern uint8_t USART1_TX[256]; //  ਥ


typedef struct{
	uint8_t inputText[sizeStrCalc];
	int32_t X;
	int32_t Y;
	int32_t counterPos;
} _InputEcho;
extern _InputEcho *InputEcho[4];


typedef union {
    uint16_t ADCRES[6];
    struct {
     uint16_t det_24V;
     uint16_t detCurrent_24V;
     uint16_t det_5V;
     uint16_t detCurrent_5V;
     uint16_t detReserve;
     uint16_t tempCPU;
    };
} unionAdc;

typedef union {
    uint16_t DIO[32];
    struct {
     uint16_t RTC_Year;
     uint16_t RTC_Mon;
     uint16_t RTC_Day;
     uint16_t RTC_Hour;
     uint16_t RTC_Min;
     uint16_t RTC_Sec;
	 uint16_t RTC_Week;
	 uint16_t Reserve;
     float    SysTimer; // 蠣 0,01 ᥪ㭤 10 .
     float    WRK_Hour; // 蠣 0,1 ᥪ㭤
     uint16_t ASU_P_Mode;
     uint16_t ASU_P_Speed;
     uint16_t ASU_P_Adr;
     uint16_t REL1;
     uint16_t REL2; // 15
     unionAdc ADC; // 21
     uint16_t loadCPU;          // 㧪   業
 	 uint16_t counterHandTask;  // 稪 ᠭ 
 	 uint16_t numberHandTask;   //  ᫥ 襭   ⠩
    };
} unionDio00;

typedef union{
	uint16_t word;
	struct{
		uint8_t Lo;
		uint8_t Ho;
	};
} unionDIO_MIN[32]; //       32 2-(int16) ࠬ

typedef union{
	unionDIO_MIN DIO_MIN;
	unionDio00 DIO_00;
} _DIO_MIN;

typedef union{
	uint16_t word;
	struct{
		uint8_t Lo;
		uint8_t Ho;
	};
} _DIO_MID[128]; //    ।   128 2-(int16) ࠬ

typedef union{
	uint16_t word;
	struct{
		uint8_t Lo;
		uint8_t Ho;
	};
} _DIO_MAX[4096]; //    訬   4096 2-(int16) ࠬ


typedef struct DIO{
	   _DIO_MIN DIO_MIN[64];       // 64    32 2-塠(int16) ࠬ
	   _DIO_MID DIO_MID[32];       // 32 ।   128 2-塠(int16) ࠬ
	   _DIO_MAX DIO_MAX[4];        //  4    4096 2-塠(int16) ࠬ
	   float    GLOB[8192];
	   uint16_t ASUIO[32768];
	   uint8_t  LOCALL[32768];
	   float    STATDATA[32768];
	   char     ERRORS[80];
	   float    READYINPUT; // ਧ ⮢     ନ ᫨ -1    stin  騭 0  ⮢ 1 ⮢  ७ 0x0d 2  ९ 
	   float    RNDVAL;     // ६
	   uint32_t READYINPUTMAX; // ᨬ쭮 ⢮     
	   /* 㦭  */
	   /*뢮  ᯫ*/
	   TERM     DISP[4][30][95];
	   uint32_t DATA_PNT;
} _SysMem;
extern _SysMem SysMem;


/*ઠ ࠭  । */
extern TERM MirrorDISP[30][95];
void initMirrorDISP(void); // 樠 મ

/*   ࠡ  横 for next*/
typedef struct{
  uint32_t  var;    //  ६ 横, ᥣ 쭠
  uint32_t  begin;  //  砫 ᯮ塞  横
  float     step;   // 稭 蠣 横
  float     to;     // 稭 ண 砭 横
} UFOR;

typedef struct {
  UFOR FOR[16];
} _FORNEXT;
extern _FORNEXT FORNEXT;

typedef struct{
	uint32_t  var;    //  ६ 横, ᥣ 쭠
	uint32_t  begin;  //  砫 ᯮ塞  横
	float     step;   // 稭 蠣 横
	float     to;     // 稭 ண 砭 横
} _popFornext;
extern _popFornext popFornext;



/*짠⥫᪨ ᨢ*/
typedef struct {
	uint16_t	type;	    // ⨯: 0-float(4 ), 1-int16(  4 ) 2-int16(2 ), 3-string$
	uint16_t	size;	    // ⢮ ࠧ୮⥩ ᨢ 1..4
	uint32_t	adr;	//  ६.  ଠ  ਧ ⨯ 
    uint16_t    dim[4];
} _DimData;
extern _DimData *DimData;



/*⥬᪨ */
typedef union {
	float    f;
	uint32_t i;
	struct{
	int16_t   lo;
	uint16_t  hi;
	};
	struct{
		uint8_t b0;
		uint8_t b1;
		uint8_t b2;
		uint8_t b3;
	};
} uniondata;

typedef struct {
	uniondata  data[32];
	int        size;
} Mcalc;
extern Mcalc MCALC;




/*ப */
typedef struct {
	char str[4][256];
	int  sizeStr;
} _StrCalc;
extern _StrCalc StrCalc;




/*⥪   ணࠬ*/
typedef struct {
	uint32_t addr[32];
	uint32_t size;
} _Subprog;
extern _Subprog Subprog;




/* */
typedef struct {
	int32_t step;              //  ᪠ 
	int32_t timeWork;          // ६ 襤襥   ᫥ 
	int32_t counterRun;        // 稪 ᮢ  

	int32_t attribute;         // ਧ 믮 
	int32_t timeout;           //    ᨬ쭮 ६ 믮
	int32_t timeoutWork;
	int32_t flagTimeout;       // 䫠 ⠭ ᫨ ணࠬ 믮  祬 㪠  ⠩

	uint32_t ptr;              // 㪠⥫  䠩  
	uint32_t offset;           // ᬥ饭  ८  ணࠬ
} _Task;

typedef struct{
	_Task task[sizeTaskExec];
	uint32_t size;              // ⢮   믮
	uint32_t numberCurrentTask; //  ⥪饩 믮塞 
	int32_t  queueTask;         // ⢮   ।, 㧪  (queueTask/size) * 100
	float    timeExecTask;      // ६ 믮 
	int32_t  counterTimeExecTask;
} _Manager;
extern _Manager Manager;




/*⠡ 㭪権  */
typedef void (*funcByteCode)(void);
extern funcByteCode fn[];


/*䠩 ⥬*/
typedef union {
   struct{
	uint8_t day;
	uint8_t mounts;
	uint16_t year;
   };
   uint32_t data;
} uniondate;

typedef union {
	struct{
	uint8_t sec;
	uint8_t min;
	uint8_t hour;
	uint8_t reserve;
	};
	uint32_t time;
} uiniontime;


typedef struct {
    const char name[sizeName];                    // 
    const char textExtension[sizeTextExtension];  // ७
    const uint32_t size;                          // ࠧ  
    const uniondate date;                         // 
    const uiniontime time;                        // ६
    const uint32_t numberSector;                  //  ᥪ
    const uint32_t crc;                           // ஫쭠 㬬
    const uint32_t reserve[5];                    // १
} const headerFileList;
extern const headerFileList *HeaderFileList[sizeFileSystem];


typedef struct {
    char name[sizeName];                    // 
    char textExtension[sizeTextExtension];  // ७
    uint32_t size;                          // ࠧ  
    uniondate date;                         // 
    uiniontime time;                        // ६
    uint32_t numberSector;                  //  ᥪ
    uint32_t crc;                           // ஫쭠 㬬
    uint32_t reserve[5];                    // १
} _modifyFileHeaderList;
extern _modifyFileHeaderList modifyFileHeaderList;




/*    */
typedef union {
    struct {                 // ᠭ 稬  
     uint32_t BASIC_ver;     //  몠  樮 ᯮ⥫쭮 ⥬
     uint32_t Begin_adr;     // ᬥ饭  砫 ਮ᪮  ணࠬ
     uint32_t NumConst_adr;  // ᬥ饭  砫  ⠭
     uint32_t StrConst_adr;  // ᬥ饭  砫  ப ⠭
     uint32_t DataSTR_adr;   // ᬥ饭  砫  ᨢ DATA_STR
     uint32_t DataSTR_len;   // ࠧ ᨢ DATA_STR (⢮ ᥩ)
     uint32_t DataDNV_adr;   // ᬥ饭  砫  ᨢ DATA_DNV
     uint32_t DataDNV_len;   // ࠧ ᨢ DATA_DNV (⢮ ᫮  4 )
     uint32_t DataDIM_adr;   // ᬥ饭  砫  ᨢ DATA_DIM
     uint32_t DataDIM_len;   // ࠧ ᨢ DATA_DIM (⢮ ᥩ)
     uint32_t StrVar_adr;    // ᬥ饭  砫  ᨢ StrVar
     uint32_t StrVar_len;    // ࠧ ᨢ StrVar (⢮ ᥩ)
     uint32_t TaskNum;       //  
     uint32_t FileSize;      //  䠩  蠯
    };
    uint8_t   head[64];       //    64 .  ᯮ짮 - १.
} _BinFileHead;
extern _BinFileHead *BinFileHead;


// , 뢠  ப ६
typedef struct {
    uint32_t adr:24;        //   ଠ  ਧ ⨯ 
    uint32_t len:8;         // ࠧ 뤥 
} _StrVarData;
extern _StrVarData *StrVarData;

/*ன ᮢ*/
typedef struct {
   uint16_t hours;
   uint16_t minutes;
   uint16_t seconds;
   uint16_t subSeconds;
} _RtcTime;
extern _RtcTime Rtctime;

typedef struct {
	uint16_t weekDay;
	uint16_t year;
	uint16_t month;
    uint16_t day;
} _RtcData;
extern _RtcData Rtcdata;



/*⥭  */
extern uint32_t ByteCode;


/*  ⥭   ᨢ DNV*/
typedef union {
	int i;
	float f;

	struct{
	uint32_t mantissa :23;
	uint32_t exponent :8;
	uint32_t sign :1;
	} FloatP;

	struct{
	uint16_t lo;
	uint16_t hi;
	} UintP;
} _typeDigit;
extern _typeDigit typeDigit;





/*ਥ ।   */

typedef union {
uint16_t word;
struct{
	uint8_t Lo;
	uint8_t Ho;
};
} unionAddrReg;

typedef union {
	uint16_t word;
	struct{
	uint8_t Lo;
	uint8_t Ho;
	};
} unionCountReg;

typedef union {
    uint64_t DIO;
    struct {
    uint8_t  addr;          //  ன
    uint8_t  function;      // 㭪
    unionAddrReg addrReg;   //  ன⢠
    unionCountReg countReg; // ⢮ ॣ஢   ⥭
    uint16_t attribute;     // ਡ ᪠
    };
} unionExtBlocks;

typedef struct{
	unionExtBlocks ExtBlock[64]; // ⢮   ࠡ  譥 
	int32_t head;
	int32_t tail;
} _StackCommandExternalDevice;
extern _StackCommandExternalDevice StackCommandExternalDevice;


extern const _DimData fSysDimData[];


/* 訡*/
enum {
	eIncorrectDimIndex = 1,
};



/* ਥ   */
typedef struct{
	uint8_t data[256];
    int32_t head; // 
    int32_t tail; // 墮
} _inputDataKeyboard;
extern _inputDataKeyboard inputDataKeyboard;

void    initInputDataKeyboard(void);
void    pushInputDataKeyboard(_inputDataKeyboard *stack, uint8_t value);
uint8_t popInputDataKeyboard(_inputDataKeyboard *stack);
int     sizeInputDataKeyboard(_inputDataKeyboard *stack);
void    clearInputDataKeyboard(_inputDataKeyboard *stack);



/*⥪  ਥ । १ USB */

typedef struct{
	uint8_t ch;
	uint8_t y;
	uint8_t x;
	uint8_t reserve;
} _retTxDispData;
extern _retTxDispData retTxDispData;

typedef struct{
	uint8_t data[sizeTxDispData];
	uint8_t Y[sizeTxDispData];
	uint8_t X[sizeTxDispData];
    int head; // 
    int tail; // 墮
} _txDispData;
extern _txDispData txDispData;

void    initStacktxDispData(_txDispData *stack);
void    pushtxDispData(_txDispData *stack, uint8_t value, uint8_t y, uint8_t x);
_retTxDispData poptxDispData(_txDispData *stack);
_retTxDispData peektxDispData(_txDispData *stack);
int sizeStackTxDispData(_txDispData *stack);



typedef struct{
	uint8_t data[sizeTxDispData];
    int head; // 
    int tail; // 墮
} _DispDataUpdate;
extern _DispDataUpdate DispDataUpdate;

void    initStackDispDataUpdate(_DispDataUpdate *stack);
void    pushDispDataUpdate(_DispDataUpdate *stack, uint8_t value);
uint8_t popDispDataUpdate(_DispDataUpdate *stack);
int sizeStackDispDataUpdate(_DispDataUpdate *stack);


typedef struct{
	uint8_t data[sizeBufUpdateMonitor];
    int head; // 
    int tail; // 墮
} _UpdateMonitor;
extern _UpdateMonitor UpdateMonitor;

void    initUpdateMonitor(void);
void    pushUpdateMonitor(_UpdateMonitor *stack, uint8_t value);
uint8_t popUpdateMonitor(_UpdateMonitor *stack);
int sizeUpdateMonitor(_UpdateMonitor *stack);


void callTxDispData(void);                              // 맮   ।  ࠦ
void transmitDataTerminal(uint8_t *buf, uint32_t size); // ।   ନ 
void updateWindowMenu(void);                            //   
void searchESCM(void);                                  //  ESC  
int8_t searchESCB(void);                                //  ESC   

void clearDisp(uint32_t num, uint32_t colF, uint32_t colB); // ⪠ । ࠭   梥⮬ 䮭

/*㭪 뢮   ࠭   ࠭*/
int32_t updateDisplay(void); //  ᯫ ᥣ


void extraditionDispUsb(void); // 㭪 뤠   usb 


/*樠  SYSMEM*/
void initStackSysMem(void);


/**㭪樨  ਥ ।   **/
void  initStackCommandExternalDevice(void);                                                                                                 // 樠 ⥪ 譥 
void  pushStackCommandExternalDevice(_StackCommandExternalDevice *stack, uint8_t addr, uint8_t funct, uint16_t addrReg, uint16_t countReg); //   ⥪ int
void  popStackCommandExternalDevice(_StackCommandExternalDevice *stack);                                                                    // ନ஢   ।   । 
int   sizeStackCommandExternalDevice(_StackCommandExternalDevice *stack);                                                                   // 㧭 ࠧ ⥪

/*㭪樨  ࠡ  襩 */
void callByteCode(int code); // ⨥ 㭪樨  


/*⥬᪨ */
void  initStackMcalc(Mcalc *stack); // 樠 ⥪ ⥬᪮ 
void  pushMcalcF(Mcalc *stack, float value); //   ⥪ float
float popMcalcF(Mcalc *stack); // ⨥  ⥪ float
void  pushMcalcI(Mcalc *stack, int16_t value); //   ⥪ int
int16_t popMcalcI(Mcalc *stack); // ⨥  ⥪ int
void  pushMcalcAddr(Mcalc *stack, uint32_t value); //   ⥬᪨  
uint32_t popMcalcAddr(Mcalc *stack); //    
int popHiMcalc(Mcalc *stack); // ⨥        ᫮ int  float


/*ப */
void initStrCalc();            // 樠 ⥪
void pushStrCalc(_StrCalc *stack, char *str); //   ⥪
void popStrCalc(_StrCalc *stack, char *str);  // ⨥  ⥪

/*横 for --- next*/
void initForNext(void);
void pushForNext(_FORNEXT *ForNext, uint32_t var, uint32_t begin, float step, float to); //   ⥪
void popForNext(_FORNEXT *ForNext, uint32_t var); // ⨥  ⥪
void clearAddressForNext(_FORNEXT *ForNext, uint32_t value); //    ⥪ for-next

/*⥪ 맮 ணࠬ*/
void initSubprog(void);                            // 樠 맮 ணࠬ
void pushSubprog(_Subprog *stack, uint32_t value); //   ⥪
uint32_t popSubprog(_Subprog *stack); //   ⥪

/* CRC */
uint16_t CRCModbus(uint8_t *pBuffer, uint32_t BufferLength); //  crc  


/*ਥ ।  १ USART  ࠡ  譥   RS422*/
void TxRXData(uint32_t lenRx, uint32_t lenTx);
void RXData(void); // 㭪 ਥ 
void TimeOutRxData(void); // 㭪 ᫨  諨   ⠩

/*᫥  㤠   float int*/
float calcAddrVarF(uint32_t addr); // ᫥   㤠  ६ float
uint16_t calcAddrVarI(uint32_t addr); // ᫥   㤠  ६ int
void SetCalcAddrVarI(uint32_t addr, __IO uint16_t var); // ᫨ 㤠 뢠  ६ int
void SetCalcAddrVarF(uint32_t addr, __IO float var); // ᫨ 㤠 뢠  ६ float

/*᫥  㤠   ப*/
void setcalcAddrStr(uint32_t addr, char *str); // 㤠  ப
void getCalcAddrStr(uint32_t addr, char *str); //  㤠  ப

/*樠  砩 ᥫ*/
void initRNG(void);


/*   */
void managerTaskInit(void); // 樠 ᯥ 
uint32_t searchFile(_Manager *manager, char* str); //  䠩 .b00
void searchExecFile(_Manager *manager); //   ᯮ塞 䠩
void managerInitTaskBoo(void); //   b00  砨 ᫨ 諨 䠩
void managerTask(_Manager *manager, uint32_t numberTask);
void pushTask(_Manager *manager, uint16_t step, uint16_t timeout, uint16_t numberTasks); //  
void execByteCode(_Manager *manager); // ᯮ  
void startFileSystem(void); //  䠩 ⥬
uint8_t checkTask(_Manager *manager); // ஢ઠ     ୮ 믠.
void execTask(void);                  // 믮  


int32_t charInStr(uint8_t *str, uint8_t ch, uint32_t size);


/*㭪   ᨢ*/
uint32_t adressDimData(uint32_t n);


/*㭪 뢮 */
void inputEcho(uint8_t ch);



/*㭪樨 ࠡ  EEPROM*/
uint8_t ReadStatus(void);
void SetWriteEnableLatch(void);
void EepromWriteF(uint32_t adrr, float val);
void EepromWriteI(uint32_t adrr, uint32_t val);
uint32_t EepromReadI(uint32_t adrr);
float EepromReadF(uint32_t adrr);


/*㭪樨 ࠡ  ᠬ RTC*/
void setTime(_RtcTime *stime);
void setData(_RtcData *sdate);
void getTime(_RtcTime *gtime);
void getData(_RtcData *gdata);
uint8_t RTC_ByteToBcd(uint8_t Value);
uint8_t RTC_BcdToByte(uint8_t Value);


/*					ASU					*/
void modbasRTU(void);          // ࠧ  ⢥    RTU
void initTxRxModbasRTU(uint32_t len);  // ।  ਥ   RTU


/*					⫠					*/
void Send_String(char *str); //㭪 뢮 ப  設 USB
void Send_USB_data(unsigned char *message, unsigned short int data_length); //㭪 뢮 ᮤন   設 USB
void Send_USB_short_int(unsigned short int Value); //㭪 뢮 ⪮ 楫  設 USB
void Send_USB_long_int(unsigned long int Value); //㭪 뢮  楫  設 USB
void Send_USB_float(float Value); //㭪 뢮 ஡  設 USB
void Send_USB_data(unsigned char *message, unsigned short int data_length); //㭪 뢮 ᮤন   設 USB

#endif
