#ifndef   Glob_h
#define   Glob_h

#include "main.h"
#include <string.h>

#define ZELLER_OFFSET 2 //饭   RTC

#define sizeBufInputKeyBoard 256 // ࠧ  

#define WORK_PROGRAM SET_BIT(GPIOB->BSRR,GPIO_BSRR_BS2);\
						SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS7);
#define WORK_EDIT SET_BIT(GPIOB->BSRR,GPIO_BSRR_BR2);\
					SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS7);
#define WORK_BOOTLOADER SET_BIT(GPIOB->BSRR, GPIO_BSRS_BS2);\
							SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR7);


#define LOAD_CPU_40 SET_BIT(GPIOE->BSRR,GPIO_BSRR_BR14);\
					SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS15);
#define LOAD_CPU_80 SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS14);\
					SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS15);
#define LOAD_CPU_100 SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS14);\
					 SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR15);


#define SET_DIO_ERRORS SET_BIT(GPIOE->BSRR,GPIO_BSRR_BR9);\
					   SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS8);
#define CLEAR_DIO_ERRORS SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS9);\
					     SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR8);

#define SET_ASU_ERRORS SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS10);\
					   SET_BIT(GPIOE->BSRR, GPIO_BSRR_BR11);

#define CLEAR_ASU_ERRORS SET_BIT(GPIOE->BSRR,GPIO_BSRR_BR10);\
					     SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS11);


#define READY_WORK SET_BIT(GPIOE->BSRR,GPIO_BSRR_BR12);\
					   SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS13);

#define PROHIBITED_WORK SET_BIT(GPIOE->BSRR,GPIO_BSRR_BS12);\
					   SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS13);


#define FAULT_WORK SET_BIT(GPIOE->BSRR,GPIO_BSRR_BR12);\
					   SET_BIT(GPIOE->BSRR, GPIO_BSRR_BS13);


#define FLASH_PAGESIZE 32 // ࠧ ࠭ flash
#define SIZE_CLASTER 4096 // ࠧ    

/*  䠩 ⥬*/
#define sizeName 20            //  
#define sizeTextExtension 4    // ࠧ ७
#define sizeFileSystem 256     // ࠧ 䠩 ⥬
#define numbeSectors   256     // ⢮ ᥪ஢
/*                            */

#define sizeTaskExec 64       // ᨬ쭮 ⢮ ᯮ塞 

#define sizeStrCalc 128       // ࠧ ப ப 


/*ࠧ */
#define sizeWindowAxisX 80    // ࠧ   X
#define sizeWindowAxisY 30    // ࠧ   Y

#define sizeTxDispData 8192   // ࠧ ⥪  ।   lcd
#define TxDispDataMask (sizeTxDispData - 1) // ᪠ ⥪  ।   lcd


#define sizeBufUpdateMonitor 8192 // 楢     १ usart


#define N 16

/*buf ASU*/
extern uint8_t AsuRX[256];
extern uint8_t AsuTX[256];


typedef struct{
	char B_C : 4;
	char F_C : 4;
	char ch;
} TERM;


extern uint16_t ADC[6];

extern int32_t counterUpdateDisp; // 稪  ࠭

extern uint8_t startCompile;      //  ࠡ 
extern uint8_t thereNoSpaceFlash; //   䠩 ⥬
extern uint8_t workRedactor;      // ࠡ⠥ ।
extern uint8_t onOffCursor;       // 祭 ⪫祭 
extern uint8_t readyClock;        // ⮢ ᮢ  뤠   ࠭
extern uint8_t updateDispZmodem;  //  ࠭
extern uint8_t outFileSistem;
extern int32_t errorsExchangeDio; // 訡  譥 
extern int16_t counterChar;       // 稪  ᨬ  ப
extern int32_t usbConect;         // USB ⮢ । 


extern int16_t counterTryTransmitionUsbDisp; // 稪 ⮪ । 
extern uint8_t flagTryTransmitionUsbDisp;    // 䫠 ⮪ । 

extern const uint8_t aucCRCHi[];
extern const uint8_t aucCRCLo[];


void centerText(char *textinput, char *textoutput, int fieldWidth); 	// ࠢ ⥪  業
void addCharStr(uint8_t *textinput, char ch, int16_t *cell); 			//   ப  ந쭮 祩 ᨬ
void dellCharStr(uint8_t *textinput, int16_t *cell);					// 㤠 ᨬ  ந쭮 祩 ᨢ
uint8_t* addSpaceInStr(uint8_t *text, int32_t size);           			//  ஡  


uint16_t filter24V(uint16_t x);
uint16_t filterCurrent24(uint16_t x);
uint16_t filter5V(uint16_t x);
uint16_t filterCurrent5V(uint16_t x);
uint16_t filterReserve24V(uint16_t x);

uint16_t AsuCRC16(uint8_t *pucFrame, uint32_t usLen); //  CRC  ASU modbas RTU

void DebugSetup (void); // SWO
int _write ( int file, char *ptr, int len ); // SWO


#endif
