#ifndef Flash
#define Flash

	/* ᫨  FF   name  ⠥  ᥪ ⮩      
	 * ᫨   name     FF  ⠥    ਭ  䠩
	 *
	 *  䠩     㣮 ᫥⥫쭮 ࠧ뢠     ⨬
	 *   蠯 䠩   ⨬
	 * 砥 䠩:
	 * 1. ஢塞     ⠪ ᬮਬ   name
	 * 2. ᫨ 諨 䠩  ⠪   蠯,  ⠥,   䠩 㢥祭  ࠧ  뢠    ࠢ
	 *   室  ᨬ쭮 ⤯ ⤠ 䠩  砫 ࠧ饭 䠩 ⥬
	 * 3. ᫨  諨 䠩     饬 ᢮    0xff   䠩,
	 *    塞   蠯 䠩 ⥬ ᫥ 뢠    
	 * 4.  ண ⮤ ஢
	 * */
#include "main.h"
#include <stdlib.h>
#include "menu.h"
#include "SysVar.h"
#include "Glob.h"
#include "editor.h"
#include <time.h>
#include <stdio.h>
#include <ctype.h>

#define Next_File ChoiceNumberFile ++;
#define PREVIOUS_File ChoiceNumberFile --;
#define Num_File ChoiceNumberFile

extern uint8_t mirrorMemory[0x20000];
extern int32_t ChoiceNumberFile;
extern uint16_t ListFileItem[sizeFileSystem]; //  䠩   祩 ᮮ⢥  䠩
extern uint32_t numberFilesInSystem; // ⢮ 䠩  ⥬
extern uint32_t busySector; // ⢮  ᥪ஢
extern uint32_t defSpace; // ࠣ஢ ࠭⢮


typedef struct {
	uint32_t numHead;
	uint32_t sector;
	uint32_t size;
} _sortHead;
extern _sortHead sortHead[sizeFileSystem];


typedef struct {
	uint32_t numHead;
	uint8_t  exp[4];
	uint8_t  name[20];
	uint64_t data;
} _sortExpData;
extern _sortExpData sortExpData[sizeFileSystem];

void * compile(char * filename);

void writeFlashBufferBank2(uint8_t *pBuffer, uint32_t NumberSector, uint32_t addrBegin, uint32_t Size); //    ᥪ୮  砫쭮    2

void writeFlashBufferBank1(uint8_t *pBuffer, uint32_t NumberSector, uint32_t addrBegin, uint32_t Size); //    ᥪ୮  砫쭮    1

void writeFlashCopySector(uint32_t *addr);

void writeFlashPageBank1(uint8_t *pBuffer, uint32_t *addr, uint8_t size);

void writeFlashPageBank2(uint8_t *pBuffer, uint32_t *dest_addr, uint8_t size);

void eraseSectorFileSystem(uint32_t numberSector, uint32_t len);

void sectorReserve(uint32_t addr);

void copyReserveSector(uint32_t NumberSector);

void copyReserveHeaderSector(uint32_t number);

void eraseBank1Sector(uint32_t sector);

void eraseBank2Sector(uint32_t sector);

void writeHeaderFile(uint8_t *pBuffer, uint32_t number); //   䠩

void eraseHeaderFile(uint32_t number); // 㤠  䠩

uint32_t readByteCode(uint32_t addr); // ⥭   4 
//////////////////////////////

uint32_t crcFile(uint32_t adrr, uint32_t size); // ⢮ 

uint32_t crcBootFlash(uint32_t adrr, uint32_t size); // ⢮ 

uint32_t crcBank1Flash(uint32_t adrr, uint32_t size); //   CRC   flash

int32_t delFile(int32_t num); // 㤠 䠩  䠩 ⥬ 㤠 ⮫쪮 

int32_t renameFile(int32_t num, uint8_t *str); //   䠩

int32_t copyFile(uint8_t *str, int32_t num); // ஢ 䠩

int32_t createFile(uint8_t *name, int size); // ᮧ 䠩


/*㭪樨  ࠡ  ஬*/
int32_t fileSearchBC(char *str); //  䠩  

void compileFile(uint32_t num); // 㭪  ஢

void writeExecFileByteCode(uint8_t* name, uint32_t addr); //  ᯮ塞 䠩  


/*				㭪樨  ࠡ  ।஬						*/
void startEditor(int num); //  ࠡ ।

void writeFileEditor(uint8_t* name, uint32_t addr, uint32_t size); //  䠩  ।  䠩 ⥬


/* ࠡ  䠩*/
int32_t FileSearch(char *str); //  䠩   ७ "name.txt"

int32_t searchesVoidSector(void); //  ᢮ ᥪ 頥  ⮣ ᥪ  㤠  稭 

int32_t searchesVoidHead(void); // 頥   㤠    ᫨  -1   ᢮ 

int32_t busyHeaderName(int32_t num); // 頥      ᪠ ᢮ 

uint32_t quantityFileInSystem(void); // ⢮ 䠩  ⥬

int32_t quantityBusySectorSystem(void); // ⢮  ᥪ஢

int32_t defragmentedSpace(void); // ⢮ ᥪ஢    묨

int32_t quantityBusySector(int32_t n); // ᫥ ⢠  ᥪ஢  䠩

/*ࠣ ᦠ⨥ 䠩 ⥬*/
void copyHead(void);

int cmpSector(const void *a1, const void *a2);

int transferSector(uint32_t inSector, uint32_t outSector, uint32_t len); // ७ ᥪ

int overwritingFile(void); // १뢠 䠩 ࠣ

/*		ࢪ  ७			*/
int exp_c(const void * a, const void * b);
int name_c(const void * a, const void * b);
int strcasecmp_withNumbers(const void *void_a, const void *void_b);
int data_c(const void * a, const void * b);

#endif
